/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import jams.runtime.JAMSRuntime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class RuntimeManager
extends Observable {
    private HashMap<JAMSRuntime, RuntimeInfo> runtimeInstances = new HashMap();
    private static RuntimeManager instance;

    private RuntimeManager() {
    }

    public static RuntimeManager getInstance() {
        if (instance == null) {
            instance = new RuntimeManager();
        }
        return instance;
    }

    public void addRuntime(JAMSRuntime runtime) {
        if (runtime.getState() != 1) {
            return;
        }
        RuntimeInfo rtInfo = new RuntimeInfo(Calendar.getInstance(), runtime);
        this.runtimeInstances.put(runtime, rtInfo);
        this.setChanged();
        this.notifyObservers(rtInfo);
        runtime.addStateObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JAMSRuntime rt = (JAMSRuntime)o;
                if (rt.getState() == 0 || rt.getState() == 2) {
                    RuntimeManager.this.removeRuntime(rt);
                }
            }
        });
    }

    private void removeRuntime(JAMSRuntime runtime) {
        RuntimeInfo rtInfo = this.runtimeInstances.get(runtime);
        if (rtInfo == null) {
            return;
        }
        rtInfo.setEnd(Calendar.getInstance());
        this.runtimeInstances.remove(runtime);
        this.setChanged();
        this.notifyObservers(rtInfo);
    }

    public int getNumberofInstances() {
        return this.runtimeInstances.size();
    }

    public class RuntimeInfo {
        private Calendar startTime;
        private Calendar endTime;
        private JAMSRuntime runtime;
        private String stringRepresentation = null;

        public RuntimeInfo(Calendar startTime, JAMSRuntime runtime) {
            this.startTime = startTime;
            this.runtime = runtime;
        }

        public String toString() {
            String result;
            if (this.stringRepresentation == null) {
                result = this.runtime.getModel().getName() + " [";
                SimpleDateFormat sdf = new SimpleDateFormat();
                result = result + "start=" + sdf.format(this.startTime.getTime()) + ", ";
                if (this.runtime != null) {
                    result = this.runtime.getModel().getWorkspace() != null ? result + "workspace=" + this.runtime.getModel().getWorkspaceDirectory().getAbsolutePath() : result + "workspace=null";
                }
                this.stringRepresentation = result = result + "]";
            } else {
                result = this.stringRepresentation;
            }
            return result;
        }

        public void setEnd(Calendar endTime) {
            this.endTime = endTime;
        }

        public Calendar getStartTime() {
            return this.startTime;
        }

        public Calendar getEndTime() {
            return this.endTime;
        }

        public JAMSRuntime getRuntime() {
            return this.runtime;
        }
    }
}

