/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import jams.data.DataFactory;
import jams.data.DefaultDataFactory;
import jams.data.JAMSData;
import jams.model.Context;
import jams.model.GUIComponent;
import jams.model.JAMSModel;
import jams.model.Model;
import jams.model.SmallModelState;
import jams.runtime.JAMSRuntime;
import jams.runtime.RuntimeLogger;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Observer;
import javax.swing.JFrame;
import org.w3c.dom.Document;

public class MiniRuntime
implements JAMSRuntime {
    private JFrame frame;
    private int debugLevel = 3;
    private RuntimeLogger errorLog = new RuntimeLogger();
    private RuntimeLogger infoLog = new RuntimeLogger();
    private DataFactory dataFactory = DefaultDataFactory.getDataFactory();

    public MiniRuntime(jams.model.Component component) {
        JAMSModel model = new JAMSModel(this);
        component.setModel((Model)model);
        component.setContext((Context)model);
        if (component instanceof GUIComponent) {
            this.frame = new JFrame();
            this.frame.setDefaultCloseOperation(2);
            this.frame.setTitle("MiniRuntime");
            this.frame.setIconImages(JAMSTools.getJAMSIcons());
            this.frame.setPreferredSize(new Dimension(800, 600));
            this.frame.getContentPane().add((Component)((GUIComponent)component).getPanel(), "Center");
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDebugLevel(int aDebugLevel) {
        this.debugLevel = aDebugLevel;
    }

    public void sendInfoMsg(String str) {
        this.infoLog.print("INFO: " + str + "\n");
    }

    public void sendErrorMsg(String str) {
        this.errorLog.print("ERROR: " + str + "\n");
    }

    public void println(String s, int debugLevel) {
        if (debugLevel <= this.getDebugLevel()) {
            this.sendInfoMsg(s);
        }
    }

    public void println(String s) {
        this.sendInfoMsg(s);
    }

    public void handle(Throwable t) {
        this.handle(t, null, false);
    }

    public void handle(Throwable t, String cName) {
        this.handle(t, cName, false);
    }

    public void handle(Throwable t, boolean proceed) {
        this.handle(t, null, proceed);
    }

    public void handle(Throwable t, String cName, boolean proceed) {
        String message = "";
        if (cName != null) {
            message = message + "Exception occured in component " + cName + "!\n";
        }
        message = message + t.toString();
        if (this.getDebugLevel() > 1) {
            message = message + "\n" + StringTools.getStackTraceString(t.getStackTrace());
        }
        this.sendErrorMsg(message);
        if (!proceed) {
            this.sendHalt();
        }
    }

    public HashMap<String, JAMSData> getDataHandles() {
        return new HashMap<String, JAMSData>();
    }

    public void pause() {
        this.sendHalt("pause is not supported by mini runtime!");
    }

    public void resume(SmallModelState state) {
        this.sendHalt("resume is not supported by mini runtime!");
    }

    public void sendHalt() {
        System.exit(0);
    }

    public void sendHalt(String str) {
        this.sendErrorMsg(str);
        this.sendHalt();
    }

    public int getState() {
        return -1;
    }

    public void addStateObserver(Observer o) {
    }

    public void addInfoLogObserver(Observer o) {
        this.infoLog.addObserver(o);
    }

    public void deleteInfoLogObserver(Observer o) {
        this.infoLog.deleteObserver(o);
    }

    public void deleteInfoLogObservers() {
        this.infoLog.deleteObservers();
    }

    public void addErrorLogObserver(Observer o) {
        this.errorLog.addObserver(o);
    }

    public void deleteErrorLogObserver(Observer o) {
        this.errorLog.deleteObserver(o);
    }

    public void deleteErrorLogObservers() {
        this.errorLog.deleteObservers();
    }

    public String getErrorLog() {
        return this.errorLog.getLogString();
    }

    public String getInfoLog() {
        return this.infoLog.getLogString();
    }

    public void addGUIComponent(GUIComponent component) {
    }

    public void initGUI(String title, boolean ontop, int width, int height) {
    }

    public JFrame getFrame() {
        return null;
    }

    public void runModel() {
    }

    public void loadModel(Document modelDocument, String defaultWorkspacePath) {
    }

    public ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public void saveModelParameter() {
    }

    public JAMSModel getModel() {
        return null;
    }

    public Document getModelDocument() {
        return null;
    }

    public void incrementRunCount(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRunCount(int n, Context c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

