/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutputDSDescriptor {
    private ContextDescriptor context;
    private String name;
    private boolean enabled = true;
    private ArrayList<ContextAttribute> contextAttributes = new ArrayList();
    private ArrayList<FilterDescriptor> filters = new ArrayList();

    public OutputDSDescriptor(ContextDescriptor context) {
        this.context = context;
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element dsElement = document.createElement("outputdatastore");
        dsElement.setAttribute("context", this.context.getInstanceName());
        dsElement.setAttribute("name", this.getName());
        dsElement.setAttribute("enabled", Boolean.toString(this.enabled));
        for (FilterDescriptor f : this.filters) {
            Element filterElement = document.createElement("filter");
            filterElement.setAttribute("context", f.context.getInstanceName());
            filterElement.setAttribute("expression", f.expression);
            dsElement.appendChild(filterElement);
        }
        Element traceElement = document.createElement("trace");
        dsElement.appendChild(traceElement);
        for (ContextAttribute ca : this.contextAttributes) {
            Element caElement = document.createElement("attribute");
            caElement.setAttribute("id", ca.getName());
            traceElement.appendChild(caElement);
        }
        document.appendChild(dsElement);
        return document;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<ContextAttribute> getContextAttributes() {
        return this.contextAttributes;
    }

    public ArrayList<FilterDescriptor> getFilters() {
        return this.filters;
    }

    public ContextDescriptor getContext() {
        return this.context;
    }

    public void setContext(ContextDescriptor context) {
        this.context = context;
    }

    public String toString() {
        if (this.isEnabled()) {
            char enabledChar = Character.toChars(9746)[0];
        } else {
            char enabledChar = Character.toChars(9744)[0];
        }
        return this.name + " [" + this.context.getInstanceName() + "]";
    }

    public FilterDescriptor addFilter(ContextDescriptor context, String expression) {
        FilterDescriptor f = new FilterDescriptor();
        f.context = context;
        f.expression = expression;
        this.filters.add(f);
        return f;
    }

    public void removeFilter(FilterDescriptor f) {
        this.filters.remove(f);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public class FilterDescriptor {
        public String expression;
        public ContextDescriptor context;

        public String toString() {
            return this.expression + " [" + this.context.getInstanceName() + "]";
        }
    }
}

