/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.data.DefaultDataFactory;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class ContextDescriptor
extends ComponentDescriptor {
    private HashMap<String, ContextAttribute> staticAttributes = new HashMap();
    private HashMap<String, ContextAttribute> dynamicAttributes = new HashMap();

    public ContextDescriptor(String instanceName, Class clazz) {
        super(instanceName, clazz);
    }

    public ContextDescriptor(String instanceName, Class clazz, String versionID, ComponentCollection md) {
        super(instanceName, clazz, versionID, md);
    }

    public ContextDescriptor(Class clazz, String versionID, ComponentCollection md) {
        super(clazz, versionID, md);
    }

    public ContextAttribute addDynamicAttribute(String name, Class type) {
        ContextAttribute ca = this.dynamicAttributes.get(name);
        if (ca != null) {
            throw new JAMSException(JAMS.i18n("Error_adding_context_attribute") + "\n" + MessageFormat.format(JAMS.i18n("Context_attribute_does_already_exist"), name));
        }
        ca = new ContextAttribute(name, type, this);
        this.getDynamicAttributes().put(name, ca);
        return ca;
    }

    public ContextAttribute addStaticAttribute(String name, Class type, String value) {
        ContextAttribute ca = this.staticAttributes.get(name);
        if (ca != null) {
            throw new JAMSException(JAMS.i18n("Error_adding_context_attribute") + "\n" + MessageFormat.format(JAMS.i18n("Context_attribute_does_already_exist"), name));
        }
        ca = new ContextAttribute(name, type, this);
        this.staticAttributes.put(name, ca);
        ca.setValue(value);
        return ca;
    }

    public void removeStaticAttribute(String name) {
        ContextAttribute ca = this.staticAttributes.get(name);
        this.staticAttributes.remove(name);
    }

    public HashMap<String, ContextAttribute> getStaticAttributes() {
        return this.staticAttributes;
    }

    public HashMap<String, ContextAttribute> getDynamicAttributes() {
        return this.dynamicAttributes;
    }

    public HashMap<String, ContextAttribute> getAttributes(Class<?> type) {
        type = DefaultDataFactory.getDataFactory().getBelongingInterface(type);
        HashMap<String, ContextAttribute> result = new HashMap<String, ContextAttribute>();
        for (Map.Entry<String, ContextAttribute> entry : this.dynamicAttributes.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getType())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, ContextAttribute> entry : this.staticAttributes.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue().getType())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public ContextDescriptor cloneNode() {
        Object caCopy;
        Object ca;
        ContextDescriptor copy = new ContextDescriptor(this.getInstanceName(), this.getClazz());
        for (String name : this.componentFields.keySet()) {
            ca = (ComponentField)this.componentFields.get(name);
            caCopy = new ComponentField(((ComponentField)ca).getName(), ((ComponentField)ca).getType(), ((ComponentField)ca).getAccessType(), this);
            ((ComponentField)caCopy).setValue(((ComponentField)ca).getValue());
            copy.componentFields.put(name, caCopy);
            if (((ComponentField)ca).getContextAttributes().size() <= 0) continue;
            ((ComponentField)caCopy).linkToAttribute(((ComponentField)ca).getContext(), ((ComponentField)ca).getAttribute());
        }
        for (String name : this.staticAttributes.keySet()) {
            ca = this.staticAttributes.get(name);
            caCopy = new ContextAttribute(((ContextAttribute)ca).getName(), ((ContextAttribute)ca).getType(), copy);
            ((ContextAttribute)caCopy).setValue(((ContextAttribute)ca).getValue());
            ((ContextAttribute)caCopy).getFields().addAll(((ContextAttribute)ca).getFields());
            copy.staticAttributes.put(name, (ContextAttribute)caCopy);
        }
        for (String name : this.dynamicAttributes.keySet()) {
            ca = this.dynamicAttributes.get(name);
            caCopy = new ContextAttribute(((ContextAttribute)ca).getName(), ((ContextAttribute)ca).getType(), copy);
            ((ContextAttribute)caCopy).setValue(((ContextAttribute)ca).getValue());
            ((ContextAttribute)caCopy).getFields().addAll(((ContextAttribute)ca).getFields());
            copy.dynamicAttributes.put(name, (ContextAttribute)caCopy);
        }
        return copy;
    }
}

