/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.tools.XMLTools;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelComposer {
    private Document template;
    private HashMap<String, Element> pluginBlocks;

    public ModelComposer(Document template) {
        this.template = template;
    }

    public void setTemplate(Document template) {
        this.template = template;
    }

    public Document loadPlugin(Document plugin) {
        this.pluginBlocks = new HashMap();
        NodeList blocks = plugin.getElementsByTagName("block");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Element block = (Element)blocks.item(i);
            this.pluginBlocks.put(block.getAttribute("name"), block);
        }
        Document result = (Document)this.template.cloneNode(true);
        NodeList slots = result.getElementsByTagName("slot");
        for (int i = 0; i < slots.getLength(); ++i) {
            Element slot = (Element)slots.item(i);
            Element block = this.pluginBlocks.get(slot.getAttribute("name"));
            NodeList blockNodes = block.getChildNodes();
            for (int j = 0; j < blockNodes.getLength(); ++j) {
                Node blockNode = blockNodes.item(j);
                if (!blockNode.getNodeName().equals("contextcomponent") && !blockNode.getNodeName().equals("component")) continue;
                Node newNode = result.importNode(blockNode, true);
                slot.getParentNode().insertBefore(newNode, slot);
            }
        }
        HashMap<String, Element> launcherGroups = new HashMap<String, Element>();
        Element templateLauncher = (Element)result.getElementsByTagName("launcher").item(0);
        NodeList groupNodes = templateLauncher.getElementsByTagName("group");
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element group = (Element)groupNodes.item(i);
            launcherGroups.put(group.getAttribute("name"), group);
        }
        Element pluginLauncher = (Element)plugin.getElementsByTagName("launcher").item(0);
        groupNodes = pluginLauncher.getElementsByTagName("group");
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element group = (Element)groupNodes.item(i);
            String groupName = group.getAttribute("name");
            Element templateGroup = (Element)launcherGroups.get(groupName);
            if (templateGroup != null) {
                NodeList propertyNodes = group.getChildNodes();
                for (int j = 0; j < propertyNodes.getLength(); ++j) {
                    Node newNode = result.importNode(propertyNodes.item(j), true);
                    templateGroup.appendChild(newNode);
                }
                continue;
            }
            Node newNode = result.importNode(group, true);
            templateLauncher.appendChild(newNode);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Document plugin = XMLTools.getDocument("D:/jamsapplication/j2k_gehlberg_snow_plugin.jam");
        Document template = XMLTools.getDocument("D:/jamsapplication/j2k_gehlberg_template.jam");
        ModelComposer comp = new ModelComposer(template);
        Document result = comp.loadPlugin(plugin);
        XMLTools.writeXmlFile(result, "D:/jamsapplication/j2k_gehlberg_result.jam");
    }
}

