/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.io.Serializable;
import java.text.ParseException;

public class JAMSTableDataArray
implements Serializable {
    private Attribute.Calendar time;
    private String[] values;

    public JAMSTableDataArray(Attribute.Calendar time, String[] values) {
        this.time = time;
        this.setValues(values);
    }

    public JAMSTableDataArray(String dataLine) throws ParseException {
        String[] parts = dataLine.split("\\s+");
        int valueNumber = parts.length - 1;
        if (parts.length > 1) {
            String dateString = parts[0];
            String timeString = parts[1];
            int dataReadIndex = 2;
            dateString = dateString + " " + timeString;
            valueNumber = parts.length - 2;
            Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
            cal.setValue(dateString, "yyyy-MM-dd HH:mm");
            this.setTime(cal);
            String[] theValues = new String[valueNumber];
            for (int i = 0; i < valueNumber; ++i) {
                theValues[i] = parts[dataReadIndex];
                ++dataReadIndex;
            }
            this.setValues(theValues);
        }
    }

    public Attribute.Calendar getTime() {
        return this.time;
    }

    public void setTime(Attribute.Calendar time) {
        this.time = time;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public int getLength() {
        return this.values.length;
    }

    public String toString() {
        String result = "";
        result = this.time == null ? result + "no time\n" : result + "time  : " + this.time.toString() + "\n";
        if (this.values == null) {
            result = result + "no values\n";
        } else {
            result = result + "values: ";
            boolean firstValue = true;
            for (String value : this.values) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    result = result + ",";
                }
                result = result + "<" + value + ">";
            }
        }
        return result;
    }
}

