/*
 * Decompiled with CFR 0.152.
 */
package jams.dataaccess;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSData;
import jams.dataaccess.DataAccessor;

public class BooleanAccessor
implements DataAccessor {
    Attribute.Boolean componentObject;
    Attribute.Boolean[] entityObject;
    int index;
    int accessType;

    public BooleanAccessor(DataFactory dataFactory, Attribute.Entity[] entities, JAMSData dataObject, String attributeName, int accessType) throws Attribute.Entity.NoSuchAttributeException {
        this.entityObject = new Attribute.Boolean[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (Attribute.Boolean)entities[i].getObject(attributeName);
                }
                catch (Attribute.Entity.NoSuchAttributeException nsae) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = dataFactory.createBoolean();
                entities[i].setObject(attributeName, (Object)this.entityObject[i]);
                continue;
            }
            throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + attributeName + JAMS.i18n("_does_not_exist!"));
        }
        this.accessType = accessType;
        this.componentObject = (Attribute.Boolean)dataObject;
    }

    public void initEntityData() {
        for (Attribute.Boolean v : this.entityObject) {
            v.setValue(this.componentObject.getValue());
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    public int getAccessType() {
        return this.accessType;
    }

    public JAMSData getComponentObject() {
        return this.componentObject;
    }
}

