/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSDoubleChecked;
import jams.data.JAMSEntity;
import jams.data.JAMSFloatChecked;
import java.util.HashMap;
import java.util.StringTokenizer;

public class JAMSEntityChecked
extends JAMSEntity {
    private HashMap<String, Object> values = new HashMap();
    private long id = -1L;

    @Override
    public void setFloat(String name, float attribute) {
        JAMSFloatChecked v = (JAMSFloatChecked)this.values.get(name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put(name, new JAMSFloatChecked(attribute));
        }
    }

    @Override
    public void setDouble(String name, double attribute) {
        JAMSDoubleChecked v = (JAMSDoubleChecked)this.values.get(name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put(name, new JAMSDoubleChecked(attribute));
        }
    }

    @Override
    public float getFloat(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((Attribute.Float)this.values.get(name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(float)_not_found!"));
    }

    @Override
    public double getDouble(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey(name)) {
            return ((Attribute.Double)this.values.get(name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(double)_not_found!"));
    }

    @Override
    public void setValue(String value) {
        StringTokenizer st1 = new StringTokenizer(value, "\t");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            String name = st2.nextToken().trim();
            String val = st2.nextToken().trim();
            try {
                JAMSDoubleChecked d = new JAMSDoubleChecked(Double.parseDouble(val));
                this.values.put(name, d);
            }
            catch (NumberFormatException nfe) {
                System.out.println("\"" + val + "\" is not a valid double expression!");
                nfe.printStackTrace();
            }
        }
    }
}

