/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayPool<T>
implements Serializable {
    static final int DefaultInitalSize = 100;
    IdList[] freeIdLists;
    int maxSize = 0;
    int allocatedObjects = 0;
    int Power = 1000000;
    Class c;

    public ArrayPool(Class c) {
        this.c = c;
        this.expandPool(100);
    }

    public ArrayPool(Class c, int n) {
        this.expandPool(n);
    }

    public T alloc(int size) {
        if (size >= this.maxSize) {
            ++this.allocatedObjects;
            return (T)Array.newInstance(this.c, size);
        }
        IdList freeIdList = this.freeIdLists[size];
        Object freeId = freeIdList.alloc();
        if (freeId == null) {
            ++this.allocatedObjects;
            if (this.allocatedObjects >= this.Power) {
                System.out.println("Memory Pool allocated: " + this.allocatedObjects);
                this.Power *= 10;
            }
            return (T)Array.newInstance(this.c, size);
        }
        return freeId;
    }

    public T free(T array) {
        int size = Array.getLength(array);
        if (size >= this.maxSize) {
            this.expandPool(size);
        }
        this.freeIdLists[size].free(array);
        return null;
    }

    private void expandPool(int size) {
        int oldSize = this.maxSize;
        this.maxSize = size + 1;
        IdList[] oldList = this.freeIdLists;
        this.freeIdLists = (IdList[])Array.newInstance(IdList.class, this.maxSize);
        if (oldList != null) {
            System.arraycopy(oldList, 0, this.freeIdLists, 0, oldSize);
        }
        for (int i = oldSize; i < this.maxSize; ++i) {
            this.freeIdLists[i] = new IdList();
        }
    }

    private class IdList
    implements Serializable {
        Object[] freeArrays = null;
        int lastIndex = -1;
        static final int initialAlloc = 8;

        public T alloc() {
            if (this.lastIndex >= 0) {
                return this.freeArrays[this.lastIndex--];
            }
            return null;
        }

        public void free(T array) {
            ++this.lastIndex;
            if (this.freeArrays == null) {
                this.freeArrays = new Object[8];
            }
            if (this.freeArrays.length <= this.lastIndex) {
                this.freeArrays = Arrays.copyOf(this.freeArrays, this.freeArrays.length * 2);
            }
            this.freeArrays[this.lastIndex] = array;
        }
    }
}

