/*
 * Decompiled with CFR 0.152.
 */
package jams;

import jams.meta.HelpComponent;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAMS {
    public static final int SILENT = 0;
    public static final int STANDARD = 1;
    public static final int VERBOSE = 2;
    public static final int VVERBOSE = 3;
    private static final double missingDataValue = Double.POSITIVE_INFINITY;
    private static ResourceBundle resources = ResourceBundle.getBundle("resources/i18n/JAMSBundle");
    private static String charset = "UTF-8";
    public static final Font STANDARD_FONT = new Font("Monospaced", 0, 11);
    public static final String DEFAULT_MODEL_PARAMETER_FILENAME = "model.jmp";
    public static final String DEFAULT_PARAMETER_FILENAME = "default.jap";
    private static String floatFormat = "%f";

    public static String i18n(String key) {
        if (JAMS.getResources().containsKey(key)) {
            return JAMS.getResources().getString(key);
        }
        Logger.getLogger(JAMS.class.getName()).log(Level.INFO, "Could not find i18n key \"" + key + "\", using the key as result!");
        return key;
    }

    public static HelpComponent getHelpDocument(String key) {
        String resourceName = "resources/help/i18n/" + key + "_" + Locale.getDefault().getLanguage() + ".html";
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        if (stream == null) {
            resourceName = "resources/help/i18n/" + key + ".html";
            stream = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                HelpComponent help = new HelpComponent();
                help.setHelpText("Resource " + resourceName + " was not found.");
                return help;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String result = "";
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result = result + line;
            }
            reader.close();
        }
        catch (IOException ioe) {
            return null;
        }
        HelpComponent help = new HelpComponent();
        help.setHelpText(result);
        return help;
    }

    public static ResourceBundle getResources() {
        return resources;
    }

    public static void setResources(ResourceBundle aResources) {
        resources = aResources;
    }

    public static String getCharset() {
        return charset;
    }

    public static void setCharset(String aCharset) {
        charset = aCharset;
    }

    public static String getFloatFormat() {
        return floatFormat;
    }

    public static void setFloatFormat(String aFloatFormat) {
        floatFormat = aFloatFormat;
    }

    public static double getMissingDataValue() {
        return Double.POSITIVE_INFINITY;
    }

    public static Object getMissingDataValue(Class c) {
        if (c == Double.TYPE) {
            return new Double(JAMS.getMissingDataValue());
        }
        if (c == Integer.TYPE) {
            return new Integer(Integer.MAX_VALUE);
        }
        if (c == Long.TYPE) {
            return new Long(Long.MAX_VALUE);
        }
        if (c == String.class) {
            return null;
        }
        return null;
    }
}

