/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.style.Description;
import org.opengis.util.Cloneable;
import org.opengis.util.InternationalString;

public class StyleImpl
implements Style,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");
    private List<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
    private String abstractText = "";
    private String name = "Default Styler";
    private String title = "Default Styler";
    private boolean defaultB = false;

    protected StyleImpl() {
    }

    public Description getDescription() {
        return new Description(){

            public InternationalString getAbstract() {
                return new SimpleInternationalString(StyleImpl.this.abstractText);
            }

            public InternationalString getTitle() {
                return new SimpleInternationalString(StyleImpl.this.title);
            }

            public void accept(org.opengis.style.StyleVisitor visitor) {
                visitor.visit((Description)this, null);
            }
        };
    }

    public String getAbstract() {
        return this.abstractText;
    }

    public FeatureTypeStyle[] getFeatureTypeStyles() {
        FeatureTypeStyle[] ret = new FeatureTypeStyleImpl[]{new FeatureTypeStyleImpl()};
        if (this.featureTypeStyles != null && this.featureTypeStyles.size() != 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("number of fts set " + this.featureTypeStyles.size());
            }
            ret = this.featureTypeStyles.toArray(new FeatureTypeStyle[0]);
        }
        return ret;
    }

    public void setFeatureTypeStyles(FeatureTypeStyle[] styles) {
        List<FeatureTypeStyle> newStyles = Arrays.asList(styles);
        this.featureTypeStyles.clear();
        this.featureTypeStyles.addAll(newStyles);
        LOGGER.fine("StyleImpl added " + this.featureTypeStyles.size() + " feature types");
    }

    public void addFeatureTypeStyle(FeatureTypeStyle type) {
        this.featureTypeStyles.add(type);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDefault() {
        return this.defaultB;
    }

    public void setAbstract(String abstractStr) {
        this.abstractText = abstractStr;
    }

    public void setDefault(boolean isDefault) {
        this.defaultB = isDefault;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Style clone;
        try {
            clone = (Style)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        FeatureTypeStyle[] ftsArray = new FeatureTypeStyle[this.featureTypeStyles.size()];
        for (int i = 0; i < ftsArray.length; ++i) {
            FeatureTypeStyle fts = this.featureTypeStyles.get(i);
            ftsArray[i] = (FeatureTypeStyle)((Cloneable)fts).clone();
        }
        clone.setFeatureTypeStyles(ftsArray);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.featureTypeStyles != null) {
            result = 1000003 * result + ((Object)this.featureTypeStyles).hashCode();
        }
        if (this.abstractText != null) {
            result = 1000003 * result + this.abstractText.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        result = 1000003 * result + (this.defaultB ? 1 : 0);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyleImpl) {
            StyleImpl other = (StyleImpl)oth;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.title, (Object)other.title) && Utilities.equals((Object)this.abstractText, (Object)other.abstractText) && Utilities.equals(this.featureTypeStyles, other.featureTypeStyles);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StyleImpl");
        buf.append("[");
        if (this.name != null) {
            buf.append(" name=");
            buf.append(this.name);
        } else {
            buf.append(" UNNAMED");
        }
        if (this.defaultB) {
            buf.append(", DEFAULT");
        }
        buf.append("]");
        return buf.toString();
    }
}

