/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.resources.Utilities;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalGraphicImpl
implements ExternalGraphic,
Symbol,
Cloneable {
    private URL location = null;
    private String format = null;
    private String uri = null;
    private Map<String, Object> customProps = null;

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        if (this.location == null) {
            this.location = new URL(this.uri);
        }
        return this.location;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setLocation(URL location) {
        this.uri = location.toString();
        this.location = location;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.format != null) {
            result = 1000003 * result + this.format.hashCode();
        }
        if (this.uri != null) {
            result = 1000003 * result + this.uri.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof ExternalGraphicImpl) {
            ExternalGraphicImpl other = (ExternalGraphicImpl)oth;
            return Utilities.equals((Object)this.uri, (Object)other.uri) && Utilities.equals((Object)this.format, (Object)other.format);
        }
        return false;
    }

    @Override
    public Map<String, Object> getCustomProperties() {
        return this.customProps;
    }

    @Override
    public void setCustomProperties(Map<String, Object> list) {
        this.customProps = list;
    }
}

