/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.fits.FitsDatatype;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.util.Cursor;

public class FitsDataset
extends ScalarDS {
    private static final long serialVersionUID = 3944770379558335171L;
    private List attributeList;
    private BasicHDU nativeDataset;

    public FitsDataset(FileFormat fileFormat, BasicHDU hdu, String dName, long[] oid) {
        super(fileFormat, dName, "/", oid);
        this.unsignedConverted = false;
        this.nativeDataset = hdu;
    }

    public boolean hasAttribute() {
        return false;
    }

    public Dataset copy(Group pgroup, String dstName, long[] dims, Object buff) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public byte[] readBytes() throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public Object read() throws Exception {
        Object theData = null;
        Object fitsData = null;
        if (this.nativeDataset == null) {
            return null;
        }
        try {
            fitsData = this.nativeDataset.getData().getData();
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("This implementation only supports integer and float dataset. It may not work for other datatypes. \n" + ex);
        }
        int n = this.get1DLength(fitsData);
        theData = FitsDatatype.allocateArray(this.nativeDataset.getBitPix(), n);
        this.to1Darray(fitsData, theData, 0);
        return theData;
    }

    public void write(Object buf) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public List getMetadata() throws Exception {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        if (this.nativeDataset == null) {
            return null;
        }
        Header header = this.nativeDataset.getHeader();
        if (header == null) {
            return null;
        }
        this.attributeList = new Vector();
        HeaderCard hc = null;
        Cursor it = header.iterator();
        Attribute attr = null;
        FitsDatatype dtype = new FitsDatatype(3, 80, 0, 0);
        long[] dims = new long[]{1L};
        String value = null;
        while (it.hasNext()) {
            value = "";
            hc = (HeaderCard)it.next();
            attr = new Attribute(hc.getKey(), (Datatype)dtype, dims);
            String tvalue = hc.getValue();
            if (tvalue != null) {
                value = value + tvalue;
            }
            if ((tvalue = hc.getComment()) != null) {
                value = value + " / " + tvalue;
            }
            attr.setValue((Object)value);
            this.attributeList.add(attr);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public void removeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public int open() {
        return -1;
    }

    public void close(int did) {
    }

    public void init() {
        if (this.nativeDataset == null) {
            return;
        }
        if (this.rank > 0) {
            return;
        }
        int[] axes = null;
        try {
            axes = this.nativeDataset.getAxes();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (axes == null) {
            return;
        }
        this.rank = axes.length;
        if (this.rank == 0) {
            this.rank = 1;
            this.dims = new long[1];
            this.dims[0] = 1L;
        } else {
            this.dims = new long[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                this.dims[i] = axes[i];
            }
        }
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedDims[1] = 1L;
        }
    }

    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    public byte[][] readPalette(int idx) {
        return null;
    }

    public static FitsDataset create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public byte[] getPaletteRefs() {
        return null;
    }

    public Datatype getDatatype() {
        if (this.datatype == null) {
            try {
                this.datatype = new FitsDatatype(this.nativeDataset.getBitPix());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.datatype;
    }

    public void setName(String newName) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    private int get1DLength(Object data) throws Exception {
        if (!data.getClass().isArray()) {
            return 1;
        }
        int len = Array.getLength(data);
        int total = 0;
        for (int i = 0; i < len; ++i) {
            total += this.get1DLength(Array.get(data, i));
        }
        return total;
    }

    private int to1Darray(Object dataIn, Object dataOut, int offset) throws Exception {
        Class<?> component = dataIn.getClass().getComponentType();
        if (component == null) {
            return offset;
        }
        int size = Array.getLength(dataIn);
        if (!component.isArray()) {
            System.arraycopy(dataIn, 0, dataOut, offset, size);
            return offset + size;
        }
        for (int i = size - 1; i >= 0; --i) {
            offset = this.to1Darray(Array.get(dataIn, i), dataOut, offset);
        }
        return offset;
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

