/*
 * ShuffleComplexEvolution.java
 * Created on 30. Juni 2006, 15:12
 *
 * This file is part of JAMS
 * Copyright (C) 2005 S. Kralisch and P. Krause
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 */

package org.unijena.j2k;

//import jams.components.efficiencies.NashSutcliffe;
//import jams.components.efficiencies.VolumeError;
import jams.JAMS;
import java.io.IOException;
import java.util.*;
import java.util.Arrays;
import java.util.Random;

import java.util.StringTokenizer;
import jams.data.*;
import jams.io.GenericDataWriter;
import jams.model.*;
import java.util.Arrays.*;
import org.unijena.j2k.efficiencies.NashSutcliffe;
import org.unijena.j2k.efficiencies.VolumeError;

/**
 *
 * @author Christian Fischer, based on the original MatLab sources
 * from SAHRA Tuscon Arizona
 */
@JAMSComponentDescription(
title="Title",
        author="Author",
        description="Description"
        )
        public class SCE extends JAMSContext {

    /*
     *  Component variables
     */

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READ,
            description = "List of parameter identifiers to be sampled"
            )
            public Attribute.String parameterIDs;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READ,
            description = "List of parameter value bounaries corresponding to parameter identifiers"
            )
            public Attribute.String boundaries;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READ,
            description = "objective function name"
            )
            public Attribute.String effMethodName;

    /*@JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "objective function value"
            )
            public Attribute.Double effValue;*/

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "the prediction series"
            )
            public Attribute.DoubleArray prediction;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "the observation series"
            )
            public Attribute.DoubleArray observation;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "maximize efficiency?"
            )
            public Attribute.Integer MaximizeEff;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "number of complexes"
            )
            public Attribute.Integer NumberOfComplexes;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "maximum runs"
            )
            public Attribute.Integer maxn;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "kstop"
            )
            public Attribute.Integer kstop;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "pcento"
            )
            public Attribute.Double pcento;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READWRITE,
            description = "peps"
            )
            public Attribute.Double peps;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READ,
            description = "Flag for enabling/disabling this sampler"
            )
            public Attribute.Boolean enable;

    @JAMSVarDescription(
    access = JAMSVarDescription.AccessType.READ,
            description = "Output file name"
            )
            public Attribute.String sceFileName;

    Attribute.Double[] parameters;
    String[] parameterNames;
    double[] lowBound;
    double[] upBound;

    int currentCount;
    Random generator = new Random();

    GenericDataWriter writer;

    static final int MAXIMIZATION = 1;
    static final int MINIMIZATION = 2;
    static final int ABSMAXIMIZATION = 3;
    static final int ABSMINIMIZATION = 4;


//matlab zufallszahlen ..
/*    int randcounter = 0;
    static double MatlabRand[] = {
0.999992173630741	,0.868462211856834	,0.244394677804967	,0.541349868076551	,0.467232762587831	,0.78104081367191	,0.952955383785514	,0.321135283131681	,0.320703594163388	,0.0653071040591724	,0.616497922510141	,0.480583627932045	,0.169034653887634	,0.965427889472539	,0.946538364955475	,0.470299806664837	,0.328850615922758	,0.992301813788853	,0.616584349245105	,0.933157762481439	,0.582514025542193	,0.313227287639504	,0.411023357143171	,0.0695635052721778	,0.153833109491427	,0.47307122241383	,0.908035109242441	,0.346081037701145	,0.584000643149019	,0.298809405555394	,0.0896791695103418	,0.237801960314532	,0.73754700633583	,0.952535486292343	,0.263918115414641	,0.671765773869942	,0.367361432112456	,0.243589514048579	,0.00896261446595314	,0.634661329274374	,0.752961114399583	,0.0174497137858764	,0.277339599224431	,0.246644165016079	,0.348481425246448	,0.927314117051342	,0.368365281898698	,0.115292871424599	,0.727290033235815	,0.56358859434891	,0.233505222123817	,0.522268234995319	,0.762225566321158	,0.725093159696596	,0.640735020693734	,0.833492799584518	,0.51348261698777	,0.10234371344668	,0.090791898356188	,0.939435672452411	,0.0953469076637863	,0.495477105255927	,0.483708036357401	,0.680967058837864	,0.0133578879820918	,0.506023315017123	,0.733855492777124	,0.909267105119893	,0.0522357500401492	,0.926250924787601	,0.499292905209257	,0.615857851978325	,0.722918199711907	,0.0861825580178679	,0.470252606305411	,0.535554175048859	,0.0590200461722072	,0.949916016287131	,0.238485737814794	,0.229795453245656	,0.172182699745606	,0.874634624400472	,0.98413229872665	,0.31154469880813	,0.131752868244309	,0.370456582107794	,0.263775485690579	,0.274588001554174	,0.000542121008290966	,0.111427786346258	,0.766805121566544	,0.693678168902955	,0.648984751966309	,0.486726297757927	,0.408886417471285	,0.154018439889894	,0.587919229449667	,0.158489360547852	,0.730682727755365	,0.584605384424611
,0.462696024432171	,0.532082631500476	,0.712787628505746	,0.821672296068478	,0.846280022918377	,0.428345189163622	,0.19759427299611	,0.966946245621399	,0.465550158855296	,0.501519880956747	,0.0446392400398102	,0.251707349089769	,0.445416151753355	,0.109262518635608	,0.375150708656363	,0.157960387486015	,0.840232477448989	,0.787248485156916	,0.285290032292386	,0.86957273812479	,0.909009663345762	,0.725411852228181	,0.997000399044249	,0.585706736699541	,0.973123709193023	,0.290180407133969	,0.0621027006125556	,0.760089195221704	,0.819104091180071	,0.682460463457955	,0.11300933785411	,0.347941314032274	,0.849664940428764	,0.318653786237656	,0.614185296285052	,0.61227466287663	,0.500258967513339	,0.852466996690476	,0.412813376827544	,0.154424340536084	,0.409891389966892	,0.0445911735503893	,0.443853861393339	,0.851848437847499	,0.0166949029158311	,0.591233306374044	,0.858180228554728	,0.435101319307043	,0.747873593470023	,0.511485450673609	,0.535969471342847	,0.0389048592368629	,0.873969193954938	,0.800242800638193	,0.680750326104812	,0.37073084356763	,0.873287841153	,0.348746258462195	,0.378365974118172	,0.196927004119813	,0.752158241696729	,0.523568196931653	,0.610685830288886	,0.79674966530723	,0.971624818617303	,0.0983265010166571	,0.573502586955904	,0.857978967883614	,0.0525132199062562	,0.589686964447464	,0.868811468532687	,0.114351628867142	,0.90782637005105	,0.837801447993983	,0.92893643487661	,0.634660971180844	,0.746942636439084	,0.864890631691036	,0.21684683124388	,0.544692715883578	,0.650475855288317	,0.547699830749864	,0.191055412958868	,0.0683255996873256	,0.348353944881053	,0.784751615852468	,0.320407632421892	,0.0910781147382586	,0.749874405912065	,0.139140164078744	,0.528737671453849	,0.494044124844505	,0.39960626158845	,0.182438517074305	,0.244156467842011	,0.537755020678861	,0.0486325496102835	,0.367261300034477	,0.560669679455771	,0.175302613142553
,0.311019086889466	,0.297793351252467	,0.0128545002140359	,0.0455850973006268	,0.148730331635443	,0.710683796885742	,0.462574258662096	,0.485565333853273	,0.896566071965064	,0.585971516829902	,0.423283360164279	,0.123434281034132	,0.559961340650898	,0.270252319644323	,0.130736262132757	,0.284357665239069	,0.199279673024677	,0.293464525739413	,0.258284102314284	,0.980907596173188	,0.113968882762812	,0.475012594589504	,0.536677265789675	,0.934806127070825	,0.28657767935031	,0.511056840657749	,0.332320934781954	,0.317950880303025	,0.800445252936541	,0.0833661044404684	,0.134117330952602	,0.10998132038395	,0.456051693044627	,0.860805001045021	,0.549652563663969	,0.0106375003283087	,0.784468017883817	,0.553976573307988	,0.684267587347081	,0.485340542385979	,0.118495881146982	,0.560274437330791	,0.532468218604321	,0.193350082819047	,0.63484193973003	,0.788481042621881	,0.000883345958256789	,0.846395520421861	,0.369511730209697	,0.383649634376005	,0.999404957517704	,0.99912100005854	,0.226647983876359	,0.272665009960842	,0.680822411869104	,0.582276284034493	,0.317505767716796	,0.319438016190863	,0.794738119838172	,0.163580120151667	,0.291079389066938	,0.171292048027409	,0.905451196667483	,0.918262390381779	,0.235995146555824	,0.370428163730739	,0.786147822526352	,0.786453200404743	,0.918939202520502	,0.611176762083162	,0.0478403317033501	,0.0524549382051709	,0.610146414307014	,0.730785257988975	,0.307831020703461	,0.715964963061719	,0.223134178306504	,0.21613479741669	,0.577540182311805	,0.717844114507476	,0.806032527147807	,0.988683773199415	,0.808176162563346	,0.0167642021629793	,0.755945753192504	,0.180273906411731	,0.863545061956879	,0.601856309269488	,0.398989892284847	,0.823119631420411	,0.171645282847642	,0.842268820312931	,0.0120629994254853	,0.742831344130836	,0.766400806962699	,0.898362622083334	,0.780589354587993	,0.365282560403125	,0.303992695316669	,0.205230187254599
,0.303757188051826	,0.247059587038616	,0.330479358011149	,0.366570093374034	,0.943559337381068	,0.401783363615062	,0.772992278343529	,0.681222119685832	,0.300165559770616	,0.882563064751478	,0.237429278081949	,0.47387672330899	,0.446088654196862	,0.412011086666962	,0.670333611625402	,0.297010588132316	,0.856954739828107	,0.838312290999253	,0.514674824436509	,0.139774304414063	,0.186734287155203	,0.443164217492176	,0.261003391007429	,0.683992661854249	,0.864667784359617	,0.4714517320839	,0.689261134103528	,0.411880877992083	,0.481916412935553	,0.569152207844496	,0.741157242442089	,0.629773724186129	,0.606982396266881	,0.553134057462743	,0.524103776330177	,0.612168781278734	,0.720706951674403	,0.921736791693483	,0.63025799236738	,0.74607771856062	,0.328215848341685	,0.323763078695053	,0.486063627752505	,0.271391636352703	,0.279232179876059	,0.0552471769299578	,0.539302661800432	,0.0598368798661217	,0.678439909908194	,0.539565827017448	,0.48285468224569	,0.338644503307829	,0.598167094680559	,0.394360296146181	,0.0134973288576572	,0.849606110644343	,0.329901599478862	,0.656182441234674	,0.45828983115884	,0.477192286624197	,0.170761292879824	,0.985049431205285	,0.725790267216875	,0.357021114023878	,0.45386339931463	,0.0821522809947619	,0.733386678962683	,0.0299133258079706	,0.753266854562455	,0.156024631185469	,0.305976334170427	,0.544248402372118	,0.182898668191814	,0.977916299820839	,0.83925108883495	,0.293050049009291	,0.292173699146218	,0.563361550477967	,0.417578883197894	,0.248289907001094	,0.0084669673854797	,0.30432084775731	,0.720488257110346	,0.246137253589061	,0.828821071343879	,0.995746076570706	,0.504308923848117	,0.92008311530579	,0.836918944416996	,0.0966988164450502	,0.217007991958879	,0.253320852878187	,0.563574323693092	,0.99365830979946	,0.415212799522659	,0.481521577332877	,0.933150233669742	,0.4559772873558	,0.6102685889277	,0.784174107845954
,0.614230566944103	,0.373138629539469	,0.340946669849077	,0.290680153430756	,0.461338710720343	,0.719711076803371	,0.184067834254386	,0.628090313462583	,0.313898365625133	,0.689831061609942	,0.990652478295682	,0.896202715531086	,0.479039930961579	,0.224119671259131	,0.779314852216893	,0.944721209325232	,0.929365129177163	,0.839726080577693	,0.276236269286012	,0.702977890010447	,0.949397405585925	,0.522195682638416	,0.54283810385635	,0.480011513680225	,0.553510423541772	,0.849688466568332	,0.714057613962357	,0.166317865329943	,0.304362600345333	,0.422224004018225	,0.318835534303838	,0.668825044608128	,0.94252472880414	,0.0131170111769424	,0.457606850870702	,0.998342583886507	,0.143807380527168	,0.970644520116339	,0.622449595305347	,0.510348296961909	,0.423827038809577	,0.261041272553169	,0.320667801108522	,0.463733230933423	,0.964412298036931	,0.877493106703038	,0.0266443579581773	,0.811724203085398	,0.648681256290842	,0.385874480188766	,0.392388532586577	,0.87406718259401	,0.447137857529865	,0.0459715044339986	,0.643075022214593	,0.161898360663046	,0.0257476638191136	,0.740985807842103	,0.748472402220812	,0.575664125185303	,0.186951989395056	,0.102085762704763	,0.755413778943668	,0.239382706228356	,0.305143579982754	,0.548148770140553	,0.736379752278505	,0.334496544829801	,0.883428954465049	,0.790437694075721	,0.886324330645764	,0.45302516336228	,0.993920629841239	,0.82402574169637	,0.400640690885783	,0.568091717347545	,0.917493460195834	,0.312585511390392	,0.624689938325756	,0.163793440984466	,0.876362625917589	,0.0266537969124754	,0.970364707973956	,0.919646918270573	,0.505755373512281	,0.230562620903627	,0.0659695272641115	,0.749844727921227	,0.640342172067772	,0.230885943039733	,0.500044668791836	,0.250748384395031	,0.328096527293369	,0.318334219659834	,0.243229822834595	,0.963632381038569	,0.769428115230719	,0.778332682688875	,0.43739795192955	,0.347378079941207
,0.383389571860148	,0.628534253513689	,0.775198804575577	,0.766308501719641	,0.346988402002951	,0.834072463602793	,0.255895772136699	,0.840242301505172	,0.952361397423018	,0.338006488670598	,0.875055086740784	,0.0508428523553735	,0.515819536762228	,0.37895436276633	,0.0859750137133408	,0.982055480117935	,0.406454342141028	,0.278128364252918	,0.503417998786745	,0.946305608817518	,0.55836739603354	,0.480825135708239	,0.228055848380577	,0.934643732353413	,0.557209663818222	,0.022819792862432	,0.532258638894306	,0.670943896598622	,0.554070133042554	,0.256726046212356	,0.794658691061036	,0.828620662832922	,0.627480232914668	,0.060274596819782	,0.035148750075674	,0.745042521853485	,0.929664791528911	,0.876151226403262	,0.473662159626215	,0.839916837792805	,0.482292783671195	,0.894815161775246	,0.158423956557374	,0.631437859792001	,0.576109524153224	,0.67277244323528	,0.286453455354298	,0.423224139690038	,0.12811577046668	,0.241754233484042	,0.163402166293656	,0.300208897469663	,0.610939772618441	,0.0647583981346145	,0.394397448466345	,0.63791637385167	,0.460495325019814	,0.54492760800986	,0.5983078217126	,0.759559523667935	,0.916914286984556	,0.578421349440898	,0.527620053164484	,0.710233535482657	,0.89503085701495	,0.783613850261836	,0.197981350681736	,0.472560907934122	,0.331179648791989	,0.136357246961611	,0.756249683795613	,0.288435552869195	,0.736337072558858	,0.617178496726406	,0.918994480706283	,0.540237230500317	,0.767133018824799	,0.204647388404537	,0.508656915048443	,0.996771219184981	,0.733880841980633	,0.335311168495245	,0.574808899580878	,0.813175255811389	,0.0365244220181016	,0.865960858234186	,0.204144341966205	,0.0539554259991066	,0.828844766984156	,0.393998702705837	,0.93619637700552	,0.652508331766589	,0.707532001057422	,0.490341772088009	,0.174163483164349	,0.165661543219193	,0.273556884971241	,0.670565711646604	,0.197915644477082	,0.36823672632139
,0.954659283605711	,0.958579561188156	,0.846684889330848	,0.232934983555663	,0.938268620026423	,0.480696784090575	,0.0708502102973173	,0.779484467012568	,0.795437080224714	,0.911007336765066	,0.300309010455529	,0.293538726071612	,0.505369085588199	,0.73822148085489	,0.288428728137365	,0.621633804692716	,0.79935547048196	,0.767392390299306	,0.563903760427564	,0.530501506072703	,0.13881256391239	,0.0227616755397812	,0.555480797102433	,0.965756900592594	,0.476228259725602	,0.968361208200623	,0.246826227869292	,0.408411799188895	,0.177108967759232	,0.670421129404763	,0.767921905856543	,0.463471730921172	,0.569381592129069	,0.596418913265885	,0.012675259733887	,0.0330903474395584	,0.149469416658147	,0.132485773476067	,0.688394812256282	,0.851609591325563	,0.00240140874050623	,0.360476701688243	,0.531925274306873	,0.0680852756221245	,0.30922738104557	,0.184593232900181	,0.458465353333608	,0.427193477948752	,0.840783884674676	,0.0547497272746403	,0.178666304880132	,0.844586120380362	,0.958925232737756	,0.656386623464705	,0.889980571293263	,0.903461725871759	,0.481226726659214	,0.977594961401818	,0.438516280352378	,0.143123882423678	,0.483091894762168	,0.325475267751829	,0.262825104996015	,0.301539668022441	,0.977200453159027	,0.808016243767001	,0.329008991983258	,0.654128262612097	,0.933709721515751	,0.859289515232336	,0.0788825098792475	,0.778343540513117	,0.619885403951577	,0.413984214148477	,0.832687193449907	,0.973660312580718	,0.308873544125293	,0.237656113802295	,0.28630467517595	,0.922675682195777	,0.410190664422787	,0.0744969537828569	,0.0703022284760616	,0.569553997167178	,0.494030388767845	,0.168744021173913	,0.0807638699564915	,0.398362358751876	,0.276163542771788	,0.480663365442615	,0.509182994025379	,0.838580584544028	,0.0238844314701317	,0.425639718503524	,0.726748888719244	,0.468572704339667	,0.301441836776883	,0.332950709077041	,0.902567457828004	,0.451263715257525
,0.389262333227909	,0.33203456147203	,0.504874660402944	,0.428417392274559	,0.411111958516348	,0.558686784263089	,0.848783109732337	,0.497725271385966	,0.268636183938308	,0.968343451138746	,0.948383288899615	,0.47793653583058	,0.679357704557179	,0.964940492513096	,0.754857667607655	,0.892819481851915	,0.617031485129628	,0.448170573659321	,0.402831492201812	,0.388889435859811	,0.0647484958473353	,0.227969706164659	,0.486851509421529	,0.513318847638238	,0.349872255860768	,0.303004251934124	,0.592462256826676	,0.513150485937088	,0.520217144638401	,0.28954993760658	,0.465801353783254	,0.72335303515352	,0.394461825208022	,0.719896271228742	,0.29663054146647	,0.469510426963452	,0.0617459747296506	,0.764597281238342	,0.586505772819047	,0.402523769718839	,0.216997664522844	,0.0797476354426461	,0.318508884552172	,0.178822668352547	,0.472587001264369	,0.769730250243903	,0.856315849281995	,0.100478882482498	,0.748577883350001	,0.348485463461133	,0.995184391269081	,0.0640640594363511	,0.724646946752745	,0.141234073388034	,0.721071432680391	,0.0475690593233188	,0.493180047019003	,0.877050248383102	,0.583524574797379	,0.29752861955088	,0.56350879164576	,0.892261190289753	,0.233825199880556	,0.900134392501849	,0.55873477857501	,0.655423510193556	,0.702935823101055	,0.242378859427934	,0.661490405286425	,0.669241648944673	,0.944393813118522	,0.426817082998723	,0.514713959542436	,0.79751802971471	,0.885525415132533	,0.0256521324746553	,0.13539050153242	,0.508159255379885	,0.63260516972868	,0.195087629926897	,0.837796181364821	,0.840420198552506	,0.942277071970644	,0.850748610613285	,0.531898577479598	,0.619391699609995	,0.116295345181737	,0.575866469450233	,0.587752050062526	,0.348705400875167	,0.69167250892691	,0.939857534570553	,0.185583527286343	,0.102343101567749	,0.0805080491493028	,0.0987820523319682	,0.229953543390126	,0.829203757843563	,0.427558076767045	,0.968596223727146
,0.196732182147322	,0.477785350046021	,0.138378223468726	,0.722801838872396	,0.130505928364818	,0.413138027495303	,0.61082811356095	,0.188104618893985	,0.474329751205784	,0.0601285156142565	,0.579961928809044	,0.420137493601133	,0.25085495424031	,0.119215916897736	,0.661915300256533	,0.810451411553869	,0.25687398587208	,0.281080552042034	,0.120838170461747	,0.927130950580878	,0.289886412811413	,0.120940121412715	,0.640620583501002	,0.910146901342155	,0.838970857597408	,0.583203639641033	,0.903571446846971	,0.325307157042114	,0.437388406804478	,0.1869531628615	,0.121808213238515	,0.230639899722598	,0.364794637712089	,0.103476027074957	,0.121587048806989	,0.513529299066183	,0.886929405334838	,0.622515462628806	,0.617380402338403	,0.312422101531374	,0.878260437808121	,0.923178241086741	,0.856697944857505	,0.522359220088627	,0.291412029551068	,0.7619806648055	,0.60903338604096	,0.0241191904172856	,0.37123334331961	,0.31880117269177	,0.0913094305858526	,0.637599856423959	,0.140786917480075	,0.205722087624353	,0.571126702507551	,0.926489044412267	,0.501369436970618	,0.516127165181621	,0.549265207512893	,0.500342669198449	,0.259241218333711	,0.0671565346732533	,0.699878253368604	,0.853804366129359	,0.889981536143451	,0.919677962977289	,0.0275237592996674	,0.591822549510665	,0.761589625739301	,0.0368398004383034	,0.16652596656537	,0.801920064167082	,0.870518456152882	,0.803692561482868	,0.660880842553862	,0.424320802755803	,0.559731916785115	,0.414325407433475	,0.567122734415868	,0.631797327488566	,0.617683100336084	,0.399867348559139	,0.570527233449056	,0.851212578290707	,0.329803331908678	,0.00459938915660576	,0.301933555073074	,0.597260113152331	,0.150721751223654	,0.180472815959003	,0.206617822966826	,0.625750603445689	,0.990392111703005	,0.520221392400666	,0.36094207799106	,0.353504795745716	,0.355102098246618	,0.20096523091242	,0.622635945036372	,0.642328226306629
,0.610499535505893	,0.665693247535123	,0.306411322814604	,0.855102545048624	,0.708474632216838	,0.333143668404382	,0.14563487244101	,0.685301116055483	,0.85585754451149	,0.397750604617293	,0.994411802848061	,0.0791704673688721	,0.618045068633764	,0.483468527665114	,0.655544467575636	,0.735866543713895	,0.709000199432019	,0.166351853947319	,0.875609292590809	,0.365380573722245	,0.95130254977909	,0.541954137171597	,0.62318344303555	,0.844127098491475	,0.244144346213035	,0.334026802486753	,0.988469394849832	,0.20511924112454	,0.439085580147377	,0.711345536965572	,0.584439780369606	,0.679388671964122	,0.485409701003418	,0.280844764449096	,0.157956095951589	,0.768104658354122	,0.534992957736828	,0.626640682866164	,0.94995693161616	,0.926149672794225	,0.79755065254753	,0.433817366340113	,0.168476078272088	,0.577447518975217	,0.160451416466595	,0.706956554067767	,0.818804216952438	,0.642474319619348	,0.0658898423732677	,0.410580767509798	,0.630959537174068	,0.536941284563831	,0.37216966430292	,0.0555479391736667	,0.594213691816765	,0.949518364364988	,0.555149882359034	,0.404072808289934	,0.251688928926219	,0.135828462958256	,0.868976939408563	,0.895420639726995	,0.334691891602563	,0.16662216427113	,0.418714904887003	,0.341406435864701	,0.0179675780320389	,0.98108398447795	,0.0785271209098991	,0.805321132673566	,0.0322768446208336	,0.476927542349756	,0.721204272341544	,0.280205244328922	,0.409541436196091	,0.162918147706854	,0.165308509098975	,0.340112426476605	,0.269551792307548	,0.356973312961391	,0.650470942096073	,0.465123808693664	,0.335852714411846	,0.676571119891746	,0.130812020567624	,0.557629680055021	,0.0820326847406256	,0.723332435695144	,0.0482467282788114	,0.882762181983684	,0.583992599781599	,0.163624529337336	,0.0374645725998397	,0.667071685505599	,0.473818292596293	,0.464043665893396	,0.181892670310052	,0.0701099010510882	,0.337106965639213	,0.756771498246478
,0.0585710285504214	,0.403276846931911	,0.87396638462039	,0.753026314896078	,0.113274458382872	,0.80382204093217	,0.83704194698345	,0.164002950845288	,0.3975948567491	,0.376757382125015	,0.161321375128497	,0.3283517846504	,0.608444619275837	,0.128716168985104	,0.332652132647416	,0.884393405115415	,0.999959774781	,0.323934744263037	,0.371246828870497	,0.545452826444736	,0.425654056680228	,0.967730624586218	,0.648607420571431	,0.144917544044982	,0.629162764004042	,0.338574615930475	,0.423569943487444	,0.940040193470214	,0.255531653880855	,0.720506775528428	,0.557376306297898	,0.823579948779	,0.908199128652084	,0.102755255579369	,0.00758052245135443	,0.405840839913972	,0.966996434129307	,0.309068411266929	,0.512788163271168	,0.430660098526003	,0.10427592653049	,0.56549719793978	,0.311405773885271	,0.796841689756532	,0.518279738034252	,0.727557141672614	,0.0528800916172937	,0.755699811855191	,0.0467378501997971	,0.523048307990212	,0.872912391495384	,0.0385638629265893	,0.142844207185714	,0.782590170289665	,0.992992058393076	,0.217525412429834	,0.949606708227474	,0.039945179149483	,0.358625965359912	,0.42659980404498	,0.862906583986667	,0.870957063916585	,0.175373246043629	,0.498146255266921	,0.344112271137588	,0.494941009439035	,0.47354564185885	,0.881602721699329	,0.0969436006140632	,0.33109552056114	,0.722414071076742	,0.613292586809626	,0.608506509386239	,0.168903254516843	,0.756998664586339	,0.876555702591574	,0.271693456578857	,0.351924720849807	,0.798783322702527	,0.151304661366765	,0.977443591215389	,0.894437557037192	,0.812021124089147	,0.639032566286173	,0.2203415717093	,0.280795718208326	,0.333635927333327	,0.419030691226493	,0.648827443667142	,0.842845713646545	,0.707909257480832	,0.830890480350186	,0.776303245581828	,0.328648493778263	,0.595234931258128	,0.113489655364998	,0.420637719529047	,0.658152124685306	,0.562759585940633	,0.300360904215072
,0.165717142711262	,0.208017548177399	,0.150932217552761	,0.717780409249375	,0.735338254242827	,0.83003905919848	,0.466467948847668	,0.926816282759801	,0.00126434397011266	,0.249829105683523	,0.877779222967932	,0.835400422027055	,0.574893008719614	,0.226797550556621	,0.786432205134273	,0.56607169172078	,0.966922751146798	,0.070678524240236	,0.893956905647161	,0.733713211833366	,0.517951283379435	,0.2072197581675	,0.742475521165168	,0.786084222973364	,0.717535513321653	,0.619372397018304	,0.791876686640026	,0.0714723589231597	,0.235936421545193	,0.383436910055316	,0.424147299688378	,0.64366586256943	,0.0921522044074499	,0.802099476010585	,0.885893309901419	,0.20885951314534	,0.301837433735764	,0.981748796990956	,0.252031026991099	,0.885470639395281	,0.105036316488421	,0.345371220887346	,0.654109453621371	,0.617587014389032	,0.78495083646148	,0.668708408097135	,0.98221488854951	,0.0856318516124188	,0.214530049923123	,0.606549057926307	,0.270016567441643	,0.168448991686315	,0.122203271892948	,0.870390704772617	,0.656575113375008	,0.0579304937543024	,0.637808528560125	,0.64793951001388	,0.919344803280823	,0.428108740797317	,0.223606580506827	,0.155798578241746	,0.506704509028562	,0.182683243035657	,0.357265700286844	,0.564624720981636	,0.647685538347664	,0.650843009190095	,0.718455457928803	,0.0808814093847207	,0.373847529000532	,0.255419911935655	,0.842459902559621	,0.223582319553747	,0.748044739825672	,0.387942250067341	,0.145396881804521	,0.685392488578983	,0.391555546965243	,0.874077844840511	,0.626338234462933	,0.866706618511447	,0.738137321890396	,0.873969011881374	,0.797182690257757	,0.249475162126811	,0.929049865309638	,0.541086259084328	,0.0367564303040302	,0.765324119834846	,0.802482064255738	,0.31605394618402	,0.918673514816292	,0.145763517425285	,0.847437366772181	,0.879823340047069	,0.190876171081735	,0.0558073707184789	,0.954479665474258	,0.939737625857693
,0.170277790245729	,0.858820659974041	,0.198832183703236	,0.772511500293627	,0.600785434991487	,0.400805901922661	,0.344793614160639	,0.946273197860584	,0.0136364428389987	,0.187694795051447	,0.586420429677898	,0.968161596436129	,0.891951302016131	,0.0255329851180003	,0.132880878230967	,0.328920427862983	,0.16563109316194	,0.761782772728141	,0.283061241862858	,0.410291989059323	,0.777460120049054	,0.772237664448208	,0.998426381032181	,0.552186007868585	,0.590234247311128	,0.0669945581196782	,0.977538317431481	,0.486501070897328	,0.623498571395641	,0.140489446530347	,0.206127835533641	,0.390531813907685	,0.668196346456276	,0.375994890637693	,0.346126947713144	,0.355610214805049	,0.740880228458382	,0.973999700031243	,0.0129584251032017	,0.792250709511456	,0.357674759047886	,0.439675317816285	,0.623066538303656	,0.879309269543415	,0.550893216184756	,0.862284417200035	,0.414199880982842	,0.457399678629544	,0.516398726737312	,0.113400274009165	,0.918405272028598	,0.637406984640941	,0.899190860287841	,0.700788857741649	,0.158332063890217	,0.0869978028754693	,0.172072928013314	,0.0297011197682941	,0.18671994571887	,0.202127697040386	,0.1602041577735	,0.551279699220918	,0.357904805968471	,0.306073912096244	,0.184240601576977	,0.531790704248376	,0.806366302448495	,0.598445251862726	,0.0693480568329562	,0.532791191494461	,0.621555447402203	,0.482404488829153	,0.772243751572559	,0.100732679991393	,0.0141526153377037	,0.863005980785473	,0.54151906144876	,0.310865769307532	,0.720984751694363	,0.590721727158279	,0.260068349195676	,0.968744931727995	,0.696067552406372	,0.807353293899146	,0.186810562939761	,0.725131328555351	,0.282239029781073	,0.591373530491895	,0.214926977276302	,0.277707082814401	,0.422940861630692	,0.367061427034001	,0.201404160448073	,0.999724650755396	,0.372205245947561	,0.653568640655637	,0.5281434992925	,0.507792609048911	,0.470380285042515	,0.681450709552248
,0.142075444637833	,0.861998028057626	,0.600857564527941	,0.61308702109991	,0.153563626182062	,0.943865241922375	,0.543120989363231	,0.234468227827208	,0.7075050918886	,0.038079371693581	,0.000000540167093528512	,0.000907858834093371	,0.258383424607284	,0.650217374623854	,0.203415303120117	,0.80099953981163	,0.39926561405848	,0.457175480880391	,0.748307156724998	,0.798383077047012	,0.424375929136004	,0.486240988823697	,0.25229915988273	,0.391980149034401	,0.0103648211855278	,0.201549665164924	,0.445222426878858	,0.853328552960105	,0.892989600493102	,0.476215487567808	,0.753699552153097	,0.4283730371056	,0.66563463381754	,0.321290571392183	,0.930633388427381	,0.155359298994466	,0.123738199995709	,0.667927327876877	,0.854599626667146	,0.255925394713844	,0.338108955574273	,0.597216336800352	,0.414972603514312	,0.444547265043737	,0.505883590088172	,0.385498611901653	,0.0751702310867469	,0.3860738749551	,0.743616370364845	,0.960336721949436	,0.379285804172645	,0.656510729648411	,0.975833200838339	,0.828606489965975	,0.38927685813479	,0.576154671412033	,0.431562422044371	,0.269627299750982	,0.626026914746513	,0.634356144645417	,0.623723055526485	,0.913394233637207	,0.416884740543032	,0.581834306745713	,0.889193475194831	,0.674737599526876	,0.314835248195955	,0.436016429418706	,0.128129240185083	,0.468139790682187	,0.0254619955203785	,0.939758711000792	,0.524655790312521	,0.889867782541489	,0.00782117480776327	,0.45048499407735	,0.301295458013795	,0.872762837853638	,0.525015806092422	,0.940652995342693	,0.554892724638289	,0.0820229957262161	,0.560489170514275	,0.141488833418809	,0.00282326992732625	,0.450697668572281	,0.875715694332363	,0.15367464402396	,0.809742110692776	,0.335654413483876	,0.343727423503868	,0.026806829509701	,0.542383569545291	,0.840653347708589	,0.860814938256897	,0.716667283660112	,0.0270364754959179	,0.402043659892885	,0.147791819715775	,0.937113963038248
,0.0743767838340145	,0.0506058982809102	,0.533332407257209	,0.717768771908138	,0.539749460080522	,0.56917557333092	,0.133860972772288	,0.801369383838665	,0.615234176449121	,0.240803580377625	,0.185775406745158	,0.327261165868147	,0.278414745944745	,0.316635093333495	,0.686013656056492	,0.831517341468259	,0.31195805701984	,0.0790643324512357	,0.8342355079177	,0.996181572785686	,0.823693809017396	,0.821848155382019	,0.801947505586756	,0.331726396610833	,0.325547838269522	,0.48251779586194	,0.676595051622295	,0.533032615917284	,0.679175721797708	,0.90635625408327	,0.129562377524358	,0.554879051891565	,0.852225141530961	,0.34795371086707	,0.0580185428531927	,0.117649733609357	,0.339072772459627	,0.796086728943552	,0.829653354282329	,0.983925423111732	,0.834586238877189	,0.890916808923202	,0.638807572256218	,0.438866910263368	,0.0361607964318994	,0.754505630933915	,0.976139106310969	,0.969959768452663	,0.113828383904802	,0.113648288004868	,0.0867764978142346	,0.452598763840552	,0.827423868154839	,0.512952078372683	,0.185581209690115	,0.0633912617635873	,0.416936460610915	,0.451093487651597	,0.528246960383024	,0.246663157477352	,0.667687721861381	,0.827541324229697	,0.487036328523902	,0.619573501227225	,0.171835125969646	,0.0329621718418608	,0.99522214615495	,0.698610426252061	,0.545434018385333	,0.109547002292027	,0.156467522101694	,0.749643963179385	,0.266089155928273	,0.160443686489222	,0.577038824361301	,0.291521040392817	,0.594125882067776	,0.473699913115101	,0.474439725500736	,0.908466490874284	,0.59631212409414	,0.217869650208331	,0.735211051411559	,0.692141074078223	,0.815032032697942	,0.243373554313264	,0.379327343022138	,0.354654173066213	,0.672686723839811	,0.845767575709972	,0.815644957505001	,0.544800786555186	,0.466819633015813	,0.837572096771361	,0.0742304362702325	,0.590942393797889	,0.968812561113766	,0.832714639060532	,0.434938690362004	,0.0145689142004442
,0.859740966865672	,0.666430111353486	,0.690881518037469	,0.645673655739833	,0.837132019380635	,0.677849730326724	,0.620417601252169	,0.358624245207116	,0.397689196000662	,0.962317183130568	,0.664896875463844	,0.921785920821962	,0.45597125471382	,0.508877975171841	,0.712128713127286	,0.747281530288645	,0.560679561253954	,0.341385995196824	,0.674421273020292	,0.998335652052581	,0.0273040477313586	,0.899130220943657	,0.681623400040727	,0.0444844844958207	,0.650730921258559	,0.834593592600242	,0.0145108322680513	,0.883557929137516	,0.958115014228092	,0.0390441315430422	,0.214718843910247	,0.779609599513751	,0.898539027617564	,0.745437168397679	,0.562489259784338	,0.756989195364057	,0.717406483701154	,0.450771565293321	,0.117697884849132	,0.148350659361272	,0.329531884905664	,0.442389609498153	,0.242166835461821	,0.0980036068232747	,0.146619878777591	,0.240302614979587	,0.766049961916194	,0.0017099254772579	,0.738717496273442	,0.624959867738634	,0.70049708322645	,0.254477786950058	,0.00816526962824411	,0.233686641898792	,0.571390392990499	,0.358334991316467	,0.536199055861774	,0.897531868842212	,0.81811963106418	,0.136639295675158	,0.496642412383409	,0.0690249279462848	,0.101963993209397	,0.70883387034239	,0.370858844542344	,0.0246002231839114	,0.455951051998861	,0.169330944851661	,0.945190121859866	,0.810378098772083	,0.0247060624066303	,0.234790868235189	,0.130122428820525	,0.967661186572007	,0.481562715713662	,0.624562999524438	,0.0303330072343037	,0.806852586943122	,0.771428753049778	,0.403052507621726	,0.103495598353211	,0.450521522411388	,0.915227168200178	,0.223015940386344	,0.228910073278896	,0.291601598398574	,0.948064284840629	,0.116435316445509	,0.92836349966394	,0.0053388518306142	,0.730082717132793	,0.500226850854338	,0.312682308867891	,0.251565142651817	,0.0553525490944053	,0.310292629669557	,0.0882268562392457	,0.828772813002007	,0.184668124739392	,0.717172494957769
,0.518122755232324	,0.0891471896735705	,0.296816843700044	,0.600692066643709	,0.83156408082301	,0.0975063923269074	,0.789935838333301	,0.451634867792779	,0.627222993237536	,0.736847343266405	,0.193298278466472	,0.764166185988191	,0.341087903520599	,0.664394470706766	,0.477869168612114	,0.547116863796076	,0.393129820652832	,0.332895712150678	,0.978234116443542	,0.180795066608486	,0.622684488828613	,0.45820374249397	,0.0303000961571467	,0.253716113163957	,0.206713946632442	,0.241301051453362	,0.546771776651392	,0.593250179939554	,0.755774244086712	,0.297720365364906	,0.786180687968703	,0.338822689996484	,0.592950770907547	,0.72360664313827	,0.656851224907139	,0.698537014284421	,0.311599078267626	,0.0457084439907728	,0.221818152918396	,0.0976960994758159	,0.978343890038479	,0.0257598767177015	,0.946247994409058	,0.590042033041847	,0.836449334321753	,0.20396194569951	,0.988421371666911	,0.397993605769236	,0.0785321635559817	,0.890072885383886	,0.454984646968071	,0.926961592364573	,0.443482871373875	,0.616619180709412	,0.518570183086475	,0.609067134377112	,0.591327476124897	,0.44089123114985	,0.0589219355298774	,0.30097045064949	,0.410364065976052	,0.988856859499988	,0.717237616291846	,0.612617017055218	,0.254205647043048	,0.434309852511766	,0.44569116525617	,0.731414460452001	,0.882836816777865	,0.838379585574558	,0.645694751593142	,0.191690025940393	,0.734265980186996	,0.80832900284246	,0.585550773230172	,0.351845679502862	,0.470335404607624	,0.927145240328808	,0.530054206275406	,0.62104487075519	,0.901142782485645	,0.50674523623043	,0.86718532483428	,0.783754489749556	,0.561709220782718	,0.646873695145768	,0.00619431492229659	,0.107850899038767	,0.650060144555783	,0.560849549044319	,0.198370787873106	,0.0178317832843549	,0.698781660152032	,0.423362175199837	,0.448078583668954	,0.856755724110061	,0.493455117798157	,0.500164833618405	,0.270358624528329	,0.91740244762851
,0.782937292374176	,0.827072932770044	,0.614781066130279	,0.625378451601313	,0.735636063262651	,0.835315255371535	,0.143497029386227	,0.754572894309914	,0.10663466672722	,0.208843684386855	,0.035803489869369	,0.74925423448405	,0.71591897342164	,0.450186297507112	,0.281102202032275	,0.484709556440222	,0.513515090808978	,0.648131226491244	,0.141523638340423	,0.587789587484575	,0.979596853246725	,0.0843125177008624	,0.0404849983940297	,0.43136800845683	,0.00211813394078898	,0.59947714284038	,0.412339718273068	,0.193645015449098	,0.591774652987614	,0.956592762822561	,0.454564758788126	,0.869900952032721	,0.425300813943753	,0.0307799526633601	,0.318664413093899	,0.792790869154404	,0.436137878073444	,0.169316780366617	,0.707127621726658	,0.693938359941327	,0.0220155338859258	,0.0150780207547722	,0.416294825457174	,0.667131458719788	,0.478426703474683	,0.917605298998582	,0.19226026916516	,0.318343858848486	,0.405235666504705	,0.795846944579783	,0.799597552418521	,0.83606349808912	,0.719212383832416	,0.802535071411419	,0.206945211722956	,0.128173427715978	,0.210799622447602	,0.909254476851437	,0.839992442093786	,0.752974270262278	,0.238560298103169	,0.482930219957107	,0.608206819094814	,0.132008526535709	,0.667305485656162	,0.403297423107222	,0.21979016308663	,0.0132709969828236	,0.0456462903160817	,0.177201342385822	,0.2229614785048	,0.313569230173514	,0.158051526247548	,0.37200164253451	,0.23160607751068	,0.603344722000577	,0.414742663695823	,0.579948735693446	,0.198400799743086	,0.522241282054336	,0.309227487216344	,0.18637764509133	,0.449081049975511	,0.705206938416328	,0.413013963221113	,0.525679857249223	,0.101360787684732	,0.570758617283198	,0.740080678714477	,0.535967154212281	,0.999960845801961	,0.341935393559716	,0.908159558152854	,0.437693875021159	,0.320957480613588	,0.332376672575426	,0.254735975179233	,0.347534837363071	,0.0180115611376295	,0.720308040138477
,0.217230607390977	,0.994818420146973	,0.913187410176353	,0.940802833969147	,0.0732305194592245	,0.785340551186977	,0.218643799525985	,0.746338633236633	,0.713408808090449	,0.261837576172239	,0.704142726820029	,0.526809664222789	,0.0900265924120446	,0.0769386692330887	,0.108213800521667	,0.749345367657647	,0.247594222076048	,0.316090432142881	,0.531893025400067	,0.526077898929863	,0.791247314210631	,0.493609938069065	,0.102229126776675	,0.16493373558155	,0.0412939191056853	,0.0268984092524733	,0.0815643063194884	,0.851296311640784	,0.737109746661554	,0.603512140737619	,0.228549377167853	,0.22938206010935	,0.224284257844223	,0.545521587853097	,0.581327047004051	,0.363678997086212	,0.35290402795789	,0.25799788826052	,0.17050799455983	,0.727864567063686	,0.219778639366747	,0.819591836919818	,0.880003111381085	,0.212292981898549	,0.00814676890529076	,0.922744991221812	,0.575067464995695	,0.158884182646351	,0.366457737221596	,0.0551894833590786	,0.569646816034637	,0.0540370941413739	,0.201441234071479	,0.622821039344566	,0.753208264127936	,0.171295198226019	,0.958396584707497	,0.771399178901408	,0.905999795955606	,0.138570625865166	,0.95650891585113	,0.0453487099359504	,0.175767893519144	,0.130986376260867	,0.488025816384715	,0.24989597790404	,0.00170063320626534	,0.582542297701604	,0.788397470856271	,0.596292681338402	,0.891095254519533	,0.637942709791447	,0.903123464855889	,0.796073832919856	,0.612909884011797	,0.176420586265819	,0.100793369626996	,0.0341633209186435	,0.182934679641824	,0.583160740129259	,0.182559352453127	,0.275036679708882	,0.54147586717339	,0.584899583172472	,0.4072943797369	,0.396640238071159	,0.332481261963249	,0.0125698163232626	,0.260902945073742	,0.995797854380588	,0.37453857454217	,0.869822330246597	,0.103904454551593	,0.322167648618188	,0.671670325878854	,0.76316704590021	,0.548540444834409	,0.319256331920277	,0.741170584103638	,0.854007029837932
,0.296150486122887	,0.401220267359736	,0.309033515075703	,0.926287877339072	,0.120354437790976	,0.797035952935478	,0.78326098657365	,0.26740134333605	,0.214377448993911	,0.0417852406584589	,0.284539746718733	,0.259523101737501	,0.804770902173953	,0.784552837621678	,0.979541907543103	,0.160840076934937	,0.239173045493277	,0.781375605511188	,0.579801826542151	,0.729298693933198	,0.323148935252404	,0.164154787158666	,0.949507775692971	,0.377186071768955	,0.366308220832752	,0.542267536065666	,0.890478655644915	,0.274765424092657	,0.982482725280562	,0.587163790402545	,0.4618252955665	,0.897742586162753	,0.359645637385382	,0.564227536117764	,0.972199531259108	,0.757521871830114	,0.670099848727742	,0.36815756716214	,0.624231294088173	,0.455359739929139	,0.231148989047459	,0.921058920640991	,0.237279213144108	,0.951735313027974	,0.815406061157308	,0.529669870869103	,0.161519697011225	,0.661547667654952	,0.63165027677624	,0.146201778271329	,0.21328740623467	,0.721436586101277	,0.184702604163765	,0.296668180402679	,0.102108027833564	,0.129623798713844	,0.587184983579062	,0.818019013301478	,0.445556557944769	,0.469069377737618	,0.649031636141721	,0.274708633904675	,0.028010035878052	,0.764673002420307	,0.859151678094245	,0.762253729981488	,0.198439798875917	,0.17769970753123	,0.598984477389131	,0.132111479124106	,0.39762963885331	,0.961340207588552	,0.244868940787795	,0.512287820462272	,0.0213985093968913	,0.644747433552867	,0.270115723027902	,0.834956929942107	,0.121121536996738	,0.689672304172848	,0.322416233048968	,0.849628854007287	,0.712149300478468	,0.0932931416171105	,0.977831158776689	,0.408285559810831	,0.0554037406367267	,0.170668881465992	,0.431890798933753	,0.788657679589772	,0.969620865289877	,0.417882926956696	,0.358353361188599	,0.844941496776855	,0.931736328607302	,0.692474902929959	,0.425693543826087	,0.631391085046991	,0.78996638478244	,0.96502903847258
,0.243049608656694	,0.934772693056042	,0.72465219289281	,0.229405949464723	,0.625792653591276	,0.697128908567656	,0.645566296598672	,0.0327469338815412	,0.377717747063245	,0.302174891951575	,0.653409030127064	,0.845569345562518	,0.483990869244556	,0.434539393258532	,0.303582496151134	,0.311012812103616	,0.192333025481707	,0.541159271048922	,0.263868519227891	,0.838202663156298	,0.672159667905494	,0.987538487644651	,0.559361843652726	,0.194506271367197	,0.066902868480842	,0.436510557512059	,0.4329401051779	,0.424347724963141	,0.012213455518807	,0.27154690458977	,0.888825440261897	,0.489174481709103	,0.555514084899572	,0.525224907102634	,0.455013673964429	,0.414818320150868	,0.851506775641584	,0.274378208105628	,0.474543631297789	,0.654811221945477	,0.412207237636767	,0.967042961142512	,0.0910479221916981	,0.242428275869427	,0.49203253746593	,0.590857189889465	,0.536790472239624	,0.837466931360526	,0.306715376352293	,0.965330352990576	,0.307242712614705	,0.828270915350072	,0.749274288653058	,0.0529693919480636	,0.2565704711045	,0.179907853333237	,0.711290971707223	,0.667361483288632	,0.34444963203019	,0.164965531399923	,0.575686238508525	,0.558610612786659	,0.568569105383274	,0.940954176681561	,0.616847486988105	,0.355713809074701	,0.48198911849502	,0.791114545795654	,0.262171187560154	,0.311149323504022	,0.486680132097881	,0.63298016909183	,0.497701926388639	,0.876276813855524	,0.584410469785524	,0.186765685298837	,0.970872817547467	,0.459444520277644	,0.884052306359658	,0.267112986774702	,0.367968722417936	,0.450317678251452	,0.489218372148098	,0.293180693077473	,0.487908553093629	,0.279051844626224	,0.0243526329399797	,0.294701822239301	,0.0535263759333297	,0.617800311473105	,0.3698349284799	,0.815642961680723	,0.511256967909288	,0.695859651405299	,0.31316116885895	,0.299765012366588	,0.150562845240609	,0.509739958918532	,0.199489543772996	,0.820762192746979
,0.550173498480662	,0.76598896447848	,0.976525989815838	,0.472310834784205	,0.128200218141172	,0.661066298680877	,0.541281929491685	,0.325388966745412	,0.812364090146666	,0.403263095022767	,0.642838047651033	,0.179066870910612	,0.576899394661607	,0.948126077627822	,0.154986690802028	,0.861312309681118	,0.0759888105448283	,0.143938826929749	,0.179864208297741	,0.977748860129038	,0.0250921887462457	,0.724416258150905	,0.264050742268586	,0.900825308123988	,0.170953639862572	,0.217825170242146	,0.987636259751225	,0.202617638838765	,0.394655963124081	,0.982772226437355	,0.452809732618187	,0.37317611387613	,0.97094591612506	,0.688012313883757	,0.422959444310032	,0.679380518700639	,0.348377801640135	,0.18571216575136	,0.264369783114814	,0.262944810680554	,0.313433108065945	,0.870247264332253	,0.24577163217858	,0.68382202539771	,0.996780859304956	,0.895902338389262	,0.430601308322792	,0.116188981158747	,0.788206335058532	,0.383873328745306	,0.759036222360579	,0.121789214257984	,0.911324033938034	,0.623038396529406	,0.406330469719288	,0.196204572076073	,0.610242882561983	,0.352127219248622	,0.202173911594867	,0.936932174925195	,0.0190639677546285	,0.408106052041103	,0.038416654820748	,0.668717572311274	,0.136237835575006	,0.749302509124066	,0.527270848177034	,0.841145311408278	,0.129248838931904	,0.285235928504372	,0.960250372979907	,0.928018673289576	,0.209841977902615	,0.814122609241923	,0.958693528994309	,0.762141807359709	,0.317356294634452	,0.807243921238577	,0.348584256762911	,0.65560341424104	,0.726583149156805	,0.682987878417125	,0.977272556618449	,0.0198590862657219	,0.771662867987371	,0.337822263752028	,0.778786880326824	,0.0710976529266209	,0.938252737716889	,0.213762807759346	,0.711510011326293	,0.348760361014288	,0.615387567139877	,0.818840919909459	,0.259340918278015	,0.742813498593314	,0.466470857833731	,0.975707611523432	,0.717826874329628	,0.516276858056093
,0.0651533487556285	,0.0323325358481764	,0.412930000300021	,0.11451504245145	,0.654318481522761	,0.130718953037038	,0.993443693496959	,0.808156603392286	,0.688033214159325	,0.774230375780831	,0.489925748431089	,0.182053881316471	,0.779583285925716	,0.456286553505942	,0.808104774359662	,0.816942662846736	,0.355334465091738	,0.106354796842837	,0.505070537563912	,0.720524836667126	,0.86092986439398	,0.648230869624871	,0.816225785210834	,0.30677203848342	,0.917650790846744	,0.956841761226226	,0.639480929188189	,0.755976865885769	,0.703184942110993	,0.429322059466188	,0.615853448219529	,0.648904225625519	,0.133320088094715	,0.710720607876182	,0.0812565749889503	,0.679255839287888	,0.252890911536706	,0.337550197419501	,0.206168029553335	,0.0660727029042657	,0.483917711993641	,0.204985477125731	,0.190914052161814	,0.692474683603493	,0.422007323904898	,0.677092869615691	,0.89985963092179	,0.940816902527966	,0.309680787524991	,0.804995932525488	,0.566637955869845	,0.484124304486497	,0.677185504546941	,0.456774920437846	,0.0160877988748661	,0.387635689874941	,0.99303972813908	,0.0187108335172342	,0.472978924155691	,0.35677828470095	,0.372630968863438	,0.808693687808092	,0.714810990595636	,0.828318940861299	,0.556439055854659	,0.0712117492552901	,0.855869733661353	,0.602613646352018	,0.127554238367618	,0.804084244558627	,0.243898296842304	,0.198675028606632	,0.131205791668597	,0.175740574102728	,0.671828944548885	,0.429071033107616	,0.396853439694668	,0.915760948283487	,0.194257800557771	,0.890853974451709	,0.582748609866364	,0.255886023983306	,0.676405087428356	,0.340304408380903	,0.49619165784502	,0.493193401253407	,0.10149486600491	,0.824212944518874	,0.546958528713769	,0.731992092324417	,0.591095696478661	,0.545370716855568	,0.0456381915349691	,0.0410851282258914	,0.517750092557515	,0.825805614155627	,0.314957113617546	,0.484208570087426	,0.0934374593633402	,0.403379519657874
,0.599586889892624	,0.256858425334496	,0.0195545968690676	,0.654109578418596	,0.619684481350558	,0.0370780588300331	,0.17093475636604	,0.900450244033919	,0.86725147807377	,0.895591985851336	,0.214506203408589	,0.205760688151121	,0.219885755898378	,0.619899384034751	,0.648947472054953	,0.860162827586831	,0.756643251868264	,0.903134149919792	,0.975657701946636	,0.878996617104391	,0.29614367349825	,0.286720485094339	,0.911192980553579	,0.420424164002959	,0.068924397727905	,0.412352612899781	,0.410365006611852	,0.00466612540402735	,0.423569665487655	,0.935367851022337	,0.727472132410608	,0.624129425093592	,0.743247547998674	,0.761539213713975	,0.189564890782146	,0.0171193755311516	,0.725344552064941	,0.865886555456504	,0.955337557455216	,0.358328149820831	,0.421214038702293	,0.344348469443782	,0.464725941636006	,0.648901076358231	,0.0803903527932197	,0.120659395642886	,0.922462569979235	,0.828413641000359	,0.148064293036267	,0.516573060544474	,0.0434285709836653	,0.903992522463199	,0.402325038985501	,0.876930229308517	,0.566363988242282	,0.879550388026773	,0.603371565976819	,0.865909372393931	,0.338821824797812	,0.578409376823534	,0.326396273135392	,0.742162586535403	,0.526591900515646	,0.430071966457214	,0.219540246398905	,0.812921226403174	,0.767052158139205	,0.845621845613058	,0.366359218659978	,0.39938801825018	,0.514422730782266	,0.902836257546598	,0.968980585676143	,0.656703458939075	,0.215034389037189	,0.0829765480398091	,0.586842905071957	,0.0687055443733491	,0.734084282877894	,0.754542328768662	,0.592919614907782	,0.199967755097881	,0.85805993008337	,0.41324491119629	,0.40722247604617	,0.188154907984731	,0.319538499377453	,0.483559036852587	,0.176732381422414	,0.341134566506899	,0.448659281455287	,0.616543419014916	,0.245243383685706	,0.805549605658999	,0.872222310803934	,0.440377681721178	,0.427696687834196	,0.298232429334071	,0.392439817726817	,0.73601653461159
,0.229897217000787	,0.882526132223441	,0.616704279378384	,0.948823512507986	,0.876774721721548	,0.952747974057099	,0.835199977660179	,0.206024534630601	,0.654353536504485	,0.719888030886598	,0.158135111051675	,0.776811445493629	,0.869964411421662	,0.491862763879757	,0.737472527072519	,0.700762507832033	,0.715469132976359	,0.889717933670486	,0.489311199863121	,0.853336099466931	,0.0198237407113536	,0.17761013571993	,0.093551044861577	,0.312410988524748	,0.691484135431929	,0.77386420442437	,0.335683760389538	,0.836960866971389	,0.801291188132619	,0.300998944929335	,0.889267427329564	,0.917651127985516	,0.962508052570051	,0.872839544840548	,0.814230135089825	,0.765880454688277	,0.152801945876704	,0.142304349756941	,0.709206364913474	,0.631375100757636	,0.521318433583397	,0.798913236148149	,0.334759941946138	,0.310344288735811	,0.956460782772145	,0.236376051435422	,0.772296475140516	,0.986857686651339	,0.117139549049148	,0.764400869032555	,0.2854058301474	,0.815787287343194	,0.936938377067884	,0.123303379920918	,0.359906330872283	,0.945702970468301	,0.429824660732329	,0.0630729282568548	,0.0667052129594168	,0.114514208917745	,0.640309280548389	,0.678078176769464	,0.459916964387482	,0.824420460418063	,0.0346782463764205	,0.837286848499108	,0.280062724500924	,0.0142106870255483	,0.839016838389922	,0.356002819424496	,0.339386067511228	,0.0616366612080655	,0.92736492395744	,0.222276952686849	,0.80874380786379	,0.557178766726134	,0.503532366130283	,0.868477551670967	,0.502210933948965	,0.659166880258902	,0.617756511372401	,0.633686635938327	,0.371290215463978	,0.274651303083939	,0.0644509317653491	,0.226810180222062	,0.998698992188414	,0.133961710675602	,0.494471324837986	,0.579556552031802	,0.606969998500762	,0.344764802299796	,0.462032252672143	,0.376070660714093	,0.619594621760582	,0.526807930100154	,0.0608811932899436	,0.230215624082003	,0.233993946217929	,0.736254084732502
,0.222402099157871	,0.912080546334423	,0.337742242653734	,0.433872281310089	,0.0914319786668904	,0.697265454426997	,0.940492554540044	,0.858364154518751	,0.526344996656452	,0.280358804986048	,0.990435400507616	,0.24777633149539	,0.376803443011271	,0.935466690424581	,0.388665965939251	,0.308889540987503	,0.506515376971343	,0.00394075736586971	,0.23230904817223	,0.418172630676149	,0.227403774032092	,0.975230157363801	,0.693254813409063	,0.533648966128774	,0.0381737263119657	,0.585818125207824	,0.845230367893926	,0.786793193214942	,0.633198363535664	,0.164895943908438	,0.406129269118481	,0.814626074309752	,0.42043092400787	,0.182539800266987	,0.946423087244119	,0.532827311909212	,0.228631258117329	,0.605555177948231	,0.565875775909925	,0.674165718105699	,0.703224202479806	,0.0891710780976206	,0.698309586708578	,0.489223811071936	,0.384592686027564	,0.849274065275339	,0.749215082614317	,0.0578934988276537	,0.0160347963757975	,0.496822688028599	,0.0989176966710564	,0.50972795044525	,0.997663133310928	,0.724281556775925	,0.000124732963798909	,0.096386922568263	,0.975007604795977	,0.9528138059903	,0.941637278972956	,0.097747698471764	,0.845568214936912	,0.464988444682671	,0.0607897816508961	,0.693860206610458	,0.708492501968747	,0.633480588734839	,0.908254866445556	,0.0395403504555767	,0.554670106877885	,0.340486296611133	,0.553187143315183	,0.416317698273956	,0.0515548903735144	,0.483042507657335	,0.495426196835668	,0.628090217070696	,0.312278307188432	,0.46150891597453	,0.580350783923804	,0.955625407377083	,0.19622178664255	,0.899568101344429	,0.0410792958182652	,0.419724817583209	,0.315009120998443	,0.358296620826375	,0.891306228885104	,0.183788871943852	,0.93957076032626	,0.365768803453897	,0.476279649639632	,0.832071493301574	,0.625587919552619	,0.256163920860814	,0.347017907699113	,0.329974698987778	,0.884765887579306	,0.260272545395546	,0.4006704629402	,0.0684706359489218
,0.785978393529532	,0.938860050839772	,0.42087446405593	,0.637117388023584	,0.0319405123740158	,0.824191470082938	,0.186037683946098	,0.73535408206999	,0.0960573503263562	,0.435886935068242	,0.951717691939193	,0.519248422011383	,0.00822874531533045	,0.300522514758875	,0.881905552410477	,0.186619362880764	,0.511631937004454	,0.997965233865178	,0.801685572043846	,0.929409340922446	,0.582792883544598	,0.999993734061715	,0.894688375245169	,0.0275227455550445	,0.574784543632895	,0.403824838066392	,0.0840533818509678	,0.685188769216271	,0.967644217874689	,0.196369819900193	,0.387563062546571	,0.772392220223505	,0.596045296451098	,0.73329745360338	,0.530302712009429	,0.797680742478781	,0.620238840868808	,0.354198482052515	,0.0138878566277623	,0.413206342800151	,0.759003442134244	,0.570851950240718	,0.308727695750411	,0.786382477165378	,0.730293718506719	,0.0465269424237902	,0.978321316641905	,0.646368800497786	,0.5204299662823	,0.866443306611126	,0.312654213194109	,0.779361153384373	,0.72290493115918	,0.863177992339795	,0.432517254926505	,0.317503549772084	,0.282161019408219	,0.28025319393736	,0.215430505208406	,0.740501037677983	,0.600940253865412	,0.00284671597315311	,0.844755360784361	,0.803348702752659	,0.881647163946949	,0.843884456364384	,0.166058116204132	,0.938759042852912	,0.723233228886143	,0.380877889404482	,0.414687221131608	,0.648125558927714	,0.0462688980839536	,0.64137009700824	,0.507220417497317	,0.853556877399588	,0.730438454882446	,0.479111209269199	,0.42209418743015	,0.137008138530426	,0.695784280866284	,0.0464085196360985	,0.987989523908118	,0.139928323747557	,0.775337225187261	,0.0927437222994602	,0.743740687027453	,0.0497268703997726	,0.759510808978002	,0.0981664932790056	,0.884252540247632	,0.632443941958455	,0.48533249575893	,0.983256220344108	,0.587295323418125	,0.672500688430155	,0.719070445615365	,0.416979457445899	,0.17374129322066	,0.0699151596380003
,0.0640880358703844	,0.12761887355131	,0.89040777687468	,0.083505932746225	,0.484211665803665	,0.145467162200002	,0.866595095427053	,0.863768842473518	,0.362935452425357	,0.856148912970046	,0.294780287563233	,0.372293075254323	,0.12971579941442	,0.13344075816378	,0.738822458655956	,0.389062630659464	,0.975633493613281	,0.472127158414632	,0.0411514747148154	,0.632835531901957	,0.0667846761954877	,0.450052817561688	,0.037704759294961	,0.70388947040955	,0.270329173314538	,0.422415897446878	,0.543988389682019	,0.812865385698558	,0.828537435656664	,0.228681081546788	,0.442937556860474	,0.451518153982013	,0.665613975685841	,0.974089351936285	,0.519737993143377	,0.236450760735409	,0.0279356800149827	,0.514974011813744	,0.168216553595018	,0.215616271465838	,0.862674526340642	,0.970764207174426	,0.634029980578474	,0.141883582408486	,0.637369539419827	,0.269849029029649	,0.352630901314612	,0.667558394683319	,0.653939442547941	,0.760210903249779	,0.864650919039106	,0.187996290246023	,0.653650164908567	,0.898321618278661	,0.0914384094492711	,0.805347613899665	,0.477346811665849	,0.767863667927619	,0.484666859491107	,0.795907467042984	,0.816798591435328	,0.933926253548789	,0.498543394495986	,0.0188312940387201	,0.497558908768724	,0.472579675946655	,0.646613635423879	,0.635370569133838	,0.673155432414802	,0.723352595569264	,0.387073732627124	,0.548224264079809	,0.00520638935510367	,0.503785891227324	,0.129473857641906	,0.0671253875210534	,0.176388066344144	,0.554231046025749	,0.961190554760951	,0.72965386730137	,0.292547734124841	,0.849767436203439	,0.0413002711913084	,0.133657912320298	,0.388532367250199	,0.0634963740890363	,0.18355931443328	,0.0813976801379573	,0.0508100786482962	,0.964991841914594	,0.617887058583036	,0.827793605079778	,0.727120575833656	,0.715518036259114	,0.711635406926105	,0.456284207038714	,0.768667699661417	,0.998028209432041	,0.860115924319306	,0.968340034581879
,0.890961217643209	,0.385184929419861	,0.803108759598391	,0.848922570165676	,0.841636774522083	,0.389269392653028	,0.450682319444922	,0.617742910803176	,0.405101868978283	,0.547111918007541	,0.310005952748473	,0.270047843582019	,0.694107082995636	,0.857743907653607	,0.101855934179321	,0.892685751846379	,0.369431282100003	,0.0315582547483771	,0.39958755597453	,0.868053263923178	,0.37120675685406	,0.871962446194125	,0.0728331846524184	,0.107334453196886	,0.970154880066474	,0.393069277234873	,0.315342486517198	,0.961170894541392	,0.399224557168421	,0.767132329646094	,0.193064361900587	,0.832730463162405	,0.700894370535805	,0.931685595275688	,0.839799798484798	,0.515213134007162	,0.187143258371923	,0.316743456906054	,0.507280220048167	,0.858658349541322	,0.470880741007105	,0.0926141064114003	,0.565286456404853	,0.769472796362579	,0.529288465869282	,0.751245865016825	,0.189253337769421	,0.780847890666149	,0.710498425974743	,0.34704535750069	,0.791323514092399	,0.774301350942953	,0.682805298214222	,0.90864708642878	,0.631581608500137	,0.992094061799391	,0.124896662367925	,0.138204417721464	,0.801648644638084	,0.308770432280735	,0.504655342318423	,0.742338345731766	,0.480576713793248	,0.052828723123683	,0.892349539740174	,0.718714413102118	,0.433141007289822	,0.80090952003417	,0.886303214303359	,0.0981227965551069	,0.149841701681652	,0.389480163524617	,0.993108358230958	,0.1721767877099	,0.775271040282804	,0.980374033088039	,0.146374110666278	,0.10967796813216	,0.357610397207369	,0.357945864255515	,0.996140542438319	,0.134096760830887	,0.764259284718083	,0.905798256819042	,0.751302357647243	,0.138724977215158	,0.550692055165159	,0.481371160820765	,0.40509991459786	,0.514264646225732	,0.245909115879754	,0.994510591027565	,0.739503400278978	,0.833648488779389	,0.130150915184129	,0.446431499648109	,0.174214585765365	,0.0245429584870781	,0.493503292320996	,0.309834038983022
,0.380693187648753	,0.310404812595996	,0.973685300896729	,0.72885217132459	,0.818443452389186	,0.579104305048987	,0.00605495833142426	,0.765684676247502	,0.862353691767135	,0.578497530230553	,0.807990584898736	,0.897760393050388	,0.658925997865818	,0.569246130794867	,0.319720269329716	,0.538566624530855	,0.689258490078737	,0.367442753337064	,0.61035533603763	,0.242132784445832	,0.525708181097036	,0.577399697889294	,0.356722425369882	,0.43380319161052	,0.930241398015172	,0.567176440994803	,0.53444379965516	,0.396940804271466	,0.384097390521363	,0.524842492549141	,0.0277722734155936	,0.768599295880925	,0.848365870699457	,0.485188845770987	,0.568930872980939	,0.0211821906367234	,0.00907803141003383	,0.574473908438568	,0.182979127011718	,0.330187685941433	,0.464437617670948	,0.803040195630416	,0.696567960407849	,0.217710574724577	,0.0616293959606576	,0.805257910771881	,0.969706343007137	,0.85450692095538	,0.697820497070356	,0.269094261466104	,0.667252460805351	,0.512108755536428	,0.0118543007466264	,0.235232648549244	,0.555124167145753	,0.971877218676674	,0.340414298856824	,0.343120886638351	,0.832741730768579	,0.890269027506127	,0.751545295469251	,0.221780951703797	,0.472455285709563	,0.555986920630553	,0.472175037708215	,0.845858761968957	,0.348212412254984	,0.406012769511907	,0.856617186617394	,0.165055478534221	,0.0874277246591764	,0.397768346778009	,0.292604298001437	,0.800436510145867	,0.936426021594753	,0.512144943006404	,0.620057108635109	,0.299824830284261	,0.155922587567904	,0.590929253767677	,0.747968073351294	,0.0994088151955087	,0.763956990914399	,0.825146298308459	,0.233835670274606	,0.0761103053000338	,0.185901177667967	,0.44109306551567	,0.451152121858276	,0.513712072052859	,0.95879499239791	,0.467437231665215	,0.217552597270139	,0.406502319223481	,0.0844791890515383	,0.841730389204682	,0.962651363090915	,0.281459469013596	,0.489295711503036	,0.593023231529176
,0.941452310858971	,0.988988606719761	,0.931513139014837	,0.941327422364302	,0.889987676818849	,0.0228842944013347	,0.616336003232904	,0.759206335413831	,0.980879300265051	,0.638399554713815	,0.581316075092794	,0.179274084595625	,0.0595397986748907	,0.685396328887621	,0.456099614247726	,0.66621666153251	,0.103430376901957	,0.354344591197718	,0.469544260049958	,0.630378659642478	,0.774132611124838	,0.846795175153201	,0.0865087998502463	,0.953399083089735	,0.778389489175002	,0.392144564256139	,0.773691452934263	,0.432249466158566	,0.816777727015679	,0.583257952510965	,0.816407851789337	,0.366765023379943	,0.219747946699964	,0.303740186292557	,0.961311019007727	,0.754296462868478	,0.460651430515876	,0.168592680324145	,0.537178207904649	,0.354140253436817	,0.0352395125828867	,0.270487980577391	,0.0914895642043508	,0.665105582524606	,0.429525491050224	,0.034928081107758	,0.0362591780890986	,0.408006143480542	,0.359253477472464	,0.97319587970767	,0.503150246806047	,0.446198069232608	,0.250949592446419	,0.709800246967841	,0.612750788504607	,0.502502396936762	,0.557785316164505	,0.69780877684141	,0.0721123735756205	,0.9926626854542	,0.681754428745133	,0.246683919451518	,0.0166342216621312	,0.571363475439774	,0.90593171627537	,0.994355440137142	,0.131882384946515	,0.547243796078136	,0.526480685233362	,0.560876717120817	,0.654984649575774	,0.327005420032426	,0.980094484975605	,0.448008985001598	,0.687010921857791	,0.59256366388526	,0.217498919562203	,0.504341081950972	,0.460564349992464	,0.705030323334518	,0.444644283244686	,0.136468493443201	,0.625969299872392	,0.666022955284465	,0.847809465996832	,0.133695008761107	,0.0120122479330805	,0.889851011284558	,0.72594665956029	,0.985507229801969	,0.420011281697085	,0.129611482904112	,0.380193169405774	,0.906598202840704	,0.195995143705977	,0.0903802663508711	,0.021136559090175	,0.24214862857114	,0.792000395148993	,0.150641269120686
,0.827810111375437	,0.00454188697251579	,0.335494347072902	,0.653491254268909	,0.227510497545596	,0.768932248823779	,0.444305981250622	,0.450626879209013	,0.685958865883741	,0.910658908034982	,0.444267343936613	,0.801249542646692	,0.601063262951124	,0.0702604195430225	,0.866871259578909	,0.505259742729952	,0.900496062310644	,0.637319254985694	,0.424718544550575	,0.244578261507944	,0.626841164020282	,0.319443688876668	,0.890078950156495	,0.55691528020283	,0.0751143689617116	,0.447199139486625	,0.0759373517129279	,0.279070239178403	,0.33350987142581	,0.300409053592202	,0.97496372413587	,0.215311551566846	,0.741247183988452	,0.141421293905667	,0.867686672540236	,0.209905383740508	,0.879784526713092	,0.538540466939351	,0.249627849669022	,0.495269387259739	,0.992591674436159	,0.488272248529025	,0.391681027315408	,0.983026090070152	,0.719495809040729	,0.566062547530077	,0.813236337999458	,0.0631327568847373	,0.0722449617796787	,0.221072631059714	,0.567710220612451	,0.505677833457327	,0.927346917301112	,0.91963907979412	,0.37401409976837	,0.0549748069862718	,0.961581018269798	,0.292174060499377	,0.569434813023282	,0.490902482294898	,0.598019930346878	,0.920969339982126	,0.731697079600625	,0.632816847708457	,0.752759436030294	,0.627841361159385	,0.129757005781753	,0.825996173930353	,0.517695247436732	,0.904023669149738	,0.925807399640701	,0.0449657612689611	,0.739549647429748	,0.610924351779243	,0.805580353739476	,0.389005299373067	,0.0120665631313187	,0.80272654807322	,0.425093466613951	,0.545893380672621	,0.830048964745388	,0.63295047573417	,0.998645664192106	,0.237678076716921	,0.655435381296759	,0.902453454631592	,0.535211993164947	,0.307969123268486	,0.0370547734373504	,0.779577161548462	,0.353354145005976	,0.823115115437245	,0.0957451537697321	,0.188799407886713	,0.151648351993248	,0.753851950519649	,0.989732383745598	,0.432173612263135	,0.541901306501544	,0.735258371445936
,0.487448891851794	,0.553525353108312	,0.100609691394777	,0.947083272015249	,0.628552760290239	,0.0862421980529289	,0.472622675575606	,0.369308399208499	,0.966265497247812	,0.024212243978033	,0.93518453879989	,0.646543609745122	,0.458448986270674	,0.152112251218461	,0.550606228667594	,0.0388852162467713	,0.543829459484587	,0.141725557456597	,0.981444173018189	,0.13221591670635	,0.152912083618768	,0.993389380627027	,0.895320198449921	,0.646575347821496	,0.991870835885345	,0.373138725000033	,0.342551075547259	,0.255926722779836	,0.360429760702154	,0.742988121110475	,0.401351503749076	,0.514723510721104	,0.958044689594789	,0.857098019615327	,0.246415674801178	,0.508246383400749	,0.0969658163827685	,0.704475945189817	,0.127210805251827	,0.0320038674548286	,0.889000313304831	,0.428265714286019	,0.861860005120682	,0.281106063295671	,0.549605810339379	,0.224854373943458	,0.127462867706764	,0.268417547581912	,0.293722209191752	,0.589169885771894	,0.178270168219819	,0.186717270494773	,0.157165205644986	,0.475611275283439	,0.598703688755028	,0.412896905752317	,0.558294979184072	,0.263715146697925	,0.260470552025582	,0.728567893956121	,0.0405937205257796	,0.258660876778262	,0.31335601225186	,0.57449791700323	,0.586491073289183	,0.15546877130655	,0.963639349194076	,0.886541904828763	,0.109794457028524	,0.315439278406761	,0.58795218243634	,0.712330207560365	,0.133798467057663	,0.750835838145966	,0.297931719244426	,0.33840534106754	,0.578567322147343	,0.980983330393668	,0.386833926377275	,0.517800622860808	,0.675068421603678	,0.874961893015989	,0.484535919728007	,0.595202868615837	,0.574612826376507	,0.517772909960604	,0.209297707867482	,0.666576128763415	,0.144996126715558	,0.949901708378411	,0.998012715949683	,0.599716966319697	,0.443052935154668	,0.390681144497674	,0.177995572415178	,0.571585581904084	,0.638875061943603	,0.5731660861397	,0.202409749944885	,0.900667323684631
,0.515709167586504	,0.52397962637431	,0.525580473023271	,0.431010102122561	,0.986786373884783	,0.918585881552932	,0.67291126012472	,0.619548916173889	,0.758634134549012	,0.363899365236936	,0.056631537180688	,0.806245395823496	,0.566367605499163	,0.940345624433991	,0.388909862092188	,0.40805218341204	,0.133046606151874	,0.114309594554039	,0.201355669741219	,0.184741340663629	,0.947712533617258	,0.204552505260591	,0.913955914747881	,0.857059167631464	,0.593430382010262	,0.784430446468494	,0.922513795980492	,0.689369044121992	,0.225524558325077	,0.391251769564697	,0.768491073869397	,0.0294785229626477	,0.445535433220461	,0.114026136283775	,0.437272521405142	,0.239267256222324	,0.36477532860114	,0.778947799363615	,0.775663904275589	,0.583239159818384	,0.500559067586697	,0.896248929619905	,0.255760121744014	,0.560366151649675	,0.073910776094492	,0.218413820126287	,0.881074862499291	,0.225214025576233	,0.172127859747097	,0.952938769456436	,0.0418982543246347	,0.183960434135031	,0.82301650746866	,0.438441025763024	,0.878319999146424	,0.924225653952093	,0.460565972822051	,0.732305220203616	,0.853835962179041	,0.421016343133997	,0.0216790530931573	,0.359845336694198	,0.920573819391697	,0.0841825162452564	,0.855550534024625	,0.237825351877988	,0.130689013344557	,0.490247281962189	,0.586067938518742	,0.0438426844979835	,0.863998357608914	,0.220396333011052	,0.201168916747518	,0.0459837755402475	,0.849315504938977	,0.445691509379862	,0.737198147334716	,0.0892622545777179	,0.230712687704113	,0.588142243022165	,0.906678473533447	,0.545104676645764	,0.574300385347707	,0.266576538917877	,0.35188959275926	,0.208385504879237	,0.335180505334949	,0.37875316449383	,0.704435647793317	,0.449932462279653	,0.0148935341345582	,0.315628199519416	,0.763149322831607	,0.250668830820671	,0.991039603013098	,0.402607841139011	,0.629986023358063	,0.175094578962351	,0.814588620241074	,0.790940391733749
,0.335163869119791	,0.0991482963315902	,0.385416445036147	,0.694191722522579	,0.280280436985325	,0.673304412361842	,0.227258565475819	,0.534709952089335	,0.870164765450249	,0.859212922332442	,0.791585641350404	,0.179874176243262	,0.145280120496303	,0.722985181362827	,0.211943165032167	,0.128774695624027	,0.316309353018324	,0.21129617896457	,0.254879857532158	,0.765765542986694	,0.221480977358986	,0.430786472480179	,0.228242974368969	,0.0796702192535951	,0.0173749951726641	,0.021543866964776	,0.0877720769903493	,0.185297976799914	,0.303096076149073	,0.135751837462071	,0.58113222503156	,0.0893061054355028	,0.967714054494963	,0.37011389684403	,0.504264257617418	,0.169377775941686	,0.732280251911041	,0.434193868857899	,0.496353894703255	,0.219908277606549	,0.99842173326687	,0.474071016290258	,0.711570790368864	,0.370273729493038	,0.190571589484146	,0.936704460036338	,0.191859830725873	,0.588175009744323	,0.45738877284219	,0.333105158681565	,0.498401961055771	,0.641759464350417	,0.0513173374586354	,0.490490667284695	,0.676645053865688	,0.373420320625147	,0.0753287468456331	,0.0502482345561722	,0.522078185585364	,0.568065133210302	,0.470693865544486	,0.95179820617279	,0.872451146073849	,0.286412063188111	,0.727546002588955	,0.865665512562574	,0.240269639175511	,0.21182562280997	,0.153242567159814	,0.547826254995459	,0.315867708677364	,0.788579740463095	,0.659697963232034	,0.543668040793235	,0.428761611892265	,0.196411073299316	,0.0809089416083456	,0.836581611464071	,0.427143876639727	,0.00713468389917849	,0.91263229349285	,0.610956734330839	,0.349833898409192	,0.658330563296718	,0.56177732793697	,0.791550636660098	,0.59155034627372	,0.186669822403542	,0.359705136325073	,0.564226215502353	,0.950003948039377	,0.716354697810651	,0.77340610361351	,0.636383432259962	,0.696345993176264	,0.487107313464911	,0.812617404764806	,0.660721882088446	,0.75267226051198	,0.162682424840835
,0.203514299915877	,0.464838686149958	,0.543798122342582	,0.615042211774291	,0.0144532905027518	,0.916453479750293	,0.833634163175539	,0.889380491287159	,0.817917063281833	,0.732082577763164	,0.111884465493208	,0.442211544347094	,0.249425841611543	,0.100119965197574	,0.716255075631782	,0.0990561433597729	,0.836601447703597	,0.76053155435274	,0.253834006494765	,0.188147157518262	,0.189276409423573	,0.168613181993651	,0.88174976728938	,0.568338832616964	,0.07075979331078	,0.259846174279156	,0.234651109778625	,0.781202049358376	,0.662843566230891	,0.411817642586221	,0.419118946613334	,0.132135730298299	,0.805219123514937	,0.317808915543281	,0.414443535923233	,0.552508261777697	,0.00635569775773012	,0.820212214170123	,0.306683557250855	,0.430546715124765	,0.198641101922207	,0.561000006534625	,0.727109827439818	,0.534869781013052	,0.556409486362901	,0.574237301281764	,0.206322642604971	,0.664654261742092	,0.844177099337884	,0.0845085718131198	,0.335566463105179	,0.865545408737634	,0.221684653415198	,0.853969949229606	,0.672936701994825	,0.0471504270318665	,0.457227124579822	,0.616282813072336	,0.865239306755941	,0.0770286471010319	,0.62047182704344	,0.269997119097969	,0.841580679566404	,0.446481472554841	,0.0141092292098837	,0.13381533051553	,0.0342599745068047	,0.807391535866722	,0.829543312000829	,0.134444797939828	,0.613718974689822	,0.774807611841153	,0.191532214261374	,0.0819250909061754	,0.9150028600893	,0.453069520859546	,0.739437086386344	,0.719110895283106	,0.0968170231659045	,0.203708349356292	,0.72622763119928	,0.707797566292713	,0.953696681630656	,0.780128166442797	,0.614093404083556	,0.0678424323293578	,0.227760159516595	,0.965000995418523	,0.771729999115565	,0.466095135298602	,0.660938963601803	,0.401161255501751	,0.317221217936474	,0.537009858310693	,0.524688627815195	,0.441767689977664	,0.789565454604833	,0.226595543430464	,0.391298435810627	,0.552810669202735
,0.0889172903676132	,0.432899208475323	,0.736996844754087	,0.705969781943583	,0.234125125796592	,0.940989263328253	,0.206548757947306	,0.464974820364721	,0.831805869858622	,0.161254713852543	,0.207975719686586	,0.447920772455596	,0.2044226611985	,0.731666763188162	,0.123288903442812	,0.11660016333526	,0.698945175716162	,0.171568261539363	,0.547771692065416	,0.398828543442687	,0.111329641244993	,0.117280404603705	,0.131760174469911	,0.493252315788182	,0.0916714519689192	,0.722093241625509	,0.221111999927606	,0.229382783281329	,0.236438609304111	,0.823706574190271	,0.0363924158906529	,0.647333874202955	,0.74042372905669	,0.301614255784831	,0.230796975656784	,0.00476986356301692	,0.167096903625455	,0.397659233025116	,0.458729453132828	,0.865918803431987	,0.497329281408959	,0.613232640369438	,0.600986689143342	,0.783284432153816	,0.66145120917887	,0.010472669271041	,0.0141524383864144	,0.860031960466891	,0.557159567045588	,0.180843335194906	,0.433934620783634	,0.139171510533975	,0.0555775445213437	,0.0917907702232668	,0.727475142445171	,0.674719075986519	,0.0035101054252638	,0.994341882408756	,0.904017643958338	,0.824542007792993	,0.0775249768409529	,0.962285765894822	,0.136867394268917	,0.330295477681931	,0.276093400212048	,0.301777363895335	,0.972154988894311	,0.00889834668901672	,0.554512802304007	,0.696668323453827	,0.90451228847006	,0.138032316294514	,0.90913996189327	,0.915339540185099	,0.111651890963154	,0.533331417726973	,0.701137737231859	,0.0219496558522571	,0.907865908885312	,0.502330635442552	,0.670989882979072	,0.326963229257131	,0.270994124594607	,0.598252061567387	,0.822398763067275	,0.0560108716860464	,0.374720427382142	,0.926223011653043	,0.0301568526915074	,0.846223186164267	,0.47308986283517	,0.221324670697248	,0.803740408645822	,0.465048110329103	,0.063590301230359	,0.762192778644242	,0.17403067377118	,0.933534072215452	,0.907151725099958	,0.499043755000012
,0.42839028519969	,0.955523351186664	,0.480963394269796	,0.551767492458116	,0.556245743556063	,0.822211946743639	,0.916188920343383	,0.387184211233251	,0.405038197247795	,0.47698114368924	,0.622081985055507	,0.331922827908733	,0.626968662080806	,0.4623035921074	,0.936472549073618	,0.294132280300433	,0.481235009376535	,0.116802591419221	,0.101153982850329	,0.0949897654796903	,0.492988417154638	,0.656327118005756	,0.889872322739042	,0.084128275087163	,0.943919389948211	,0.45318685958776	,0.711549091484188	,0.00558057474232306	,0.79271969422359	,0.239900815878017	,0.0130124618359899	,0.700446077482983	,0.397224256488133	,0.148078796057067	,0.760325331129285	,0.78784028989628	,0.23175228677306	,0.0606837948135491	,0.912539431318892	,0.0502221766161836	,0.0841223881971661	,0.844978429770553	,0.552469153680126	,0.34906590187413	,0.750612798496435	,0.549304329580303	,0.157867256159832	,0.274974278302386	,0.492695428194802	,0.732061670037015	,0.760488312114257	,0.527061704325984	,0.326064606814675	,0.16784673424803	,0.0000625066459469994	,0.0505491984312186	,0.580378033491028	,0.413608883700151	,0.524508348444713	,0.411812310298817	,0.329499192223651	,0.892923702901659	,0.368674668189452	,0.315148260125494	,0.696807929173488	,0.250865618815117	,0.298455425677102	,0.140339355049813	,0.683540322204838	,0.262195296707654	,0.716351765541524	,0.724123456386907	,0.342931494742134	,0.649632131052032	,0.36722659150475	,0.977323420335224	,0.874725574103522	,0.512723957892844	,0.3515603050364	,0.67404674676901	,0.703672946758416	,0.631216168697558	,0.850147299864398	,0.42566882093701	,0.215873488325567	,0.185718287800308	,0.367263059768483	,0.59024552888714	,0.256604006167782	,0.743531661920031	,0.536641889967323	,0.34024468080152	,0.492350231154054	,0.930335006178513	,0.140448842263058	,0.523691915219506	,0.690019094240861	,0.150916906143966	,0.460441561630201	,0.641326318793616
,0.771439964310937	,0.591480173911657	,0.00728293322365868	,0.404258690031366	,0.375803357165215	,0.127023875772498	,0.890280108382124	,0.937781578366543	,0.294987606487697	,0.856702238720237	,0.59452617102979	,0.201356497686988	,0.198656625206888	,0.821899852166837	,0.670815368029669	,0.393890474640713	,0.117207286468338	,0.902863673354901	,0.429758075824826	,0.943980387851587	,0.47837862161844	,0.10949354111659	,0.257945546534818	,0.290800610692613	,0.48586391074856	,0.914747951046912	,0.168813245449594	,0.244216271324184	,0.542872145559114	,0.0521504120212749	,0.491974841566745	,0.621162212277372	,0.873301745799045	,0.582441644548644	,0.0967199290621653	,0.571847747811977	,0.0450974758924439	,0.953277324304579	,0.73198958706669	,0.548989829862951	,0.872070506621185	,0.889004782256207	,0.503375380068727	,0.230012815087108	,0.825383169029552	,0.214921879682188	,0.192031818531468	,0.478774058389838	,0.755599358005263	,0.358409994448726	,0.796776699738939	,0.425992512342517	,0.656154940676016	,0.996087941804942	,0.250037915655429	,0.387248420802526	,0.484208428060733	,0.0910504167392153	,0.28435413599217	,0.13996362040749	,0.368568188682463	,0.525547186157455	,0.87155774835104	,0.27107653593229	,0.983339413992753	,0.985530976199327	,0.819116982081494	,0.899117843666635	,0.473598505125194	,0.770075639137102	,0.66126697727538	,0.914087067318189	,0.0613404168101682	,0.948385328496054	,0.512216033186864	,0.81486977162532	,0.516251706758631	,0.642435492315532	,0.413319347153101	,0.658267602165354	,0.503589593108552	,0.830291375438818	,0.707147000221138	,0.019632716672324	,0.967069111749096	,0.530561167062522	,0.141534819799259	,0.775716366141902	,0.464965746954533	,0.679309064838714	,0.147452744258313	,0.238272749464155	,0.650100244046236	,0.234801685081237	,0.311921160347723	,0.458941964180647	,0.437591984140497	,0.60847744932793	,0.680490854513129	,0.00979180215382567
,0.570818799347998	,0.751560641802643	,0.479706777017427	,0.431801331896242	,0.284985180145588	,0.745922706902923	,0.72293491741779	,0.367157040800507	,0.808384734116674	,0.522226298936748	,0.0574062299250654	,0.826506350574319	,0.0922341025863933	,0.178562169512064	,0.0943829892642717	,0.294900564614171	,0.393789470379143	,0.419628662252626	,0.698926479881129	,0.857347362142684	,0.437115532083956	,0.600747735053649	,0.767183046679563	,0.0454655434216678	,0.139388287970511	,0.698955920384711	,0.352153905831349	,0.650695307483289	,0.236032871639371	,0.0044736429138452	,0.188516452996301	,0.39602550882661	,0.000726848841051966	,0.216148471560398	,0.807361515614838	,0.324992938584179	,0.156318784298524	,0.249807705287732	,0.518102770912509	,0.753270726536061	,0.221100891577593	,0.0426847445977315	,0.402502454073402	,0.858745611672637	,0.937495382007908	,0.484885406906198	,0.469033872461428	,0.0522944592182964	,0.912976081908204	,0.389008631179579	,0.0680642351825089	,0.955600712427684	,0.781173772076691	,0.187587292952271	,0.779632648816161	,0.285928653220613	,0.602874678840337	,0.514727269539017	,0.0212191422568723	,0.630123911253234	,0.492576433109388	,0.732111269483395	,0.594106207412717	,0.143027985535109	,0.871352888583836	,0.827998428525402	,0.169588226438308	,0.269321748646592	,0.490629503266248	,0.0100613958249154	,0.101879629353937	,0.290930551612252	,0.669780947114239	,0.00837814901414241	,0.811550480691507	,0.728928982153968	,0.109403061731441	,0.737258520320644	,0.103951029062248	,0.104945449207418	,0.81816482908007	,0.896282348733527	,0.817435164385212	,0.632807822261382	,0.601068747044107	,0.162431570311278	,0.987402221647744	,0.269139233636269	,0.423099724772898	,0.0370742581026043	,0.107055930470608	,0.28902341951105	,0.61661172221257	,0.393215226658254	,0.76831444528341	,0.0608818782776975	,0.241728213262618	,0.726080304815471	,0.231683033626379	,0.896746158551772
,0.612686779635347	,0.426705331274637	,0.63650273281918	,0.701430491964068	,0.942278440083507	,0.873742483497477	,0.989920142102018	,0.587828308617616	,0.630382936275742	,0.846009986403403	,0.88984148199197	,0.565787839035405	,0.196210668047988	,0.712697882537124	,0.313311801437899	,0.831446766774844	,0.125809184799813	,0.474968930461895	,0.802814273071854	,0.899487518658623	,0.686726095474663	,0.805486642664991	,0.814003270498478	,0.952967267927233	,0.520872053001482	,0.296594795909056	,0.868734843502163	,0.826514740859398	,0.233249623902724	,0.226428933081417	,0.591078299372959	,0.252977561323427	,0.793873162844159	,0.626247921784524	,0.348821432492147	,0.641815895513546	,0.999755896162128	,0.89734679688576	,0.707615258967325	,0.889657463827011	,0.47299454057263	,0.619243404185047	,0.623894138086538	,0.788778820442398	,0.00563517539093046	,0.710392795368281	,0.571711754692584	,0.75946111826201	,0.263014629605699	,0.486879782977924	,0.988512509962783	,0.929754944485498	,0.391351967766579	,0.452522252897044	,0.541504440615654	,0.0651334273000869	,0.697512632560689	,0.0948154475050119	,0.563226216734958	,0.143024664438807	,0.815535223025612	,0.700493391463763	,0.192430331461332	,0.176580870606276	,0.794692279675366	,0.39314450388455	,0.579676787638886	,0.627769846761492	,0.927814520396206	,0.778644299031535	,0.674733823013834	,0.251363393502013	,0.664554588340481	,0.16896623846561	,0.815569891508468	,0.283166582828	,0.180757590188066	,0.99281829083004	,0.297013980474795	,0.913969839883023	,0.0910989139653272	,0.0994470152535695	,0.40598536674212	,0.396058834807975	,0.560836617630365	,0.981032513538856	,0.213455047557808	,0.538984304079313	,0.709198661013133	,0.501895647729698	,0.360151393041085	,0.0644628415184388	,0.426977400401131	,0.209168541808225	,0.49568217084542	,0.930245398976954	,0.634420605671788	,0.707119525739513	,0.557869103996954	,0.106030876797638
,0.0609463379070844	,0.325101204367867	,0.975941810745719	,0.654013203295885	,0.999907793942796	,0.450292796571875	,0.071031983509209	,0.834546839275652	,0.228727705883201	,0.226552778960463	,0.672555988502016	,0.648498753387713	,0.318548187296162	,0.839383886586588	,0.524981860781546	,0.370134155438344	,0.844750452248729	,0.720850944389054	,0.341822346831589	,0.00818319851913638	,0.535017511125196	,0.0393094811771575	,0.67445014448578	,0.483578372506228	,0.501706712181543	,0.184711635198776	,0.44845278581998	,0.145971276399666	,0.339242449188252	,0.647843506954538	,0.305821384911342	,0.940016204928987	,0.852356241481545	,0.55135058031946	,0.5492034291612	,0.462033912288972	,0.403963840754686	,0.420271564005069	,0.504176233198576	,0.689951368463203	,0.0126497610531048	,0.604534019531931	,0.403266273161055	,0.696253017846613	,0.924470948020216	,0.583223375763382	,0.235276455169207	,0.291382028856958	,0.257758998897746	,0.155494474412638	,0.395631453206591	,0.377834043175836	,0.256763656277565	,0.426771057037064	,0.741155621940808	,0.602537959163328	,0.855479658048358	,0.0466128187471129	,0.421644682726657	,0.582182586929846	,0.742738529919991	,0.206472365281765	,0.18104329061743	,0.794585407150251	,0.596937974261557	,0.73653341398413	,0.917088831270621	,0.511987165320659	,0.968287544310227	,0.00875722198223566	,0.182629855434704	,0.459980291062957	,0.88875189511513	,0.253101199983201	,0.871868117652772	,0.487453390139832	,0.629128080154363	,0.755643154380677	,0.0944956760362236	,0.188827140810353	,0.6177555996076	,0.618362604928372	,0.820301031144476	,0.79943044520888	,0.0274926256516448	,0.0685593271947276	,0.276612161787512	,0.0206031627117671	,0.27735569666948	,0.517193923945163	,0.478279746360276	,0.447697077154972	,0.444775743617106	,0.345922972702385	,0.92740220899107	,0.848926512919798	,0.90790264304164	,0.119721600841601	,0.160945344791257	,0.0084099066482903
,0.345301037815074	,0.474542557948522	,0.636771440802501	,0.217605567638579	,0.296775301590923	,0.902493838641091	,0.213946040819374	,0.791108051217677	,0.153016815498945	,0.753618090764442	,0.0592514779694618	,0.839590232744622	,0.99304173886452	,0.052505095979434	,0.453148126347525	,0.0605595228544248	,0.82390061431746	,0.297624833554786	,0.180577555289761	,0.966971755012391	,0.89428649325589	,0.273092151746662	,0.859794406155029	,0.564584247565169	,0.967448827795428	,0.912448757752985	,0.526271554420829	,0.0460151508664783	,0.376640612900555	,0.198781019634931	,0.912597004283498	,0.0178509927437878	,0.0216350448418572	,0.620198657093662	,0.678829773179642	,0.0919978302400549	,0.207532844602844	,0.00451924000145832	,0.954866704509997	,0.444702699521884	,0.118270864299625	,0.778416283791147	,0.842481677812748	,0.589558998863007	,0.718093890565491	,0.00401873421111085	,0.542865886140087	,0.946948356436076	,0.361026621126117	,0.774421266640733	,0.698228430793727	,0.125236350169981	,0.847337306871702	,0.198116592689472	,0.745573331949102	,0.850990068563721	,0.590082350461782	,0.514064211172082	,0.877197169175929	,0.0528223398387536	,0.785065669931968	,0.598714546579269	,0.595384357774344	,0.624901113391342	,0.713012768287683	,0.605596611092611	,0.262242633505837	,0.511941332608434	,0.197977149951261	,0.401959230844844	,0.728792809289318	,0.820745725566869	,0.273409602359594	,0.195186857690656	,0.505517206855825	,0.227695625847064	,0.880383611601025	,0.607360178421885	,0.902518736618813	,0.632406352382342	,0.853564490030317	,0.858383939535536	,0.858871773750927	,0.057901431833348	,0.149364823079372	,0.374581495008702	,0.591186611257115	,0.0733753983273056	,0.22031968702577	,0.9129798421231	,0.452206562949441	,0.235703491249915	,0.468577437320993	,0.380989053929685	,0.283029396218727	,0.875062248145725	,0.17120458519608	,0.435463390515867	,0.833204400182331	,0.666353864439928
,0.409399641868379	,0.779780881842496	,0.777281126835049	,0.763898716663895	,0.84573097007616	,0.200414070021554	,0.359274852256884	,0.332441881453824	,0.350701594422898	,0.241697465647802	,0.209305142615598	,0.791531940359404	,0.277321620507781	,0.944475874278916	,0.806019005741002	,0.761429489013473	,0.345421849445171	,0.505023624983162	,0.932065091995553	,0.218001169254073	,0.945651653197432	,0.567335289235849	,0.204206186907462	,0.0933833537126814	,0.494025849035953	,0.0924447472637728	,0.718867262228796	,0.0020762793729437	,0.896027421064688	,0.532865834204883	,0.876075481472572	,0.200617109518786	,0.771759682228677	,0.964979217371428	,0.405706361590748	,0.706819255699785	,0.511230546287834	,0.25179145962549	,0.859061925606365	,0.253783666181277	,0.342077508728056	,0.296689192436956	,0.455257287926626	,0.509238182804193	,0.766138390063373	,0.487921795103663	,0.50161030725651	,0.56443406015841	,0.443249082399183	,0.687327883060709	,0.919730601329231	,0.912216540385138	,0.623394253022687	,0.387210552295302	,0.847752427145723	,0.175043038174064	,0.948342591500069	,0.79393534166456	,0.671287356257107	,0.32659661319414	,0.109277953910305	,0.634571370498543	,0.241023969017446	,0.88984727621537	,0.663171351730438	,0.92090853346554	,0.70972195533557	,0.296903324917379	,0.0541818863964555	,0.634964665228019	,0.85112848731276	,0.916486265564564	,0.384665343623918	,0.070430287192776	,0.721836848986259	,0.911920912057125	,0.654768944091522	,0.701643346204256	,0.519719654936213	,0.928240512929969	,0.938300813985197	,0.0217806492102242	,0.0673712762386404	,0.309039742829762	,0.0309577398146306	,0.3067330644963	,0.262614989309858	,0.770125330784416	,0.496434493687206	,0.574535400874231	,0.216482493195907	,0.421263143616385	,0.169654760588731	,0.387561214802582	,0.741337187002104	,0.654101944367449	,0.491378983711535	,0.606579239762658	,0.777282690991314	,0.790187491006305
,0.681161342971568	,0.278691323138164	,0.96506798312304	,0.897592348930236	,0.834608470478378	,0.2645633301067	,0.515889103298955	,0.548159145539701	,0.910759085747767	,0.127954162716844	,0.525612782000384	,0.974027080449288	,0.473141111188168	,0.0826557395433335	,0.195014504806611	,0.608782284710921	,0.803859136441657	,0.460506174927813	,0.727282011754476	,0.428771557486044	,0.363566667942128	,0.464988103352947	,0.0550530529837371	,0.276661497669603	,0.849791333009392	,0.442933888846512	,0.389869843325517	,0.542456771965351	,0.0709664216595546	,0.732648832133342	,0.628921665078458	,0.286424973647308	,0.94453209030653	,0.75084178184664	,0.397827496471734	,0.286733200441456	,0.124899819551455	,0.191267201300369	,0.627852255305207	,0.312854914606016	,0.15254978330459	,0.904208000239082	,0.0238600182458107	,0.015326657339617	,0.595129906942663	,0.348345985332665	,0.650975486101106	,0.944994901281313	,0.529305835035306	,0.0431694383933998	,0.548751077870257	,0.859365765405523	,0.360419170633154	,0.565000831412617	,0.968973551862395	,0.538486151275451	,0.3367444865111	,0.664584792062913	,0.676600201370474	,0.619584433557272	,0.355574797073181	,0.14561440895573	,0.341371318950025	,0.427757593070975	,0.321866743882125	,0.614364426869137	,0.622922389592474	,0.456601880703402	,0.107808982072309	,0.945561689299327	,0.0553120537918583	,0.629688079762127	,0.167556562073322	,0.123138766327472	,0.593245665819033	,0.67990542048584	,0.170402105511353	,0.948187329316599	,0.184443824079094	,0.947351297339122	,0.133254378630432	,0.606341641678634	,0.783971692800509	,0.2122408981492	,0.132775193607796	,0.552678966220785	,0.875385272724268	,0.600278676767032	,0.883720423506443	,0.689157872781697	,0.676367841975935	,0.714320089535005	,0.577744814836301	,0.157102953715763	,0.429343100837126	,0.969495769575935	,0.31539926273534	,0.915408792866119	,0.275581700855671	,0.701646281267352
,0.569049260378373	,0.0109191793067936	,0.518646609279628	,0.893562162711081	,0.0992686851412378	,0.408791168783228	,0.553173739720683	,0.191043485510649	,0.867860977476398	,0.139448445820924	,0.710028912271386	,0.455928545191851	,0.791059039435843	,0.32927579820588	,0.138340446231114	,0.0878798063322342	,0.99590502586025	,0.175769633229715	,0.160225691814081	,0.913202319253796	,0.191379698548177	,0.518593499212802	,0.000941269565811972	,0.819917592601812	,0.354978858658568	,0.129677474559135	,0.489314915374534	,0.915782699787888	,0.5598353350348	,0.15247592989005	,0.662953662063439	,0.262198300222959	,0.766831847264819	,0.142856979809169	,0.99725965270645	,0.942983037299934	,0.715907899996223	,0.264075236517971	,0.312500157539034	,0.190147758550079	,0.813377951184929	,0.443225565107179	,0.292072756351937	,0.866816007004499	,0.576629724622066	,0.415781723063337	,0.0434195255131552	,0.751965299598857	,0.280790357981245	,0.243546590788079	,0.287551375239879	,0.875963656639663	,0.3211771428218	,0.0242394060009343	,0.391696657702186	,0.245726000632032	,0.916892622558816	,0.21430734601538	,0.86356448049823	,0.928223733756795	,0.656293250460314	,0.320660486501018	,0.340796622606365	,0.768836145181598	,0.829092067121105	,0.550372104416775	,0.103958932731281	,0.237782414647649	,0.409042983040699	,0.785415965032492	,0.486124301089963	,0.291128419009563	,0.995338293721591	,0.650702578784294	,0.358241627625302	,0.967035498454718	,0.965622528440143	,0.217835493487229	,0.161139039863431	,0.263842984691189	,0.409043704815695	,0.797546837384602	,0.369695922997639	,0.479377821311065	,0.903042775067986	,0.439920567646586	,0.744980436165342	,0.886190630908213	,0.205933674334518	,0.127264540236101	,0.935127748146247	,0.692063093973353	,0.50442041014527	,0.793833311551173	,0.95646724056288	,0.344912140325137	,0.938342444569963	,0.721465887372133	,0.677169063443862	,0.180449300995306
,0.811401828104352	,0.230524949836789	,0.432831906915098	,0.605859522058563	,0.680987238269759	,0.352513599839301	,0.69607249912623	,0.890492814542024	,0.512734007794752	,0.520469006393323	,0.52259045258285	,0.177736559965525	,0.218363340580074	,0.0326651293005166	,0.00282815378290981	,0.532780629365137	,0.444037739859912	,0.942293825532447	,0.1323257238289	,0.998440392314662	,0.787673632515442	,0.43074168704019	,0.475534084474451	,0.301357762097082	,0.919907565657006	,0.886455997306135	,0.66594672420339	,0.566593686382563	,0.740087031731423	,0.642742310018624	,0.570004483019004	,0.0653461003980348	,0.271909389771479	,0.981113889245835	,0.581136554750212	,0.162075686809642	,0.00606820965468334	,0.988399666262977	,0.0331908818488898	,0.839151234291099	,0.6147947304951	,0.855035431149898	,0.580491336332863	,0.317889746426553	,0.772968191082109	,0.276387517003523	,0.244998278210404	,0.686061882267735	,0.642055273820672	,0.022987104031717	,0.344257461067409	,0.935148159943124	,0.0351241640910153	,0.331825877694332	,0.997526408637653	,0.426349973038933	,0.663996865350752	,0.795315950082297	,0.875173033156978	,0.0331682693367676	,0.459102743053391	,0.139802498342377	,0.660589640336386	,0.530085133635479	,0.140841011489202	,0.114880099014789	,0.789824141557247	,0.574347152642136	,0.05259445638051	,0.9550283872313	,0.16210419645631	,0.485229841193757	,0.257940943472991	,0.213436950563191	,0.234828115550255	,0.756138053143461	,0.41225918215339	,0.840074452031438	,0.131315292386019	,0.0161191318259198	,0.914248598233912	,0.776190517366021	,0.434025370717992	,0.664405657287876	,0.665882037331295	,0.479401427078713	,0.299784911936049	,0.485014909172903	,0.645578468984728	,0.237328226322927	,0.775499809428817	,0.825297070120134	,0.76785750909143	,0.381155299665944	,0.0771214855262644	,0.180807239925865	,0.827281434008517	,0.119061381145875	,0.0646329187157717	,0.285464855975222
,0.807834375560207	,0.272350040391251	,0.387128855747696	,0.474678551533575	,0.922415624802194	,0.0394060504806256	,0.297490427874723	,0.921621290464709	,0.68902884036723	,0.507720052035395	,0.250914558885114	,0.120991182104215	,0.498797625535539	,0.291692375806948	,0.473760187380835	,0.487469309702268	,0.896688166026346	,0.638006404805	,0.973645557637161	,0.0608872077711333	,0.331301009436744	,0.176065603353114	,0.134595555781664	,0.147506022428864	,0.133718961912076	,0.414592856268675	,0.0621353076128919	,0.308115049874464	,0.489643240109851	,0.433936526269622	,0.171197013543545	,0.308206626357607	,0.0287691922992324	,0.523814973199654	,0.75825456658297	,0.98450055997097	,0.500911432085983	,0.818439069119487	,0.505434691210014	,0.840855166707586	,0.252786854399735	,0.588661896338995	,0.640491769481679	,0.745169678584286	,0.0667879660924841	,0.50534611637953	,0.352177990764462	,0.0554907783193005	,0.633511212483752	,0.422948214422422	,0.490639797640331	,0.183078941043037	,0.00776211033005366	,0.457788317211805	,0.0482473788076301	,0.893695619839102	,0.34228263578484	,0.744259635798754	,0.771698869658494	,0.942902350306	,0.35980159293851	,0.185372517530514	,0.555902135351627	,0.0471888547982969	,0.103082594975402	,0.509173751580144	,0.683242807482948	,0.261865365906556	,0.17120479148403	,0.438930472097793	,0.104444547604976	,0.399511596839648	,0.591408083956413	,0.795667055433461	,0.776200670179073	,0.604663699681248	,0.582800542741455	,0.128721855640748	,0.428227754043521	,0.223862209461565	,0.45215442052677	,0.359345793425732	,0.524750106281019	,0.475036265084071	,0.934507267984798	,0.26365302049725	,0.216315497279314	,0.614562773431913	,0.956533070167775	,0.451310309791616	,0.172376667695295	,0.134653954829394	,0.129018817622689	,0.419267784533681	,0.633654657580729	,0.833829959311443	,0.180126147428586	,0.380159832248539	,0.346300601189165	,0.274204186291529
,0.549759001727104	,0.799542027432258	,0.902855053964469	,0.284891980832858	,0.179521857844443	,0.223864791553405	,0.495551638070285	,0.736381047282545	,0.356261677740264	,0.690017780610368	,0.128838718463126	,0.392341209758232	,0.0787124066048825	,0.919417808260498	,0.655103434182286	,0.323418301680786	,0.691396348966004	,0.298437071637454	,0.831863010689552	,0.1216206593074	,0.0784209794730046	,0.0214020027878704	,0.703460855737078	,0.0666023730610508	,0.386084037081378	,0.91441122671329	,0.50948737026634	,0.954232066382762	,0.778339695082204	,0.55525524660724	,0.174929727881648	,0.0439365068655165	,0.440870888736505	,0.71702699443187	,0.0726954164321979	,0.791863975949522	,0.857843783617878	,0.780471265679445	,0.380562274428346	,0.110146317216636	,0.229153459998385	,0.382202192853299	,0.672255285397291	,0.594581672267328	,0.134165796979408	,0.924549832904967	,0.909041633787119	,0.262739060103306	,0.855383156265776	,0.424707358900787	,0.0565810455272817	,0.957632177023977	,0.923999241983518	,0.655260016981168	,0.955105402485982	,0.456499581903452	,0.388473051315394	,0.066573457823402	,0.900105637917344	,0.0754564768054786	,0.197005669678098	,0.0742902797992762	,0.596732586434452	,0.284580203837054	,0.939485889365657	,0.939342568600244	,0.530550464303489	,0.96165354874062	,0.511193683608991	,0.63224041631084	,0.0646769362802976	,0.025268062960947	,0.680334184635586	,0.376641170297117	,0.208149183638463	,0.36332941165349	,0.477421660198561	,0.0258429572106539	,0.342581839460219	,0.772975807903789	,0.404403438979948	,0.808598935980629	,0.122317026426232	,0.782263145680662	,0.496689454883658	,0.859668229641238	,0.443935580292687	,0.225297979184099	,0.583136147159681	,0.769225312755082	,0.369831474670131	,0.757594780883563	,0.895482310045269	,0.371184930843853	,0.505132692635587	,0.765165126307479	,0.130277849794495	,0.579821496074936	,0.0598845314513354	,0.479320102594476
,0.932964305362182	,0.331080222190861	,0.465294361796833	,0.20233871936907	,0.706856435959626	,0.136119173437412	,0.754947962590935	,0.410407265839357	,0.714916962066161	,0.609381445967304	,0.873962372482737	,0.685594317356867	,0.783691816862529	,0.508366008525885	,0.107505294544392	,0.841485407595283	,0.845245453922658	,0.0403440781125538	,0.0629208376924139	,0.510519096399899	,0.294453193105037	,0.874816516355992	,0.041190395150888	,0.286971300974009	,0.12665547017318	,0.69848720063385	,0.474381053109831	,0.922359616925176	,0.0980816614339508	,0.458483720411772	,0.735888960648276	,0.0857616155807681	,0.39547306597022	,0.715819761490365	,0.782731368570929	,0.366111571605369	,0.237183971440971	,0.351008008397654	,0.391597139365784	,0.573121320723147	,0.450037393928523	,0.778479756684266	,0.909270592457275	,0.110847429423988	,0.012746328959589	,0.227550823813095	,0.446695826690037	,0.6167591794472	,0.871528969086487	,0.787383436592009	,0.553418801889484	,0.309803356560787	,0.8650137171452	,0.285544059372295	,0.13900587015739	,0.27165973525106	,0.785170364559242	,0.358317147175929	,0.236292585840585	,0.36949022271181	,0.0221731173909144	,0.663583989098474	,0.856104778058876	,0.553004835524133	,0.352270654101051	,0.612883476360181	,0.732587185563793	,0.592827770669399	,0.65634164058433	,0.133953300832749	,0.35312709601276	,0.00710268644946752	,0.374851156200679	,0.12338226480567	,0.68572458889602	,0.9731655754024	,0.993825788141147	,0.230021288259896	,0.967791784074061	,0.676514932735132	,0.18647447935607	,0.076574537473067	,0.9882513098364	,0.539764420380706	,0.820613338528487	,0.0483806482741519	,0.133555543671155	,0.668022481104369	,0.453839921138175	,0.687554569303782	,0.729646288663915	,0.165173574427689	,0.0722654061728462	,0.564681547025536	,0.60276085818315	,0.601743484196134	,0.502738884418616	,0.53243042367158	,0.558130648247027	,0.501805087785146
,0.83811040494503	,0.121575911120314	,0.326338199119241	,0.766112597084657	,0.054419201824078	,0.623525057278352	,0.585637677267956	,0.812441842543167	,0.710047623007581	,0.770399888404831	,0.110924419998622	,0.306726916835982	,0.159291262346921	,0.208246264703686	,0.994970874858541	,0.475493747496742	,0.623414177737857	,0.722085240167605	,0.0866314969428962	,0.0155691192557891	,0.670187332048168	,0.83848973356117	,0.496951962586936	,0.271635198626497	,0.372783315541587	,0.369184307460293	,0.880655485149778	,0.176738912321971	,0.450899395370343	,0.266137989361835	,0.981187204355927	,0.813343610061958	,0.866054311332318	,0.774810562271071	,0.241120089889094	,0.505350766007486	,0.430324287819827	,0.460305387834229	,0.352653329890526	,0.0445154700635539	,0.171505358149999	,0.490554427025167	,0.748255011974021	,0.921986247376532	,0.822859657380199	,0.802261589002917	,0.610526372031554	,0.116734734325081	,0.96067980162831	,0.145425967008539	,0.174227512522707	,0.241802969128733	,0.982502146615881	,0.913578173105409	,0.508355382600965	,0.928915374413559	,0.280697768684802	,0.687398285459447	,0.10298371692327	,0.847330329402969	,0.0808462757062382	,0.783355794746129	,0.860842298185845	,0.176505609497663	,0.52977882722848	,0.992749229070148	,0.136292981978642	,0.676148115040803	,0.0213694907824367	,0.157031580413241	,0.229772005337184	,0.778093702056489	,0.42085046340751	,0.233738490023528	,0.442801825442725	,0.170280215875376	,0.899588217446389	,0.379170621456192	,0.720634814221708	,0.709322624238824	,0.585345581912131	,0.903195197183264	,0.00167905911881433	,0.219946609912415	,0.642672797964268	,0.401715385448986	,0.630483241114059	,0.531833403991458	,0.524020884430046	,0.21900461577764	,0.810577374794789	,0.373938176023745	,0.778924431083223	,0.382913215729833	,0.62241677130685	,0.958675354234257	,0.456678615164328	,0.397485066856018	,0.53151864909172	,0.233935284537233
,0.75032721727636	,0.749540763790505	,0.531617027023629	,0.887373186129785	,0.0811392832925261	,0.707934297485247	,0.25173783453728	,0.957785068060171	,0.493638887299988	,0.588778850896647	,0.606147019940497	,0.512964139931353	,0.388299826247757	,0.155179746055594	,0.105991956361566	,0.406810568835032	,0.265230410390175	,0.727507427673557	,0.217336909481015	,0.78143764742717	,0.622540308452463	,0.0349641605443154	,0.642646268309395	,0.955831476000991	,0.659617148646907	,0.185417308558439	,0.308704941677258	,0.403954769672805	,0.267813890831458	,0.148063204320177	,0.498275009215937	,0.508079892260991	,0.298749230475514	,0.0783166019610672	,0.267129159656879	,0.639786353167047	,0.889237678558211	,0.417663527847111	,0.670912526394665	,0.0268311151428293	,0.950552205532115	,0.93091837825762	,0.945183375824794	,0.696997487310785	,0.436769232357279	,0.780488228788827	,0.665661253810703	,0.768692796476508	,0.419830380668785	,0.0892079002639316	,0.317179735897658	,0.839821231942541	,0.875445258280004	,0.60845591202772	,0.318513449895435	,0.255552392571956	,0.0690619568662075	,0.724309050349663	,0.462209226778806	,0.350474471389537	,0.424440643947777	,0.573902830283112	,0.584868568268078	,0.886026881582116	,0.453798750626761	,0.995601783970186	,0.0791831869069409	,0.831822344954974	,0.438151658251021	,0.0149202249082365	,0.764220032731174	,0.246090112834279	,0.0365264057351865	,0.899301191279339	,0.555121831854396	,0.932627976840654	,0.678406760878119	,0.982430078546717	,0.702330134670404	,0.0625734054774853	,0.671225860096154	,0.293030636055875	,0.965900191090023	,0.884511650020495	,0.987301894457686	,0.582940150323762	,0.475106491462843	,0.114802015998774	,0.477482891398241	,0.0549557302403058	,0.640958148818909	,0.583607199407931	,0.686200449097064	,0.970947974347951	,0.722604866010419	,0.819983037104822	,0.454904620747503	,0.581960903285984	,0.0169015275393154	,0.0639733532741542
,0.20014847870923	,0.895481666035709	,0.360361062158067	,0.588371690636674	,0.763004530576526	,0.817145399664131	,0.762732155044904	,0.239329839702384	,0.416615877960164	,0.0630608764770724	,0.864150950156223	,0.78501927563223	,0.818965550893436	,0.354013865978464	,0.911045500035885	,0.941719103111755	,0.472965999260995	,0.139549579536333	,0.409783267141219	,0.227370842465838	,0.421749323337222	,0.340877328692413	,0.125263333378948	,0.300844099978378	,0.286788336600544	,0.0515732453444848	,0.791534504756115	,0.320421436019438	,0.323075178695412	,0.924528333788984	,0.547705991448698	,0.294598278261068	,0.31326273377671	,0.00676658517064833	,0.725996963086537	,0.83095859542068	,0.921113235373568	,0.150146923563512	,0.519344331938468	,0.620186889832926	,0.481057421993957	,0.132091452429114	,0.0610409761131932	,0.915685534437972	,0.926777298993793	,0.346064188678779	,0.300819124235222	,0.867021021371251	,0.0223061866230826	,0.900078574148975	,0.620595721816921	,0.352296576999266	,0.0485696266631454	,0.309715327485332	,0.385509045974123	,0.250535687082697	,0.75329279888109	,0.592070794474367	,0.933842730677613	,0.0947744986483708	,0.874998783168848	,0.104548718828963	,0.150317358388713	,0.383842439103798	,0.239874017536582	,0.562612737325305	,0.832276226408908	,0.0665372545209421	,0.291636733474041	,0.53857949820281	,0.905626294624818	,0.861133759310997	,0.0750927399262286	,0.0836799401248246	,0.408753677927309	,0.923064924275067	,0.95218229105332	,0.327765733156244	,0.758677156995366	,0.086977621115268	,0.832878084309808	,0.181962994943356	,0.252056012978803	,0.305410134748281	,0.0281347143594803	,0.860144239785217	,0.444238070139772	,0.309244839152901	,0.478011642805306	,0.941680628779196	,0.826327891939472	,0.0928798267119005	,0.0312475469108892	,0.177520931315385	,0.59429261767971	,0.276025342883554	,0.157937843891763	,0.461342288861676	,0.779848898192797	,0.920431926343791
,0.6993860600979	,0.581512065409455	,0.473283336718233	,0.47304022334192	,0.387033707642478	,0.8755243471244	,0.937702119787085	,0.959527261536348	,0.774684641405328	,0.124768099340037	,0.977445607994425	,0.928333562299764	,0.502181572142142	,0.16568299297508	,0.634062932168163	,0.69570095031322	,0.645871914292626	,0.169263516165904	,0.811916200356519	,0.875579392013875	,0.862841577205268	,0.77838808893151	,0.368610671893047	,0.239562506433373	,0.327045625693652	,0.655831033203672	,0.552175054118119	,0.406134563221659	,0.903604066420162	,0.873544323664878	,0.659447835599747	,0.339772924939065	,0.56354945086108	,0.5756206221765	,0.455796920440997	,0.578841851828081	,0.595003674549518	,0.226758153749052	,0.124290060309828	,0.943043627284022	,0.734243762555646	,0.434917272736746	,0.654602886482423	,0.910713110077527	,0.355241072995235	,0.536713830910955	,0.549356120428702	,0.0283160451931488	,0.907771561251847	,0.916629959790329	,0.799734196066733	,0.132633293574971	,0.167765114534537	,0.628279981961604	,0.501656828681779	,0.346319654652066	,0.594435737279447	,0.681436455660237	,0.902510281606815	,0.490302965738952	,0.521945174560857	,0.33254884431723	,0.14842643968222	,0.60317173907681	,0.507418663942916	,0.185484888584113	,0.444522433189918	,0.0885346229600416	,0.00140808941861991	,0.665758858744874	,0.409138925098413	,0.397914129028988	,0.742766590203516	,0.678081550485492	,0.516619009672021	,0.815695557657487	,0.395237549392151	,0.757492633889193	,0.178697775666927	,0.373515634040123	,0.677261312341905	,0.730876530395298	,0.841846353766437	,0.911667752504194	,0.399916337989232	,0.393892585017668	,0.152676391952055	,0.032119538184311	,0.833078263715412	,0.546378264923756	,0.979498573569347	,0.43252598002205	,0.464146230585941	,0.9056974579141	,0.0571751622749377	,0.942952354877699	,0.200228429492669	,0.23921448329427	,0.477820726799695	,0.732955322476549
,0.780104863354985	,0.22243840723412	,0.522310383861098	,0.470621553468807	,0.736449150245846	,0.500868181931259	,0.0915337186732952	,0.407209742072602	,0.974135014216478	,0.287183936353393	,0.700418291473956	,0.930224802778207	,0.288260293327393	,0.790749953496619	,0.134468417677315	,0.0106959026356674	,0.766035597662458	,0.760289912931756	,0.192566644024368	,0.467586117548675	,0.719877640586289	,0.983505333766111	,0.774144607025266	,0.0484102736452642	,0.631469155955813	,0.1021041493407	,0.0644379691520883	,0.00894753914743082	,0.381290450869729	,0.348607767535657	,0.0507489717801795	,0.937968709477209	,0.440100183449732	,0.763783239649508	,0.9049087892775	,0.802021386940974	,0.573450316942041	,0.979476844882349	,0.0673319376387316	,0.647875894162746	,0.850153193273653	,0.5247193502843	,0.958120228237529	,0.126675988140831	,0.0433326829426608	,0.292402217300796	,0.404066174479232	,0.140194472456441	,0.248498575411969	,0.515556948965209	,0.96564125826845	,0.532627717839846	,0.874053734296027	,0.221112313317653	,0.234649929792923	,0.761370029654992	,0.346088411447633	,0.707931200372023	,0.19968465259284	,0.0999561278614943	,0.962640968133994	,0.106751428035438	,0.171250991603011	,0.215415871802445	,0.494557383700533	,0.0259478548662494	,0.105596737053989	,0.764359666390512	,0.592913025334903	,0.089216803707749	,0.466819916137876	,0.842330529281092	,0.0492056273153078	,0.998978288378091	,0.828092770570932	,0.755194985659418	,0.562123977840936	,0.617695572608009	,0.609488822803595	,0.678644860013688	,0.984162250060664	,0.814936769574386	,0.64228623669701	,0.904780166644966	,0.640260801948728	,0.863298352278442	,0.455406743779502	,0.02114270209388	,0.345394091841483	,0.0385015797980603	,0.0960516659990194	,0.340350445518433	,0.269937828308874	,0.845080387240779	,0.266068355769882	,0.810855424409199	,0.0471180454115933	,0.912989232648625	,0.610033125435018	,0.826739186340356
,0.00550482236105242	,0.51954942220801	,0.0671390500232294	,0.406013740415691	,0.872935166523296	,0.421343757035836	,0.524524501303455	,0.683293407169773	,0.112294302374262	,0.330340004214244	,0.0244508287983252	,0.945079613451417	,0.953063277971495	,0.134512866909855	,0.75775415392488	,0.574065015452944	,0.310714717633424	,0.182259264952624	,0.231466058749457	,0.250049402122409	,0.580301471324778	,0.12682855554243	,0.60753300162383	,0.807158291715737	,0.909408866385654	,0.434817343687088	,0.975095348886724	,0.427528739174608	,0.475519307644814	,0.0530035863877291	,0.831276418562642	,0.262766782316736	,0.321310397387161	,0.263848886016686	,0.508227282440396	,0.775935975730389	,0.155944100653727	,0.952499687183881	,0.662242499488519	,0.309688903535571	,0.941401722348017	,0.138747503114281	,0.929284841720613	,0.490334798344567	,0.0569557771351914	,0.255746311161549	,0.328251692153631	,0.92619002607008	,0.475768159830835	,0.235462276840332	,0.414486855461489	,0.280579741243543	,0.703711080226913	,0.272125373721181	,0.611156131891141	,0.701108694403017	,0.533826831511141	,0.0275572077499503	,0.153990653415206	,0.120911949370481	,0.167133069675012	,0.00550202792766598	,0.472583380282197	,0.70887240288261	,0.0184752480212949	,0.513493493904124	,0.285152046608344	,0.550447346433274	,0.368551504038531	,0.245128375592236	,0.872608578704581	,0.93238228789176	,0.549112596804794	,0.935414498176153	,0.511470846604309	,0.290518878628741	,0.750793113257174	,0.579854513322867	,0.614805417421649	,0.0346506056537156	,0.372729221998122	,0.460034122439117	,0.793495834243249	,0.284486126287135	,0.358324507883901	,0.360004004724326	,0.587307401740601	,0.875501054281137	,0.546219303061356	,0.307826552217745	,0.640863123648271	,0.986519156483244	,0.427463013877842	,0.370874244892446	,0.283433907331635	,0.673680522792824	,0.54854657899055	,0.422353094174691	,0.488453794032547	,0.442916305010634
,0.0943383137203466	,0.544038697864878	,0.658395015009863	,0.64501727076481	,0.80526974415652	,0.168590038627661	,0.492779215095928	,0.140268117254725	,0.486246700159389	,0.348289578849585	,0.702951724968362	,0.509641543268059	,0.545417706270431	,0.835389287134348	,0.387748866988229	,0.895207471165437	,0.751967877499744	,0.324117138201425	,0.436741751356396	,0.318615046943824	,0.963093984854917	,0.720603456590606	,0.182294918309103	,0.830692021097379	,0.440798583645745	,0.501795334043817	,0.674179274437101	,0.931065464360204	,0.417259501953264	,0.880449328515888	,0.711864366527584	,0.304408229097914	,0.189106448641562	,0.312082318734416	,0.16753096932896	,0.69300151182944	,0.27640931740236	,0.611397581459674	,0.759151592738531	,0.0608191564962357	,0.187563232233544	,0.37524414918164	,0.728415295820877	,0.475876861473488	,0.0624107849143496	,0.938062055473245	,0.00896633882493076	,0.69725663061126	,0.792190683443188	,0.348816629661627	,0.56109472297183	,0.319008987545506	,0.584053677313055	,0.190154600511377	,0.92837079471367	,0.127946752648776	,0.401071767975144	,0.813204358244876	,0.525649021624424	,0.583106441694827	,0.269965564957804	,0.311250245809206	,0.182881315323935	,0.686266649368343	,0.0835759337449334	,0.66071845109608	,0.695007571808532	,0.992259385991962	,0.903500366911059	,0.13066667417561	,0.114792869479765	,0.323757346404603	,0.389721022168976	,0.0412195939762609	,0.777715959017033	,0.0721231992692329	,0.174610117997327	,0.672253181073933	,0.559214309583984	,0.714901178011159	,0.344098833549814	,0.26909547171979	,0.687593194510598	,0.378820139625492	,0.830086685637984	,0.266925517593941	,0.217174201373558	,0.0468024853834894	,0.609371840306265	,0.712520027399305	,0.324100500123622	,0.157105577717119	,0.473444691613989	,0.18493195631771	,0.151389831747576	,0.408902181502852	,0.418964518429229	,0.536661240056465	,0.665461629007692	,0.413598732284083
,0.353893498589235	,0.888030789274737	,0.133475340499298	,0.320047771707199	,0.0428990829004436	,0.0048863077558979	,0.124174453375942	,0.0000378894619820125	,0.636808187531684	,0.835207845007632	,0.338251043268596	,0.985284215298148	,0.671806515972971	,0.052113957727381	,0.879287524092611	,0.185417424508099	,0.310653707622855	,0.156864017321199	,0.413539117394732	,0.35194605325905	,0.157317124846073	,0.0289172879554877	,0.0128586678825592	,0.115631102172486	,0.411934212973311	,0.378317442433125	,0.381254973533216	,0.752340172767798	,0.581283708373682	,0.635286636480729	,0.262499331618892	,0.826266518713099	,0.0613800110581238	,0.613845853886495	,0.907266270326109	,0.424205370910561	,0.61966889380462	,0.77509817424002	,0.0750144520192474	,0.767895087491672	,0.0127354725323317	,0.0450868508988464	,0.774703056912265	,0.434277524442541	,0.902353305789807	,0.8520104092788	,0.738948748791101	,0.511620932031246	,0.813004649157172	,0.169138384596043	,0.708829905702188	,0.304225136667595	,0.111871972266525	,0.232237883485964	,0.22210774860443	,0.964930794651122	,0.591865701410857	,0.486843612271754	,0.380591451367639	,0.600523135904466	,0.992345146365624	,0.344874967050215	,0.313571212959276	,0.191376206554182	,0.45990355613637	,0.599067983962161	,0.535606452047642	,0.937639564712364	,0.908164120702149	,0.514376641025011	,0.12820570735643	,0.753323539510986	,0.108728561135348	,0.400927001797094	,0.380119203766863	,0.66345770967354	,0.73372648318006	,0.741002807273065	,0.0341818384054032	,0.494158079612142	,0.314844041278047	,0.583801760144439	,0.956182747593235	,0.563438799494616	,0.715903106013268	,0.183502764992184	,0.130971223642571	,0.233355760683006	,0.0102697992745181	,0.604516406825053	,0.1072495086618	,0.542492078869833	,0.664369565278464	,0.0592836351409944	,0.380055814692777	,0.598077541495709	,0.889239918389004	,0.455308363984948	,0.367673495024291	,0.488430873252652
,0.0576867573231863	,0.541330330791571	,0.13886961393937	,0.98160147898905	,0.776057368971434	,0.196200302893389	,0.538490729191569	,0.413685522700514	,0.81258002753024	,0.0325227007421305	,0.609031372987214	,0.990285796108789	,0.733375200411945	,0.836993323563129	,0.346789125514584	,0.484832523616418	,0.580224421145499	,0.831846192400831	,0.838955680764725	,0.328126612737834	,0.823980284772804	,0.636646176519173	,0.112288757745311	,0.237151425442263	,0.804007408117879	,0.952508237190781	,0.805942465460832	,0.475017000210945	,0.610722545353101	,0.413819749566642	,0.0685309665596723	,0.799954968411454	,0.84315409131495	,0.890812730365811	,0.889559258189778	,0.822452395606065	,0.957412951140391	,0.239469816554091	,0.769206824604984	,0.0591011359631555	,0.312792132754248	,0.0973752006410506	,0.584997174136805	,0.047505717281022	,0.428590342136375	,0.317880286051836	,0.613967673207618	,0.954683600438146	,0.367272563915361	,0.749981725472017	,0.942860008190787	,0.648157662548198	,0.585834447567274	,0.119560263175313	,0.449343187478065	,0.110951943840343	,0.769320124652851	,0.963335040474001	,0.772025246532646	,0.428318474175557	,0.748595468582863	,0.644040472174082	,0.388215829799052	,0.743451432671142	,0.188228903891625	,0.56318770654648	,0.495783926684309	,0.640455783177379	,0.140347862215875	,0.826520262205284	,0.326046884211733	,0.869982946603551	,0.803383565881934	,0.467591777661625	,0.815007158934608	,0.825320213951785	,0.156835887654142	,0.94076380317135	,0.417239900872689	,0.551013967278886	,0.891748056230949	,0.609581073564282	,0.229103394890718	,0.540757928295414	,0.518500861021923	,0.44397119546494	,0.823882179252748	,0.987786700943386	,0.731082755481397	,0.30787137584196	,0.394213775822061	,0.550930241379389	,0.484566863386224	,0.115272932273929	,0.39217272791647	,0.247038092113583	,0.969214152996062	,0.582269404820292	,0.201886814647301	,0.111693777195967
,0.237313332612307	,0.525181215035348	,0.720681099091042	,0.487232423148692	,0.915335860063944	,0.0498000947059133	,0.99019172228416	,0.152276429884264	,0.309957064832541	,0.448388640511962	,0.0678810845445288	,0.877387939895218	,0.25910581893246	,0.791498797848587	,0.720295441206682	,0.00548036070795747	,0.108422418641123	,0.255590101357359	,0.702833513125234	,0.522855095808792	,0.62559525837451	,0.379507500389362	,0.38255904399909	,0.669852492711438	,0.210845001140072	,0.671934161182462	,0.197446993644092	,0.491622176250267	,0.693916238236202	,0.650216035847653	,0.180914491499269	,0.629858628208683	,0.0339643033379523	,0.83804620096369	,0.0424995967384892	,0.290722383787261	,0.171104312488392	,0.750179992406713	,0.275132379622726	,0.149904319154985	,0.441892037839578	,0.879479969795551	,0.419852353827959	,0.458510786508448	,0.190788847483131	,0.588159648975432	,0.199220330081517	,0.296087680056732	,0.345638713494706	,0.149857705528782	,0.658456822232556	,0.683811262568371	,0.815889986611852	,0.663004985387905	,0.124789414519812	,0.335689834475373	,0.939048027591337	,0.580199727593083	,0.41682165694275	,0.521588236802066	,0.333495932320829	,0.0661345161805556	,0.522813446597575	,0.925596965442224	,0.50819818745749	,0.286936598032218	,0.543403127483746	,0.976363619312813	,0.743349790453608	,0.4799281537905	,0.152480756934956	,0.744081805806645	,0.782910192284226	,0.371601720979252	,0.51012449828448	,0.66244266725259	,0.673908514284486	,0.380399579359405	,0.375730293512219	,0.899043059860842	,0.216707081169219	,0.195913211068098	,0.713338421524194	,0.0788505571330202	,0.24131373466985	,0.759938596170367	,0.287985835358494	,0.177934870206721	,0.55136356435314	,0.767426083221764	,0.130180708193304	,0.947162604866159	,0.961899985541543	,0.653056996712953	,0.928943754606388	,0.757683669569755	,0.389434458869246	,0.224950215418334	,0.738270535943224	,0.112897597771556
,0.469925746540504	,0.0420221062572776	,0.265539866064461	,0.928528945394107	,0.785985238750458	,0.053907678953329	,0.0263601685996913	,0.0353536550120235	,0.188879787078537	,0.502581428970481	,0.88607670687422	,0.291212435016042	,0.407395314614938	,0.0930527332672164	,0.937288022105251	,0.999787522945454	,0.428898144247429	,0.491110366532165	,0.0919303060937348	,0.0726545174013146	,0.104473963894171	,0.893911169326823	,0.965022875911101	,0.139475437877455	,0.163684406393992	,0.0438182638230819	,0.453560074536856	,0.98417274094381	,0.991257042619985	,0.0571153140892812	,0.937083898548542	,0.569082905337719	,0.576390011038813	,0.386915529326962	,0.889301398251812	,0.488600418199133	,0.907228672833754	,0.792304316904538	,0.258654214562222	,0.201384147257257	,0.663362952723803	,0.141146428948802	,0.248031342517599	,0.662773693289037	,0.237463108840148	,0.0424702763755202	,0.797935043367527	,0.89427387802595	,0.0610679821395632	,0.36957581963836	,0.460800661920011	,0.676724889630789	,0.71522002467663	,0.702954740125199	,0.56031728422284	,0.252595933271849	,0.379850499974494	,0.147353071322363	,0.56306971496114	,0.51269935188475	,0.938007126999091	,0.0857834737216046	,0.762842839007658	,0.0995952017137758	,0.896555203430613	,0.403304058314908	,0.331308098664185	,0.295214248958609	,0.665882247344536	,0.482931119614714	,0.623327364504024	,0.263015219132889	,0.496787966460357	,0.515352299211245	,0.526092843397564	,0.0424189828533768	,0.935844816703277	,0.743834331978035	,0.623617554839522	,0.140244187852481	,0.0840652366560256	,0.884432477822729	,0.656654766600884	,0.396662261056091	,0.702621569718524	,0.960722259227523	,0.859010836975188	,0.395137041991175	,0.068264745673288	,0.325580530951536	,0.0319837024584337	,0.550087218894664	,0.315887962615065	,0.128987671401812	,0.89579325024774	,0.597156913763451	,0.41624962231901	,0.907402315599566	,0.710718281898051	,0.0421638605381194
,0.648004064172508	,0.00430654734573632	,0.380141239790312	,0.0338171557680784	,0.364936994092975	,0.496059720635442	,0.27572471987257	,0.105366898283999	,0.901459459169516	,0.829130262056892	,0.192314390182642	,0.227955799655968	,0.253124817858043	,0.26881374012158	,0.952530223388472	,0.175464490044613	,0.0316841798050721	,0.516009983846922	,0.579798515224735	,0.673645382129422	,0.957937449197256	,0.0547086582773871	,0.48841966804509	,0.869360833833628	,0.347534241782284	,0.00800163485482411	,0.483477005028854	,0.798023519943479	,0.381299690055335	,0.50389076001192	,0.892003520341592	,0.903166381131469	,0.517367676607039	,0.398540734499013	,0.274124724918103	,0.214251698560199	,0.928297701258351	,0.899465049104516	,0.309080299599599	,0.712595370464304	,0.590391393560167	,0.70815156572878	,0.903365203600081	,0.858976906565473	,0.824868645903128	,0.567331693865048	,0.143778789855437	,0.490121100326125	,0.465333181184406	,0.854776166311827	,0.223027202870244	,0.418198640187363	,0.664545629017309	,0.0183868939142613	,0.0285260169899678	,0.436767550388709	,0.752219383023781	,0.551170480694236	,0.522269028016491	,0.77555387316996	,0.733946367508707	,0.43659871883532	,0.914667465218654	,0.816087929911952	,0.989838030184544	,0.207773311626061	,0.0460484991995844	,0.937126047414321	,0.277478892485369	,0.587746001588062	,0.247048690564487	,0.147342317340589	,0.382327543283965	,0.779019973603552	,0.988696354901742	,0.019636833583767	,0.0362620423716782	,0.456146140795269	,0.44818834608802	,0.70153270135705	,0.660111707942612	,0.497475391485484	,0.0689046965301524	,0.0812345822720018	,0.309624245534476	,0.854694697938252	,0.853788248195214	,0.619087416966952	,0.00221696356414676	,0.260506622614575	,0.334806283160488	,0.0892010783260693	,0.202523426247073	,0.811224934557092	,0.257475101043226	,0.384023233495663	,0.278485361616353	,0.503472686048352	,0.865434414644462	,0.356206929477028
,0.76986372041044	,0.0995489382648603	,0.119005417506679	,0.124052034748742	,0.942548022113064	,0.40460765427193	,0.240845348332471	,0.887769423838597	,0.74070645530741	,0.0533943516450908	,0.398868099040756	,0.776140577986902	,0.594694225860152	,0.0258540315673938	,0.528708553187879	,0.0046534286833617	,0.210175881260157	,0.426036339451576	,0.392757162634636	,0.0696324003253283	,0.311752267792706	,0.620364792002535	,0.471059186603436	,0.0917492439466292	,0.0295430109973732	,0.529385832850535	,0.387692718947163	,0.951527344971675	,0.320086938943754	,0.701182827679991	,0.779784817611698	,0.843429599815714	,0.521284102704974	,0.221914162496996	,0.711329087014929	,0.307965459911137	,0.975484726473449	,0.971797839259635	,0.00628443667957766	,0.622527273661703	,0.815888432234474	,0.636880564799942	,0.0516525926308951	,0.12512434745446	,0.964907667117616	,0.203161245772225	,0.531057693777167	,0.486659312847377	,0.28307102587217	,0.574731833569115	,0.517926796114969	,0.795662304291344	,0.696348224625154	,0.524611274956079	,0.141698186817438	,0.521425840687671	,0.604104437680964	,0.18328410395574	,0.455935184124827	,0.902639585967474	,0.663521355326996	,0.803418980819834	,0.0628106389487212	,0.658408811156828	,0.876889112813812	,0.875319061742778	,0.487470710877083	,0.920237711127958	,0.435210927592223	,0.590060042492142	,0.139134165430038	,0.427918382653929	,0.0242572645769721	,0.691845745170417	,0.851439079200588	,0.136604124278111	,0.905516742218992	,0.0198864746000089	,0.231978602349748	,0.864369692217731	,0.461417103401114	,0.0372568625198942	,0.176088371861767	,0.517265880721279	,0.687657282542278	,0.45594768806172	,0.11279325332157	,0.716208575626932	,0.31753056185205	,0.73615304740898	,0.52426780272474	,0.368960394695848	,0.117353653124233	,0.362848058977559	,0.387327235838085	,0.808852730695555	,0.387844800198378	,0.507556934146004	,0.509392191893138	,0.354569147971724
,0.243669960761289	,0.361030514985803	,0.83986536638805	,0.617212883949845	,0.496940545037827	,0.0797404507546408	,0.197755833248494	,0.682289407440596	,0.238070854096706	,0.256844803344852	,0.79060981692309	,0.779193026376512	,0.897194310043563	,0.144768902168036	,0.13093873817983	,0.687372588406956	,0.671093355711127	,0.0660294369170579	,0.756746264992629	,0.634475731120666	,0.633612945039576	,0.132767280159875	,0.419677647026106	,0.522213567757147	,0.843433294372369	,0.583378516409257	,0.842725290377962	,0.683955382408553	,0.238112140557781	,0.950746354624045	,0.193982166328459	,0.258269482412501	,0.735190906904261	,0.353572339915471	,0.490316959326303	,0.757135397175856	,0.174620334605975	,0.84396372262573	,0.498286170651338	,0.695670137040163	,0.127993234027174	,0.18228429471249	,0.652141232812843	,0.537699885451095	,0.121974776555772	,0.0300695728650641	,0.379311143131606	,0.0823826129000553	,0.60457501122941	,0.0922137326990318	,0.83620547262775	,0.105378454600171	,0.0956864650806815	,0.202418611013525	,0.0495953043222406	,0.548279743896928	,0.93765567566159	,0.178940844339757	,0.45877081829066	,0.561143011116024	,0.130587827009423	,0.789608547366042	,0.95085558106697	,0.0297509925578493	,0.0249319197726119	,0.0307756182880959	,0.245816568027165	,0.439058832563022	,0.261798886704165	,0.0538888369006518	,0.709681789255553	,0.621832018076364	,0.130727809449065	,0.142293410441975	,0.525349298271048	,0.545656041496273	,0.841089427862824	,0.190014090477495	,0.566818655266808	,0.521139069237345	,0.784336672064074	,0.346447380886621	,0.741130561447298	,0.18134624472882	,0.886335157270699	,0.634988248643926	,0.24749495845637	,0.647766776218902	,0.0162079110817089	,0.406361550281924	,0.718575588296436	,0.0999124981928209	,0.229357126741371	,0.805229142217538	,0.486193250159823	,0.449955436144935	,0.40101528791758	,0.863944030769143	,0.307325136990903	,0.213577406114702
,0.595464569793765	,0.973024523804441	,0.623171581245573	,0.644765994346126	,0.582066975339347	,0.799654528405356	,0.79365890882614	,0.0252806409379843	,0.891732244701931	,0.343836705360486	,0.863506993680963	,0.962042795942185	,0.0532714003013779	,0.332424865259055	,0.0647104089449674	,0.587843138066979	,0.87962149171141	,0.798411193675553	,0.896932105020123	,0.737889073201404	,0.701653295988987	,0.68694568690236	,0.496159767963067	,0.957220155260162	,0.999149457551143	,0.704933062058377	,0.809974015136237	,0.233272394739684	,0.609138389867329	,0.788918500202204	,0.353232898448237	,0.785324219514301	,0.94415737685941	,0.453032876110185	,0.123548783885105	,0.48441075695884	,0.491592207221124	,0.190226765438089	,0.141246717954635	,0.933588663550834	,0.82466829885946	,0.200098930951254	,0.0627324977250455	,0.345089264840395	,0.915274172516202	,0.0130174798020243	,0.784783032622553	,0.84842928724756	,0.551030769735123	,0.174146938218804	,0.887590643431801	,0.735944158274654	,0.0134681221160424	,0.35872840432391	,0.148291471948983	,0.334769046555631	,0.4633654604961	,0.783294557958513	,0.83163560872508	,0.299675842420978	,0.65188356938394	,0.207150635871641	,0.580737094665289	,0.448350039519533	,0.419114204784443	,0.0524398121295682	,0.355922461653092	,0.988813003519929	,0.980150159439142	,0.383729693658524	,0.344961318813712	,0.764885302057902	,0.427271687158976	,0.155246080902985	,0.220881736474522	,0.359344927295737	,0.510193059458487	,0.814750318794861	,0.508607985222995	,0.174407642881576	,0.269253910644564	,0.350476203183865	,0.453546911223581	,0.762936934718367	,0.68106181159665	,0.605867504890015	,0.815154686484092	,0.304815738138191	,0.0381108885808433	,0.529704378233154	,0.7414849646117	,0.137800228846166	,0.0084462175185076	,0.955577833557305	,0.396648597622592	,0.472980242908457	,0.378942562443643	,0.887646990310236	,0.682966144142191	,0.611984597804018
,0.625135292124532	,0.648854737006526	,0.301564868679999	,0.400747904740622	,0.370034975637698	,0.177835542791446	,0.881967695840619	,0.231063993289631	,0.492535218825813	,0.039422805439412	,0.579091020198116	,0.782776469729271	,0.124126739857777	,0.198116789664196	,0.748883886145839	,0.491474453123042	,0.211133638960837	,0.52307001479113	,0.237738594523509	,0.672558156620971	,0.684938328659599	,0.758489781878185	,0.937764026661294	,0.999996096361427	,0.934391546498235	,0.318721995837391	,0.760584039036457	,0.135944085724626	,0.812248773785424	,0.465141011618609	,0.624982273962806	,0.0770784928822324	,0.458229871680136	,0.469453328042037	,0.102084402508142	,0.732552954336886	,0.0175035400397626	,0.181997448290697	,0.831113421745185	,0.523279271332211	,0.754713280477893	,0.466104991951075	,0.826599721716065	,0.661522881901601	,0.215076120204793	,0.784352281961754	,0.608802931201087	,0.15086469666607	,0.582956866632661	,0.756057495137703	,0.0583207793805379	,0.197339048701031	,0.677391518222816	,0.91924677086959	,0.780478005195259	,0.493833316720013	,0.85655411326166	,0.104981588714282	,0.425561520934832	,0.41248235172242	,0.590885398718941	,0.0108962692371087	,0.133597068085148	,0.365923307075129	,0.0730220117014935	,0.28095066700175	,0.937860298407199	,0.618035329793596	,0.319787840973487	,0.674243241396846	,0.00615815678898159	,0.500141152413628	,0.87234861584024	,0.563186426909262	,0.474277063959407	,0.174613965756546	,0.736922470264566	,0.455957736566643	,0.281678475570715	,0.170138917011274	,0.52477820847406	,0.947349823521147	,0.10848391992435	,0.289242168557477	,0.293126945520345	,0.584573360432206	,0.924468784092212	,0.546854237814832	,0.979174953875679	,0.993449788537552	,0.910595950628908	,0.38614222006227	,0.892292586570742	,0.761502494458809	,0.572424369199399	,0.736373134300287	,0.223268184914844	,0.468383863786414	,0.127598658263496	,0.550649434584495
,0.765047061613317	,0.145964535021207	,0.225940101419548	,0.375284558336849	,0.407571967415312	,0.0620563491536567	,0.981060225507738	,0.679210108555486	,0.484294492045555	,0.537527809635516	,0.229896544120226	,0.871217028643571	,0.544600412503164	,0.0991329406849728	,0.127334092337328	,0.104089913472575	,0.439175733569626	,0.226554104698149	,0.694837661783601	,0.136581596982005	,0.526900476555759	,0.616309472646708	,0.313306773227317	,0.746937631511566	,0.78077281489073	,0.448699868493108	,0.298689763666452	,0.078857942055379	,0.365432124755081	,0.817720758643803	,0.432790526390444	,0.910377044188966	,0.706981683944809	,0.2411620604066	,0.210749253728776	,0.0627074195364059	,0.923600148374029	,0.947693722298226	,0.888390666287574	,0.181928295261193	,0.668858454874185	,0.504051070429408	,0.58634070706849	,0.628263700114686	,0.228007827525962	,0.127557228844407	,0.854345187942658	,0.979573752255912	,0.696054165110017	,0.582353004059919	,0.606939235053463	,0.827723543545102	,0.549596362537516	,0.0660651680389723	,0.357279231006875	,0.792035532552765	,0.741195614329165	,0.274690030270577	,0.715338757594739	,0.698498894785763	,0.670924664321786	,0.230833256259017	,0.614537945303385	,0.53924671399372	,0.119522092453913	,0.807807872913688	,0.826920060360301	,0.0454544755841859	,0.953371143412483	,0.308807333609465	,0.124855974281605	,0.454359750940632	,0.424334059201336	,0.782532996862444	,0.032078267090059	,0.139434982621779	,0.483752924242873	,0.435397749969455	,0.729983736635178	,0.83666162744009	,0.771972385594608	,0.53988468858408	,0.841961032637377	,0.839075536392199	,0.342540143682873	,0.0721948780455603	,0.379315311731452	,0.152444270510433	,0.130854468853611	,0.271058022636482	,0.672186451345769	,0.437687768339034	,0.218322474145481	,0.345822963093325	,0.246540709513491	,0.609704793249119	,0.308460137950471	,0.289538533561648	,0.274133570619921	,0.362921409012248
,0.620121268844288	,0.3781654659557	,0.826986317442258	,0.159037252030818	,0.939094881964426	,0.367681176107228	,0.617526834186877	,0.773502178850352	,0.251119937864654	,0.572795691235361	,0.977182592720344	,0.507835850821732	,0.197144760842037	,0.411995472112668	,0.407899797618343	,0.571898571481881	,0.899290895973933	,0.382088633897756	,0.763669919578205	,0.000338350888499222	,0.686663383006427	,0.751478189021106	,0.0939228777279718	,0.561805974022395	,0.273005394392184	,0.401663549431443	,0.759275294262578	,0.139870671154871	,0.806370099916295	,0.662269293173342	,0.760010364353662	,0.494193691990428	,0.91338128313114	,0.199225585069147	,0.38440825714935	,0.74957790912575	,0.15591867647875	,0.525195578357762	,0.962085458898025	,0.770307699111434	,0.561498965863836	,0.113119273499176	,0.195629700643769	,0.948378719831062	,0.401144200657096	,0.0305804438100105	,0.965519114847071	,0.479763234723249	,0.380685993647522	,0.189495233907129	,0.846396277121453	,0.382229580256264	,0.132555367021149	,0.858053524446699	,0.305585375663631	,0.973408778651342	,0.0813427931076581	,0.128323760409059	,0.737441195052788	,0.174165252211581	,0.195393920035751	,0.985614040859795	,0.215184730577834	,0.609766821660924	,0.350971655152259	,0.780608144020945	,0.681076560020948	,0.853744272074543	,0.879980756845316	,0.836580299230563	,0.405089168066666	,0.333647696456708	,0.616834347889216	,0.134884974050748	,0.0117588709163288	,0.631343490738116	,0.990048835515067	,0.750778501737294	,0.33427869870061	,0.2220890611513	,0.650850769901113	,0.84888972800639	,0.289658603393314	,0.292147231424296	,0.118518548141475	,0.941238613771851	,0.397381663507494	,0.793618570451447	,0.347313577470981	,0.299296554783032	,0.277196238412148	,0.837178992963014	,0.467334729371283	,0.494796543146855	,0.0455006691839083	,0.729746973947504	,0.857391135700695	,0.172817721577742	,0.547446557109918	,0.934285346388018
,0.533816743425008	,0.858006744113754	,0.519348319861734	,0.687211916170647	,0.970675080069655	,0.136070730693671	,0.940770768532888	,0.534306732255177	,0.093249012759537	,0.236157449537962	,0.0982543845187195	,0.361440606117919	,0.732267023870846	,0.211870197305395	,0.902406111779812	,0.739520683297664	,0.12412418384297	,0.155157848799209	,0.737964768306336	,0.973860924585658	,0.6805595111477	,0.163703859394278	,0.370764839635587	,0.444659755306626	,0.396507438456876	,0.100518144713956	,0.408458207458471	,0.957092754522847	,0.857925265495631	,0.149937185062998	,0.994269353800579	,0.685029326325762	,0.287887557078101	,0.526171811635686	,0.36963816097455	,0.508571499264134	,0.561188132297801	,0.888939529139986	,0.406666255745416	,0.839760313201584	,0.851583979023427	,0.571935446733579	,0.519053251258588	,0.727993903089312	,0.393529222064432	,0.0456352369140998	,0.991426815274836	,0.910484324167708	,0.5100362866698	,0.179870059331819	,0.0760871898737211	,0.797400207630079	,0.905289638743405	,0.202958360408879	,0.121163392030244	,0.3931298523178	,0.333427905260319	,0.922803710178846	,0.561956975870746	,0.810893459623164	,0.686375886521477	,0.91952476646729	,0.452750015749014	,0.369514693678131	,0.43345664834299	,0.10588870062767	,0.671391449249998	,0.0760875447076222	,0.803363901005762	,0.137084203836082	,0.974213873024198	,0.612563917698601	,0.361764760390746	,0.180327887265164	,0.770801265617274	,0.856871229529786	,0.434754707121642	,0.922362593432126	,0.148107813740199	,0.248025531530392	,0.565108431300665	,0.777404870268612	,0.843654604555878	,0.302938770643873	,0.491918211566246	,0.669381793900105	,0.299810079065994	,0.90799886216782	,0.736876454547456	,0.682571579088723	,0.98052974416899	,0.76341024821783	,0.636041797062402	,0.954483227783108	,0.999609350692299	,0.434357085467482	,0.239535451978229	,0.872341398090283	,0.441877703388165	,0.638560844882653
,0.292119942741524	,0.659877656800615	,0.563777847943724	,0.414290390170315	,0.978587592476321	,0.121666749530317	,0.853059356032433	,0.368596837096194	,0.00704107573583772	,0.339359892224595	,0.621708618766493	,0.0567556084397974	,0.891511047674115	,0.62617825885591	,0.177996591282076	,0.588709677843707	,0.443555519191341	,0.837611048872401	,0.728898398451925	,0.595382781510885	,0.598408853448187	,0.457599903669953	,0.881580980905137	,0.73154607263	,0.0948426924156224	,0.0211314293654316	,0.155933344809307	,0.771726210029668	,0.402411968634656	,0.33795684265809	,0.0406545545163818	,0.281097756829624	,0.409999035489745	,0.85378947614403	,0.639725552704057	,0.867364297093528	,0.791741250917195	,0.795204165296258	,0.996406134216304	,0.597897773421322	,0.867877892157006	,0.4237334828003	,0.688645424641969	,0.063651957578795	,0.798451026807749	,0.566407557840649	,0.61182462778493	,0.936519181326273	,0.0778805506778325	,0.938415242330365	,0.944977846436658	,0.242665060908843	,0.471678694929778	,0.503825684778311	,0.798284069075381	,0.76034894993545	,0.184801565103606	,0.959904696308032	,0.118230849093865	,0.105880720590186	,0.537270959251221	,0.913012135267729	,0.994957444721347	,0.249773431685648	,0.942066340680265	,0.3089878132143	,0.158176692742005	,0.475674914883298	,0.668294443594429	,0.0247134915668115	,0.359652763400065	,0.683994464894754	,0.894971486132113	,0.78576742242359	,0.393068673272183	,0.305191685587723	,0.356659672854775	,0.379121670210325	,0.897911224932369	,0.193957438317108	,0.842665795629223	,0.6840271403473	,0.444147817066008	,0.792361428398807	,0.218527098753735	,0.784948754024202	,0.633708884768984	,0.745226312310075	,0.0186309954238269	,0.131140088257911	,0.0714633507055525	,0.0845353082216043	,0.78492528050436	,0.239189436770598	,0.0568638034429698	,0.709944465993878	,0.0366399591027945	,0.807792640667312	,0.57091169551523	,0.312866524473236
,0.347676821680589	,0.404341985659833	,0.775752984814231	,0.0804157727772443	,0.54789306714567	,0.438779517281232	,0.567346945669198	,0.400115862209404	,0.747296153450057	,0.806451035107696	,0.0225470550463288	,0.948354163648726	,0.988428444130546	,0.516860502081393	,0.874458481964869	,0.0237063835485402	,0.433188300315844	,0.595763408390695	,0.995604822410087	,0.130250246324693	,0.115889979114705	,0.762878980842828	,0.707031025414835	,0.0704441471353379	,0.954780903623803	,0.00264720525715836	,0.491578757060496	,0.964169915748839	,0.803773990740894	,0.0294623822110996	,0.17425782195025	,0.751213517855487	,0.645594597163421	,0.508394525623133	,0.586792147991616	,0.215631295095957	,0.115176677757491	,0.774423070146899	,0.728539958935482	,0.571089828652837	,0.306750168235391	,0.550077532208561	,0.153083829280494	,0.879918717257641	,0.793880949166548	,0.75711264217138	,0.792176974374883	,0.118408318664137	,0.0886117881576586	,0.298323565767297	,0.924169850966041	,0.522685186249523	,0.769925295733812	,0.134445398177228	,0.623807164665222	,0.327016528382439	,0.166792523659203	,0.281945140232306	,0.651971884375425	,0.691460697768005	,0.37994738685896	,0.775730938546234	,0.709884146558998	,0.022851217083098	,0.0604055156281244	,0.235501161886147	,0.0680278204698245	,0.343578636340601	,0.526140976476549	,0.851391641353905	,0.339316235081906	,0.887963021587563	,0.994503822175089	,0.625739296723967	,0.800360039714891	,0.651187488181138	,0.508113860389271	,0.869651562473574	,0.233810493365773	,0.652961998550669	,0.332309641098748	,0.128137946654175	,0.614469416725668	,0.38748690829961	,0.492467791537041	,0.906172363043843	,0.0389056778694064	,0.887727951113008	,0.0436743563244466	,0.0349067449732249	,0.677662764991477	,0.478091211746489	,0.278995823245028	,0.0828012791847816	,0.641099258624529	,0.955239702460933	,0.713679260906614	,0.807338057461818	,0.930731760771355	,0.808703284155905
,0.876096808293879	,0.559056995231219	,0.0709188510994049	,0.9331304276982	,0.12309832364465	,0.913525495637919	,0.623005186497702	,0.848169466875572	,0.18422977774601	,0.349874577182287	,0.342018702692361	,0.308336150510393	,0.205681628177726	,0.891124783033098	,0.134228437270144	,0.977345199313641	,0.240764864366858	,0.535075413777994	,0.0124793667404351	,0.740716806492171	,0.227366713912863	,0.352360733483155	,0.126847651380509	,0.928476752214356	,0.908774466676998	,0.772461440308234	,0.759427260495456	,0.693967147122122	,0.505841681503617	,0.681141031291867	,0.937312922411278	,0.41828696635472	,0.1490435237759	,0.974504101543922	,0.490434648697467	,0.735140658326047	,0.509044485869372	,0.510674006543436	,0.898027975530377	,0.156184739040297	,0.996909050269476	,0.0504078790780194	,0.205223664271284	,0.194125407465792	,0.665723277565894	,0.811126049985702	,0.595522109696419	,0.940097667714626	,0.221501279725461	,0.772008345821876	,0.144268228273964	,0.716112600507267	,0.704476725638135	,0.140327800130624	,0.489336795401451	,0.283520312180519	,0.125886817987024	,0.779749907916295	,0.256702349175095	,0.396382585818126	,0.00211984524602063	,0.62823904986877	,0.813711144409008	,0.0432040821962078	,0.131009471663744	,0.876190252544447	,0.129574514520156	,0.758865540269234	,0.253135305015899	,0.445071402213104	,0.315056995635413	,0.162925644387922	,0.291305227806468	,0.966963743309939	,0.759633810147473	,0.165447148571465	,0.670226040608355	,0.489064504620183	,0.707129151423988	,0.71964798295854	,0.123649584187032	,0.178561431438924	,0.0819781939880821	,0.807506357695677	,0.759353791251478	,0.459169563585506	,0.262855181592915	,0.807037032119481	,0.871398832123447	,0.600171498768111	,0.0823797956492658	,0.557225477209885	,0.288595466543266	,0.424006192676726	,0.272080317731984	,0.853900121456897	,0.499341326066917	,0.429667206681179	,0.416742690567273	,0.19440036415793
,0.286920402332638	,0.271202004640923	,0.0920919999909084	,0.790243847197967	,0.628339856224293	,0.507963561689464	,0.343581314824327	,0.571158252456765	,0.45674904084613	,0.581129500913028	,0.0435218452678629	,0.471653416972446	,0.0789790558996513	,0.400992505439088	,0.481038914751745	,0.821040232582502	,0.223189014114062	,0.137760215037391	,0.335934133425324	,0.0449804794252759	,0.986917700612414	,0.125794192834661	,0.222998972154688	,0.943725003834686	,0.186139449563874	,0.445728820024863	,0.364278157876934	,0.422999437629711	,0.351548242546408	,0.471312477472849	,0.348808886180077	,0.430950028556841	,0.977129954834064	,0.62315089610552	,0.297110845473181	,0.541979867751701	,0.0556373028343717	,0.0961487372853554	,0.971827554969037	,0.505716364600564	,0.574939841672284	,0.0139189860848333	,0.936399127792753	,0.0601408127975375	,0.786640688211955	,0.0700467783352578	,0.276203480677774	,0.151899751346512	,0.97912088082131	,0.0846439637637902	,0.611098978021694	,0.740523610608896	,0.980323503716068	,0.297126955956745	,0.812748765020049	,0.868493691956854	,0.773480718849916	,0.890441710544024	,0.653829113419088	,0.905909234614069	,0.616506158661333	,0.619008621023506	,0.677893542068961	,0.356761553025228	,0.0914216950030167	,0.524427915701842	,0.0599792008567505	,0.0704287994049624	,0.696831599202394	,0.648687794640981	,0.495764530960361	,0.314471850783784	,0.328396123055553	,0.353640194681306	,0.630752008702025	,0.0490102549311753	,0.715354628262741	,0.965237211885507	,0.741820159713654	,0.771424307381466	,0.32833416030199	,0.312232195545096	,0.686510526429168	,0.182417695029833	,0.894200366406795	,0.825558199000339	,0.15665059869953	,0.826612342999602	,0.873648794309073	,0.415285952582623	,0.711005056142344	,0.861978584370566	,0.274067516100624	,0.252743103193465	,0.853335372569661	,0.00760677829739022	,0.847122844237426	,0.593643098414709	,0.35955505602041	,0.0418265350357753
,0.978574346275336	,0.899037849576696	,0.129137835525506	,0.419601677181014	,0.245388381297415	,0.242524465658946	,0.108694329908441	,0.825602771167458	,0.905775011473231	,0.360617830585976	,0.903878658499512	,0.488613401301491	,0.1254356741558	,0.197375536522537	,0.290642334283629	,0.825712304946832	,0.746709241413842	,0.942220442435807	,0.898976018605277	,0.0899446988897141	,0.700554239424204	,0.215102002590477	,0.219357538139148	,0.742143504667163	,0.205882941002903	,0.27458943579094	,0.0246473383273218	,0.247815267298285	,0.0311974822688836	,0.33608449312676	,0.572075981447509	,0.8810201882762	,0.306304358088553	,0.0573463943122636	,0.820849206215166	,0.0126088582969312	,0.917081396522504	,0.387031353724669	,0.835962050518003	,0.0141830560817304	,0.374623565643385	,0.298267768369181	,0.986382980824627	,0.138758719497714	,0.117798598072398	,0.841037802789844	,0.322351488900535	,0.761473951284529	,0.0926992390736468	,0.996111110782303	,0.639438918158151	,0.0498974840389087	,0.627014241938952	,0.228364267958498	,0.118251578471741	,0.454279374542776	,0.0734479404396601	,0.43953496936687	,0.264230148989814	,0.916114071810671	,0.129204921950216	,0.547123217278683	,0.499912802828435	,0.0344771375108869	,0.457250145476894	,0.00319503015056021	,0.698871740465458	,0.937342002958684	,0.907043726605849	,0.683913064507727	,0.52687518136896	,0.19117326810545	,0.0491170482938723	,0.510230675111632	,0.446956601202002	,0.999596402048877	,0.216729235470635	,0.568260554954531	,0.755147120801335	,0.757659308033837	,0.979990124693136	,0.694025717533206	,0.490234580584911	,0.372595890598649	,0.21913329149556	,0.973230165882609	,0.0793979890082953	,0.442001262419858	,0.715217490547904	,0.660363638615405	,0.73167420911215	,0.248432547901027	,0.405832572563473	,0.828047074297465	,0.987177717493464	,0.495897912651253	,0.556217929607359	,0.354742910878147	,0.164103129023734	,0.0812895018985912
,0.232658409621873	,0.289890514821694	,0.189882608218995	,0.35699633665243	,0.0374301173898532	,0.0879829712621788	,0.729798003439697	,0.71504381099485	,0.741331390450397	,0.556679299826119	,0.108992177578151	,0.831528555989046	,0.500440507894587	,0.903616184323847	,0.0772099309029104	,0.667308685214868	,0.457072406288736	,0.0159324947818799	,0.777439799056128	,0.430702736336134	,0.820889601400536	,0.691530738813584	,0.557127239907685	,0.637521128467061	,0.817606145896766	,0.506494086937278	,0.646119154824931	,0.324635142611635	,0.142841873757002	,0.743372233930683	,0.857135672987036	,0.879255893118333	,0.653795639823096	,0.343318506769519	,0.154143275299176	,0.686027953255003	,0.071810356840403	,0.916667416652975	,0.42927168655641	,0.769235953581164	,0.548671838617265	,0.527591640375364	,0.232699788749544	,0.985349513583514	,0.769274798114446	,0.201531909500031	,0.146802967016959	,0.317466654031289	,0.66205430387615	,0.146685246446489	,0.338937026140716	,0.514598347020614	,0.854418375461557	,0.209636382390576	,0.358678838405143	,0.315237075237202	,0.189523511654475	,0.321660376769332	,0.145952362169489	,0.0213509826089027	,0.84596470782811	,0.12884446705172	,0.488957738265841	,0.912707033992143	,0.867120305945687	,0.690982029163736	,0.334964154909814	,0.742551569241356	,0.0642242394686789	,0.416792750087005	,0.0357507122847022	,0.86222136899001	,0.354548615102912	,0.898574034636176	,0.333800130213518	,0.17878849859293	,0.898295851376977	,0.658374092848214	,0.293378499938817	,0.812448471697256	,0.821463815784763	,0.342351894519456	,0.908291188491644	,0.650004979060034	,0.633683061987945	,0.311222831397887	,0.72212730428303	,0.79360308488533	,0.0870476677487826	,0.0101518537896461	,0.622206642582178	,0.427041878656969	,0.292854587683852	,0.00705520250231736	,0.57678845644779	,0.0835875180007832	,0.85541503916281	,0.96056320935514	,0.185859631833555	,0.742832226558976
    };*/

    static public class SCE_Comparator implements Comparator {
        private int col = 0;
        private int order = 1;

        public SCE_Comparator(int col,boolean decreasing_order) {
            this.col = col;
            if (decreasing_order)
                order = -1;
            else
                order = 1;
        }

        public int compare(Object d1, Object d2) {

            double[] b1 = (double [])d1;
            double[] b2 = (double [])d2;

            if (b1[col] < b2[col])
                return -1*order;
            else if (b1[col] == b2[col])
                return 0*order;
            else
                return 1*order;
        }
    }

    int N; //parameter dimension
    int p; //number of complexes
    int s; //population size
    int m; //complex size; floor(s/q)
    int icall=0;

    public void init() {
        if(enable.getValue()){
	icall = 0;
//generalise this!!


//add more checks!!!
            //retreiving parameter names
            int i;
            StringTokenizer tok = new StringTokenizer(parameterIDs.getValue(), ";");
            String key;
            parameters = new Attribute.Double[tok.countTokens()];
            parameterNames = new String[tok.countTokens()];

            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                parameterNames[i] = key;
                parameters[i] = (Attribute.Double) getModel().getRuntime().getDataHandles().get(key);
                i++;
            }

            //retreiving boundaries
            tok = new StringTokenizer(boundaries.getValue(), ";");
            int n = tok.countTokens();
            lowBound = new double[n];
            upBound = new double[n];

            //check if number of parameter ids and boundaries match
            if (n != i) {
                getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": Different number of parameterIDs and boundaries!");
            }

            i = 0;
            while (tok.hasMoreTokens()) {
                key = tok.nextToken();
                key = key.substring(1, key.length()-1);

                StringTokenizer boundTok = new StringTokenizer(key, ">");
                lowBound[i] = Double.parseDouble(boundTok.nextToken());
                upBound[i] = Double.parseDouble(boundTok.nextToken());

                //check if upBound is higher than lowBound
                if (upBound[i] <= lowBound[i]) {
                    getModel().getRuntime().sendHalt("Component " + this.getInstanceName() + ": upBound must be higher than lowBound!");
                }

                i++;
            }

            //initialising output file
            writer = new GenericDataWriter(getModel().getWorkspaceDirectory().getPath()+"/"+sceFileName.getValue());
            writer.addComment("SCE output");
            for(int p = 0; p < this.parameterNames.length; p++){
                writer.addColumn(this.parameterNames[p]);
            }
            writer.addColumn(this.effMethodName.getValue());
            writer.addColumn("model runs");
            writer.writeHeader();
            writer.flush();

        }


    }
    public double Custom_rand() {
	/*randcounter++;
	return MatlabRand[randcounter-1];	*/
	return this.generator.nextDouble();
    }
    private double[] RandomSampler(){
        int paras = this.parameterNames.length;
        double[] sample = new double[paras];

        for(int i = 0; i < paras; i++){
            double d = Custom_rand();
            sample[i] = (lowBound[i] + d * (upBound[i]-lowBound[i]));
        }
        /*
	int order[] = {1,2,0,3};

        for(int i = 0; i < paras; i++){
            double d = Custom_rand();

            sample[order[i]] = (lowBound[order[i]] + d * (upBound[order[i]]-lowBound[order[i]]));
        }*/
        return sample;
    }

    private void singleRun() {
	icall++;
        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            try {
                comp.init();
            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        
        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            try {
                comp.initAll();
            } catch (Exception e) {
                
            }
        }

        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            try {
                comp.run();
            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }

        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            try {
                comp.cleanup();
            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void disabledRun() {
        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            //comp.updateInit();
            try {
                comp.init();
            } catch (Exception e) {

            }
        }

        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            //comp.updateRun();
            try {
                comp.run();
            } catch (Exception e) {

            }
        }

        runEnumerator.reset();
        while(runEnumerator.hasNext() && doRun) {
            Component comp = runEnumerator.next();
            try {
                comp.cleanup();
            } catch (IOException e) {
                System.out.println(comp.getInstanceName());
                e.printStackTrace();
            } catch (Exception e) {

            }
        }
    }

    private boolean IsSampleValid(double[] sample) {
        Attribute.Double conv_sample[] = new Attribute.Double[sample.length];
        for (int i = 0;i<sample.length;i++) {
            conv_sample[i] = getModel().getRuntime().getDataFactory().createDouble();
            conv_sample[i].setValue(sample[i]);
        }
        return IsSampleValid(conv_sample);
    }
    private boolean IsSampleValid(Attribute.Double [] sample) {
        int paras = this.parameterNames.length;
        boolean criticalPara = false;
        double criticalParaValue = 0;

        for(int i = 0; i < paras; i++){
            if (sample[i].getValue() < lowBound[i] || sample[i].getValue() > upBound[i] )
                return false;
        }
        return true;
    }

    public double funct(double x[]) {
        double value = 0;

        for (int j=0;j<parameters.length;j++) {
            parameters[j].setValue(x[j]);
        }

        //model run
        singleRun();
        this.currentCount++;

        //getting rid of pairs which contain missing data values
        double[] preArr = prediction.getValue();
        double[] obsArr = observation.getValue();
        Vector<Double> obsVector = new Vector<Double>();
        Vector<Double> preVector = new Vector<Double>();
        for(int i = 0; i < preArr.length; i++){
            //consider valid values only
            if(preArr[i] != JAMS.getMissingDataValue() && obsArr[i] != JAMS.getMissingDataValue()){
                obsVector.add(obsArr[i]);
                preVector.add(preArr[i]);
            }
        }
        int dataCount = obsVector.size();
        obsArr = new double[dataCount];
        preArr = new double[dataCount];

        //converting Vectors to arrays
        for(int i = 0; i < dataCount; i++){
            obsArr[i] = obsVector.get(i).doubleValue();
            preArr[i] = preVector.get(i).doubleValue();
        }

        //efficiency calculation
        if(this.effMethodName.getValue().equals("e2")){
            return (-1 * NashSutcliffe.efficiency(preArr, obsArr, 2));
        }
        else if(this.effMethodName.getValue().equals("e1")){
            return (-1 * NashSutcliffe.efficiency(preArr, obsArr, 1));
        }
        else if(this.effMethodName.getValue().equals("le2")){
            return (-1 * NashSutcliffe.logEfficiency(preArr, obsArr, 2));
        }
        else if(this.effMethodName.getValue().equals("pbias")){
            return (Math.abs(VolumeError.pbias(obsArr, preArr)));
        }
        else
            return -9999;

        /*if (MaximizeEff.getValue() == MINIMIZATION)
            return this.effValue.getValue();
        else if (MaximizeEff.getValue() == ABSMINIMIZATION)
            return Math.abs(this.effValue.getValue());
        else if (MaximizeEff.getValue() == ABSMAXIMIZATION)
            return -Math.abs(this.effValue.getValue());
        else if (MaximizeEff.getValue() == MAXIMIZATION)
            return -this.effValue.getValue();
        else
            return 0;*/
    }

    @SuppressWarnings("unchecked")
    public void sort(double x[][],double xf[]) {
	if (x.length == 0)
	    return;
	int n = x[0].length;
	double t[][] = new double[x.length][n+1];
	for (int i=0;i<x.length;i++) {
	    for (int j=0;j<n;j++) {
		t[i][j] = x[i][j];
	    }
	    t[i][n] = xf[i];
	}

	SCE_Comparator comparator = new SCE_Comparator(n,false);
        java.util.Arrays.sort(t,comparator);

	for (int i=0;i<x.length;i++) {
	    for (int j=0;j<n;j++) {
		x[i][j] = t[i][j];
	    }
	    xf[i] = t[i][n];
	}
    }

    public void sort(int x[]) {
	Arrays.sort(x);
    }


    public double NormalizedgeometricRange(double x[][],double bound[]) {
	if (x.length == 0)
	    return 0;
	int n = x[0].length;

	double min[] = new double[n];
	double max[] = new double[n];

	double mean = 0;

	for (int i=0;i<n;i++) {
	    min[i] = Double.POSITIVE_INFINITY;
	    max[i] = Double.NEGATIVE_INFINITY;

	    for (int j=0;j<x.length;j++) {
		if (x[j][i] < min[i])
		    min[i] = x[j][i];
		if (x[j][i] > max[i])
		    max[i] = x[j][i];
	    }

	    mean += Math.log(max[i] - min[i])/bound[i];
	}
	mean/=n;
	return Math.exp(mean);
    }

    public double[] std(double x[][]) {
	if (x.length == 0)
	    return null;
	if (x.length == 1)
	    return null;

	int n = x[0].length;

	double mean[] = new double[n];
	double var[] = new double[n];

	for (int i=0;i<n;i++) {
	    mean[i] = 0;
	    for (int j=0;j<x.length;j++) {
		mean[i] += x[j][i];
	    }
	    mean[i] /= n;
	}

	for (int i=0;i<n;i++) {
	    var[i] = 0;
	    for (int j=0;j<x.length;j++) {
		var[i] += (mean[i] - x[j][i])*(mean[i] - x[j][i]);
	    }
	    var[i] = Math.sqrt(var[i])/(n-1);
	}

	return var;
    }

    public int find(int lcs[],int startindex,int endindex,int value) {
	for (int i=startindex;i<endindex;i++) {
	    if (lcs[i] == value)
		return i;
	}
	return -1;
    }
    //s forms the simplex
    //sf function values of simplex
    //bl lower bound, bu upper bound
    public double[] cceua( double s[][],double sf[],double bl[],double bu[]) {
	int nps = s.length;
	int nopt = s[0].length;

	int n = nps;
	int m = nopt;

	double alpha = 1.0;
	double beta = 0.5;

	// Assign the best and worst points:
	double sb[] = new double[nopt];
	double sw[] = new double[nopt];
	double fb = sf[0];
	double fw = sf[n-1];

	for (int i=0;i<nopt;i++) {
	    sb[i] = s[0][i];
	    sw[i] = s[n-1][i];
	}

	// Compute the centroid of the simplex excluding the worst point:
	double ce[] = new double[nopt];
	for (int i=0;i<nopt;i++) {
	    ce[i] = 0;
	    for (int j=0;j<n-1;j++) {
		ce[i] += s[j][i];
	    }
	    ce[i] /= (n-1);
	}

	// Attempt a reflection point
	double snew[] = new double[nopt];
	for (int i=0;i<nopt;i++) {
	    snew[i] = ce[i] + alpha*(ce[i]-sw[i]);
	}

	// Check if is outside the bounds:
	int ibound=0;
	for (int i=0;i<nopt;i++) {
	    if ( (snew[i]-bl[i]) < 0 )
		ibound = 1;
	    if ( (bu[i]-snew[i]) < 0 )
		ibound = 2;
	}

	if (ibound >=1) {
	    snew = this.RandomSampler();
	}

	double fnew = funct(snew);

	// Reflection failed; now attempt a contraction point:
	if (fnew > fw) {
	    for (int i=0;i<nopt;i++) {
		snew[i] = sw[i] + beta*(ce[i]-sw[i]);
	    }
	    fnew = funct(snew);
	}
	// Both reflection and contraction have failed, attempt a random point;
	if (fnew > fw) {
	    snew = this.RandomSampler();
	    fnew = funct(snew);
	}

	double result[] = new double[nopt+1];
	for (int i=0;i<nopt;i++) {
	    result[i] = snew[i];
	}
	result[nopt] = fnew;
	return result;
    }

    public double[] sceua(double[] x0,double[] bl,double []bu,int maxn,int kstop,double pcento,double peps,int ngs,int iseed,int iniflg) {
    try {
	int nopt = x0.length;
	int npg = 2*nopt+1;
	int nps = nopt+1;
	int nspl = npg;
	int mings = ngs;
	int npt = npg*ngs;

	double bound[] = new double[nopt];
	for (int i=0;i<nopt;i++) {
	    bound[i] = bu[i] - bl[i];
	}

	// Create an initial population to fill array x(npt,nopt):
	//this.generator.setSeed(iseed);

	double x[][] = new double[npt][nopt];

	for (int i=0;i<npt;i++) {
	    x[i] = this.RandomSampler();
	}

	if (iniflg==1) {
	    x[0] = x0;
	}

	int nloop=0;

	double xf[] = new double[npt];
	for (int i=0;i<npt;i++) {
	    xf[i] = funct(x[i]);
	}
	double f0 = xf[0];

	// Sort the population in order of increasing function values;
	sort(x,xf);

	// Record the best and worst points;
	double bestx[] = new double[nopt];
	double worstx[] = new double[nopt];
	double bestf,worstf;
	for (int i=0;i<nopt;i++) {
	    bestx[i] = x[0][i];
	    worstx[i] = x[npt-1][i];
	}
	bestf = xf[0];
	worstf = xf[npt-1];

	// Compute the standard deviation for each parameter
	double xnstd[] = std(x);

	// Computes the normalized geometric range of the parameters
	double gnrng = NormalizedgeometricRange(x,bound); //exp(mean(log((max(x)-min(x))./bound)));

	System.out.println("The Inital Loop: 0");
	System.out.println("BestF: " + bestf);
	System.out.print("BestX");

        //writer.writeLine("The Inital Loop: 0");
	//writer.writeLine("BestF: " + bestf);
	//writer.writeLine("BestX");
	for (int i=0;i<nopt;i++) {
	    System.out.print("\t\t" + bestx[i]);
        }
        for (int i=0;i<nopt;i++) {
	    writer.addData(bestx[i]);
	}
        writer.addData(bestf);
        writer.addData(this.currentCount);
        writer.writeData();
        writer.flush();
	System.out.println("");
	System.out.println("WorstF: " + worstf);
	System.out.print("WorstX");

        //writer.writeLine("");
	//writer.writeLine("WorstF: " + worstf);
	//writer.writeLine("WorstX");
	for (int i=0;i<nopt;i++) {
	    System.out.print("\t\t" + worstx[i]);
        //    writer.write("\t\t" + worstx[i]);
	}
	System.out.println("");
        //writer.writeLine("");
	//writer.flush();
	//Check for convergency;
	if (icall >= maxn) {
	    System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
	    System.out.println("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
	    System.out.println("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + icall);
	    System.out.println("OF THE INITIAL LOOP!");

            writer.writeLine("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
	    writer.writeLine("ON THE MAXIMUM NUMBER OF TRIALS" + maxn);
	    writer.writeLine("HAS BEEN EXCEEDED.  SEARCH WAS STOPPED AT TRIAL NUMBER:" + icall);
	    writer.writeLine("OF THE INITIAL LOOP!");
            writer.flush();
	}

	if (gnrng < peps) {
	    writer.writeLine("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
            System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
            writer.flush();
	}

	// Begin evolution loops:
	nloop = 0;
	double criter[] =new double[kstop];
	double criter_change=100000;

	while (icall<maxn && gnrng>peps && criter_change>pcento) {
	    nloop++;

	    // Loop on complexes (sub-populations);
	    for (int igs=0;igs<ngs;igs++) {

		// Partition the population into complexes (sub-populations);
		int k1[] = new int[npg];
		int k2[] = new int[npg];

		for (int i=0;i<npg;i++) {
		    k1[i] = i;
		    k2[i] = k1[i]*ngs+igs;
		}
		double cx[][] = new double[npg][nopt];
		double cf[] = new double[npg];
		for (int i=0;i<npg;i++) {
		    for (int j=0;j<nopt;j++) {
			cx[k1[i]][j] = x[k2[i]][j];
		    }
		    cf[k1[i]] = xf[k2[i]];
		}

		//Evolve sub-population igs for nspl steps:
		for (int loop=0;loop<nspl;loop++) {
		    // Select simplex by sampling the complex according to a linear
		    // probability distribution
		    int lcs[] = new int[nps];
		    lcs[0] = 0;
		    for (int k3=1;k3<nps;k3++) {
			int lpos = 0;
			for (int iter=0;iter<1000;iter++) {
			    lpos = (int)Math.floor(npg+0.5-Math.sqrt((npg+0.5)*(npg+0.5) - npg*(npg+1)*Custom_rand()));
			    //wirklich nÃ¶tig??
			    int idx = find(lcs,0,k3,lpos);
			    if (idx == -1) {
				break;
			    }
			}
			lcs[k3] = lpos;
		    }
		    sort(lcs);

		    // Construct the simplex:
		    double s[][] = new double[nps][nopt];
		    double sf[]  = new double[nps];
		    for (int i=0;i<nps;i++) {
			for (int j=0;j<nopt;j++) {
			    s[i][j] = cx[lcs[i]][j];
			}
			sf[i] = cf[lcs[i]];
		    }

		    double snew[] = new double[nopt];
		    double fnew;

		    double xnew[] = cceua(s,sf,bl,bu);

		    //icall aktualisieren!!!

		    for (int i=0;i<nopt;i++) {
			snew[i] = xnew[i];
		    }
		    fnew = xnew[nopt];

		    // Replace the worst point in Simplex with the new point:
		    s[nps-1] = snew;
		    sf[nps-1] = fnew;

		    //Replace the simplex into the complex;
		    for (int i=0;i<nps;i++) {
			for (int j=0;j<nopt;j++) {
			    cx[lcs[i]][j] = s[i][j];
			}
			cf[lcs[i]] = sf[i];
		    }

		    // Sort the complex;
		    sort(cx,cf);
		    // End of Inner Loop for Competitive Evolution of Simplexes
		}
		// Replace the complex back into the population;
		for (int i=0;i<npg;i++) {
		    for (int j=0;j<nopt;j++) {
			x[k2[i]][j] = cx[k1[i]][j];
		    }
		    xf[k2[i]] = cf[k1[i]];
		}
	    // End of Loop on Complex Evolution;
	    }
	    // Shuffled the complexes;
	    sort(x,xf);

	    // Record the best and worst points;
	    for (int i=0;i<nopt;i++) {
	        bestx[i] = x[0][i];
	        worstx[i] = x[nopt-1][i];
	    }
	    bestf = xf[0];
	    worstf = xf[npt-1];

	    //Compute the standard deviation for each parameter
	    xnstd = std(x);

	    gnrng = NormalizedgeometricRange(x,bound);

	    System.out.println("Evolution Loop:" + nloop + " - Trial - " + icall);
	    System.out.println("BESTF:" + bestf);
	    System.out.print("BESTX:");

            //writer.writeLine("Evolution Loop:" + nloop + " - Trial - " + icall);
	    //writer.writeLine("BESTF:" + bestf);
	    //writer.writeLine("BESTX:");
	    for (int i = 0;i<nopt;i++) {
	        System.out.print("\t" + bestx[i]);
              //  writer.write("\t" + bestx[i]);
	    }
            for (int i=0;i<nopt;i++) {
                //System.out.print("\t\t" + bestx[i]);
                writer.addData(bestx[i]);
            }
            writer.addData(bestf);
            writer.addData(this.currentCount);
            writer.writeData();
            writer.flush();

	    System.out.println("\nWORSTF:" + worstf);
	    System.out.print("WORSTX:");

            //writer.writeLine("\nWORSTF:" + worstf);
	    //writer.writeLine("WORSTX:");
	    for (int i = 0;i<nopt;i++) {
	        System.out.print("\t" + worstx[i]);
                //writer.write("\t" + worstx[i]);
	    }
	    System.out.println("");
            //writer.flush();


	    // Check for convergency;
	    if (icall >= maxn) {
		System.out.println("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
		System.out.println("ON THE MAXIMUM NUMBER OF TRIALS " +  maxn + " HAS BEEN EXCEEDED!");

                writer.writeLine("*** OPTIMIZATION SEARCH TERMINATED BECAUSE THE LIMIT");
		writer.writeLine("ON THE MAXIMUM NUMBER OF TRIALS " +  maxn + " HAS BEEN EXCEEDED!");
                writer.flush();
	    }
	    if (gnrng < peps) {
		System.out.println("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                writer.writeLine("THE POPULATION HAS CONVERGED TO A PRESPECIFIED SMALL PARAMETER SPACE");
                writer.flush();
	    }

	    for (int i=0;i<kstop-1;i++) {
		criter[i] = criter[i+1];
	    }
	    criter[kstop-1] = bestf;
	    if (nloop >= kstop) {
		criter_change=Math.abs(criter[0]-criter[kstop-1])*100.0;
		double criter_mean = 0;
		for (int i=0;i<kstop;i++) {
		    criter_mean += Math.abs(criter[i]);
		}
		criter_mean /= kstop;
		criter_change /= criter_mean;

		if (criter_change < pcento) {
		    System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
		    System.out.println("LESS THAN THE THRESHOLD " + pcento + "%");
		    System.out.println("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");

                    writer.writeLine("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY");
		    writer.writeLine("LESS THAN THE THRESHOLD " + pcento + "%");
		    writer.writeLine("CONVERGENCY HAS ACHIEVED BASED ON OBJECTIVE FUNCTION CRITERIA!!!");
                    writer.flush();
		}
	    }
	}
	System.out.println("SEARCH WAS STOPPED AT TRIAL NUMBER: " + icall);
	System.out.println("NORMALIZED GEOMETRIC RANGE = " + gnrng);
	System.out.println("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");

        writer.writeLine("SEARCH WAS STOPPED AT TRIAL NUMBER: " + icall);
	writer.writeLine("NORMALIZED GEOMETRIC RANGE = " + gnrng);
	writer.writeLine("THE BEST POINT HAS IMPROVED IN LAST " + kstop + " LOOPS BY " + criter_change + "%");
        writer.flush();
        double[] retVal = new double[nopt+1];
        for(int i = 0; i < nopt; i++)
            retVal[i] = bestx[i];
        retVal[nopt] = bestf;
	return retVal;
        } catch (jams.runtime.RuntimeException ex) {
                ex.printStackTrace();
            }
    return null;
    }

    public void run() {
        if (runEnumerator == null) {

            runEnumerator = getChildrenEnumerator();
        }
        if(!enable.getValue()){
            disabledRun();
	    return;
	}

	int maxn= this.maxn.getValue();//10000;
	int kstop=this.kstop.getValue();//10;
	double  pcento=this.pcento.getValue();//0.01;
	double peps=this.peps.getValue();//0.00001;
	int iseed=10;
	int iniflg=0;

        System.out.println("Pcento: " + pcento);

	double bestpoint[],bestx[],bestf;

        double x0[] = RandomSampler();

	//double x0[] = {-1.295,2.659,1.1,0.1649};

	bestpoint = sceua(x0,this.lowBound,this.upBound,maxn,kstop,pcento,peps,NumberOfComplexes.getValue(),iseed,iniflg);

	bestx = new double[this.parameters.length];
	for (int i=0;i<this.parameters.length;i++) {
	    bestx[i] = bestpoint[i];
	}

	bestf = bestpoint[this.parameters.length];
    }

    public void cleanup() {

        if (enable.getValue()) {
            writer.close();
        }
    }
}