/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import com.vividsolutions.jts.geom.Geometry;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.DefaultDataFactory;
import jams.data.JAMSBoolean;
import jams.data.JAMSBooleanArray;
import jams.data.JAMSCalendar;
import jams.data.JAMSData;
import jams.data.JAMSDirName;
import jams.data.JAMSDocument;
import jams.data.JAMSDoubleArrayChecked;
import jams.data.JAMSDoubleChecked;
import jams.data.JAMSEntityChecked;
import jams.data.JAMSEntityCollectionChecked;
import jams.data.JAMSFileName;
import jams.data.JAMSFloatArrayChecked;
import jams.data.JAMSFloatChecked;
import jams.data.JAMSGeometry;
import jams.data.JAMSInteger;
import jams.data.JAMSIntegerArray;
import jams.data.JAMSLong;
import jams.data.JAMSLongArray;
import jams.data.JAMSObject;
import jams.data.JAMSString;
import jams.data.JAMSStringArray;
import jams.data.JAMSTimeInterval;
import java.util.HashMap;

public class CheckedDataFactory
extends DefaultDataFactory {
    private static HashMap<Class, Class> interfaceLookup;
    private static HashMap<Class, Class> classLookup;
    private static CheckedDataFactory instance;

    private CheckedDataFactory() {
    }

    @Override
    public JAMSData createInstance(Object value) {
        Object result;
        Class<?> type = value.getClass();
        if (Integer.class.isAssignableFrom(type)) {
            JAMSInteger v = new JAMSInteger();
            v.setValue((Integer)value);
            result = v;
        } else if (Long.class.isAssignableFrom(type)) {
            JAMSLong v = new JAMSLong();
            v.setValue((Long)value);
            result = v;
        } else if (Float.class.isAssignableFrom(type)) {
            JAMSFloatChecked v = new JAMSFloatChecked();
            v.setValue(((Float)value).floatValue());
            result = v;
        } else if (Double.class.isAssignableFrom(type)) {
            JAMSDoubleChecked v = new JAMSDoubleChecked();
            v.setValue((Double)value);
            result = v;
        } else if (String.class.isAssignableFrom(type)) {
            JAMSString v = new JAMSString();
            v.setValue(value.toString());
            result = v;
        } else if (Geometry.class.isAssignableFrom(type)) {
            JAMSGeometry v = new JAMSGeometry((Geometry)value);
            result = v;
        } else {
            result = new JAMSString();
            result.setValue(value.toString());
        }
        return result;
    }

    @Override
    public Attribute.Double createDouble() {
        return new JAMSDoubleChecked();
    }

    @Override
    public Attribute.DoubleArray createDoubleArray() {
        return new JAMSDoubleArrayChecked();
    }

    @Override
    public Attribute.Float createFloat() {
        return new JAMSFloatChecked();
    }

    @Override
    public Attribute.FloatArray createFloatArray() {
        return new JAMSFloatArrayChecked();
    }

    @Override
    public Class getImplementingClass(Class interfaceType) {
        while (interfaceType.isArray()) {
            interfaceType = interfaceType.getComponentType();
        }
        if (interfaceLookup == null) {
            interfaceLookup = new HashMap();
            interfaceLookup.put(Attribute.Boolean.class, JAMSBoolean.class);
            interfaceLookup.put(Attribute.BooleanArray.class, JAMSBooleanArray.class);
            interfaceLookup.put(Attribute.Calendar.class, JAMSCalendar.class);
            interfaceLookup.put(Attribute.DirName.class, JAMSDirName.class);
            interfaceLookup.put(Attribute.Document.class, JAMSDocument.class);
            interfaceLookup.put(Attribute.Double.class, JAMSDoubleChecked.class);
            interfaceLookup.put(Attribute.DoubleArray.class, JAMSDoubleArrayChecked.class);
            interfaceLookup.put(Attribute.Entity.class, JAMSEntityChecked.class);
            interfaceLookup.put(Attribute.EntityCollection.class, JAMSEntityCollectionChecked.class);
            interfaceLookup.put(Attribute.FileName.class, JAMSFileName.class);
            interfaceLookup.put(Attribute.Float.class, JAMSFloatChecked.class);
            interfaceLookup.put(Attribute.FloatArray.class, JAMSFloatArrayChecked.class);
            interfaceLookup.put(Attribute.Geometry.class, JAMSGeometry.class);
            interfaceLookup.put(Attribute.Integer.class, JAMSInteger.class);
            interfaceLookup.put(Attribute.IntegerArray.class, JAMSIntegerArray.class);
            interfaceLookup.put(Attribute.Long.class, JAMSLong.class);
            interfaceLookup.put(Attribute.LongArray.class, JAMSLongArray.class);
            interfaceLookup.put(Attribute.Object.class, JAMSObject.class);
            interfaceLookup.put(Attribute.String.class, JAMSString.class);
            interfaceLookup.put(Attribute.StringArray.class, JAMSStringArray.class);
            interfaceLookup.put(Attribute.TimeInterval.class, JAMSTimeInterval.class);
        }
        return interfaceLookup.get(interfaceType);
    }

    public static DataFactory getDataFactory() {
        return instance;
    }

    static {
        instance = new CheckedDataFactory();
    }
}

