/*
 * Decompiled with CFR 0.152.
 */
package jams;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class ResourceBundleChecker {
    private static ArrayList<String> getKeySet(String res) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(res)));
        ArrayList<String> resSet = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, "=");
            if (tok.countTokens() < 2) continue;
            resSet.add(tok.nextToken());
        }
        return resSet;
    }

    private static void compareBundles(String res1, String res2) throws IOException {
        System.out.println(">>>>>>>>>>>>>>>> Comparing " + res1 + " with " + res2);
        ArrayList<String> resKeys1 = ResourceBundleChecker.getKeySet(res1);
        ArrayList<String> resKeys2 = ResourceBundleChecker.getKeySet(res2);
        for (String key : resKeys1) {
            if (resKeys2.contains(key)) continue;
            System.out.println("Missing key in " + res2 + ": " + key);
        }
    }

    private static void check4Duplicates(String res) throws IOException {
        ArrayList<String> resKeys = ResourceBundleChecker.getKeySet(res);
        HashSet<String> set = new HashSet<String>();
        for (String key : resKeys) {
            if (!set.contains(key)) {
                set.add(key);
                continue;
            }
            System.out.println("Duplicate key in " + res + ": " + key);
        }
    }

    private static ArrayList<String> check4UnusedKeys(String res, File[] sourcePaths) throws IOException {
        ArrayList<String> resKeys = ResourceBundleChecker.getKeySet(res);
        TreeSet<String> usedKeys = new TreeSet<String>();
        for (File f : sourcePaths) {
            if (!f.exists()) {
                System.out.println("Path is non-existing: " + f.getAbsolutePath());
            }
            usedKeys.addAll(ResourceBundleChecker.collectUsedKeys(resKeys, f));
        }
        resKeys.removeAll(usedKeys);
        for (String key : resKeys) {
            System.out.println("Unused key in " + res + ": " + key);
        }
        return resKeys;
    }

    private static void cleanUp(String res, File[] sourcePaths) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(res)));
        TreeMap<Object, String> resSet = new TreeMap<Object, String>();
        while ((line = br.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(line, "=");
            if (tok.countTokens() < 2) continue;
            String key = tok.nextToken();
            String value = tok.nextToken();
            if (resSet.containsKey(key) && ((String)resSet.get(key)).compareTo(value) != 0) {
                System.out.println("Clean up failed in: " + res + " conflict for key " + (String)key + "\n value1: " + value + "\n value2: " + (String)resSet.get(key));
            }
            resSet.put(key, value);
        }
        br.close();
        ArrayList<String> unusedKeys = ResourceBundleChecker.check4UnusedKeys(res, sourcePaths);
        for (String key : unusedKeys) {
            resSet.remove(key);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(res.replace("/", ".") + ".cleanup"));
        for (String s : resSet.keySet()) {
            writer.write(s + "=" + (String)resSet.get(s) + "\n");
        }
        writer.close();
    }

    private static TreeSet<String> collectUsedKeys(ArrayList<String> resKeys, File sourcePath) throws IOException {
        TreeSet<String> usedKeys = new TreeSet<String>();
        for (File f : sourcePath.listFiles()) {
            if (f.isDirectory()) {
                usedKeys.addAll(ResourceBundleChecker.collectUsedKeys(resKeys, f));
            }
            if (!f.isFile() || !f.getName().endsWith(".java")) continue;
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("\"")) continue;
                for (String key : resKeys) {
                    String key2 = key.replace("\\", "");
                    if (!line.contains("\"" + key2 + "\")")) continue;
                    usedKeys.add(key);
                }
            }
            reader.close();
        }
        return usedKeys;
    }

    public static void main(String[] args) throws IOException {
        File[] sourcePaths = new File[]{new File("../../")};
        System.out.println("For JAMS sources using path: " + sourcePaths[0].getAbsolutePath());
        ResourceBundleChecker.compareBundles("resources/i18n/JAMSBundle.properties", "resources/i18n/JAMSBundle_pt.properties");
        ResourceBundleChecker.compareBundles("resources/i18n/JAMSBundle_pt.properties", "resources/i18n/JAMSBundle.properties");
        ResourceBundleChecker.compareBundles("resources/i18n/JAMSBundle.properties", "resources/i18n/JAMSBundle_de.properties");
        ResourceBundleChecker.compareBundles("resources/i18n/JAMSBundle_de.properties", "resources/i18n/JAMSBundle.properties");
        ResourceBundleChecker.check4Duplicates("resources/i18n/JAMSBundle.properties");
        ResourceBundleChecker.check4Duplicates("resources/i18n/JAMSBundle_pt.properties");
        ResourceBundleChecker.check4Duplicates("resources/i18n/JAMSBundle_de.properties");
        ResourceBundleChecker.cleanUp("resources/i18n/JAMSBundle.properties", sourcePaths);
        ResourceBundleChecker.cleanUp("resources/i18n/JAMSBundle_de.properties", sourcePaths);
        ResourceBundleChecker.cleanUp("resources/i18n/JAMSBundle_pt.properties", sourcePaths);
        ResourceBundleChecker.cleanUp("resources/i18n/JAMSBundle_vn.properties", sourcePaths);
    }
}

