/*
 * Decompiled with CFR 0.152.
 */
package jams.model;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.model.Component;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.runtime.JAMSRuntime;
import jams.tools.StringTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

@JAMSComponentDescription(title="JAMS model", author="Sven Kralisch", date="2006-05-31", version="1.0_0", description="This component represents a JAMS model which is a special type of context component")
public class JAMSModel
extends JAMSContext
implements Model {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ)
    public Attribute.DirName workspaceDirectory = DefaultDataFactory.getDataFactory().createDirName();
    private final JAMSRuntime runtime;
    private String name;
    private String author;
    private String date;
    public JAMSWorkspace workspace;
    private transient HashMap<Component, ArrayList<Field>> nullFields;
    private final HashMap<Component, Long> execTime = new HashMap();
    private boolean profiling = false;
    private final long[] progressData = new long[]{0L, 0L};

    public JAMSModel(JAMSRuntime runtime) {
        this.runtime = runtime;
    }

    public JAMSRuntime getRuntime() {
        return this.runtime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setInstanceName(name);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public void init() {
        this.runtime.println("", 1);
        this.runtime.println(JAMS.i18n("starting_simulation"), 1);
        this.runtime.println(JAMS.i18n("*************************************"), 1);
        try {
            if (this.workspace != null) {
                this.workspace.init();
            }
        }
        catch (InvalidWorkspaceException iwe) {
            this.runtime.sendHalt(iwe.getMessage());
            return;
        }
        if (this.workspaceDirectory.getValue() == null) {
            this.runtime.sendHalt(JAMS.i18n("No_workspace_directory_specified,_stopping_execution!"));
            return;
        }
        this.getRuntime().saveModelParameter();
        super.init();
        if (!this.doRun) {
            return;
        }
        this.updateProgress();
        if (!this.getNullFields().isEmpty() && this.runtime.getDebugLevel() >= 3) {
            this.runtime.println("");
            this.runtime.println(JAMS.i18n("UNDEFINED_FIELDS"));
            this.runtime.println(JAMS.i18n("*************************************"));
            for (Component comp : this.getNullFields().keySet()) {
                ArrayList<Field> nf = this.getNullFields().get(comp);
                if (nf.isEmpty()) continue;
                String str = "  " + comp.getInstanceName() + ": ";
                for (Field field : nf) {
                    str = str + field.getName() + " ";
                }
                this.getRuntime().println(str);
            }
            this.runtime.println(JAMS.i18n("*************************************"));
        }
        this.setupDataTracer();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.profiling) {
            this.printExecTimes();
        }
    }

    private long getMaxRunCount(Context c) {
        long childCount = 0L;
        long nIter = c.getNumberOfIterations();
        if (nIter <= 0L) {
            return 0L;
        }
        for (Component child : c.getComponents()) {
            if (child instanceof Context) {
                childCount += this.getMaxRunCount((Context)child) + 1L;
                continue;
            }
            ++childCount;
        }
        return childCount * nIter;
    }

    private long getCurrentRunCount(Context c) {
        long rc = c.getRunCount();
        if (rc <= 0L) {
            return 0L;
        }
        long childCount = 0L;
        for (Component child : c.getComponents()) {
            if (!(child instanceof Context)) continue;
            childCount += this.getCurrentRunCount((Context)child);
        }
        return childCount + rc;
    }

    public void updateProgress() {
        this.progressData[1] = this.getMaxRunCount(this);
    }

    public long[] getProgress() {
        this.progressData[0] = this.getCurrentRunCount(this);
        return this.progressData;
    }

    private void printExecTimes(Context context, String indent) {
        this.runtime.println(indent + context.getInstanceName() + "\t" + this.execTime.get(context));
        for (Component c : context.getComponents()) {
            if (c instanceof Context) {
                this.printExecTimes((Context)c, indent + "\t");
                continue;
            }
            this.runtime.println(indent + "\t" + c.getInstanceName() + "\t" + this.execTime.get(c));
        }
    }

    private void printExecTimes() {
        this.runtime.println("");
        this.runtime.println("JAMS profiler results");
        this.runtime.println(JAMS.i18n("*************************************"));
        for (Component c : this.getComponents()) {
            if (c instanceof Context) {
                this.printExecTimes((Context)c, "");
                continue;
            }
            this.runtime.println(c.getInstanceName() + "\t" + this.execTime.get(c));
        }
    }

    public boolean moveWorkspaceDirectory(String workspaceDirectory) {
        this.workspaceDirectory.setValue(workspaceDirectory);
        try {
            this.workspace.setDirectory(new File(workspaceDirectory));
        }
        catch (InvalidWorkspaceException e) {
            this.getRuntime().sendHalt("Error during model setup: \"" + this.workspace.getDirectory().getAbsolutePath() + "\" is not a valid datastore, because: " + e.toString());
            return false;
        }
        this.setupDataTracer();
        return true;
    }

    public void setWorkspacePath(String workspacePath) {
        if (StringTools.isEmptyString(workspacePath)) {
            this.workspaceDirectory.setValue("");
            this.workspace = null;
            this.getRuntime().sendInfoMsg(JAMS.i18n("no_workspace_defined"));
        } else {
            this.workspaceDirectory.setValue(workspacePath);
            this.workspace = new JAMSWorkspace(new File(workspacePath), this.getRuntime());
        }
    }

    public JAMSWorkspace getWorkspace() {
        return this.workspace;
    }

    public File getWorkspaceDirectory() {
        if (this.workspace == null) {
            return null;
        }
        return this.workspace.getDirectory();
    }

    public String getWorkspacePath() {
        return this.workspaceDirectory.getValue();
    }

    public HashMap<Component, ArrayList<Field>> getNullFields() {
        return this.nullFields;
    }

    public void setNullFields(HashMap<Component, ArrayList<Field>> nullFields) {
        this.nullFields = nullFields;
    }

    public void measureTime(long startTime, Component c) {
        long time = System.currentTimeMillis() - startTime;
        Long current = this.execTime.get(c);
        if (current == null) {
            current = new Long(0L);
        }
        current = current + time;
        this.execTime.put(c, current);
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        if (objIn.readBoolean()) {
            this.getRuntime().initGUI((String)objIn.readObject(), objIn.readBoolean(), objIn.readInt(), objIn.readInt());
        }
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        objOut.defaultWriteObject();
        if (this.getRuntime().getFrame() != null) {
            objOut.writeBoolean(true);
            objOut.writeObject(this.getRuntime().getFrame().getTitle());
            objOut.writeBoolean(this.getRuntime().getFrame().isAlwaysOnTop());
            objOut.writeInt(this.getRuntime().getFrame().getWidth());
            objOut.writeInt(this.getRuntime().getFrame().getHeight());
        } else {
            objOut.writeBoolean(false);
        }
    }
}

