/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.data.DefaultDataFactory;
import jams.meta.AttributeList;
import jams.meta.ComponentDescriptor;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.tools.StringTools;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class ComponentField
implements Comparable {
    public static final int READ_ACCESS = 0;
    public static final int WRITE_ACCESS = 1;
    public static final int READWRITE_ACCESS = 2;
    private String value = null;
    private String name = "";
    private Class type = null;
    private int accessType;
    private ArrayList<ContextAttribute> contextAttributes = new ArrayList();
    private AttributeList attributeList = null;
    private ComponentDescriptor parent;
    private ContextDescriptor context;

    public ComponentField(String name, Class type, int accessType, ComponentDescriptor parent) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.accessType = accessType;
    }

    public String getAttribute() {
        String aName = "";
        if (this.contextAttributes.isEmpty()) {
            return aName;
        }
        for (ContextAttribute ca : this.contextAttributes) {
            aName = aName + ca.getName() + ";";
        }
        aName = aName.substring(0, aName.length() - 1);
        return aName;
    }

    public ContextDescriptor getContext() {
        return this.context;
    }

    public ArrayList<ContextAttribute> getContextAttributes() {
        return this.contextAttributes;
    }

    public String getValue() {
        return this.value;
    }

    public void linkToAttributeList(ContextDescriptor context, AttributeList list) {
        this.attributeList = list;
        this.context = context;
        for (String attributeName : this.attributeList.getElements()) {
            this.linkToAttribute(this.getContext(), attributeName, false);
        }
        this.attributeList.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object o1) {
                String attributeName = (String)o1;
                if (ComponentField.this.getAttributeList().getElements().contains(o1)) {
                    ComponentField.this.linkToAttribute(ComponentField.this.getContext(), attributeName, false);
                } else {
                    ComponentField.this.unlinkFromAttribute(attributeName);
                }
            }
        });
    }

    public void unlinkFromAttribute() {
        for (ContextAttribute ca : this.contextAttributes.toArray(new ContextAttribute[this.contextAttributes.size()])) {
            this.unlinkFromAttribute(ca);
        }
    }

    public void unlinkFromAttribute(String caName) {
        for (ContextAttribute ca : this.contextAttributes) {
            if (!ca.getName().equals(caName)) continue;
            this.unlinkFromAttribute(ca);
            return;
        }
    }

    public void unlinkFromAttribute(ContextAttribute ca) {
        ca.getFields().remove(this);
        if (ca.getFields().isEmpty()) {
            ContextDescriptor context = ca.getContext();
            context.getDynamicAttributes().remove(ca.getName());
        }
        this.contextAttributes.remove(ca);
    }

    public void linkToAttribute(ContextDescriptor context, String attributeName) {
        this.linkToAttribute(context, attributeName, true);
    }

    public void linkToAttribute(ContextDescriptor context, String attributeName, boolean removeOldLink) {
        ContextAttribute attribute;
        if (removeOldLink) {
            this.unlinkFromAttribute();
        }
        if (attributeName.contains(";")) {
            if (this.type.isArray()) {
                String[] attributeNames;
                for (String s : attributeNames = StringTools.toArray(attributeName, ";")) {
                    this.linkToAttribute(context, s, false);
                }
                return;
            }
            throw new JAMSException(MessageFormat.format(JAMS.i18n("Semicolons_not_allowed_in_attribute_names"), this.parent.getInstanceName(), attributeName));
        }
        Class basicType = this.type.isArray() ? this.type.getComponentType() : this.type;
        if (!basicType.isInterface()) {
            basicType = DefaultDataFactory.getDataFactory().getBelongingInterface(basicType);
        }
        if ((attribute = context.getDynamicAttributes().get(attributeName)) != null && !basicType.isAssignableFrom(attribute.getType())) {
            throw new JAMSException(MessageFormat.format(JAMS.i18n("Attribute_already_exists_in_context_with_different_type"), attributeName, context.getInstanceName(), attribute.getType()));
        }
        if (attribute == null) {
            attribute = new ContextAttribute(attributeName, basicType, context);
            context.getDynamicAttributes().put(attributeName, attribute);
        }
        attribute.getFields().add(this);
        this.contextAttributes.add(attribute);
        this.context = context;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ComponentDescriptor getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public int getAccessType() {
        return this.accessType;
    }

    public String toString() {
        return this.parent.getInstanceName() + "." + this.name;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public AttributeList getAttributeList() {
        return this.attributeList;
    }
}

