/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.io.JAMSTableDataArray;
import java.util.StringTokenizer;

public class JAMSTableDataConverter {
    public static double[] toDouble(JAMSTableDataArray a) {
        double[] d = new double[a.getValues().length];
        for (int i = 0; i < a.getValues().length; ++i) {
            d[i] = Double.parseDouble(a.getValues()[i]);
        }
        return d;
    }

    public static double[] toDouble(JAMSTableDataArray a, int start, int end) {
        double[] d = new double[end - start + 1];
        int c = 0;
        for (int i = start - 1; i < end; ++i) {
            d[c++] = Double.parseDouble(a.getValues()[i]);
        }
        return d;
    }

    public static double[] toDouble(JAMSTableDataArray a, int start) {
        return JAMSTableDataConverter.toDouble(a, start, a.getLength());
    }

    public static int[] toInt(JAMSTableDataArray a) {
        int[] d = new int[a.getValues().length];
        for (int i = 0; i < a.getValues().length; ++i) {
            d[i] = Integer.parseInt(a.getValues()[i]);
        }
        return d;
    }

    public static Attribute.Calendar parseTime(String timeString) {
        int maxTimeElements = 5;
        String[] timeArray = new String[maxTimeElements];
        timeArray[0] = "0";
        timeArray[1] = "1";
        timeArray[2] = "1";
        timeArray[3] = "00";
        timeArray[4] = "00";
        StringTokenizer st = new StringTokenizer(timeString, ".-/ :");
        int n = st.countTokens();
        if (n > maxTimeElements) {
            n = maxTimeElements;
        }
        for (int i = 0; i < n; ++i) {
            timeArray[i] = st.nextToken();
        }
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        cal.setValue(timeArray[0] + "-" + timeArray[1] + "-" + timeArray[2] + " " + timeArray[3] + ":" + timeArray[4]);
        return cal;
    }
}

