/*
 * Decompiled with CFR 0.152.
 */
package jams;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class JAMSVersion {
    private String dateString;
    private String contactString;
    private int major;
    private int minor;
    String revision;
    private static JAMSVersion instance;

    private JAMSVersion() {
        InputStream is = ClassLoader.getSystemResourceAsStream("resources/text/version.txt");
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.major = Integer.parseInt(p.getProperty("main.majorversion"));
        this.minor = Integer.parseInt(p.getProperty("main.minorversion"));
        this.revision = p.getProperty("main.revision");
        this.dateString = p.getProperty("date");
        this.contactString = p.getProperty("contact");
    }

    public static JAMSVersion getInstance() {
        if (instance == null) {
            instance = new JAMSVersion();
        }
        return instance;
    }

    public String getVersionDateString() {
        return String.format("%d.%d_%s (%s)", this.major, this.minor, this.revision, this.dateString);
    }

    public String getVersionString() {
        return String.format("%d.%d", this.major, this.minor);
    }

    public String getDateString() {
        return this.dateString;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getContactString() {
        return this.contactString;
    }
}

