/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import java.io.File;

@JAMSComponentDescription(title="Thorntwaite data output", author="Sven Kralisch", date="30. September 2005", description="This component writes various model results to an ASCII file")
public class Output
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calculated day length")
    public Attribute.Double daylength;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Model time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Simulated potET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Simulated snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Simulated runoff")
    public Attribute.Double runoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Simulated soil moisture storage")
    public Attribute.Double soilMoistStor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    private GenericDataWriter writer;

    public void init() {
        this.writer = new GenericDataWriter(this.getModel().getWorkspace().getOutputDataDirectory().getPath() + File.separator + this.fileName.getValue());
        this.writer.addComment("Thornthwaite model output");
        this.writer.addComment("");
        this.writer.addColumn("time");
        this.writer.addColumn("daylength");
        this.writer.addColumn("potet");
        this.writer.addColumn("snowMelt");
        this.writer.addColumn("runoff");
        this.writer.addColumn("soilMoistStor");
        this.writer.writeHeader();
    }

    public void run() {
        this.writer.addData((Object)this.time);
        this.writer.addData((Object)this.daylength);
        this.writer.addData((Object)this.potET);
        this.writer.addData((Object)this.snowMelt);
        this.writer.addData((Object)this.runoff);
        this.writer.addData((Object)this.soilMoistStor);
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

