/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite runoff (2007)", author="Sven Kralisch", date="30. September 2005", description="This component calculates the runoff based on a runoff factor surface runoff and snowmelt")
public class Direct_Runoff
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="A factorn defining how much water leaves the model - the remain will be stored in the model", defaultValue="0.05")
    public Attribute.Double runoffFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precip (storage)")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Surface runoff water")
    public Attribute.Double directRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Water coming from snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Water that potenially infiltrates")
    public Attribute.Double surface_water;

    public void run() {
        double runoffFactor = this.runoffFactor.getValue();
        double directRunoff = this.directRunoff.getValue();
        double snowMelt = this.snowMelt.getValue();
        double precip = this.precip.getValue();
        double ro1 = (snowMelt + precip) * runoffFactor;
        double surface_water = (snowMelt + precip) * (1.0 - runoffFactor);
        this.surface_water.setValue(surface_water);
        this.directRunoff.setValue(ro1);
        this.precip.setValue(precip);
    }
}

