/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.thornthwaite;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Thorntwaite daylength", author="Sven Kralisch", date="30. September 2005", description="This component calculates the length of a day in the current month based on the latitude")
public class Daylen
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The models latitude")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Length of a day at the current time")
    public Attribute.Double daylength;
    static final int[] DAYS = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void run() {
        int month = this.time.get(2);
        double latitude = this.latitude.getValue();
        double dayl = (double)DAYS[month] - 80.0;
        if (dayl < 0.0) {
            dayl = 285.0 + (double)DAYS[month];
        }
        double decr = 23.45 * Math.sin(dayl / 365.0 * 6.2832) * 0.017453;
        double alat = latitude * 0.017453;
        double csh = (-0.02908 - Math.sin(decr) * Math.sin(alat)) / (Math.cos(decr) * Math.cos(alat));
        double dl = 24.0 * (1.570796 - Math.atan(csh / Math.sqrt(1.0 - csh * csh))) / Math.PI;
        this.daylength.setValue(dl);
    }
}

