/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;

public class BufferedFileWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    public static final String CHARSET_NAME_ISO_8859_1 = "ISO-8859-1";
    public static final String CHARSET_NAME_UTF_8 = "UTF-8";
    private transient FileChannel outChannel;
    private String lineSeparator;

    public BufferedFileWriter(FileOutputStream is) {
        this(is, defaultCharBufferSize, CHARSET_NAME_ISO_8859_1);
    }

    public BufferedFileWriter(FileOutputStream out, String charsetName) {
        this(out, defaultCharBufferSize, charsetName);
    }

    public BufferedFileWriter(FileOutputStream is, int sz, String charsetName) {
        this.outChannel = is.getChannel();
        try {
            this.out = new OutputStreamWriter((OutputStream)is, charsetName);
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Charset \"" + charsetName + "\" could not be found, using default charset!");
            this.out = new OutputStreamWriter(is);
        }
        if (this.lock == null) {
            throw new NullPointerException();
        }
        this.lock = this.out;
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.cb = new char[sz];
        this.nChars = sz;
        this.nextChar = 0;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)c;
        }
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.nChars) {
                this.flushBuffer();
                this.out.write(cbuf, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                s.getChars(b, b + d, this.cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    public long getPosition() {
        try {
            this.flush();
            return this.outChannel.position();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void setPosition(long position) throws IOException {
        this.outChannel = this.outChannel.position(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flushBuffer();
            this.out.close();
            this.out = null;
            this.cb = null;
        }
    }
}

