/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import com.vividsolutions.jts.geom.Geometry;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSBoolean;
import jams.data.JAMSBooleanArray;
import jams.data.JAMSCalendar;
import jams.data.JAMSData;
import jams.data.JAMSDirName;
import jams.data.JAMSDocument;
import jams.data.JAMSDouble;
import jams.data.JAMSDoubleArray;
import jams.data.JAMSEntity;
import jams.data.JAMSEntityCollection;
import jams.data.JAMSFileName;
import jams.data.JAMSFloat;
import jams.data.JAMSFloatArray;
import jams.data.JAMSGeometry;
import jams.data.JAMSInteger;
import jams.data.JAMSIntegerArray;
import jams.data.JAMSLong;
import jams.data.JAMSLongArray;
import jams.data.JAMSObject;
import jams.data.JAMSObjectArray;
import jams.data.JAMSString;
import jams.data.JAMSStringArray;
import jams.data.JAMSTimeInterval;
import jams.runtime.JAMSRuntime;
import java.util.HashMap;

public class DefaultDataFactory
implements DataFactory {
    private HashMap<Class, Class> interfaceLookup;
    private HashMap<Class, Class> classLookup;
    protected static DataFactory instance = new DefaultDataFactory();

    protected DefaultDataFactory() {
    }

    public JAMSData createInstance(Class clazz) throws InstantiationException, IllegalAccessException {
        if (clazz.isInterface()) {
            clazz = this.getImplementingClass(clazz);
        }
        if (!JAMSData.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (JAMSEntity.class.isAssignableFrom(clazz)) {
            clazz = JAMSEntity.class;
        }
        return (JAMSData)clazz.newInstance();
    }

    public JAMSData createInstance(Class clazz, JAMSRuntime rt) {
        if (clazz.isInterface()) {
            clazz = this.getImplementingClass(clazz);
        }
        JAMSData value = null;
        try {
            value = this.createInstance(clazz);
        }
        catch (InstantiationException ex) {
            rt.handle((Throwable)ex, false);
        }
        catch (IllegalAccessException ex) {
            rt.handle((Throwable)ex, false);
        }
        return value;
    }

    public JAMSData createInstance(Object value) {
        Object result;
        Class<?> type = value.getClass();
        if (Integer.class.isAssignableFrom(type)) {
            JAMSInteger v = new JAMSInteger();
            v.setValue((Integer)value);
            result = v;
        } else if (Long.class.isAssignableFrom(type)) {
            JAMSLong v = new JAMSLong();
            v.setValue((Long)value);
            result = v;
        } else if (Float.class.isAssignableFrom(type)) {
            JAMSFloat v = new JAMSFloat();
            v.setValue(((Float)value).floatValue());
            result = v;
        } else if (Double.class.isAssignableFrom(type)) {
            JAMSDouble v = new JAMSDouble();
            v.setValue((Double)value);
            result = v;
        } else if (String.class.isAssignableFrom(type)) {
            JAMSString v = new JAMSString();
            v.setValue(value.toString());
            result = v;
        } else if (Geometry.class.isAssignableFrom(type)) {
            JAMSGeometry v = new JAMSGeometry((Geometry)value);
            result = v;
        } else {
            result = new JAMSString();
            result.setValue(value.toString());
        }
        return result;
    }

    public Attribute.Double createDouble() {
        return new JAMSDouble();
    }

    public Attribute.DoubleArray createDoubleArray() {
        return new JAMSDoubleArray();
    }

    public Attribute.Float createFloat() {
        return new JAMSFloat();
    }

    public Attribute.FloatArray createFloatArray() {
        return new JAMSFloatArray();
    }

    public Attribute.Long createLong() {
        return new JAMSLong();
    }

    public Attribute.LongArray createLongArray() {
        return new JAMSLongArray();
    }

    public Attribute.Integer createInteger() {
        return new JAMSInteger();
    }

    public Attribute.IntegerArray createIntegerArray() {
        return new JAMSIntegerArray();
    }

    public Attribute.String createString() {
        return new JAMSString();
    }

    public Attribute.StringArray createStringArray() {
        return new JAMSStringArray();
    }

    public Attribute.Boolean createBoolean() {
        return new JAMSBoolean();
    }

    public Attribute.BooleanArray createBooleanArray() {
        return new JAMSBooleanArray();
    }

    public Attribute.Calendar createCalendar() {
        return new JAMSCalendar();
    }

    public Attribute.DirName createDirName() {
        return new JAMSDirName();
    }

    public Attribute.Document createJAMSDocument() {
        return new JAMSDocument();
    }

    public Attribute.FileName createFileName() {
        return new JAMSFileName();
    }

    public Attribute.Geometry createGeometry() {
        return new JAMSGeometry();
    }

    public Attribute.TimeInterval createTimeInterval() {
        return new JAMSTimeInterval();
    }

    public Attribute.Entity createEntity() {
        return new JAMSEntity();
    }

    public Attribute.Document createDocument() {
        return new JAMSDocument();
    }

    public Attribute.EntityCollection createEntityCollection() {
        return new JAMSEntityCollection();
    }

    public Attribute.Object createObject() {
        return new JAMSObject();
    }

    public Attribute.ObjectArray createObjectArray() {
        return new JAMSObjectArray();
    }

    public Class getImplementingClass(Class interfaceType) {
        while (interfaceType.isArray()) {
            interfaceType = interfaceType.getComponentType();
        }
        if (this.interfaceLookup == null) {
            this.interfaceLookup = new HashMap();
            this.interfaceLookup.put(Attribute.Boolean.class, JAMSBoolean.class);
            this.interfaceLookup.put(Attribute.BooleanArray.class, JAMSBooleanArray.class);
            this.interfaceLookup.put(Attribute.Calendar.class, JAMSCalendar.class);
            this.interfaceLookup.put(Attribute.DirName.class, JAMSDirName.class);
            this.interfaceLookup.put(Attribute.Document.class, JAMSDocument.class);
            this.interfaceLookup.put(Attribute.Double.class, JAMSDouble.class);
            this.interfaceLookup.put(Attribute.DoubleArray.class, JAMSDoubleArray.class);
            this.interfaceLookup.put(Attribute.Entity.class, JAMSEntity.class);
            this.interfaceLookup.put(Attribute.EntityCollection.class, JAMSEntityCollection.class);
            this.interfaceLookup.put(Attribute.FileName.class, JAMSFileName.class);
            this.interfaceLookup.put(Attribute.Float.class, JAMSFloat.class);
            this.interfaceLookup.put(Attribute.FloatArray.class, JAMSFloatArray.class);
            this.interfaceLookup.put(Attribute.Geometry.class, JAMSGeometry.class);
            this.interfaceLookup.put(Attribute.Integer.class, JAMSInteger.class);
            this.interfaceLookup.put(Attribute.IntegerArray.class, JAMSIntegerArray.class);
            this.interfaceLookup.put(Attribute.Long.class, JAMSLong.class);
            this.interfaceLookup.put(Attribute.LongArray.class, JAMSLongArray.class);
            this.interfaceLookup.put(Attribute.Object.class, JAMSObject.class);
            this.interfaceLookup.put(Attribute.String.class, JAMSString.class);
            this.interfaceLookup.put(Attribute.StringArray.class, JAMSStringArray.class);
            this.interfaceLookup.put(Attribute.TimeInterval.class, JAMSTimeInterval.class);
        }
        return this.interfaceLookup.get(interfaceType);
    }

    public Class getBelongingInterface(Class clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        if (clazz.isArray()) {
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            return this.getBelongingInterface(clazz);
        }
        if (this.classLookup == null) {
            this.classLookup = new HashMap();
            if (this.interfaceLookup == null) {
                this.getImplementingClass(Attribute.Boolean.class);
            }
            for (Class key : this.interfaceLookup.keySet()) {
                this.classLookup.put(this.interfaceLookup.get(key), key);
            }
        }
        return this.classLookup.get(clazz);
    }

    public static DataFactory getDataFactory() {
        return instance;
    }
}

