/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.tools.FileTools;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLProcessor {
    static String[] regex = new String[]{"jamsvar class=\".*\" name", "compoundcomponent", "jamsvar", "providervar", "spatattrib", "provider=", "org\\.unijena\\.jams\\.gui", "org\\.unijena\\.jamscomponents", "org\\.unijena\\.jams\\.", "jams\\.model\\.cc\\.", "jams\\.model\\.BooleanConditionalContext", "jams\\.model\\.DoubleConditionalContext", "org\\.unijena\\.j2kHimalaya", "jams\\.model\\.JAMSContext", "jams\\.model\\.JAMSSpatialContext", "jams\\.model\\.JAMSTemporalContext"};
    static String[] replace = new String[]{"jamsvar name", "contextcomponent", "var", "cvar", "attribute", "context=", "jams.components.gui", "jams.components", "jams.", "jams.model.", "jams\\.components\\.conditional\\.BooleanConditionalContext", "jams\\.components\\.conditional\\.DoubleConditionalContext", "j2k_Himalaya", "jams.components.core.Context", "jams.components.core.SpatialContext", "jams.components.core.TemporalContext"};

    public static String modelDocConverter(String inFileName) {
        String outFileName = inFileName;
        try {
            String oldDoc;
            String newDoc = oldDoc = FileTools.fileToString(inFileName);
            for (int i = 0; i < regex.length; ++i) {
                newDoc = newDoc.replaceAll(regex[i], replace[i]);
            }
            if (!newDoc.contentEquals(oldDoc)) {
                File f = new File(inFileName);
                String fName = "$_" + f.getCanonicalFile().getName();
                String pName = f.getParent();
                outFileName = pName + File.separator + fName;
                FileTools.stringToFile(outFileName, newDoc);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return outFileName;
    }

    public static Node getModelNode(Node root) {
        if (root.getNodeName().equals("model")) {
            return root;
        }
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node model = XMLProcessor.getModelNode(childs.item(i));
            if (model == null) continue;
            return model;
        }
        return null;
    }

    public static String getWorkspacePath(Document model) {
        Element root = model.getDocumentElement();
        Element modelElem = (Element)XMLProcessor.getModelNode(root);
        NodeList childs = modelElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!node.getNodeName().equals("var") || !((Element)node).getAttribute("name").equals("workspaceDirectory")) continue;
            return ((Element)node).getAttribute("value");
        }
        return null;
    }

    public static boolean setWorkspacePath(Document model, String theWorkSpacePath) {
        Element root = model.getDocumentElement();
        Element modelElem = (Element)XMLProcessor.getModelNode(root);
        NodeList childs = modelElem.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if (!node.getNodeName().equals("var") || !((Element)node).getAttribute("name").equals("workspaceDirectory")) continue;
            ((Element)node).setAttribute("value", theWorkSpacePath);
            return true;
        }
        return false;
    }

    public static Node getFirstComponent(Node root) {
        NodeList childs = root.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            if (childs.item(i).getNodeName().equals("component") || childs.item(i).getNodeName().equals("contextcomponent")) {
                return childs.item(i);
            }
            Node result = XMLProcessor.getFirstComponent(childs.item(i));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Node findComponentNode(Node context, String attributeName) {
        NodeList childs = context.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            String node_name = node.getNodeName();
            if ((node_name.equals("component") || node_name.equals("contextcomponent") || node_name.equals("model")) && ((Element)node).getAttribute("name").equals(attributeName)) {
                return node;
            }
            Node result = XMLProcessor.findComponentNode(node, attributeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getComponentNodeValue(Node context, String attributeName) {
        Node componentNode = XMLProcessor.findComponentNode(context, attributeName);
        if (componentNode != null) {
            return ((Element)componentNode).getAttribute("value");
        }
        return null;
    }
}

