/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import jams.JAMS;
import jams.data.DefaultDataFactory;
import jams.io.BufferedFileReader;
import jams.tools.StringTools;
import jams.workspace.DefaultDataSet;
import jams.workspace.DefaultDataSetDefinition;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.datatypes.CalendarValue;
import jams.workspace.datatypes.DoubleValue;
import jams.workspace.stores.TSDataStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class J2KTSDataStore
extends TSDataStore {
    public static final String DATE_TIME_FORMAT_PATTERN_J2K = "dd.MM.yyyy HH:mm";
    public static final String TAGNAME_DATAEND = "dataEnd";
    public static final String TAGNAME_DATASETATTRIBS = "@dataSetAttribs";
    public static final String TAGNAME_DATASTART = "dataStart";
    public static final String TAGNAME_DATAVAL = "@dataVal";
    public static final String TAGNAME_DATAVALUEATTRIBS = "@dataValueAttribs";
    public static final String TAGNAME_MISSINGDATAVAL = "missingDataVal";
    public static final String TAGNAME_STATATTRIBVAL = "@statAttribVal";
    public static final String TAGNAME_TEMP_RES = "tres";
    private String cache = null;
    private int columnCount = 0;
    private transient BufferedFileReader j2kTSFileReader;
    private File sourceFile;
    private String relativPath = null;
    private boolean parseDate = false;
    private String charsetName;
    private double missingData;

    public J2KTSDataStore(JAMSWorkspace ws, String id, Document doc) throws IOException {
        super(ws);
        this.id = id;
        Element sourceElement = (Element)doc.getElementsByTagName("source").item(0);
        Element timeFormatElement = (Element)doc.getElementsByTagName("dumptimeformat").item(0);
        Element parseTimeElement = (Element)doc.getElementsByTagName("parsetime").item(0);
        Element charsetElement = (Element)doc.getElementsByTagName("charset").item(0);
        this.timeFormat = timeFormatElement != null ? timeFormatElement.getAttribute("value") : "yyyy-MM-dd HH:mm";
        this.charsetName = charsetElement != null ? charsetElement.getAttribute("value") : JAMS.getCharset();
        this.parseDate = parseTimeElement != null ? Boolean.parseBoolean(parseTimeElement.getAttribute("value")) : false;
        Node displaynameNode = doc.getDocumentElement().getElementsByTagName("displayname").item(0);
        this.displayName = displaynameNode != null ? displaynameNode.getTextContent() : id;
        this.sourceFile = null;
        if (sourceElement != null) {
            String sourceFileName = sourceElement.getAttribute("value");
            if (sourceFileName != null) {
                this.sourceFile = new File(sourceFileName);
            }
        } else {
            this.sourceFile = new File(ws.getLocalInputDirectory(), id + ".dat");
        }
        this.relativPath = new File(this.ws.getDirectory().getAbsolutePath()).toURI().relativize(new File(this.sourceFile.getAbsolutePath()).toURI()).getPath();
        this.j2kTSFileReader = new BufferedFileReader(new FileInputStream(this.sourceFile), this.charsetName);
        this.readJ2KFile();
        this.columnCount = this.getDataSetDefinition().getColumnCount();
        this.currentDate = DefaultDataFactory.getDataFactory().createCalendar();
        this.currentDate.setDateFormat(this.timeFormat);
        this.currentDate.setValue(this.startDate);
        this.currentDate.add(this.timeUnit, -1 * this.timeUnitCount);
        this.calendar = new CalendarValue(this.currentDate);
        if (ws.getRuntime().getState() != 1) {
            return;
        }
    }

    private void readJ2KFile() throws IOException {
        String line = this.j2kTSFileReader.readLine();
        while (line.charAt(0) == '#') {
            this.description = this.description + line.substring(1) + "\n";
            line = this.j2kTSFileReader.readLine();
        }
        StringBuffer dataValueAttribs = new StringBuffer();
        while (!line.startsWith(TAGNAME_DATASETATTRIBS)) {
            dataValueAttribs.append(line + "\n");
            line = this.j2kTSFileReader.readLine();
        }
        StringBuffer dataSetAttribs = new StringBuffer();
        while (!line.startsWith(TAGNAME_STATATTRIBVAL)) {
            dataSetAttribs.append(line + "\n");
            line = this.j2kTSFileReader.readLine();
        }
        StringBuffer statAttribVal = new StringBuffer();
        while (!line.startsWith(TAGNAME_DATAVAL)) {
            statAttribVal.append(line + "\n");
            line = this.j2kTSFileReader.readLine();
        }
        StringTokenizer tok1 = new StringTokenizer(statAttribVal.toString(), "\n");
        tok1.nextToken();
        StringTokenizer tok2 = new StringTokenizer(tok1.nextToken(), "\t");
        int attributeCount = tok2.countTokens() - 1;
        ArrayList<Class> dataTypes = new ArrayList<Class>();
        for (int i = 0; i < attributeCount; ++i) {
            dataTypes.add(Double.class);
        }
        DefaultDataSetDefinition def = new DefaultDataSetDefinition(dataTypes);
        while (tok1.hasMoreTokens()) {
            String attributeName = tok2.nextToken().toUpperCase(StringTools.STANDARD_LOCALE);
            ArrayList<Object> values = new ArrayList<Object>();
            if (attributeName.equals("X") || attributeName.equals("Y") || attributeName.equals("ELEVATION")) {
                def.addAttribute(attributeName, Double.class);
                while (tok2.hasMoreTokens()) {
                    values.add(Double.parseDouble(tok2.nextToken()));
                }
            } else {
                def.addAttribute(attributeName, String.class);
                while (tok2.hasMoreTokens()) {
                    values.add(tok2.nextToken());
                }
            }
            def.setAttributeValues(attributeName, values);
            tok2 = new StringTokenizer(tok1.nextToken());
        }
        tok1 = new StringTokenizer(dataValueAttribs.toString());
        tok1.nextToken();
        String parameterName = tok1.nextToken();
        String parameterString = "PARAMETER";
        def.addAttribute(parameterString, String.class);
        def.setAttributeValues(parameterString, parameterName);
        tok1 = new StringTokenizer(dataSetAttribs.toString(), "\n");
        tok1.nextToken();
        while (tok1.hasMoreTokens()) {
            tok2 = new StringTokenizer(tok1.nextToken());
            String key = tok2.nextToken();
            if (key.equalsIgnoreCase(TAGNAME_MISSINGDATAVAL)) {
                this.missingDataValue = tok2.nextToken();
                this.missingData = Double.parseDouble(this.missingDataValue);
                continue;
            }
            if (key.equalsIgnoreCase(TAGNAME_DATASTART) || key.equalsIgnoreCase(TAGNAME_DATAEND)) {
                String dateFormat = DATE_TIME_FORMAT_PATTERN_J2K;
                String dateString = tok2.nextToken();
                if (tok2.hasMoreTokens()) {
                    dateString = dateString + " " + tok2.nextToken();
                }
                try {
                    if (key.equalsIgnoreCase(TAGNAME_DATASTART)) {
                        this.startDate.setValue(dateString, dateFormat);
                    }
                    if (!key.equalsIgnoreCase(TAGNAME_DATAEND)) continue;
                    this.endDate.setValue(dateString, dateFormat);
                }
                catch (ParseException pe) {
                    this.ws.getRuntime().sendErrorMsg(JAMS.i18n("Could_not_parse_date_") + dateString + JAMS.i18n("_date_kept_unchanged!"));
                }
                continue;
            }
            if (!key.equalsIgnoreCase(TAGNAME_TEMP_RES)) continue;
            String tres = tok2.nextToken();
            if (tres.equals("d")) {
                this.timeUnit = 6;
                continue;
            }
            if (tres.equals("m")) {
                this.timeUnit = 2;
                continue;
            }
            if (!tres.equals("h")) continue;
            this.timeUnit = 11;
        }
        this.timeUnitCount = 1;
        this.currentDate.setValue(this.startDate);
        this.currentDate.setDateFormat(this.timeFormat);
        this.dsd = def;
    }

    private String[] parseTSRow(String row) throws ParseException {
        StringTokenizer tok = new StringTokenizer(row);
        int n = tok.countTokens();
        if (n > 1) {
            int i;
            String[] data;
            String dateString = tok.nextToken();
            String s = tok.nextToken();
            if (s.contains(":")) {
                data = new String[n - 1];
                data[0] = dateString + " " + s;
                i = 1;
            } else {
                data = new String[n];
                data[0] = dateString;
                data[1] = s;
                i = 2;
            }
            while (tok.hasMoreTokens()) {
                data[i++] = tok.nextToken();
            }
            return data;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.cache != null) {
            return true;
        }
        try {
            this.cache = this.j2kTSFileReader.readLine();
            return this.cache != null && !this.cache.startsWith("#");
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public DefaultDataSet getNext() {
        if (!this.hasNext()) {
            return null;
        }
        DefaultDataSet result = new DefaultDataSet(this.columnCount + 1);
        String[] values = this.cache.split("\\s+");
        this.currentDate.add(this.timeUnit, this.timeUnitCount);
        result.setData(0, this.calendar);
        for (int i = 2; i < values.length; ++i) {
            double d = Double.parseDouble(values[i]);
            if (d == this.missingData) {
                d = JAMS.getMissingDataValue();
            }
            result.setData(i - 1, new DoubleValue(d));
        }
        this.cache = null;
        return result;
    }

    public static void main(String[] args) {
        double a = Double.MIN_NORMAL;
        System.out.println(a == 0.0);
        double d = -a / a;
        System.out.println(d);
        System.out.println(a);
    }

    @Override
    public void skip(int count) {
        for (int i = 0; i < count; ++i) {
            this.getNext();
        }
    }

    @Override
    public void close() {
        try {
            this.j2kTSFileReader.close();
        }
        catch (IOException ioe) {
            this.ws.getRuntime().handle((Throwable)ioe);
        }
    }

    @Override
    public void setWorkspace(Workspace ws) throws IOException {
        this.ws = ws;
        long position = this.j2kTSFileReader.getPosition();
        if (this.j2kTSFileReader != null) {
            try {
                this.j2kTSFileReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.j2kTSFileReader = new BufferedFileReader(new FileInputStream(new File(ws.getDirectory(), this.relativPath)));
        this.j2kTSFileReader.setPosition(position);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        long position = in.readLong();
        if (this.j2kTSFileReader != null) {
            try {
                this.j2kTSFileReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.j2kTSFileReader = new BufferedFileReader(new FileInputStream(this.sourceFile));
        this.j2kTSFileReader.setPosition(position);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            out.writeLong(this.j2kTSFileReader.getPosition());
        }
        catch (Throwable t) {
            out.writeLong(0L);
        }
    }
}

