/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import jams.JAMS;
import jams.meta.ModelDescriptor;
import jams.meta.ModelIO;
import jams.tools.XMLTools;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.w3c.dom.Document;

public class FileTools {
    public static void deleteFiles(File[] theFiles) {
        for (File theFile : theFiles) {
            theFile.delete();
        }
    }

    public static void deleteRecursive(File theFile) {
        if (theFile.isDirectory()) {
            for (File f : theFile.listFiles()) {
                FileTools.deleteRecursive(f);
            }
        }
        Logger log = Logger.getLogger(FileTools.class.getName());
        log.setLevel(Level.ALL);
        log.log(Level.INFO, "Deleted the file during cleanUp {0}", theFile.getAbsolutePath());
        theFile.delete();
    }

    public static File[] getFiles(String directoryName, String fileExtension) throws IOException {
        File directory = FileTools.assertDirectory(directoryName);
        if (!directory.isDirectory()) {
            throw new IOException("Can't load filelist because directory '" + directoryName + "' not found.");
        }
        return FileTools.getFiles(directory, fileExtension);
    }

    public static File[] getFiles(File directory, String fileExtension) {
        File file;
        int i;
        String ext = null;
        if (fileExtension != null) {
            ext = fileExtension.toLowerCase();
        }
        final String fileExtensionLower = ext;
        File[] fileArray = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                return fileExtensionLower == null || nameLower.endsWith("." + fileExtensionLower);
            }
        });
        ArrayList<File> files = new ArrayList<File>();
        for (i = 0; i < fileArray.length; ++i) {
            file = fileArray[i];
            if (file.isDirectory()) continue;
            files.add(file);
        }
        fileArray = new File[files.size()];
        for (i = 0; i < files.size(); ++i) {
            fileArray[i] = file = (File)files.get(i);
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String fileName1 = o1.getName();
                String fileName2 = o1.getName();
                return fileName1.compareToIgnoreCase(fileName2);
            }
        });
        return fileArray;
    }

    public static Collection<File> getFilesByRegEx(File directory, String regex, boolean isPostiveRegEx) {
        ArrayList<File> list = new ArrayList<File>();
        if (directory.isFile()) {
            String path = FileTools.normalizePath(directory.getPath());
            if (regex == null || regex.isEmpty() || isPostiveRegEx && path.toLowerCase().matches(regex) || !isPostiveRegEx && !path.toLowerCase().matches(regex)) {
                list.add(directory);
            }
            return list;
        }
        for (File f : directory.listFiles()) {
            String path = FileTools.normalizePath(f.getPath());
            if (f.isDirectory()) {
                list.addAll(FileTools.getFilesByRegEx(f, regex, isPostiveRegEx));
                continue;
            }
            if (regex != null && !regex.isEmpty() && (!isPostiveRegEx || !path.toLowerCase().matches(regex)) && (isPostiveRegEx || path.toLowerCase().matches(regex))) continue;
            list.add(f);
        }
        return list;
    }

    public static File assertDirectory(String dirName) throws IOException {
        File dir = new File(dirName);
        if (dir.isDirectory() && dir.exists()) {
            return dir;
        }
        dir.mkdirs();
        if (!dir.isDirectory() || !dir.exists()) {
            throw new IOException("Could not create directory '" + dirName + "' !");
        }
        return dir;
    }

    public static void stringToFile(String fileName, String string) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), JAMS.getCharset()));
        writer.write(string);
        writer.close();
    }

    public static String fileToString(String fileName, String encoding) throws IOException {
        String result = "";
        FileInputStream in = new FileInputStream(fileName);
        result = FileTools.streamToString(in, encoding);
        in.close();
        return result;
    }

    public static String fileToString(String fileName) throws IOException {
        String result = "";
        FileInputStream in = new FileInputStream(fileName);
        result = FileTools.streamToString(in);
        in.close();
        return result;
    }

    public static String streamToString(InputStream in) throws IOException {
        return FileTools.streamToString(in, JAMS.getCharset());
    }

    public static String streamToString(InputStream in, String encoding) throws IOException {
        String content = "";
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        content = new String(buffer, encoding);
        return content;
    }

    public static String streamToString(InputStream in, int offset, int size) throws IOException {
        String t = "";
        in.skip(offset);
        byte[] buffer = new byte[16384];
        int nread = 0;
        while ((nread = in.read(buffer, 0, Math.min(buffer.length, size))) > 0 && size > 0) {
            t = t + new String(buffer);
            size -= nread;
        }
        return t;
    }

    public static void streamToFile(File target, InputStream in) throws IOException {
        FileOutputStream writer = new FileOutputStream(target);
        byte[] buffer = new byte[65535];
        int fread = 0;
        while ((fread = in.read(buffer)) > 0) {
            writer.write(buffer, 0, fread);
        }
        writer.flush();
        writer.close();
    }

    public static String createAbsoluteFileName(String dirName, String fileName) {
        String canonicalPath;
        if (dirName.isEmpty()) {
            dirName = JAMS.getBaseDir().getAbsolutePath();
        }
        File file = new File(dirName, fileName);
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException ex) {
            canonicalPath = file.getAbsolutePath();
        }
        return canonicalPath;
    }

    public static boolean replaceWithinFile(String fileName, String findString, String replaceString) throws IOException {
        String theFileString = FileTools.fileToString(fileName);
        if (theFileString.indexOf(findString) > -1) {
            theFileString = theFileString.replaceAll(findString, replaceString);
            FileTools.stringToFile(fileName, theFileString);
            return true;
        }
        return false;
    }

    public static void zipFile(File file, String fileName, ZipOutputStream zipOut) throws IOException {
        int len;
        FileInputStream inFile = new FileInputStream(file);
        zipOut.putNextEntry(new ZipEntry(fileName));
        byte[] buf = new byte[65536];
        while ((len = inFile.read(buf)) > 0) {
            zipOut.write(buf, 0, len);
        }
        zipOut.closeEntry();
        inFile.close();
    }

    private static File buildDirectoryHierarchyFor(String entryName, File destDir) {
        entryName = entryName.replace("\\", "/");
        int lastIndex = entryName.lastIndexOf(47);
        String internalPathToEntry = entryName.substring(0, lastIndex + 1);
        return new File(destDir, internalPathToEntry);
    }

    public static void unzipFile(File zip, File destDir, boolean deleteZip) throws IOException {
        ZipEntry entry;
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipFile = new ZipInputStream(new FileInputStream(zip));
        byte[] buffer = new byte[16384];
        while ((entry = zipFile.getNextEntry()) != null) {
            int len;
            File f;
            String entryFileName = entry.getName();
            File dir = FileTools.buildDirectoryHierarchyFor(entryFileName = entryFileName.replace("\\", "/"), destDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (entry.isDirectory() || (f = new File(destDir, entryFileName)).isDirectory()) continue;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            while ((len = zipFile.read(buffer)) > 0) {
                bos.write(buffer, 0, len);
            }
            bos.flush();
            bos.close();
        }
        zipFile.close();
        if (deleteZip) {
            zip.delete();
        }
    }

    public static long getDirectorySize(File directory) {
        long length = 0L;
        if (directory == null || directory.listFiles() == null) {
            return 0L;
        }
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += FileTools.getDirectorySize(file);
        }
        return length;
    }

    public static String normalizePath(String s) {
        FileTools.removeSlashes(s);
        s = s.replace("\\", "/").replace("//", "/");
        return s;
    }

    public static String getParent(String s) {
        int index = (s = FileTools.normalizePath(s)).lastIndexOf("/");
        if (index != -1) {
            return s.substring(0, index);
        }
        return "";
    }

    private static String removeSlashes(String s) {
        while (s.startsWith("/") || s.startsWith("\\")) {
            s = s.substring(1);
        }
        return s;
    }

    public static <T> void serializeObjectToXMLwithJAXB(T o, File file) throws Exception {
        FileWriter writer = new FileWriter(file);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
        Marshaller m = context.createMarshaller();
        m.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                System.out.println(event.getMessage());
                return false;
            }
        });
        m.marshal(o, (Writer)writer);
        writer.close();
    }

    public static <T> T deserializeObjectFromXMLwithJAXB(File file, Class<T> c) throws Exception {
        FileReader reader = new FileReader(file);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
        Unmarshaller um = context.createUnmarshaller();
        um.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                System.out.println(event.getMessage());
                return false;
            }
        });
        Object o = um.unmarshal((Reader)reader);
        reader.close();
        return (T)o;
    }

    public static <T> void serializeObjectToXML(T o, File file) throws Exception {
        XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
        encoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        });
        encoder.writeObject(o);
        encoder.close();
    }

    public static <T> T deserializeObjectFromXML(File file) throws Exception {
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
        Object o = decoder.readObject();
        decoder.close();
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateModelFile(File f) {
        if (f.isDirectory()) {
            return false;
        }
        if (!f.exists()) {
            return false;
        }
        if (!f.getName().endsWith(".xml") && !f.getName().endsWith(".jam")) {
            return false;
        }
        ModelIO io = ModelIO.getStandardModelIO();
        Document d = XMLTools.getDocument(f.getAbsolutePath());
        if (d == null) {
            return false;
        }
        Filter filterAll = new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return false;
            }
        };
        Logger.getLogger(ModelIO.class.getName()).setFilter(filterAll);
        Logger.getLogger(ModelDescriptor.class.getName()).setFilter(filterAll);
        try {
            ModelDescriptor desc = io.loadModelDescriptor(d, null, true);
            if (desc == null) {
                boolean bl = false;
                return bl;
            }
            if (desc.getModelName() == null || desc.getModelName().isEmpty()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Logger.getLogger(ModelIO.class.getName()).setFilter(null);
            Logger.getLogger(ModelDescriptor.class.getName()).setFilter(null);
        }
        return true;
    }
}

