/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Binary Isotope Mixing", author="Andrew Watson", description="The isotope mixing model utilises isotope concentrationsof rainfall, soil-water and groundwater to validateproportions of RD1, RD2, RG1 and RG2 combinedIt provides a snapshot of flow component portioning atdiscrete sampling intervalsPublication status: Under reviewPlease cite:Development of an isotope-enabled rainfall-runoff model:Improving the capability to capture hydrological and anthropogenic changeAuthors: Andrew Watson, Yuliya Vystavna, Sven Kralisch, J\u00f6rg Helmschrot,Jared van Rooyen and Jodie Miller", date="2022-09-20", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Binary_isotope_mixing
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope rain", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope stream", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeStream;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Isotope groundwater", defaultValue="0", unit="\u2030", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double isotopeGw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Composition rain", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double compRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Composition soil-water", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double compSW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Composition groundwater", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double compGw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calibration factor minimum surface runoff contribution/rain isotopes", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double minCompRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calibration factor minimum groundwater contribution", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double minCompGw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Available Runoff and GW proportion considering simulated RD2", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double FracCompRainGw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Normalized Composition rain", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double compRainN;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Normalized Composition GW", defaultValue="0", unit="fraction", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double compGwN;

    @Override
    public void init() {
    }

    @Override
    public void run() {
        this.compRain.setValue(this.isotopeStream.getValue() - this.isotopeRain.getValue() / (this.isotopeRain.getValue() - this.isotopeGw.getValue()));
        this.compGw.setValue(this.isotopeStream.getValue() - this.isotopeRain.getValue() / (this.isotopeGw.getValue() - this.isotopeRain.getValue()));
        if (this.compRain.getValue() == 0.0) {
            this.compRain.setValue(this.minCompRain.getValue());
            return;
        }
        if (this.compGw.getValue() == 0.0) {
            this.compGw.setValue(this.minCompGw.getValue());
        }
        double fracCompRainGw = 1.0 - this.compSW.getValue();
        this.compRainN.setValue(this.compRain.getValue() * fracCompRainGw);
        this.compGwN.setValue(this.compGw.getValue() * fracCompRainGw);
    }

    @Override
    public void cleanup() {
    }
}

