/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.workspace.dsproc.AbstractDataStoreProcessor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Processor {
    protected AbstractDataStoreProcessor dsdb;
    protected Connection conn;
    protected ArrayList<AbstractDataStoreProcessor.ContextData> contexts;
    protected ProcessingProgressObservable processingProgressObservable = new ProcessingProgressObservable();
    protected boolean abortOperation = false;

    public AbstractDataStoreProcessor getDataStoreProcessor() {
        return this.dsdb;
    }

    public void close() throws SQLException {
        this.processingProgressObservable = null;
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.dsdb != null) {
            this.dsdb.close();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void addProcessingProgressObserver(Observer o) {
        this.processingProgressObservable.addObserver(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAbortOperation() {
        this.abortOperation = true;
        Processor processor = this;
        synchronized (processor) {
            this.abortOperation = false;
        }
    }

    public static void output(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        for (i = 1; i <= numberOfColumns; ++i) {
            System.out.print(rsmd.getColumnName(i) + "\t");
        }
        System.out.println();
        while (rs.next()) {
            for (i = 1; i <= numberOfColumns; ++i) {
                System.out.print(rs.getString(i) + "\t");
            }
            System.out.println();
        }
    }

    protected synchronized boolean isTableExisting(String tableName) throws SQLException {
        String q = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='" + tableName + "'";
        ResultSet rs = this.customSelectQuery(q);
        return rs.next();
    }

    protected double[][] calcWeights(double[][] a, int weightAttribIndex) {
        double[][] result = new double[a.length][a[0].length];
        double[] relWeights = null;
        double[] absWeights = null;
        int i = -1;
        for (AbstractDataStoreProcessor.AttributeData attrib : this.dsdb.getAttributes()) {
            int j;
            if (!attrib.isSelected()) continue;
            ++i;
            if (attrib.getWeightingType() == 1) {
                double weight = 0.0;
                if (attrib.getAggregationType() == 2) {
                    weight = 1.0 / (double)a.length;
                } else if (attrib.getAggregationType() == 1) {
                    weight = 1.0;
                }
                for (j = 0; j < a.length; ++j) {
                    result[j][i] = weight;
                }
                continue;
            }
            if (weightAttribIndex >= 0) {
                if (attrib.getAggregationType() == 2) {
                    if (attrib.getWeightingType() == 2 || attrib.getWeightingType() == 3) {
                        if (relWeights == null) {
                            relWeights = new double[a.length];
                            double sum = 0.0;
                            for (j = 0; j < a.length; ++j) {
                                sum += a[j][weightAttribIndex];
                            }
                            for (j = 0; j < a.length; ++j) {
                                relWeights[j] = a[j][weightAttribIndex] / sum;
                            }
                        }
                        for (int j2 = 0; j2 < a.length; ++j2) {
                            result[j2][i] = relWeights[j2];
                        }
                        continue;
                    }
                    if (attrib.getWeightingType() != 3) continue;
                    if (relWeights == null) {
                        relWeights = new double[a.length];
                        double sum = 0.0;
                        for (j = 0; j < a.length; ++j) {
                            sum += 1.0 / a[j][weightAttribIndex];
                        }
                        for (j = 0; j < a.length; ++j) {
                            relWeights[j] = 1.0 / a[j][weightAttribIndex] / sum;
                        }
                    }
                    for (int j3 = 0; j3 < a.length; ++j3) {
                        result[j3][i] = relWeights[j3];
                    }
                    continue;
                }
                if (attrib.getAggregationType() != 1) continue;
                if (attrib.getWeightingType() == 2) {
                    if (absWeights == null) {
                        absWeights = new double[a.length];
                        for (int j4 = 0; j4 < a.length; ++j4) {
                            absWeights[j4] = a[j4][weightAttribIndex];
                        }
                    }
                    for (int j5 = 0; j5 < a.length; ++j5) {
                        result[j5][i] = absWeights[j5];
                    }
                    continue;
                }
                if (attrib.getWeightingType() != 3) continue;
                if (absWeights == null) {
                    absWeights = new double[a.length];
                    for (int j6 = 0; j6 < a.length; ++j6) {
                        absWeights[j6] = 1.0 / a[j6][weightAttribIndex];
                    }
                }
                for (int j7 = 0; j7 < a.length; ++j7) {
                    result[j7][i] = absWeights[j7];
                }
                continue;
            }
            Logger.getLogger(Processor.class.getName()).log(Level.INFO, "No area attribute has been chosen! Applying unweighted sum aggregation.");
            for (int j8 = 0; j8 < a.length; ++j8) {
                result[j8][i] = 1.0;
            }
        }
        return result;
    }

    private static double[] arrayMulti(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    protected synchronized double[] getWeightedSum(double[][] a, double[][] weights) {
        double[] result = Processor.arrayMulti(a[0], weights[0]);
        for (int i = 1; i < a.length; ++i) {
            double[] b = Processor.arrayMulti(a[i], weights[i]);
            for (int c = 0; c < result.length; ++c) {
                int n = c;
                result[n] = result[n] + b[c];
            }
        }
        return result;
    }

    protected synchronized double[] getAvg(ArrayList<double[]> a) {
        double[] result = a.get(0);
        for (int i = 1; i < a.size(); ++i) {
            double[] b = a.get(i);
            for (int c = 0; c < result.length; ++c) {
                int n = c;
                result[n] = result[n] + b[c] / (double)a.size();
            }
        }
        return result;
    }

    public synchronized boolean customQuery(String query) throws SQLException {
        Statement stmt = this.conn.createStatement();
        boolean result = stmt.execute(query);
        return result;
    }

    public synchronized ResultSet customSelectQuery(String query) throws SQLException {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        return rs;
    }

    protected class ProcessingProgressObservable
    extends Observable {
        private int progress;

        protected ProcessingProgressObservable() {
        }

        protected void setProgress(int progress) {
            this.progress = progress;
            this.setChanged();
            this.notifyObservers(progress);
        }
    }
}

