/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.data.JAMSCalendar;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.Processor;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnsembleTimeSeriesProcessor
extends Processor {
    private static final String TABLE_NAME_MONTHAVG = "MONTHAVG";
    private static final String TABLE_NAME_YEARAVG = "YEARAVG";
    private static final String TABLE_NAME_SPATSUM = "SPATSUM";
    private String ensembleID;
    private String ensembleFilter = null;

    public EnsembleTimeSeriesProcessor(File file) {
        this(new DataStoreProcessor(file));
    }

    public EnsembleTimeSeriesProcessor(AbstractDataStoreProcessor dsdb) {
        this.dsdb = dsdb;
        this.contexts = dsdb.getContexts();
        if (dsdb.isEnsembleTimeSeriesDatastore()) {
            this.ensembleID = ((AbstractDataStoreProcessor.ContextData)this.contexts.get(1)).getName() + "ID";
            try {
                this.conn = dsdb.getH2Connection(true);
            }
            catch (SQLException ex) {
                Logger.getLogger(EnsembleTimeSeriesProcessor.class.getName()).log(Level.SEVERE, "Error while creating connection to H2 database of {0}", dsdb.getFile());
            }
        }
    }

    public synchronized ResultSet getData() throws SQLException {
        String query = "SELECT " + this.ensembleID + ", position FROM index";
        if (this.ensembleFilter != null) {
            query = query + " WHERE ";
            String s = null;
            if (this.ensembleFilter != null) {
                s = this.ensembleFilter.contains("%") ? " LIKE '" + this.ensembleFilter + "'" : " = '" + this.ensembleFilter + "'";
                query = query + this.ensembleID + s;
            }
        }
        query = query + " ORDER BY position";
        ResultSet rs = this.customSelectQuery(query);
        return rs;
    }

    public int getTimeUnit() throws SQLException, IOException {
        Attribute.Calendar[] timeSteps = this.getTimeSteps();
        if (timeSteps == null) {
            return -1;
        }
        Attribute.Calendar t0 = timeSteps[0];
        Attribute.Calendar tn = timeSteps[timeSteps.length - 1];
        int n = timeSteps.length;
        long diff = (tn.getTimeInMillis() - t0.getTimeInMillis()) / (long)n / 1000L;
        if (0L <= diff && diff < 30L) {
            return 13;
        }
        if (30L <= diff && diff < 1800L) {
            return 12;
        }
        if (1800L <= diff && diff < 43200L) {
            return 10;
        }
        if (43200L <= diff && diff < 1296000L) {
            return 6;
        }
        if (1296000L <= diff && diff < 3456000L) {
            return 2;
        }
        return 1;
    }

    public synchronized DataMatrix getCrossProduct(long[] modelRunIds, String[] dateIds) throws SQLException, IOException {
        double[][] matrix = new double[dateIds.length][modelRunIds.length];
        int[] idMap = null;
        for (int i = 0; i < modelRunIds.length; ++i) {
            DataMatrix col = this.getTimeSeriesData(this.getModelRuns()[i]);
            if (idMap == null) {
                idMap = new int[dateIds.length];
                for (int j = 0; j < dateIds.length; ++j) {
                    idMap[j] = col.getIDPosition(dateIds[j]);
                }
            }
            double[] timeSerie = col.getCol(0);
            for (int j = 0; j < dateIds.length; ++j) {
                matrix[j][i] = timeSerie[idMap[j]];
            }
        }
        String[] modelRunIdStrings = new String[modelRunIds.length];
        for (int i = 0; i < modelRunIds.length; ++i) {
            modelRunIdStrings[i] = Long.toString(modelRunIds[i]);
        }
        return new DataMatrix(matrix, (Object[])dateIds, modelRunIdStrings);
    }

    public synchronized DataMatrix getTimeSeriesData(long modelRun) throws SQLException, IOException {
        this.setEnsembleFilter(new Long(modelRun).toString());
        ResultSet rs = this.getData();
        DataMatrix result = null;
        if (rs.next()) {
            long position = rs.getLong("POSITION");
            result = this.dsdb.getData(position);
        }
        return result;
    }

    public synchronized void calcMonthlyMean() throws SQLException, IOException {
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int numSelected = attributeIDs.length;
        this.customQuery("DROP TABLE IF EXISTS MONTHAVG");
        String q = "CREATE TABLE MONTHAVG (";
        q = q + "MONTH " + DataStoreProcessor.TYPE_MAP.get("JAMSInteger") + ",";
        q = q + this.ensembleID + " " + DataStoreProcessor.TYPE_MAP.get("JAMSLong") + ",";
        for (int i = 1; i <= numSelected; ++i) {
            q = q + "a_" + i + " " + DataStoreProcessor.TYPE_MAP.get("JAMSDouble") + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.customQuery(q);
        int percent = 0;
        for (int i = 1; i <= 12; ++i) {
            String filterString = ".*-" + String.format("%02d", i) + "-.*";
            this.calcTemporalMean(filterString, TABLE_NAME_MONTHAVG, String.valueOf(i), true);
            if (this.abortOperation) {
                this.customQuery("DROP TABLE IF EXISTS MONTHAVG");
                return;
            }
            int current = Math.round((float)i / 12.0f * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
    }

    public synchronized void calcYearlyMean() throws SQLException, IOException {
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int numSelected = attributeIDs.length;
        this.customQuery("DROP TABLE IF EXISTS YEARAVG");
        String q = "CREATE TABLE YEARAVG (";
        q = q + "YEAR " + DataStoreProcessor.TYPE_MAP.get("JAMSInteger") + ",";
        q = q + this.ensembleID + " " + DataStoreProcessor.TYPE_MAP.get("JAMSLong") + ",";
        for (int i = 1; i <= numSelected; ++i) {
            q = q + "a_" + i + " " + DataStoreProcessor.TYPE_MAP.get("JAMSDouble") + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.customQuery(q);
        int percent = 0;
        int[] years = this.getYears();
        for (int i = 0; i < years.length; ++i) {
            int y = years[i];
            String filterString = String.format("%04d", y) + "-.*";
            this.calcTemporalMean(filterString, TABLE_NAME_YEARAVG, Integer.toString(y), true);
            if (this.abortOperation) {
                this.customQuery("DROP TABLE IF EXISTS MONTHAVG");
                return;
            }
            int current = Math.round((float)(i + 1) / (float)years.length * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.processingProgressObservable.setProgress(percent);
        }
    }

    public synchronized DataMatrix getEnsembleMean(long[] ids) throws SQLException, IOException {
        DataMatrix aggregate = null;
        if (ids.length == 0) {
            return null;
        }
        aggregate = this.getTimeSeriesData(ids[0]);
        for (int i = 1; i < ids.length; ++i) {
            aggregate.plus(this.getTimeSeriesData(ids[i]));
            this.processingProgressObservable.setProgress((int)((double)(i + 1) * 100.0 / (double)ids.length));
        }
        aggregate.times(1.0 / (double)ids.length);
        return aggregate;
    }

    public synchronized DataMatrix getEnsembleMean() throws SQLException, IOException {
        return this.getEnsembleMean(this.getModelRuns());
    }

    public synchronized DataMatrix getTemporalMean() throws SQLException, IOException {
        DataMatrix aggregate = this.getMonthlyMean(1);
        if (aggregate == null) {
            return null;
        }
        for (int i = 2; i <= 12; ++i) {
            DataMatrix monthlyData = this.getMonthlyMean(i);
            if (monthlyData == null) {
                return null;
            }
            aggregate = aggregate.plus(monthlyData);
        }
        aggregate = aggregate.times(0.08333333333333333);
        return aggregate;
    }

    public synchronized DataMatrix getTemporalMean(JAMSCalendar[] dates) throws SQLException, IOException {
        if (dates == null || dates.length == 0) {
            return null;
        }
        this.setEnsembleFilter(null);
        ResultSet rs = this.getData();
        String[] attrSet = null;
        HashMap<Long, Object> aggregate = new HashMap<Long, Object>();
        HashMap<Long, int[]> counter = new HashMap<Long, int[]>();
        while (rs.next()) {
            if (this.abortOperation) {
                return null;
            }
            long position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            Object[] ids = m.getIds();
            attrSet = m.getAttributeIDs();
            for (int i = 0; i < ids.length; ++i) {
                String current_id = (String)ids[i];
                boolean match = false;
                for (int j = 0; j < dates.length; ++j) {
                    if (!dates[j].toString().equals(current_id)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                Long modelrun = rs.getLong(this.ensembleID);
                double[] entry = (double[])aggregate.get(modelrun);
                if (entry == null) {
                    aggregate.put(modelrun, m.getRow(i).clone());
                    counter.put(modelrun, new int[]{1});
                    continue;
                }
                for (int j = 0; j < entry.length; ++j) {
                    int n = j;
                    entry[n] = entry[n] + m.getRow(i)[j];
                }
                int[] nArray = (int[])counter.get(modelrun);
                nArray[0] = nArray[0] + 1;
            }
        }
        double[][] table = new double[aggregate.size()][];
        Object[] id_table = new String[aggregate.size()];
        Iterator iter = aggregate.keySet().iterator();
        int tableCounter = 0;
        while (iter.hasNext()) {
            Long modelrun = (Long)iter.next();
            double[] data = (double[])aggregate.get(modelrun);
            int count = ((int[])counter.get(modelrun))[0];
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = data[n] / (double)count;
            }
            table[tableCounter] = data;
            id_table[tableCounter] = modelrun.toString();
            ++tableCounter;
        }
        DataMatrix result = new DataMatrix(table, id_table, attrSet);
        return result;
    }

    public synchronized DataMatrix getYearlyMean(int year) throws SQLException, IOException {
        int i;
        double[] rowdata;
        if (!this.isYearlyMeanExisiting()) {
            this.calcYearlyMean();
        }
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int attribCount = attributeIDs.length;
        String q = "SELECT * FROM YEARAVG WHERE YEAR = " + year;
        ResultSet rs = this.customSelectQuery(q);
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (rs.next()) {
            rowdata = new double[attribCount];
            for (i = 0; i < attribCount; ++i) {
                rowdata[i] = rs.getDouble(i + 3);
            }
            data.add(rowdata);
            ids.add(rs.getLong(2));
        } else {
            return null;
        }
        while (rs.next()) {
            rowdata = new double[attribCount];
            for (i = 0; i < attribCount; ++i) {
                rowdata[i] = rs.getDouble(i + 3);
            }
            data.add(rowdata);
            ids.add(rs.getLong(2));
        }
        double[][] dataArray = (double[][])data.toArray((T[])new double[data.size()][attribCount]);
        Object[] idArray = ids.toArray(new Long[ids.size()]);
        return new DataMatrix(dataArray, idArray, attributeIDs);
    }

    public synchronized DataMatrix getMonthlyMean(int month) throws SQLException, IOException {
        if (!this.isMonthlyMeanExisiting()) {
            this.calcMonthlyMean();
        }
        String[] attributeIDs = this.getDataStoreProcessor().getSelectedDoubleAttribs();
        int attribCount = attributeIDs.length;
        String q = "SELECT * FROM MONTHAVG WHERE MONTH = " + month;
        ResultSet rs = this.customSelectQuery(q);
        ArrayList<double[]> data = new ArrayList<double[]>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (rs.next()) {
            double[] rowdata = new double[attribCount];
            for (int i = 0; i < attribCount; ++i) {
                rowdata[i] = rs.getDouble(i + 3);
            }
            data.add(rowdata);
            ids.add(rs.getLong(2));
        }
        double[][] dataArray = (double[][])data.toArray((T[])new double[data.size()][attribCount]);
        Object[] idArray = ids.toArray(new Long[ids.size()]);
        return new DataMatrix(dataArray, idArray, attributeIDs);
    }

    private synchronized DataMatrix calcTemporalMean(String regex, String tableName, String id, boolean putInTable) throws SQLException, IOException {
        int j;
        this.resetEnsembleFilter();
        ResultSet rs = this.getData();
        String[] attrSet = null;
        HashMap<Long, Object> aggregate = new HashMap<Long, Object>();
        HashMap<Long, int[]> counter = new HashMap<Long, int[]>();
        while (rs.next()) {
            if (this.abortOperation) {
                return null;
            }
            long position = rs.getLong("POSITION");
            DataMatrix m = this.dsdb.getData(position);
            attrSet = m.getAttributeIDs();
            Object[] ids = m.getIds();
            for (int i = 0; i < ids.length; ++i) {
                String current_id = (String)ids[i];
                if (!current_id.matches(regex)) continue;
                Long modelrun = rs.getLong(this.ensembleID);
                double[] entry = (double[])aggregate.get(modelrun);
                if (entry == null) {
                    aggregate.put(modelrun, m.getRow(i).clone());
                    counter.put(modelrun, new int[]{1});
                    continue;
                }
                for (j = 0; j < entry.length; ++j) {
                    int n = j;
                    entry[n] = entry[n] + m.getRow(i)[j];
                }
                int[] nArray = (int[])counter.get(modelrun);
                nArray[0] = nArray[0] + 1;
            }
        }
        double[][] table = new double[aggregate.size()][];
        Object[] id_table = new String[aggregate.size()];
        Iterator iter = aggregate.keySet().iterator();
        int tableCounter = 0;
        while (iter.hasNext()) {
            Long modelrun = (Long)iter.next();
            double[] data = (double[])aggregate.get(modelrun);
            int count = ((int[])counter.get(modelrun))[0];
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = data[n] / (double)count;
            }
            table[tableCounter] = data;
            id_table[tableCounter] = modelrun.toString();
            String q = "INSERT INTO " + tableName + " VALUES (" + id + ", " + modelrun;
            for (j = 0; j < data.length; ++j) {
                q = q + ", " + data[j];
            }
            q = q + ")";
            if (putInTable) {
                this.customQuery(q);
            }
            ++tableCounter;
        }
        return new DataMatrix(table, id_table, attrSet);
    }

    public synchronized DataMatrix getTemporalData(JAMSCalendar date) throws SQLException, IOException {
        return this.calcTemporalMean(date.toString(), "dummy", "dummy", false);
    }

    public synchronized long[] getModelRuns() throws SQLException {
        String q = "SELECT min(" + this.ensembleID + ") AS MINDATE, max(" + this.ensembleID + ") AS MAXDATE FROM index";
        ResultSet rs = this.customSelectQuery(q);
        rs.next();
        int minID = (int)rs.getLong("MINDATE");
        int maxID = (int)rs.getLong("MAXDATE");
        long[] ids = new long[maxID - minID + 1];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i + minID;
        }
        return ids;
    }

    public synchronized int[] getYears() throws SQLException, IOException {
        DataMatrix block0 = this.getTimeSeriesData(this.getModelRuns()[0]);
        Attribute.Calendar minDate = DefaultDataFactory.getDataFactory().createCalendar();
        minDate.setValue((String)block0.getIds()[0]);
        Attribute.Calendar maxDate = DefaultDataFactory.getDataFactory().createCalendar();
        maxDate.setValue((String)block0.getIds()[block0.getIds().length - 1]);
        int startYear = minDate.get(1);
        int endYear = maxDate.get(1);
        int[] years = new int[endYear - startYear + 1];
        int c = 0;
        int i = startYear;
        while (i <= endYear) {
            years[c++] = i++;
        }
        return years;
    }

    public synchronized Attribute.Calendar[] getTimeSteps() throws SQLException, IOException {
        DataMatrix block0 = this.getTimeSeriesData(this.getModelRuns()[0]);
        if (block0 == null) {
            return null;
        }
        Object[] ids = block0.getIds();
        Attribute.Calendar[] steps = new Attribute.Calendar[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            Attribute.Calendar calendar = DefaultDataFactory.getDataFactory().createCalendar();
            calendar.setValue((String)ids[i]);
            steps[i] = calendar;
        }
        return steps;
    }

    public boolean isMonthlyMeanExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_MONTHAVG);
    }

    public boolean isYearlyMeanExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_YEARAVG);
    }

    public boolean isSpatSumExisiting() throws SQLException {
        return this.isTableExisting(TABLE_NAME_SPATSUM);
    }

    public synchronized void setEnsembleFilter(String ensembleFilter) {
        this.ensembleFilter = ensembleFilter;
    }

    public synchronized void resetEnsembleFilter() {
        this.ensembleFilter = null;
    }

    public synchronized void deleteCache() throws SQLException {
        String[] tables;
        for (String table : tables = new String[]{TABLE_NAME_YEARAVG, TABLE_NAME_SPATSUM, TABLE_NAME_MONTHAVG}) {
            this.customQuery("DROP TABLE IF EXISTS " + table);
        }
    }

    public static void main(String[] args) throws Exception {
        EnsembleTimeSeriesProcessor tsproc = new EnsembleTimeSeriesProcessor(new File("C:/Arbeit/ModelData/JAMS-Gehlberg/output/output_gehlberg_e2_gutmann/TimeLoop.dat"));
        tsproc.dsdb.isEnsembleTimeSeriesDatastore();
        ArrayList<AbstractDataStoreProcessor.AttributeData> attribs = tsproc.getDataStoreProcessor().getAttributes();
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            attrib.setSelected(true);
        }
        System.out.println();
        tsproc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.println("Progress: " + arg);
            }
        });
        tsproc.deleteCache();
        int c = 0;
        DataMatrix m = null;
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                long[] ids = new long[]{1L};
                break;
            }
            case 5: {
                Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
                cal.setValue("2000-10-31 07:30");
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                Attribute.Calendar[] dates = new Attribute.Calendar[2];
                dates[0] = DefaultDataFactory.getDataFactory().createCalendar();
                dates[0].setValue("2000-10-31 07:30");
                dates[1] = DefaultDataFactory.getDataFactory().createCalendar();
                dates[1].setValue("2000-10-30 07:30");
                break;
            }
            case 8: {
                Attribute.Calendar[] dates;
                for (Attribute.Calendar date : dates = tsproc.getTimeSteps()) {
                    System.out.println(date);
                }
                break;
            }
        }
        if (m == null) {
            return;
        }
        for (Object o : m.getIds()) {
            System.out.print(o + " ");
        }
        System.out.println();
        m.print(5, 3);
        tsproc.dsdb.close();
    }
}

