/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import Jama.Matrix;
import java.util.HashMap;

public class DataMatrix
extends Matrix {
    private Object[] ids;
    private String[] attributeIDs;
    private HashMap<String, Integer> idPositions;

    public DataMatrix(double[][] data, Object[] ids, String[] attributeIDs) {
        super(data);
        this.ids = ids;
        this.attributeIDs = attributeIDs;
    }

    public DataMatrix(Matrix matrix, Object[] ids, String[] attributeIDs) {
        super(matrix.getArray());
        this.ids = ids;
        this.attributeIDs = attributeIDs;
    }

    public DataMatrix plus(Matrix other) {
        Matrix result = super.plus(other);
        return new DataMatrix(result, this.ids, this.attributeIDs);
    }

    public DataMatrix times(double d) {
        Matrix result = super.times(d);
        return new DataMatrix(result, this.ids, this.attributeIDs);
    }

    public Object[] getIds() {
        return this.ids;
    }

    public double[] getAvgRow() {
        double[] result = new double[this.getColumnDimension()];
        int colCount = this.getColumnDimension();
        int rowCount = this.getRowDimension();
        double[][] data = this.getArray();
        int i = 0;
        while (i < colCount) {
            result[i] = 0.0;
            int counter = 0;
            for (int j = 0; j < rowCount; ++j) {
                if (data[j][i] == -9999.0 || !Double.isFinite(data[j][i])) continue;
                int n = i;
                result[n] = result[n] + data[j][i];
                ++counter;
            }
            int n = i++;
            result[n] = result[n] / (double)counter;
        }
        return result;
    }

    public double[] getAvgCol() {
        double[] result = new double[this.getRowDimension()];
        int colCount = this.getColumnDimension();
        int rowCount = this.getRowDimension();
        double[][] data = this.getArray();
        int i = 0;
        while (i < rowCount) {
            result[i] = 0.0;
            int counter = 0;
            for (int j = 0; j < colCount; ++j) {
                if (data[i][j] == -9999.0 || !Double.isFinite(data[i][j])) continue;
                int n = i;
                result[n] = result[n] + data[i][j];
                ++counter;
            }
            int n = i++;
            result[n] = result[n] / (double)counter;
        }
        return result;
    }

    public double[] getSumRow() {
        double[] result = new double[this.getColumnDimension()];
        int colCount = this.getColumnDimension();
        int rowCount = this.getRowDimension();
        double[][] data = this.getArray();
        for (int i = 0; i < colCount; ++i) {
            result[i] = 0.0;
            for (int j = 0; j < rowCount; ++j) {
                int n = i;
                result[n] = result[n] + data[j][i];
            }
        }
        return result;
    }

    public int getIDPosition(String id) {
        if (this.idPositions == null) {
            int i = 0;
            this.idPositions = new HashMap();
            for (Object o : this.ids) {
                this.idPositions.put(o.toString(), i);
                ++i;
            }
        }
        return this.idPositions.get(id);
    }

    public double[] getRow(int position) {
        return this.getArray()[position];
    }

    public double[] getCol(int position) {
        double[][] array = this.getArray();
        int n = array.length;
        double[] column = new double[n];
        for (int i = 0; i < n; ++i) {
            column[i] = array[i][position];
        }
        return column;
    }

    public void output() {
        System.out.println(this.getIds()[0].getClass());
        for (Object o : this.getIds()) {
            System.out.print(o + " ");
        }
        System.out.println();
    }

    public boolean equals(DataMatrix mat, double accuracy) {
        int N = this.getRowDimension();
        int M = this.getColumnDimension();
        if (N != mat.getRowDimension() || M != mat.getColumnDimension()) {
            return false;
        }
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                if (!(Math.abs(this.get(i, j) - mat.get(i, j)) > accuracy)) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        double[][] x = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {8.0, 10.0, 12.0}};
        Object[] ids = new String[]{"a", "b", "c"};
        String[] atributeids = new String[]{"x", "y", "z"};
        DataMatrix dm = new DataMatrix(x, ids, atributeids);
        for (double v : dm.getAvgRow()) {
            System.out.print(v + " ");
        }
        System.out.println("");
        for (double v : dm.getRow(dm.getIDPosition("c"))) {
            System.out.print(v + " ");
        }
        System.out.println("");
    }

    public String[] getAttributeIDs() {
        return this.attributeIDs;
    }

    public void setAttributeIDs(String[] attributeIDs) {
        this.attributeIDs = attributeIDs;
    }
}

