/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace;

import jams.JAMS;
import jams.workspace.DataSetDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;

public class DefaultDataSetDefinition
implements DataSetDefinition,
Serializable {
    private int columnCount;
    private ArrayList<Class> dataTypes;
    private ArrayList<String> attributeNames = new ArrayList();
    private HashMap<String, Class> attributes = new HashMap();
    private HashMap<String, ArrayList<Object>> attributeValues = new HashMap();

    public DefaultDataSetDefinition(ArrayList<Class> dataTypes) {
        this.dataTypes = dataTypes;
        this.columnCount = dataTypes.size();
    }

    public Class getType(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Object getAttributeValue(String attributeName, int column) {
        ArrayList<Object> values = this.attributeValues.get(attributeName);
        return values.get(column);
    }

    public ArrayList<Object> getAttributeValues(String attributeName) {
        return this.attributeValues.get(attributeName);
    }

    public ArrayList<Object> getAttributeValues(int column) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String attributeName : this.attributeNames) {
            list.add(this.getAttributeValue(attributeName, column));
        }
        return list;
    }

    public boolean setAttributeValues(String attributeName, ArrayList<Object> values) {
        if (values.size() != this.columnCount) {
            return false;
        }
        if (!this.attributes.containsKey(attributeName)) {
            return false;
        }
        Class type = this.attributes.get(attributeName);
        for (int i = 0; i < values.size(); ++i) {
            if (type.isAssignableFrom(values.get(i).getClass())) continue;
            System.out.println(JAMS.i18n("Invalid_type_in_dataset_definition:_") + values.get(i).getClass() + "<->" + type + " (" + attributeName + ")");
            return false;
        }
        this.attributeValues.put(attributeName, values);
        return true;
    }

    public boolean setAttributeValues(String attributeName, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.columnCount; ++i) {
            values.add(value);
        }
        return this.setAttributeValues(attributeName, values);
    }

    public boolean setAttributeValues(int column, ArrayList<Object> values) {
        if (column < 0 || column >= this.columnCount) {
            return false;
        }
        int i = 0;
        for (String attributeName : this.attributeNames) {
            if (i >= values.size()) {
                return false;
            }
            Class type = this.attributes.get(attributeName);
            if (!type.isAssignableFrom(values.get(i).getClass())) {
                System.out.println(JAMS.i18n("Invalid_type_in_dataset_definition:_") + values.get(i).getClass() + "<->" + type + " (" + attributeName + ")");
                return false;
            }
            ArrayList<Object> valueRow = this.attributeValues.get(attributeName);
            valueRow.set(column, values.get(i));
            ++i;
        }
        return true;
    }

    public void removeAttribute(String attributeName) {
        this.attributeNames.remove(attributeName);
        this.attributes.remove(attributeName);
        this.attributeValues.remove(attributeName);
    }

    public void addAttribute(String attributeName, Class type) {
        this.attributeNames.add(attributeName);
        this.attributes.put(attributeName, type);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            values.add(null);
        }
        this.attributeValues.put(attributeName, values);
    }

    public Set<String> getAttributes() {
        return this.attributes.keySet();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String toASCIIString() {
        String result = "";
        result = result + "#_TYPE_";
        for (Class type : this.dataTypes) {
            result = result + "\t" + type.getName();
        }
        result = result + "\n";
        for (String attributeName : this.attributeNames) {
            result = result + "#" + attributeName;
            result = result + "\t" + this.attributes.get(attributeName).getName();
            ArrayList<Object> values = this.getAttributeValues(attributeName);
            for (Object value : values) {
                result = result + "\t" + value;
            }
            result = result + "\n";
        }
        return result;
    }

    public static void main(String[] args) {
        int i;
        ArrayList<Class> dataTypes = new ArrayList<Class>();
        dataTypes.add(Double.class);
        dataTypes.add(Long.class);
        dataTypes.add(String.class);
        dataTypes.add(Object.class);
        DefaultDataSetDefinition def = new DefaultDataSetDefinition(dataTypes);
        def.addAttribute("ID", Long.class);
        def.addAttribute("NAME", String.class);
        def.addAttribute("LAT", Double.class);
        def.addAttribute("LONG", Double.class);
        def.addAttribute("HEIGHT", Double.class);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(new Long(0L));
        values.add(new Long(1L));
        values.add(new Long(2L));
        values.add(new Long(12L));
        def.setAttributeValues("ID", values);
        values = new ArrayList();
        values.add("Tmean");
        values.add("Tmin");
        values.add("Tmax");
        values.add("Precip");
        def.setAttributeValues("NAME", values);
        Random r = new Random(42L);
        values = new ArrayList();
        for (i = 0; i < 4; ++i) {
            values.add(100000.0 * new Double(r.nextDouble()));
        }
        def.setAttributeValues("LAT", values);
        values = new ArrayList();
        for (i = 0; i < 4; ++i) {
            values.add(100000.0 * new Double(r.nextDouble()));
        }
        def.setAttributeValues("LONG", values);
        values = new ArrayList();
        for (i = 0; i < 4; ++i) {
            values.add(100.0 * new Double(r.nextDouble()));
        }
        def.setAttributeValues("HEIGHT", values);
        values = new ArrayList();
        values.add(new Long(42L));
        values.add("Vmax");
        values.add(new Double(42000.0));
        values.add(new Double(84000.0));
        values.add(new Double(-1.0));
        def.setAttributeValues(0, values);
        System.out.println(def.toASCIIString());
    }

    public ArrayList<String> getAttributeNames() {
        return this.attributeNames;
    }
}

