/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import jams.tools.StringTools;
import java.util.Observable;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogTools {
    public static void log(Class c, Level l, String msg, Object ... arguments) {
        Logger.getLogger(c.getName()).log(l, StringTools.format(msg, arguments));
    }

    public static void log(Class c, Level l, Throwable t, String msg, Object ... arguments) {
        Logger.getLogger(c.getName()).log(l, StringTools.format(msg, arguments), t);
    }

    public static class ObservableLogHandler
    extends Observable {
        DefaultHandler handler = new DefaultHandler();
        Logger[] loggers = null;
        Filter filter = null;
        long threadID = -1L;

        public ObservableLogHandler(Logger ... loggers) {
            this(loggers, (Thread)null);
        }

        public ObservableLogHandler(Logger[] loggers, Thread logThread) {
            this.loggers = loggers;
            for (Logger logger : loggers) {
                logger.addHandler(this.getHandler());
                logger.setLevel(Level.ALL);
            }
            Filter f = new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (ObservableLogHandler.this.threadID != -1L && (long)record.getThreadID() != ObservableLogHandler.this.threadID) {
                        return false;
                    }
                    if (ObservableLogHandler.this.filter == null) {
                        return true;
                    }
                    return ObservableLogHandler.this.filter.isLoggable(record);
                }
            };
            this.getHandler().setFilter(f);
        }

        public void setLogLevel(Level level) {
            for (Logger l : this.loggers) {
                l.setLevel(level);
            }
        }

        public void setThreadID(long id) {
            this.threadID = id;
        }

        public long getThreadID() {
            return this.threadID;
        }

        public void setFilter(Filter newFilter) {
            this.filter = newFilter;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public void cleanup() {
            for (Logger log : this.loggers) {
                log.removeHandler(this.handler);
            }
        }

        protected class DefaultHandler
        extends Handler {
            protected DefaultHandler() {
            }

            @Override
            public void publish(LogRecord record) {
                ObservableLogHandler.this.setChanged();
                ObservableLogHandler.this.notifyObservers(record.getMessage());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        }
    }
}

