/*
 * Decompiled with CFR 0.152.
 */
package jams.model;

import jams.model.FullModelState;
import jams.model.Model;
import jams.model.SmallModelState;
import jams.runtime.JAMSClassLoader;
import jams.runtime.JAMSRuntime;
import jams.runtime.RuntimeLogger;
import jams.runtime.StandardRuntime;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class JAMSFullModelState
implements FullModelState {
    private SmallModelState state;
    private byte[] data;

    public JAMSFullModelState(SmallModelState state, Model model) throws IOException {
        this.setSmallModelState(state);
        this.setModel(model);
    }

    public JAMSFullModelState(File file) throws ClassNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        ClassLoaderObjectInputStream objIn = new ClassLoaderObjectInputStream(fis);
        JAMSFullModelState _this = (JAMSFullModelState)objIn.readObject();
        this.state = _this.state;
        this.data = _this.data;
        objIn.close();
        fis.close();
    }

    public SmallModelState getSmallModelState() {
        return this.state;
    }

    public void setSmallModelState(SmallModelState state) {
        this.state = state;
    }

    public Model getModel() {
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.data);
        try {
            ClassLoaderObjectInputStream objIn = new ClassLoaderObjectInputStream(inStream);
            String[] libs = (String[])objIn.readObject();
            ClassLoader classLoader = JAMSClassLoader.createClassLoader(libs, new RuntimeLogger());
            objIn.setClassLoader(classLoader);
            Model model = (Model)objIn.readObject();
            objIn.close();
            inStream.close();
            return model;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return null;
        }
    }

    public void setModel(Model model) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(outStream);
        JAMSRuntime rt = model.getRuntime();
        if (rt instanceof StandardRuntime) {
            objOut.writeObject(((StandardRuntime)rt).getLibs());
        } else {
            objOut.writeObject(new String[1]);
        }
        objOut.writeObject(model);
        objOut.flush();
        outStream.flush();
        this.data = outStream.toByteArray();
        objOut.close();
        outStream.close();
    }

    public void writeToFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream objOut = new ObjectOutputStream(fos);
        objOut.writeObject(this);
        objOut.flush();
        fos.flush();
        fos.close();
    }

    public class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public ClassLoaderObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.classLoader = null;
        }

        public void setClassLoader(ClassLoader loader) {
            this.classLoader = loader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                if (this.classLoader == null) {
                    this.classLoader = Thread.currentThread().getContextClassLoader();
                }
                String name = desc.getName();
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(desc);
            }
        }
    }
}

