/*
 * Decompiled with CFR 0.152.
 */
package jams.dataaccess;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DataFactory;
import jams.data.JAMSData;
import jams.dataaccess.DataAccessor;

public class DoubleAccessor
implements DataAccessor {
    Attribute.Double componentObject;
    Attribute.Double[] entityObject;
    int index;
    int accessType;

    public DoubleAccessor(DataFactory dataFactory, Attribute.Entity[] entities, JAMSData dataObject, String attributeName, int accessType) throws Attribute.Entity.NoSuchAttributeException {
        this.entityObject = new Attribute.Double[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].existsAttribute(attributeName)) {
                try {
                    this.entityObject[i] = (Attribute.Double)entities[i].getObject(attributeName);
                }
                catch (Attribute.Entity.NoSuchAttributeException noSuchAttributeException) {}
                continue;
            }
            if (accessType != 0) {
                this.entityObject[i] = dataFactory.createDouble();
                entities[i].setObject(attributeName, (Object)this.entityObject[i]);
                continue;
            }
            throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + attributeName + JAMS.i18n("_does_not_exist!") + " (entity ID: " + entities[i].getId() + ")");
        }
        this.accessType = accessType;
        this.componentObject = (Attribute.Double)dataObject;
    }

    public void initEntityData() {
        for (Attribute.Double v : this.entityObject) {
            v.setValue(this.componentObject.getValue());
        }
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void read() {
        this.componentObject.setValue(this.entityObject[this.index].getValue());
    }

    public void write() {
        this.entityObject[this.index].setValue(this.componentObject.getValue());
    }

    public int getAccessType() {
        return this.accessType;
    }

    public JAMSData getComponentObject() {
        return this.componentObject;
    }
}

