/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4Group
extends Group {
    private static final long serialVersionUID = 3785240955078867900L;
    private List attributeList;
    private int nAttributes = -1;
    private static final long[] DEFAULT_OID = new long[]{0L, 0L};

    public H4Group(FileFormat theFile, String name, String path, Group parent) {
        this(theFile, name, path, parent, null);
    }

    public H4Group(FileFormat theFile, String name, String path, Group parent, long[] oid) {
        super(theFile, name, path, parent, oid == null ? DEFAULT_OID : oid);
    }

    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int vgid = this.open();
            try {
                this.nAttributes = HDFLibrary.Vnattrs((int)vgid);
                this.nMembersInFile = HDFLibrary.Vntagrefs((int)vgid);
            }
            catch (Exception ex) {
                this.nAttributes = 0;
            }
            this.close(vgid);
        }
        return this.nAttributes > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        this.attributeList = new Vector();
        int vgid = this.open();
        if (vgid <= 0) {
            return this.attributeList;
        }
        int n = -1;
        try {
            n = HDFLibrary.Vnattrs((int)vgid);
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[3];
            for (int i = 0; i < n; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.Vattrinfo((int)vgid, (int)i, (String[])attrName, (int[])attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], (Datatype)new H4Datatype(attrInfo[0]), attrDims);
                this.attributeList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.Vgetattr((int)vgid, (int)i, (Object)buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])((byte[])buf), (int)attrInfo[1]);
                }
                attr.setValue((Object)buf);
            }
        }
        finally {
            this.close(vgid);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute((HObject)this, (Attribute)info, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(info);
    }

    public void removeMetadata(Object info) throws HDFException {
    }

    public int open() {
        int vgid = -1;
        try {
            vgid = HDFLibrary.Vattach((int)this.getFID(), (int)((int)this.oid[1]), (String)"w");
        }
        catch (HDFException ex) {
            vgid = -1;
        }
        if (vgid < 0) {
            try {
                vgid = HDFLibrary.Vattach((int)this.getFID(), (int)((int)this.oid[1]), (String)"r");
            }
            catch (HDFException ex) {
                vgid = -1;
            }
        }
        return vgid;
    }

    public void close(int vgid) {
        try {
            HDFLibrary.Vdetach((int)vgid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static H4Group create(String name, Group pgroup) throws Exception {
        int fileid;
        H4Group group = null;
        if (pgroup == null || name == null) {
            return null;
        }
        H4File file = (H4File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            path = pgroup.getPath() + pgroup.getName() + "/";
        }
        if ((fileid = file.open()) < 0) {
            return null;
        }
        int gid = HDFLibrary.Vattach((int)fileid, (int)-1, (String)"w");
        if (gid < 0) {
            return null;
        }
        HDFLibrary.Vsetname((int)gid, (String)name);
        int ref = HDFLibrary.VQueryref((int)gid);
        int tag = HDFLibrary.VQuerytag((int)gid);
        if (!pgroup.isRoot()) {
            int pid = pgroup.open();
            if (pid < 0) {
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vinsert((int)pid, (int)gid);
            pgroup.close(pid);
        }
        try {
            HDFLibrary.Vdetach((int)gid);
        }
        catch (Exception ex) {
            // empty catch block
        }
        long[] oid = new long[]{tag, ref};
        group = new H4Group(file, name, path, pgroup, oid);
        if (group != null) {
            pgroup.addToMemberList((HObject)group);
        }
        return group;
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

