/*
 * Decompiled with CFR 0.152.
 */
package jams.server.entities;

import jams.server.entities.File;
import jams.server.entities.Workspace;
import jams.tools.FileTools;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Table(name="file2ws")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="WorkspaceFileAssociation.findByFile", query="SELECT u FROM WorkspaceFileAssociation u WHERE u.file_id = :fid")})
@Entity
public class WorkspaceFileAssociation
implements Serializable,
Comparable<WorkspaceFileAssociation> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Column(name="ws_id")
    private Integer ws_id;
    @Column(name="file_id")
    private Integer file_id;
    @Column(name="role")
    @Basic(optional=true)
    private Integer role;
    @Column(name="path")
    @Size(min=0, max=1000)
    @Basic(optional=false)
    private String path;
    @ManyToOne
    @PrimaryKeyJoinColumn(name="ws_id", referencedColumnName="ID")
    private Workspace ws;
    @ManyToOne
    @PrimaryKeyJoinColumn(name="file_id", referencedColumnName="ID")
    private File file;
    public static final transient int ROLE_INPUT = 0;
    public static final transient int ROLE_OUTPUT = 1;
    public static final transient int ROLE_MODEL = 2;
    public static final transient int ROLE_CONFIG = 3;
    public static final transient int ROLE_OTHER = 4;
    public static final transient int ROLE_COMPONENTSLIBRARY = 5;
    public static final transient int ROLE_RUNTIMELIBRARY = 6;
    public static final transient int ROLE_EXECUTABLE = 7;
    public static final transient int ROLE_JAPFILE = 8;

    public WorkspaceFileAssociation() {
    }

    public WorkspaceFileAssociation(Workspace ws, File f, String path) {
        this.file_id = f.getId();
        this.ws_id = ws.getId();
        this.file = f;
        this.ws = ws;
        this.role = 0;
        this.setPath(path);
    }

    public WorkspaceFileAssociation(Workspace ws, File f, int role, String path) {
        this.file_id = f.getId();
        this.ws_id = ws.getId();
        if (this.ws_id == 0) {
            System.out.println("test");
        }
        this.file = f;
        this.ws = ws;
        this.role = role;
        this.setPath(path);
    }

    @XmlTransient
    public Workspace getWorkspace() {
        return this.ws;
    }

    public void setWorkspace(Workspace ws) {
        this.ws = ws;
        this.ws_id = ws != null ? ws.getId() : Integer.valueOf(0);
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        if (parent != null && parent instanceof Workspace) {
            this.ws = (Workspace)parent;
        }
    }

    public Integer getID() {
        return this.id;
    }

    public void setID(Integer id) {
        this.id = id;
    }

    @XmlElement(name="file", type=File.class)
    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
        this.file_id = f != null ? this.file.getId() : Integer.valueOf(0);
    }

    public void setRole(int role) {
        this.role = role;
    }

    @XmlAttribute
    public int getRole() {
        return this.role;
    }

    public void setPath(String path) {
        this.path = FileTools.normalizePath((String)path);
    }

    public String getPath() {
        return this.path;
    }

    public String getFileExtension() {
        int lastDot = this.path.lastIndexOf(".");
        if (lastDot != -1) {
            return this.path.substring(lastDot, this.path.length());
        }
        return "";
    }

    public String getFileName() {
        int index = Math.max(this.path.lastIndexOf("/"), this.path.lastIndexOf("\\"));
        if (index == -1) {
            return this.path;
        }
        return this.path.substring(index + 1, this.path.length());
    }

    public String getFileDirectory() {
        int lastSlash = Math.max(this.path.lastIndexOf("/"), this.path.lastIndexOf("\\"));
        if (lastSlash != -1) {
            return this.path.substring(0, lastSlash + 1);
        }
        return "/";
    }

    public int hashCode() {
        int hash = 0;
        hash += this.ws_id != null ? this.ws_id : 0;
        hash += this.file_id != null ? this.file_id : 0;
        hash += this.id != null ? this.id : 0;
        return hash += this.path != null ? this.path.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WorkspaceFileAssociation)) {
            return false;
        }
        return this.compareTo((WorkspaceFileAssociation)object) == 0;
    }

    public String toString() {
        return "jams.server.entities.WorkspaceFileAssociation[ ws->file = [" + this.ws_id + "->" + this.file_id + "]";
    }

    @Override
    public int compareTo(WorkspaceFileAssociation o) {
        if (this.getID() == null || o.getID() == null) {
            return Integer.compare(this.hashCode(), o.hashCode());
        }
        return Integer.compare(this.getID(), o.getID());
    }
}

