/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import java.lang.reflect.Array;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNativeData;
import ncsa.hdf.hdflib.TabDescriptor;

public class HDFTable {
    TabDescriptor _desc = null;

    void init() throws IllegalAccessException, HDFException {
        this._desc = new TabDescriptor(this);
    }

    public int size() throws HDFException, IllegalAccessException {
        if (this._desc == null) {
            this.init();
        }
        return this._desc.totalsize;
    }

    public byte[] byteify() throws IllegalAccessException, HDFException {
        if (this._desc == null) {
            this.init();
        }
        byte[] array = new byte[this._desc.totalsize];
        int pos = 0;
        for (int i = 0; i < this._desc.nfields; ++i) {
            this.getfield(this._desc.fldType[i], this._desc.flds[i].get(this), array, pos);
            pos += this._desc.fldLen[i];
        }
        return array;
    }

    void getfield(Class theType, Object obj, byte[] barray, int offset) throws HDFException {
        String type = theType.getName();
        if (type.equals("int")) {
            byte[] arow = HDFNativeData.intToByte((Integer)obj);
            System.arraycopy(arow, 0, barray, offset, 4);
            return;
        }
        if (type.equals("byte")) {
            byte f;
            barray[offset] = f = ((Byte)obj).byteValue();
            return;
        }
        if (type.equals("short")) {
            byte[] arow = HDFNativeData.shortToByte((Short)obj);
            System.arraycopy(arow, 0, barray, offset, 2);
            return;
        }
        if (type.equals("float")) {
            byte[] arow = HDFNativeData.floatToByte((Float)obj);
            System.arraycopy(arow, 0, barray, offset, 4);
            return;
        }
        if (type.equals("long")) {
            byte[] arow = HDFNativeData.longToByte((Long)obj);
            System.arraycopy(arow, 0, barray, offset, 8);
            return;
        }
        if (type.equals("double")) {
            byte[] arow = HDFNativeData.doubleToByte((Double)obj);
            System.arraycopy(arow, 0, barray, offset, 8);
            return;
        }
        if (type.equals("java.lang.String")) {
            byte[] arow = ((String)obj).getBytes();
            System.arraycopy(arow, 0, barray, offset, Array.getLength(arow));
            return;
        }
        if (type.startsWith("[")) {
            if (!obj.getClass().isArray()) {
                HDFJavaException ex = new HDFJavaException("HDFTable: getfield not an array?: " + theType + " " + type);
                throw ex;
            }
            HDFArray aa = new HDFArray(obj);
            byte[] arow = aa.byteify();
            System.arraycopy(arow, 0, barray, offset, Array.getLength(arow));
            return;
        }
        HDFJavaException ex = new HDFJavaException("HDFTable: getfield unsupported type?: " + theType + " " + type);
        throw ex;
    }

    public void structify(byte[] theBytes) throws HDFException, IllegalAccessException {
        if (this._desc == null) {
            this.init();
        }
        int pos = 0;
        for (int i = 0; i < this._desc.nfields; ++i) {
            Object v = this.setfield(this._desc.fldTypeName[i], this._desc.flds[i].get(this), theBytes, pos, this._desc.fldLen[i]);
            this._desc.flds[i].set(this, v);
            pos += this._desc.fldLen[i];
        }
    }

    Object setfield(String type, Object obj, byte[] barray, int offset, int maxlen) throws HDFException {
        if (type.equals("int")) {
            int[] f = HDFNativeData.byteToInt(offset, 1, barray);
            return new Integer(f[0]);
        }
        if (type.equals("byte")) {
            byte[] f = new byte[]{(Byte)obj};
            return new Byte(f[0]);
        }
        if (type.equals("short")) {
            short[] f = HDFNativeData.byteToShort(offset, 1, barray);
            return new Short(f[0]);
        }
        if (type.equals("float")) {
            float[] f = HDFNativeData.byteToFloat(offset, 1, barray);
            return new Float(f[0]);
        }
        if (type.equals("long")) {
            long[] f = HDFNativeData.byteToLong(offset, 1, barray);
            return new Long(f[0]);
        }
        if (type.equals("double")) {
            double[] f = HDFNativeData.byteToDouble(offset, 1, barray);
            return new Double(f[0]);
        }
        if (type.equals("java.lang.String")) {
            if (((String)obj).length() > maxlen) {
                HDFJavaException ex = new HDFJavaException("HDFTable: setfield string is too big?: " + obj + " " + type);
                throw ex;
            }
            String ss = new String(barray, offset, ((String)obj).length());
            return ss;
        }
        if (type.startsWith("[")) {
            if (!obj.getClass().isArray()) {
                HDFJavaException ex = new HDFJavaException("HDFTable: setfield type is not array?: " + obj + " " + type);
                throw ex;
            }
            HDFArray aa = new HDFArray(obj);
            if (Array.getLength(obj) > maxlen) {
                HDFJavaException ex = new HDFJavaException("HDFTable: setfield array too big?: " + obj + " " + type);
                throw ex;
            }
            byte[] b = new byte[maxlen];
            System.arraycopy(barray, offset, b, 0, maxlen);
            Object o = aa.arrayify(b);
            return o;
        }
        HDFJavaException ex = new HDFJavaException("HDFTable: setfield bad type: " + obj + " " + type);
        throw ex;
    }

    static {
        String string = HDFLibrary.getJHIVersion();
    }
}

