/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.tools;

import jams.JAMSLogging;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public class ShapeFileWriter {
    private URI inShapefileURI = null;
    private URI outShapefileURI = null;
    private String targetKeyName = null;
    private String[] names;
    private double[] ids;
    private double[][] data;

    public ShapeFileWriter() {
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(ShapeFileWriter.class.getName()));
    }

    public String getTargetKeyName() {
        return this.targetKeyName;
    }

    public void setTargetKeyName(String targetKeyName) {
        this.targetKeyName = targetKeyName;
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] data) {
        this.data = data;
    }

    public double[] getIds() {
        return this.ids;
    }

    public void setIds(double[] ids) {
        this.ids = ids;
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public URI getInShapefileURI() {
        return this.inShapefileURI;
    }

    public void setInShapefileURI(URI shapefileURI) {
        this.inShapefileURI = shapefileURI;
    }

    public URI getOutShapefileURI() {
        return this.outShapefileURI;
    }

    public void setOutShapefileURI(URI outShapefileURI) {
        this.outShapefileURI = outShapefileURI;
    }

    public void writeShape() throws MalformedURLException, IOException {
        Logger.getLogger(ShapeFileWriter.class.getName()).log(Level.INFO, "Trying to create shapefile " + new File(this.outShapefileURI).getAbsolutePath() + " based on " + new File(this.inShapefileURI).getAbsolutePath() + ".");
        File targetFile = new File(this.outShapefileURI);
        if (!targetFile.canWrite() && !targetFile.getParentFile().canWrite()) {
            Logger.getLogger(ShapeFileWriter.class.getName()).log(Level.WARNING, "Target file " + targetFile.getPath() + " is not writable. No output written!");
            return;
        }
        HashMap<Long, double[]> idMap = new HashMap<Long, double[]>();
        int n = this.data.length;
        for (int i = 0; i < this.ids.length; ++i) {
            double[] values = new double[n];
            for (int j = 0; j < n; ++j) {
                values[j] = this.data[j][i];
            }
            idMap.put((long)this.ids[i], values);
        }
        ShapefileDataStore store = new ShapefileDataStore(this.inShapefileURI.toURL());
        String typeName = store.getTypeNames()[0];
        FeatureSource source = store.getFeatureSource();
        FeatureCollection featureCollection = source.getFeatures();
        SimpleFeatureType sourceSchema = (SimpleFeatureType)featureCollection.getSchema();
        if (sourceSchema.getDescriptor(this.targetKeyName) == null) {
            Logger.getLogger(ShapeFileWriter.class.getName()).log(Level.WARNING, "Attribute name " + this.targetKeyName + " does not exist in Shapefile " + new File(this.inShapefileURI) + ". No output written!");
            return;
        }
        SimpleFeatureType targetSchema = this.createFeatureType((FeatureType)sourceSchema);
        AttributeDescriptor idProperty = targetSchema.getDescriptor(this.targetKeyName);
        String attribs = "";
        for (PropertyDescriptor d : targetSchema.getDescriptors()) {
            if (idProperty == d) {
                attribs = attribs + "\t" + d.getName() + "\t(link attribute)\n";
                continue;
            }
            attribs = attribs + "\t" + d.getName() + "\n";
        }
        Logger.getLogger(ShapeFileWriter.class.getName()).log(Level.INFO, "The following attributes are written:\n" + attribs);
        FeatureCollection targetFeatureCollection = FeatureCollections.newCollection();
        int i = 0;
        FeatureIterator fi = featureCollection.features();
        while (fi.hasNext()) {
            SimpleFeature feature = (SimpleFeature)fi.next();
            SimpleFeature targetFeature = SimpleFeatureBuilder.template((SimpleFeatureType)targetSchema, (String)Integer.toString(++i));
            for (PropertyDescriptor d : sourceSchema.getDescriptors()) {
                targetFeature.setAttribute(d.getName(), feature.getAttribute(d.getName()));
            }
            String idString = feature.getAttribute(this.targetKeyName).toString();
            long id = Long.parseLong(idString);
            double[] values = (double[])idMap.get(id);
            if (values != null) {
                for (int j = 0; j < n; ++j) {
                    targetFeature.setAttribute(this.names[j], (Object)values[j]);
                }
            }
            targetFeatureCollection.add((Feature)targetFeature);
        }
        ShapefileDataStore newShapefileDataStore = new ShapefileDataStore(this.outShapefileURI.toURL());
        newShapefileDataStore.createSchema(targetSchema);
        FeatureSource newFeatureSource = newShapefileDataStore.getFeatureSource();
        FeatureStore newFeatureStore = (FeatureStore)newFeatureSource;
        Transaction t = newFeatureStore.getTransaction();
        newFeatureStore.addFeatures(targetFeatureCollection);
        t.commit();
        t.close();
        Logger.getLogger(ShapeFileWriter.class.getName()).log(Level.INFO, "Succesfully wrote " + i + " shapes to " + targetFile.getPath() + "!");
    }

    private SimpleFeatureType createFeatureType(FeatureType inSchema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(inSchema.getName());
        builder.setCRS(inSchema.getCoordinateReferenceSystem());
        for (PropertyDescriptor d : inSchema.getDescriptors()) {
            builder.add((AttributeDescriptor)d);
        }
        for (String name : this.names) {
            builder.add(name, Double.class);
        }
        return builder.buildFeatureType();
    }
}

