/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.spreadsheet;

import jams.data.Attribute;
import jams.data.JAMSCalendar;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.explorer.spreadsheet.JTSConfigurator;
import jams.explorer.spreadsheet.JXYConfigurator;
import jams.explorer.spreadsheet.STPConfigurator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.XYSeries;
import org.jfree.util.ShapeUtilities;

public class GraphProperties {
    JTable table;
    TimeSeries ts;
    XYSeries xys;
    int index = 0;
    String legendName;
    int color;
    String name;
    int position;
    int type;
    int[] d_range = new int[2];
    boolean is_x_series = false;
    boolean result = false;
    boolean x_changed;
    int selectedColumn;
    int[] rowSelection;
    int x_series_col;
    String[] columns;
    String[] timeIntervals;
    int stroke_type;
    int shape_type;
    int size_type;
    int outline_type;
    int timeSTART;
    int timeEND;
    double data_range_start;
    double data_range_end;
    int plotType;
    JTSConfigurator ctsconf;
    JXYConfigurator cxyconf;
    STPConfigurator stpconf;
    double[] x_dataIntervals;
    double[] y_data;
    Stroke series_stroke;
    Shape series_shape;
    Color series_paint;
    Stroke series_outline_stroke;
    Color series_outline_paint;
    Color series_fill_paint;
    boolean outlineVisible;
    boolean linesVisible;
    boolean shapesVisible;
    HashMap<String, Color> colorTable = new HashMap();
    String[] headers;
    int columnCount = 0;
    int rowCount = 0;

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public GraphProperties(JTSConfigurator ctsconf) {
        this.plotType = 0;
        this.ctsconf = ctsconf;
        this.table = ctsconf.table;
        this.position = 0;
        this.name = "Graph Name";
        this.selectedColumn = 0;
        this.rowSelection = null;
        this.columnCount = this.table.getColumnCount();
        this.rowCount = this.table.getRowCount();
        this.timeIntervals = new String[this.table.getRowCount()];
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.timeIntervals[i] = this.table.getValueAt(i, 0).toString();
        }
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.colorTable.put("white", Color.WHITE);
        this.createProperties();
    }

    public GraphProperties(JXYConfigurator cxyconf) {
        this.plotType = 1;
        this.cxyconf = cxyconf;
        this.table = cxyconf.table;
        this.position = 0;
        this.legendName = this.name = "Graph Name";
        this.rowSelection = null;
        this.columnCount = this.table.getColumnCount();
        this.rowCount = this.table.getRowCount();
        this.rowSelection = this.table.getSelectedRows();
        this.x_series_col = this.table.getSelectedColumn();
        this.createProperties();
    }

    public GraphProperties(STPConfigurator stpconf) {
        this.plotType = 2;
        this.stpconf = stpconf;
        this.position = 0;
        this.legendName = this.name = "Graph Name";
        this.selectedColumn = 0;
        this.rowSelection = null;
        this.columnCount = stpconf.getColumnCount();
        this.rowCount = stpconf.getRowCount();
        this.timeIntervals = new String[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.timeIntervals[i] = stpconf.timeVector.get(i).toString();
        }
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.colorTable.put("white", Color.WHITE);
        this.createProperties();
    }

    public GraphProperties(JAMSSpreadSheet sheet, STPConfigurator stpconf) {
        this.plotType = 0;
        this.table = sheet.table;
        this.position = 0;
        this.legendName = this.name = "Graph Name";
        this.selectedColumn = 0;
        this.rowSelection = null;
        this.columnCount = this.table.getColumnCount();
        this.rowCount = this.table.getRowCount();
        this.timeIntervals = new String[this.table.getRowCount()];
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.timeIntervals[i] = this.table.getValueAt(i, 0).toString();
        }
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        this.colorTable.put("white", Color.WHITE);
        this.createProperties();
    }

    public void createProperties() {
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout());
        this.columns = new String[this.columnCount];
        block5: for (int i = 0; i < this.columnCount; ++i) {
            switch (this.plotType) {
                case 0: {
                    if (i != 0) {
                        this.columns[i] = this.table.getColumnName(i);
                        continue block5;
                    }
                    this.columns[i] = "---";
                    continue block5;
                }
                case 1: {
                    this.columns[i] = this.table.getColumnName(i);
                    continue block5;
                }
                case 2: {
                    this.columns = this.stpconf.getHeaders();
                }
            }
        }
    }

    public void setSelectedColumn(int column) {
        this.selectedColumn = column;
    }

    public void applyTSProperties() {
        try {
            this.ts = new TimeSeries((Comparable)((Object)this.getLegendName()), Second.class);
        }
        catch (IllegalArgumentException illex) {
            this.ts = new TimeSeries((Comparable)((Object)"timeseries"), Second.class);
        }
        for (int i = this.timeSTART; i <= this.timeEND; ++i) {
            JAMSCalendar time = (JAMSCalendar)this.table.getValueAt(i, 0);
            if (this.selectedColumn <= 0) continue;
            double value = (Double)this.table.getValueAt(i, this.selectedColumn);
            this.ts.addOrUpdate((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
        }
    }

    public void applyXYProperties() {
        this.xys = new XYSeries((Comparable)((Object)this.getLegendName()));
        for (int i = this.d_range[0]; i <= this.d_range[1]; ++i) {
            this.xys.add(this.cxyconf.sorted_Row[i].col[this.x_series_col], this.cxyconf.sorted_Row[i].col[this.selectedColumn]);
        }
    }

    public void applySTPProperties(Vector<double[]> rowVector, Vector<Attribute.Calendar> timeVector) {
        this.ts = new TimeSeries((Comparable)((Object)this.getLegendName()), Second.class);
        double[] row = new double[this.columnCount];
        for (int i = this.timeSTART; i <= this.timeEND; ++i) {
            row = rowVector.get(i);
            Attribute.Calendar time = timeVector.get(i);
            double value = row[this.selectedColumn];
            this.ts.add((RegularTimePeriod)new Second(new Date(time.getTimeInMillis())), value);
        }
    }

    public int getPlotType() {
        return this.plotType;
    }

    public String[] getTimeIntervals() {
        return this.timeIntervals;
    }

    public TimeSeries getTS() {
        return this.ts;
    }

    public XYSeries getXYS() {
        return this.xys;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setPossibleTimeIntervals() {
        int s = this.timeSTART;
        int e = this.timeEND;
        if (s >= e) {
            this.timeEND = s;
        }
    }

    public boolean isXSeries() {
        return this.is_x_series;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setIsXSeries(boolean xseries) {
        this.is_x_series = xseries;
    }

    public void setXSeries(int col) {
        this.x_series_col = col;
    }

    public int getXSeriesCol() {
        return this.x_series_col;
    }

    public void setXIntervals(int[] range) {
        this.d_range = range;
    }

    public void setXChanged(boolean state) {
        this.x_changed = state;
    }

    public void setSelectedRows(int[] rows) {
        this.rowSelection = rows;
    }

    public void setLegendName(String legendName) {
        this.legendName = legendName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setRendererType(int type) {
        this.type = type;
    }

    public void setTimeSTART(int index) {
        this.timeSTART = index;
    }

    public void setTimeEND(int index) {
        this.timeEND = index;
    }

    public void setDataSTART(double d_start) {
        this.data_range_start = d_start;
    }

    public void setDataEND(double d_end) {
        this.data_range_end = d_end;
    }

    public int getColor() {
        return this.color;
    }

    public String getLegendName() {
        return this.legendName;
    }

    public String getName() {
        return this.name;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public int[] getSelectedRows() {
        return this.rowSelection;
    }

    public int getPosition() {
        return this.position;
    }

    public int getRendererType() {
        return this.type;
    }

    public int getTimeSTART() {
        return this.timeSTART;
    }

    public int getTimeEND() {
        return this.timeEND;
    }

    public double getDataSTART() {
        return this.data_range_start;
    }

    public double getDataEND() {
        return this.data_range_end;
    }

    public void setSeriesStroke(Stroke stroke) {
        this.series_stroke = stroke;
    }

    public void setSeriesShape(Shape shape) {
        this.series_shape = shape;
    }

    public void setSeriesPaint(Color paint) {
        this.series_paint = paint;
    }

    public void setSeriesFillPaint(Color fill) {
        this.series_fill_paint = fill;
    }

    public void setSeriesOutlinePaint(Color out) {
        this.series_outline_paint = out;
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.series_outline_stroke = stroke;
    }

    public void setLinesVisible(boolean flag) {
        this.linesVisible = flag;
    }

    public void setShapesVisible(boolean flag) {
        this.shapesVisible = flag;
    }

    public void setStroke(int type) {
        float width;
        this.stroke_type = type;
        switch (type) {
            case 0: {
                width = 0.2f;
                break;
            }
            case 1: {
                width = 0.5f;
                break;
            }
            case 2: {
                width = 1.0f;
                break;
            }
            case 3: {
                width = 2.0f;
                break;
            }
            case 4: {
                width = 3.0f;
                break;
            }
            case 5: {
                width = 4.0f;
                break;
            }
            case 6: {
                width = 5.0f;
                break;
            }
            case 7: {
                width = 6.0f;
                break;
            }
            case 8: {
                width = 7.0f;
                break;
            }
            case 9: {
                width = 8.0f;
                break;
            }
            case 10: {
                width = 9.0f;
                break;
            }
            case 11: {
                width = 10.0f;
                break;
            }
            case 12: {
                width = 12.0f;
                break;
            }
            default: {
                width = 1.0f;
            }
        }
        this.setSeriesStroke(new BasicStroke(width));
    }

    public void setOutlineStroke(int type) {
        float width;
        this.outline_type = type;
        switch (type) {
            case 0: {
                width = 0.0f;
                break;
            }
            case 1: {
                width = 0.3f;
                break;
            }
            case 2: {
                width = 0.7f;
                break;
            }
            case 3: {
                width = 1.5f;
                break;
            }
            case 4: {
                width = 2.0f;
                break;
            }
            case 5: {
                width = 3.0f;
                break;
            }
            case 6: {
                width = 4.0f;
                break;
            }
            case 7: {
                width = 5.0f;
                break;
            }
            case 8: {
                width = 6.0f;
                break;
            }
            case 9: {
                width = 7.0f;
                break;
            }
            case 10: {
                width = 8.0f;
                break;
            }
            case 11: {
                width = 10.0f;
                break;
            }
            case 12: {
                width = 12.0f;
                break;
            }
            default: {
                width = 0.0f;
            }
        }
        if (width == 0.0f) {
            this.setOutlineVisible(false);
        } else {
            this.setOutlineVisible(true);
        }
        this.setSeriesOutlineStroke(new BasicStroke(width));
    }

    public void setOutlineVisible(boolean state) {
        this.outlineVisible = state;
    }

    public boolean getOutlineVisible() {
        return this.outlineVisible;
    }

    public void setShape(int type, int size) {
        this.shape_type = type;
        this.size_type = size;
        int dim = size;
        int coord = dim / 2;
        switch (type) {
            case 0: {
                this.setSeriesShape(new Rectangle(-coord, -coord, size, size));
                break;
            }
            case 1: {
                Ellipse2D.Double circle = new Ellipse2D.Double(-coord, -coord, size, size);
                this.setSeriesShape(circle);
                break;
            }
            case 2: {
                Shape up_triangle = ShapeUtilities.createUpTriangle((float)size);
                this.setSeriesShape(up_triangle);
                break;
            }
            case 3: {
                Shape down_triangle = ShapeUtilities.createDownTriangle((float)size);
                this.setSeriesShape(down_triangle);
                break;
            }
            case 4: {
                Shape diamond = ShapeUtilities.createDiamond((float)size);
                this.setSeriesShape(diamond);
                break;
            }
            case 5: {
                float t = (float)size * 0.07f;
                Shape diag_cross = ShapeUtilities.createDiagonalCross((float)size, (float)t);
                this.setSeriesShape(diag_cross);
                break;
            }
            case 6: {
                float d = (float)size * 0.07f;
                Shape reg_cross = ShapeUtilities.createRegularCross((float)size, (float)d);
                this.setSeriesShape(reg_cross);
                break;
            }
            default: {
                this.setSeriesShape(new Rectangle());
            }
        }
    }

    public int getStrokeType() {
        return this.stroke_type;
    }

    public int getShapeType() {
        return this.shape_type;
    }

    public int getSizeType() {
        return this.size_type;
    }

    public int getOutlineType() {
        return this.outline_type;
    }

    public Stroke getSeriesStroke() {
        return this.series_stroke;
    }

    public Shape getSeriesShape() {
        return this.series_shape;
    }

    public Color getSeriesPaint() {
        return this.series_paint;
    }

    public Color getSeriesFillPaint() {
        return this.series_fill_paint;
    }

    public Stroke getSeriesOutlineStroke() {
        return this.series_outline_stroke;
    }

    public Color getSeriesOutlinePaint() {
        return this.series_outline_paint;
    }

    public boolean getLinesVisible() {
        return this.linesVisible;
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    private void drawLegendItem() {
        JPanel pane = new JPanel();
        pane.setSize(20, 20);
    }
}

