/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMS;
import jams.explorer.gui.CancelableSwingWorker;
import jams.explorer.gui.DSPanel;
import jams.gui.tools.GUIHelper;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.SimpleSerieProcessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleDSPanel
extends DSPanel {
    private static final Dimension ACTION_BUTTON_DIM = new Dimension(150, 25);
    private static final Dimension LIST_DIMENSION = new Dimension(150, 250);
    private SimpleSerieProcessor proc;
    private GridBagLayout mainLayout;
    private JList timeList;
    private JList monthList;
    private JList yearList;
    private JTextField timeField;
    private JPanel aggregationPanel;
    private GridBagLayout aggregationLayout;
    private Action[] actions = new Action[]{new AbstractAction(JAMS.i18n((String)"SHOW_DATA")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.showData();
        }
    }, new AbstractAction(JAMS.i18n((String)"MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.showMean();
        }
    }, new AbstractAction(JAMS.i18n((String)"MONTHLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.showMonthlyMean();
        }
    }, new AbstractAction(JAMS.i18n((String)"YEARLY_MEAN")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.showYearlyMean();
        }
    }};
    private Action showData = this.actions[0];
    private Action mean = this.actions[1];
    private Action monthMean = this.actions[2];
    private Action yearMean = this.actions[3];
    private Action cacheReset = new AbstractAction(JAMS.i18n((String)"RESET_CACHES")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.resetCaches();
        }
    };
    private Action indexReset = new AbstractAction(JAMS.i18n((String)"RELOAD_INDEX")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.resetIndex();
        }
    };
    private Action freeTempMean = new AbstractAction(JAMS.i18n((String)"TEMP._MEAN_(FILTER)")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.showFreeTempMean();
        }
    };
    private Action loadParams = new AbstractAction(JAMS.i18n((String)"SAVE_PARAMS")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleDSPanel.this.loadParams();
        }
    };

    public SimpleDSPanel() {
        this.init();
    }

    private void init() {
        JButton button;
        for (Action a : this.actions) {
            a.setEnabled(false);
        }
        this.loadParams.setEnabled(false);
        this.freeTempMean.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.indexReset.setEnabled(false);
        this.mainLayout = new GridBagLayout();
        this.setLayout(this.mainLayout);
        this.timeList = new JList();
        JScrollPane timeListScroll = new JScrollPane(this.timeList);
        timeListScroll.setPreferredSize(LIST_DIMENSION);
        this.timeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (SimpleDSPanel.this.timeList.getSelectedValuesList().isEmpty()) {
                        SimpleDSPanel.this.mean.setEnabled(false);
                        SimpleDSPanel.this.showData.setEnabled(false);
                        SimpleDSPanel.this.loadParams.setEnabled(false);
                    } else if (SimpleDSPanel.this.timeList.getSelectedValuesList().size() == 1) {
                        SimpleDSPanel.this.showData.setEnabled(true);
                        SimpleDSPanel.this.mean.setEnabled(false);
                        SimpleDSPanel.this.loadParams.setEnabled(true);
                    } else {
                        SimpleDSPanel.this.mean.setEnabled(true);
                        SimpleDSPanel.this.showData.setEnabled(true);
                        SimpleDSPanel.this.loadParams.setEnabled(false);
                    }
                }
            }
        });
        this.monthList = new JList();
        this.monthList.setSelectionMode(0);
        JScrollPane monthListScroll = new JScrollPane(this.monthList);
        monthListScroll.setPreferredSize(new Dimension(SimpleDSPanel.LIST_DIMENSION.width - 100, SimpleDSPanel.LIST_DIMENSION.height));
        this.monthList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (SimpleDSPanel.this.monthList.getSelectedValues().length == 1) {
                        SimpleDSPanel.this.monthMean.setEnabled(true);
                    } else {
                        SimpleDSPanel.this.monthMean.setEnabled(false);
                    }
                }
            }
        });
        this.yearList = new JList();
        this.yearList.setSelectionMode(0);
        JScrollPane yearListScroll = new JScrollPane(this.yearList);
        yearListScroll.setPreferredSize(new Dimension(SimpleDSPanel.LIST_DIMENSION.width - 100, SimpleDSPanel.LIST_DIMENSION.height));
        this.yearList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (SimpleDSPanel.this.yearList.getSelectedValues().length == 1) {
                        SimpleDSPanel.this.yearMean.setEnabled(true);
                    } else {
                        SimpleDSPanel.this.yearMean.setEnabled(false);
                    }
                }
            }
        });
        GUIHelper.addGBComponent((Container)this, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"ATTRIBUTE/AGGREGATION:")), (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        this.aggregationLayout = new GridBagLayout();
        this.aggregationPanel = new JPanel();
        this.aggregationPanel.setLayout(this.aggregationLayout);
        JScrollPane aggregationScroll = new JScrollPane(this.aggregationPanel);
        aggregationScroll.setPreferredSize(new Dimension(SimpleDSPanel.LIST_DIMENSION.width + 100, SimpleDSPanel.LIST_DIMENSION.height));
        GUIHelper.addGBComponent((Container)this, (GridBagLayout)this.mainLayout, (Component)aggregationScroll, (int)0, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"IDS:")), (int)10, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this, (GridBagLayout)this.mainLayout, (Component)timeListScroll, (int)10, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        JPanel buttonPanelA = new JPanel();
        buttonPanelA.setPreferredSize(LIST_DIMENSION);
        for (int i = 0; i < 1; ++i) {
            Action a = this.actions[i];
            button = new JButton(a);
            button.setPreferredSize(ACTION_BUTTON_DIM);
            buttonPanelA.add(button);
        }
        JPanel filterPanel = new JPanel();
        filterPanel.setPreferredSize(new Dimension(SimpleDSPanel.LIST_DIMENSION.width, SimpleDSPanel.LIST_DIMENSION.height - 150));
        filterPanel.setBorder(BorderFactory.createEtchedBorder());
        filterPanel.add(new JLabel(JAMS.i18n((String)"FILTER:")));
        this.timeField = new JTextField();
        this.timeField.setEnabled(false);
        this.timeField.setToolTipText(JAMS.i18n((String)"DATE_EXPRESSION_WITH_WILDCARDS"));
        this.timeField.setPreferredSize(new Dimension(SimpleDSPanel.ACTION_BUTTON_DIM.width - 20, this.timeField.getPreferredSize().height));
        this.timeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                SimpleDSPanel.this.toggleFreeTempMeanButton();
            }
        });
        filterPanel.add(this.timeField);
        button = new JButton(this.freeTempMean);
        button.setPreferredSize(new Dimension(SimpleDSPanel.ACTION_BUTTON_DIM.width - 20, SimpleDSPanel.ACTION_BUTTON_DIM.height));
        filterPanel.add(button);
        buttonPanelA.add(filterPanel);
        button = new JButton(this.loadParams);
        button.setPreferredSize(ACTION_BUTTON_DIM);
        buttonPanelA.add(button);
        GUIHelper.addGBComponent((Container)this, (GridBagLayout)this.mainLayout, (Component)buttonPanelA, (int)40, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
    }

    public SimpleSerieProcessor getProc() {
        return this.proc;
    }

    private void createDB() {
        this.workerDlg.setInderminate(false);
        this.workerDlg.setTask(new CancelableSwingWorker(){

            @Override
            public int cancel() {
                SimpleDSPanel.this.dsdb.cancelCreateIndex();
                return -1;
            }

            public Object doInBackground() {
                try {
                    SimpleDSPanel.this.dsdb.createDB();
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SQLException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }
        });
        try {
            if (!this.dsdb.existsH2DB()) {
                this.workerDlg.execute();
            }
            if (!this.dsdb.existsH2DB()) {
                this.clearPanel();
            }
            this.setProc(new SimpleSerieProcessor(this.dsdb));
        }
        catch (SQLException sQLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetIndex() {
        try {
            this.dsdb.clearDB();
        }
        catch (SQLException ex) {
            Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.createDB();
    }

    private void setProc(SimpleSerieProcessor tsproc) throws SQLException, IOException {
        this.proc = tsproc;
        this.timeList.setModel(new AbstractListModel(){
            Object[] dates;
            {
                this.dates = SimpleDSPanel.this.getProc().getIDs();
            }

            @Override
            public int getSize() {
                return this.dates.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.dates[i];
            }
        });
        this.yearList.setModel(new AbstractListModel(){
            int[] years;
            {
                this.years = SimpleDSPanel.this.getProc().getYears();
            }

            @Override
            public int getSize() {
                return this.years.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.years[i];
            }
        });
        this.monthList.setModel(new AbstractListModel(){
            int[] months = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

            @Override
            public int getSize() {
                return this.months.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.months[i];
            }
        });
        if (!this.getProc().isTimeSerie()) {
            this.monthList.setEnabled(false);
            this.yearList.setEnabled(false);
        }
        JLabel label = new JLabel(JAMS.i18n((String)"AREA_ATTRIBUTE"));
        label.setHorizontalAlignment(2);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)5, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        ArrayList attribs = this.getProc().getDataStoreProcessor().getAttributes();
        label = new JLabel(JAMS.i18n((String)"AGGREGATION_WEIGHT"));
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)10, (int)3, (int)3, (int)1, (double)0.0, (double)0.0);
        label = new JLabel("1");
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)10, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        label = new JLabel("l->mm");
        label.setHorizontalAlignment(0);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)label, (int)11, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        int i = 0;
        ArrayList<JCheckBox> allChecks = new ArrayList<JCheckBox>();
        for (Object attrib : attribs) {
            DSPanel.AttribCheckBox attribCheck = new DSPanel.AttribCheckBox((AbstractDataStoreProcessor.AttributeData)attrib, attrib.getName());
            attribCheck.setSelected(attrib.isSelected());
            attribCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DSPanel.AttribCheckBox thisCheck = (DSPanel.AttribCheckBox)e.getSource();
                    if (!thisCheck.isSelected() && SimpleDSPanel.this.attribCombo.getSelectedItem().toString().equals(thisCheck.getText())) {
                        SimpleDSPanel.this.attribCombo.setSelectedIndex(0);
                        GUIHelper.showInfoDlg((Component)SimpleDSPanel.this.parent, (String)JAMS.i18n((String)"AREA_ATTRIBUTE_HAS_BEEN_RESET!"), (String)JAMS.i18n((String)"INFO"));
                    }
                    thisCheck.attrib.setSelected(thisCheck.isSelected());
                }
            });
            allChecks.add(attribCheck);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)attribCheck, (int)5, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0);
            DSPanel.AttribRadioButton button1 = new DSPanel.AttribRadioButton((AbstractDataStoreProcessor.AttributeData)attrib, 1);
            DSPanel.AttribRadioButton button2 = new DSPanel.AttribRadioButton((AbstractDataStoreProcessor.AttributeData)attrib, 2);
            button1.setSelected(true);
            ItemListener attribRadioButtonListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    DSPanel.AttribRadioButton thisButton = (DSPanel.AttribRadioButton)e.getSource();
                    thisButton.attrib.setAggregationType(thisButton.processingType);
                    SimpleDSPanel.this.setCheckBox(thisButton.attrib.getName());
                }
            };
            button1.addItemListener(attribRadioButtonListener);
            button2.addItemListener(attribRadioButtonListener);
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(button1);
            bGroup.add(button2);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)button1, (int)10, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)button2, (int)11, (int)(i + 10), (int)1, (int)1, (double)0.0, (double)0.0);
            ++i;
        }
        String[] attribNames = new String[attribs.size() + 1];
        attribNames[0] = JAMS.i18n((String)"[CHOOSE]");
        i = 1;
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            attribNames[i++] = attrib.getName();
        }
        this.attribCombo = new DSPanel.AttribComboBox(allChecks);
        this.attribCombo.setModel(new DefaultComboBoxModel<String>(attribNames));
        this.attribCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DSPanel.AttribComboBox thisCombo = (DSPanel.AttribComboBox)e.getSource();
                SimpleDSPanel.this.setCheckBox(thisCombo.getSelectedItem().toString());
            }
        });
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)this.attribCombo, (int)10, (int)0, (int)5, (int)1, (double)0.0, (double)0.0);
        DSPanel.GroupCheckBox allOnOffCheck = new DSPanel.GroupCheckBox(JAMS.i18n((String)"ALL_ON/OFF"), allChecks);
        allOnOffCheck.setSelected(false);
        GUIHelper.addGBComponent((Container)this.aggregationPanel, (GridBagLayout)this.aggregationLayout, (Component)allOnOffCheck, (int)5, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        allOnOffCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DSPanel.GroupCheckBox thisCheck = (DSPanel.GroupCheckBox)e.getSource();
                boolean selected = thisCheck.isSelected();
                ArrayList<JCheckBox> allChecks = thisCheck.checkBoxList;
                for (JCheckBox checkBox : allChecks) {
                    checkBox.setSelected(selected);
                }
            }
        });
        this.aggregationPanel.updateUI();
        this.cacheReset.setEnabled(true);
        this.timeField.setEnabled(true);
        this.indexReset.setEnabled(true);
        tsproc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SimpleDSPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
    }

    private boolean setCheckBox(String theLabel) {
        for (JCheckBox check : this.attribCombo.checkBoxList) {
            if (!theLabel.equals(check.getText())) continue;
            check.setSelected(true);
            return true;
        }
        return false;
    }

    private void clearPanel() {
        this.timeList.setEnabled(false);
        this.yearList.setEnabled(false);
        this.monthList.setEnabled(false);
        this.cacheReset.setEnabled(false);
        this.timeField.setEnabled(false);
        this.indexReset.setEnabled(false);
    }

    private void showData() {
        if (this.timeList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;

            public Object doInBackground() {
                try {
                    SimpleSerieProcessor proc = SimpleDSPanel.this.getProc();
                    Object[] objects = SimpleDSPanel.this.timeList.getSelectedValues();
                    String[] ids = new String[objects.length];
                    int c = 0;
                    for (Object o : objects) {
                        ids[c++] = o.toString();
                    }
                    this.m = proc.getData(ids);
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                SimpleDSPanel.this.loadData(this.m, SimpleDSPanel.this.proc.isTimeSerie());
            }

            @Override
            public int cancel() {
                SimpleDSPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showMonthlyMean() {
        if (this.monthList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int month = (Integer)SimpleDSPanel.this.monthList.getSelectedValue();
                    SimpleDSPanel.this.workerDlg.setInderminate(true);
                    this.m = SimpleDSPanel.this.getProc().getMonthlyMean(month);
                }
                catch (SQLException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                SimpleDSPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                SimpleDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showYearlyMean() {
        if (this.yearList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m;

            public Object doInBackground() {
                try {
                    int year = (Integer)SimpleDSPanel.this.yearList.getSelectedValue();
                    this.m = SimpleDSPanel.this.proc.getYearlyMean(year);
                    SimpleDSPanel.this.workerDlg.setInderminate(true);
                }
                catch (SQLException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(SimpleDSPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void done() {
                SimpleDSPanel.this.loadData(this.m, false);
            }

            @Override
            public int cancel() {
                SimpleDSPanel.this.proc.sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showMean() {
        if (this.timeList.getSelectedValues().length == 0) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;

            public Object doInBackground() {
                try {
                    SimpleSerieProcessor proc = SimpleDSPanel.this.getProc();
                    Object[] objects = SimpleDSPanel.this.timeList.getSelectedValues();
                    String[] ids = new String[objects.length];
                    int c = 0;
                    for (Object o : objects) {
                        ids[c++] = o.toString();
                    }
                    this.m = proc.getMean(ids);
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                SimpleDSPanel.this.loadData(this.m, true);
            }

            @Override
            public int cancel() {
                SimpleDSPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void loadParams() {
        if (this.timeList.getSelectedValuesList().isEmpty()) {
            return;
        }
        this.workerDlg.setInderminate(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setTask(new CancelableSwingWorker(){
            DataMatrix m = null;

            public Object doInBackground() {
                try {
                    SimpleSerieProcessor proc = SimpleDSPanel.this.getProc();
                    Object[] objects = SimpleDSPanel.this.timeList.getSelectedValues();
                    String[] ids = new String[objects.length];
                    int c = 0;
                    for (Object o : objects) {
                        ids[c++] = o.toString();
                    }
                    this.m = proc.getData(ids);
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                int i = 0;
                String s = "";
                for (String attrib : SimpleDSPanel.this.dsdb.getSelectedDoubleAttribs()) {
                    s = s + attrib.replace("___", ".") + "=" + this.m.get(0, i++) + "\n";
                }
                JFileChooser jfc = new JFileChooser(SimpleDSPanel.this.explorer.getWorkspace().getDirectory());
                jfc.setSelectedFile(new File(SimpleDSPanel.this.explorer.getWorkspace().getDirectory(), "opt_params_" + SimpleDSPanel.this.timeList.getSelectedValue() + ".jmp"));
                if (jfc.showSaveDialog(SimpleDSPanel.this.explorer.getExplorerFrame()) == 0) {
                    try (PrintWriter out = null;){
                        out = new PrintWriter(jfc.getSelectedFile());
                        out.println(s);
                        out.close();
                    }
                }
            }

            @Override
            public int cancel() {
                SimpleDSPanel.this.getProc().sendAbortOperation();
                return 0;
            }
        });
        this.workerDlg.execute();
    }

    private void showFreeTempMean() {
        String filter = this.timeField.getText();
        if (filter.isEmpty()) {
            return;
        }
        filter = filter.replaceAll("\\*", ".*");
        ListModel model = this.timeList.getModel();
        ArrayList<Integer> a = new ArrayList<Integer>();
        for (int i = 0; i < model.getSize(); ++i) {
            String item = model.getElementAt(i).toString();
            if (!item.matches(filter)) continue;
            a.add(i);
        }
        int[] indices = new int[a.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)a.get(i);
        }
        this.timeList.setSelectedIndices(indices);
    }

    private void toggleFreeTempMeanButton() {
        String filter = this.timeField.getText();
        if (filter.isEmpty()) {
            this.freeTempMean.setEnabled(false);
        } else {
            this.freeTempMean.setEnabled(true);
        }
    }

    private void resetCaches() {
    }

    @Override
    public void createProc(File file) {
        this.workerDlg.setTitle(this.workerDlg.getTitle() + " [" + file.getName() + "]");
        this.dsdb = AbstractDataStoreProcessor.getProcessor((File)file);
        this.dsdb.addImportProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SimpleDSPanel.this.workerDlg.setProgress(Integer.parseInt(arg.toString()));
            }
        });
        this.createDB();
        this.outputDSFile = file;
    }
}

