/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMSException;
import jams.JAMSLogging;
import jams.explorer.JAMSExplorer;
import jams.explorer.gui.DSPanel;
import jams.explorer.gui.EnsembleTimeSeriesPanel;
import jams.explorer.gui.SimpleDSPanel;
import jams.explorer.gui.TimeSpaceDSPanel;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OutputDSPanel
extends JPanel {
    private JAMSSpreadSheet spreadsheet;

    public OutputDSPanel(JAMSExplorer explorer, File file, String id) {
        this.setLayout(new BorderLayout());
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(OutputDSPanel.class.getName()));
        this.spreadsheet = new JAMSSpreadSheet(explorer);
        this.spreadsheet.init();
        this.spreadsheet.setAsOutputSheet();
        this.spreadsheet.setID(id);
        this.setName(file.getName());
        DSPanel tsp = null;
        switch (AbstractDataStoreProcessor.getDataStoreType((File)file)) {
            case Unsupported: {
                Logger.getLogger(OutputDSPanel.class.getName()).log(Level.WARNING, "Unsupported datastore");
                break;
            }
            case TimeDataSerie: {
                tsp = new EnsembleTimeSeriesPanel();
                break;
            }
            case SpatioTemporal: {
                tsp = new TimeSpaceDSPanel();
                break;
            }
            case DataSerie1D: {
                tsp = new SimpleDSPanel();
                break;
            }
            case Timeserie: {
                tsp = new SimpleDSPanel();
                break;
            }
            default: {
                Logger.getLogger(OutputDSPanel.class.getName()).log(Level.WARNING, "Unsupported datastore");
            }
        }
        if (tsp == null) {
            throw new JAMSException("Unsupported datastore");
        }
        tsp.setExplorer(explorer);
        tsp.setOutputSpreadSheet(this.spreadsheet);
        tsp.createProc(file);
        JSplitPane split = new JSplitPane(0);
        split.add(tsp);
        split.add(this.spreadsheet);
        split.setDividerLocation(300);
        this.add((Component)split, "Center");
    }

    public JAMSSpreadSheet getSpreadsheet() {
        return this.spreadsheet;
    }
}

