/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMS;
import jams.gui.WorkerDlg;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import optas.data.DataCollection;
import optas.io.ImportMonteCarloData;
import optas.io.ImportMonteCarloException;

public class ImportMonteCarloDataPanel
extends JPanel {
    Dimension defaultDatasetTable = new Dimension(500, 200);
    Dimension defaultWindowSize = new Dimension(550, 290);
    JPanel dataPanel = null;
    JComboBox mergeModeBox = new JComboBox<String>(new String[]{JAMS.i18n((String)"Attach_Mode"), JAMS.i18n((String)"Unify_Mode")});
    ArrayList<ActionListener> listenerList = new ArrayList();
    HashMap<AbstractDataStoreProcessor.AttributeData, JComboBox> attributeComboBoxMap = new HashMap();
    JFrame owner;
    JDialog ownerDlg = null;
    DataCollection importedCollection = null;
    ImportMonteCarloData importer = null;
    DataCollection finalEnsemble = null;

    public ImportMonteCarloDataPanel(JFrame owner) {
        this.owner = owner;
        this.importer = new ImportMonteCarloData();
        this.init();
    }

    public ImportMonteCarloDataPanel(JFrame owner, DataCollection dc) {
        this.owner = owner;
        this.importer = new ImportMonteCarloData();
        this.finalEnsemble = dc;
        this.init();
    }

    public ImportMonteCarloDataPanel(JFrame owner, DataCollection dc, File file) {
        this.owner = owner;
        this.importer = new ImportMonteCarloData();
        this.finalEnsemble = dc;
        if (file.getAbsolutePath().endsWith("cdat")) {
            this.importedCollection = DataCollection.createFromFile((File)file);
        }
        this.init();
        if (!file.getAbsolutePath().endsWith("cdat")) {
            this.addFile(file);
        }
    }

    private void showError(ImportMonteCarloException imce) {
        JOptionPane.showMessageDialog(this.dataPanel, imce.toString(), JAMS.i18n((String)"An_error_occured..."), 0);
    }

    public JDialog getDialog() {
        this.ownerDlg = new JDialog((Frame)this.owner, JAMS.i18n((String)"Import_Ensemble_Data"));
        this.ownerDlg.add(this);
        this.ownerDlg.setPreferredSize(this.defaultWindowSize);
        this.ownerDlg.setMinimumSize(this.defaultWindowSize);
        return this.ownerDlg;
    }

    private MergeMode getMergeMode() {
        if (this.mergeModeBox.getSelectedIndex() == 0) {
            return MergeMode.ATTACH;
        }
        return MergeMode.UNIFY;
    }

    public boolean isEmpty() {
        return this.importer.isEmpty();
    }

    private void updateDataTable() {
        this.dataPanel.removeAll();
        this.dataPanel.setLayout(new GridBagLayout());
        TreeSet attributes = this.importer.getAttributeData();
        int counter = 0;
        for (AbstractDataStoreProcessor.AttributeData a : attributes) {
            Processor p = this.importer.getProcessorForAttribute(a);
            JComboBox<EnsembleTypeStringMap> typeSelection = this.attributeComboBoxMap.get(a);
            if (typeSelection == null) {
                ImportMonteCarloData.EnsembleType[] options = this.importer.getValidProcessingOptions(p);
                EnsembleTypeStringMap[] maps = new EnsembleTypeStringMap[options.length];
                for (int i = 0; i < options.length; ++i) {
                    maps[i] = new EnsembleTypeStringMap(options[i]);
                }
                typeSelection = new JComboBox<EnsembleTypeStringMap>(maps);
                if (this.importer.getDefaultAttributeType(a) != null) {
                    typeSelection.setSelectedItem(new EnsembleTypeStringMap(this.importer.getDefaultAttributeType(a)));
                }
                typeSelection.setPreferredSize(new Dimension(175, 25));
                typeSelection.setMaximumSize(new Dimension(175, 25));
                this.attributeComboBoxMap.put(a, typeSelection);
            }
            typeSelection.putClientProperty("attribute", a);
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = counter++;
            c.gridx = 0;
            c.anchor = 17;
            c.ipadx = 10;
            JLabel lbl = new JLabel(a.getName());
            lbl.setHorizontalTextPosition(2);
            this.dataPanel.add((Component)lbl, c);
            c.gridx = 1;
            this.dataPanel.add((Component)new JLabel(p.getDataStoreProcessor().getFile().getName()), c);
            c.gridx = 2;
            this.dataPanel.add(typeSelection, c);
        }
        this.dataPanel.invalidate();
        this.dataPanel.updateUI();
    }

    private void addFile(File file) {
        WorkerDlg progress = new WorkerDlg((Window)this.owner, "Import Data");
        progress.setInderminate(true);
        progress.setTask((Runnable)new CustomRunnable(file){

            @Override
            public void run() {
                try {
                    ImportMonteCarloDataPanel.this.importer.addFile((File)this.getCustomData());
                    ImportMonteCarloDataPanel.this.updateDataTable();
                }
                catch (ImportMonteCarloException imce) {
                    ImportMonteCarloDataPanel.this.showError(imce);
                }
            }
        });
        progress.execute();
    }

    public DataCollection getEnsemble() {
        return this.finalEnsemble;
    }

    private Component createDataSetOverview() {
        this.dataPanel = new JPanel(new BorderLayout());
        JScrollPane datasetScroll = new JScrollPane(this.dataPanel);
        datasetScroll.setSize(this.defaultDatasetTable);
        datasetScroll.setMinimumSize(this.defaultDatasetTable);
        datasetScroll.setPreferredSize(this.defaultDatasetTable);
        return datasetScroll;
    }

    public void addActionEventListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    private void init() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel buttonBar = new JPanel(new FlowLayout());
        panel.add(this.createDataSetOverview(), "Center");
        this.mergeModeBox.setSelectedIndex(1);
        buttonBar.add(this.mergeModeBox);
        JButton okButton = new JButton(JAMS.i18n((String)"OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkerDlg progress = new WorkerDlg((Window)ImportMonteCarloDataPanel.this.owner, JAMS.i18n((String)"Import_Data"));
                progress.setInderminate(true);
                progress.setTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (AbstractDataStoreProcessor.AttributeData a : ImportMonteCarloDataPanel.this.attributeComboBoxMap.keySet()) {
                                JComboBox b = ImportMonteCarloDataPanel.this.attributeComboBoxMap.get(a);
                                ImportMonteCarloDataPanel.this.importer.setType(a, ((EnsembleTypeStringMap)b.getSelectedItem()).get());
                            }
                            DataCollection newCollection = ImportMonteCarloDataPanel.this.importer.getEnsemble();
                            if (ImportMonteCarloDataPanel.this.finalEnsemble == null) {
                                ImportMonteCarloDataPanel.this.finalEnsemble = newCollection;
                            } else {
                                switch (ImportMonteCarloDataPanel.this.getMergeMode()) {
                                    case ATTACH: {
                                        ImportMonteCarloDataPanel.this.finalEnsemble.mergeDataCollections(newCollection);
                                        break;
                                    }
                                    case UNIFY: {
                                        ImportMonteCarloDataPanel.this.finalEnsemble.unifyDataCollections(newCollection);
                                    }
                                }
                            }
                            ImportMonteCarloDataPanel.this.setVisible(false);
                            if (ImportMonteCarloDataPanel.this.ownerDlg != null) {
                                ImportMonteCarloDataPanel.this.ownerDlg.setVisible(false);
                            }
                            for (ActionListener listener : ImportMonteCarloDataPanel.this.listenerList) {
                                listener.actionPerformed(new ActionEvent(ImportMonteCarloDataPanel.this, 1001, "cmd"));
                            }
                            ImportMonteCarloDataPanel.this.importer.finish();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            ImportMonteCarloDataPanel.this.showError(new ImportMonteCarloException(JAMS.i18n((String)"An_error_occured_while_building_the_final_ensemble"), t));
                        }
                    }
                });
                progress.execute();
            }
        });
        buttonBar.add(okButton);
        buttonBar.add(new JButton(JAMS.i18n((String)"CANCEL")){
            {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ImportMonteCarloDataPanel.this.ownerDlg != null) {
                            ImportMonteCarloDataPanel.this.ownerDlg.setVisible(false);
                        }
                    }
                });
            }
        });
        panel.add((Component)buttonBar, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.setSize(this.defaultWindowSize);
    }

    private abstract class CustomRunnable
    implements Runnable {
        private Object customData;

        public CustomRunnable(Object o) {
            this.setCustomData(o);
        }

        public void setCustomData(Object o) {
            this.customData = o;
        }

        public Object getCustomData() {
            return this.customData;
        }
    }

    private class EnsembleTypeStringMap {
        ImportMonteCarloData.EnsembleType t;

        public EnsembleTypeStringMap(ImportMonteCarloData.EnsembleType t) {
            this.t = t;
        }

        public ImportMonteCarloData.EnsembleType get() {
            return this.t;
        }

        public String toString() {
            switch (this.t) {
                case Parameter: {
                    return JAMS.i18n((String)"Parameter");
                }
                case PosEfficiency: {
                    return JAMS.i18n((String)"Efficiency(Positive)");
                }
                case NegEfficiency: {
                    return JAMS.i18n((String)"Efficiency(Negative)");
                }
                case Measurement: {
                    return JAMS.i18n((String)"Measurement");
                }
                case Timeserie: {
                    return JAMS.i18n((String)"Timeserie-Ensemble");
                }
                case StateVariable: {
                    return JAMS.i18n((String)"State-Variable");
                }
                case Ignore: {
                    return "";
                }
            }
            return "";
        }

        public boolean equals(Object obj) {
            return obj instanceof EnsembleTypeStringMap && ((EnsembleTypeStringMap)obj).get().equals((Object)this.t);
        }
    }

    static enum MergeMode {
        ATTACH,
        UNIFY;

    }
}

