/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.gui;

import jams.JAMS;
import jams.explorer.JAMSExplorer;
import jams.explorer.gui.CancelableWorkerDlg;
import jams.explorer.spreadsheet.JAMSSpreadSheet;
import jams.gui.tools.GUIHelper;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class DSPanel
extends JPanel {
    protected AbstractDataStoreProcessor dsdb;
    protected JAMSSpreadSheet outputSpreadSheet;
    protected Frame parent;
    protected CancelableWorkerDlg workerDlg;
    protected File outputDSFile;
    protected AttribComboBox attribCombo;
    protected JAMSExplorer explorer;

    public void setExplorer(JAMSExplorer explorer) {
        this.explorer = explorer;
        this.parent = explorer.getExplorerFrame();
        this.workerDlg = new CancelableWorkerDlg(this.parent, JAMS.i18n((String)"PROCESSING_DATA"));
        this.workerDlg.setModal(false);
        this.workerDlg.setProgress(0);
        this.workerDlg.setProgressMax(100);
    }

    protected void loadData(DataMatrix m, boolean timeSeries) {
        if (m == null) {
            return;
        }
        if (m.getAttributeIDs() == null) {
            m.setAttributeIDs(this.dsdb.getSelectedDoubleAttribs());
        }
        if (this.outputSpreadSheet != null) {
            this.outputSpreadSheet.loadMatrix(m, this.outputDSFile.getParentFile(), timeSeries);
        } else {
            m.output();
        }
    }

    private void postProcess(DataMatrix m, boolean timeSeries) {
        double[] weights = null;
        double area = 0.0;
        double[][] data = m.getArray();
        ArrayList attribs = this.dsdb.getAttributes();
        int j = 0;
        for (AbstractDataStoreProcessor.AttributeData attrib : attribs) {
            if (!attrib.isSelected()) continue;
            if (attrib.getAggregationType() != 1) {
                if (this.attribCombo.getSelectedIndex() == 0) {
                    GUIHelper.showInfoDlg((Component)this.parent, (String)(JAMS.i18n((String)"NO_AREA_ATTRIBUTE_HAS_BEEN_CHOSEN!_SKIPPING_WEIGHTED_AGGREGATION_FOR_ATTRIBUTE_\"") + attrib.getName() + "\"."), (String)JAMS.i18n((String)"INFO"));
                    continue;
                }
                if (weights == null) {
                    int i;
                    AbstractDataStoreProcessor.AttributeData attrib2;
                    weights = new double[data.length];
                    String weightAttribName = this.attribCombo.getSelectedItem().toString();
                    int attribIndex = 0;
                    Iterator iterator = attribs.iterator();
                    while (iterator.hasNext() && !(attrib2 = (AbstractDataStoreProcessor.AttributeData)iterator.next()).getName().equals(weightAttribName)) {
                        boolean selected = attrib2.isSelected();
                        if (!selected) continue;
                        ++attribIndex;
                    }
                    for (i = 0; i < data.length; ++i) {
                        area += data[i][attribIndex];
                    }
                    if (timeSeries) {
                        area /= (double)data.length;
                    }
                    for (i = 0; i < data.length; ++i) {
                        weights[i] = data[i][attribIndex];
                    }
                }
                for (int i = 0; i < data.length; ++i) {
                }
            }
            ++j;
        }
    }

    public void setOutputSpreadSheet(JAMSSpreadSheet spreadsheet) {
        this.outputSpreadSheet = spreadsheet;
    }

    public abstract void createProc(File var1);

    protected class AttribCheckBox
    extends JCheckBox {
        AbstractDataStoreProcessor.AttributeData attrib;

        public AttribCheckBox(AbstractDataStoreProcessor.AttributeData attrib, String text) {
            super(text);
            this.attrib = attrib;
        }
    }

    protected class GroupCheckBox
    extends JCheckBox {
        ArrayList<JCheckBox> checkBoxList;

        public GroupCheckBox(String title, ArrayList<JCheckBox> checkBoxList) {
            super(title);
            this.checkBoxList = checkBoxList;
        }
    }

    protected class AttribRadioButton
    extends JRadioButton {
        AbstractDataStoreProcessor.AttributeData attrib;
        int processingType;

        public AttribRadioButton(AbstractDataStoreProcessor.AttributeData attrib, int processingType) {
            this.attrib = attrib;
            this.processingType = processingType;
        }
    }

    protected class AttribComboBox
    extends JComboBox {
        ArrayList<JCheckBox> checkBoxList;

        public AttribComboBox(ArrayList<JCheckBox> checkBoxList) {
            this.checkBoxList = checkBoxList;
        }
    }
}

