/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.ensembles.implementation;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.explorer.ensembles.implementation.AbstractModel;
import jams.meta.ModelDescriptor;
import jams.meta.ModelIO;
import jams.tools.XMLTools;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataStoreProcessor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClimateModel
extends AbstractModel<ClimateModel> {
    public static final transient String GCM = "GCM";
    public static final transient String GCM_MEMBER = "GCM Member";
    public static final transient String RCM = "RCM";
    public static final transient String SCENARIO = "Scenario";
    public static final transient String TIME = "Time";
    public static final transient String FILE_PREFIX = "File-Prefix";
    public static final transient String LOCATION = "Location";
    public static final transient String MODEL_FILE = "Model-File";
    @XmlTransient
    public File basePath = new File("");
    @XmlElement
    HashMap<String, TreeSet<File>> outputFiles = new HashMap();
    @XmlElement
    TreeSet<String> selectedDirectories = new TreeSet();
    @XmlTransient
    static TreeSet<String> propertySet = new TreeSet<String>(){
        {
            this.add(ClimateModel.GCM);
            this.add(ClimateModel.GCM_MEMBER);
            this.add(ClimateModel.RCM);
            this.add(ClimateModel.SCENARIO);
            this.add(ClimateModel.TIME);
            this.add(ClimateModel.FILE_PREFIX);
            this.add(ClimateModel.LOCATION);
            this.add(ClimateModel.MODEL_FILE);
        }
    };
    @XmlTransient
    static Properties defaults = new Properties(){
        {
            this.put(ClimateModel.GCM, "unknown");
            this.put(ClimateModel.GCM_MEMBER, "unknown");
            this.put(ClimateModel.RCM, "unknown");
            this.put(ClimateModel.LOCATION, "");
            this.put(ClimateModel.SCENARIO, "unknown");
            this.put(ClimateModel.TIME, "1970-01-01 1970-01-01 6 1");
            this.put(ClimateModel.FILE_PREFIX, "unknown");
            this.put(ClimateModel.MODEL_FILE, "unknown");
        }
    };

    public ClimateModel() {
        this(0);
    }

    public ClimateModel(int id) {
        super(id);
    }

    public ClimateModel(int id, File modelFile) {
        super(id);
        this.init(modelFile);
    }

    private void init(File modelFile) {
        Document doc = XMLTools.getDocument((String)modelFile.getAbsolutePath());
        ModelDescriptor md = ModelIO.getStandardModelIO().loadModelDescriptor(doc, ClassLoader.getSystemClassLoader(), true);
        String workspace = md.getWorkspacePath();
        if (workspace.isEmpty()) {
            workspace = modelFile.getParentFile().getAbsolutePath();
        }
        this.loadConfigFile(new File(workspace, "config.txt"));
        this.setBasePath(new File(workspace));
        this.setLocation(new File(workspace));
        this.setModelFile(modelFile);
    }

    public void setBasePath(File newbasePath) {
        this.basePath = newbasePath;
        this.collectOutputs();
    }

    public void relocate(File newbasePath) {
        File path = this.getLocation();
        File modelFile = this.getModelfile();
        this.basePath = newbasePath;
        this.setLocation(path);
        this.setModelFile(modelFile);
    }

    private void collectOutputs() {
        this.outputFiles.clear();
        if (this.getLocation() == null) {
            return;
        }
        File outputDirectory = new File(this.getLocation(), "/output");
        if (!outputDirectory.exists()) {
            return;
        }
        for (File subDirectory : outputDirectory.listFiles()) {
            if (!subDirectory.isDirectory()) continue;
            TreeSet<File> outputSet = new TreeSet<File>();
            block5: for (File f : subDirectory.listFiles()) {
                if (!f.isFile()) continue;
                switch (AbstractDataStoreProcessor.getDataStoreType((File)f)) {
                    case SpatioTemporal: {
                        break;
                    }
                    case Timeserie: {
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                outputSet.add(f);
            }
            this.outputFiles.put(subDirectory.getName(), outputSet);
            this.selectedDirectories.add(subDirectory.getName());
        }
    }

    public ClimateModel(ClimateModel m) {
        super(m);
    }

    @Override
    public ClimateModel copy() {
        return new ClimateModel(this);
    }

    @Override
    public void delete() throws IOException {
        Files.delete(this.getLocation().toPath());
    }

    public ClimateModel[] createDuplicates(int n) throws IOException {
        int counter = 0;
        ClimateModel[] models = new ClimateModel[n];
        for (int i = 0; i < n; ++i) {
            File workspace = this.getLocation();
            if (workspace.isFile() || !workspace.exists()) {
                return new ClimateModel[0];
            }
            File newWorkspace = new File(workspace.getAbsoluteFile() + "(" + (counter + 1) + ")");
            while (newWorkspace.exists()) {
                ++counter;
            }
            FileUtils.copyDirectory((File)workspace, (File)newWorkspace);
            models[i] = new ClimateModel(this);
            models[i].setLocation(newWorkspace);
        }
        return models;
    }

    public DataStoreProcessor[] getDataStoreProcessors(String name) {
        ArrayList<DataStoreProcessor> dsProcs = new ArrayList<DataStoreProcessor>();
        for (String outputDirectory : this.outputFiles.keySet()) {
            File outputDatastore;
            if (!this.isOutputSelected(outputDirectory) || !(outputDatastore = new File(new File(new File(this.getLocation(), "output"), outputDirectory), name)).exists()) continue;
            DataStoreProcessor dsProc = new DataStoreProcessor(outputDatastore);
            dsProcs.add(dsProc);
        }
        return dsProcs.toArray(new DataStoreProcessor[0]);
    }

    public boolean isOutputSelected(String directory) {
        return this.selectedDirectories.contains(directory);
    }

    @Override
    public Set<String> getOutputs() {
        return this.outputFiles.keySet();
    }

    public Set<File> getOutputFiles(String directory) {
        return this.outputFiles.get(directory);
    }

    public void setOutputSelection(String directory, boolean selected) {
        if (selected) {
            this.selectedDirectories.add(directory);
        } else {
            this.selectedDirectories.remove(directory);
        }
        this.setProperty("output", Arrays.toString(this.selectedDirectories.toArray()));
    }

    public void toggleOutputSelection(String directory) {
        if (this.isOutputSelected(directory)) {
            this.setOutputSelection(directory, false);
        } else {
            this.setOutputSelection(directory, true);
        }
    }

    protected boolean loadConfigFile(File configFile) {
        Properties p = new Properties(defaults);
        try {
            p.load(new FileReader(configFile));
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ioe.toString(), ioe);
        }
        p.forEach((BiConsumer<? super Object, ? super Object>)new BiConsumer<Object, Object>(){

            @Override
            public void accept(Object key, Object value) {
                ClimateModel.this.setProperty(key.toString(), value.toString());
            }
        });
        return true;
    }

    public void save() {
        this.saveConfigFile(new File(this.getLocation(), "config.txt"));
    }

    protected boolean saveConfigFile(File configFile) {
        Properties p = new Properties(defaults);
        for (String s : this.getProperties()) {
            p.put(s, this.getProperty(s));
        }
        try {
            p.store(new FileWriter(configFile), "");
        }
        catch (IOException ioe) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ioe.toString(), ioe);
        }
        return true;
    }

    public void setGCM(String gcm) {
        this.setProperty(GCM, gcm);
    }

    public String getGCM() {
        return this.getProperty(GCM);
    }

    public void setModelFile(File f) {
        Path p_shape = f.toPath();
        Path p_base = this.basePath.toPath();
        String relativePath = p_base.relativize(p_shape).toString();
        this.setProperty(MODEL_FILE, relativePath);
    }

    public File getModelfile() {
        return new File(this.basePath, this.getProperty(MODEL_FILE));
    }

    public void setGCMMember(String GCMMember) {
        this.setProperty(GCM_MEMBER, GCMMember);
    }

    public String getGCMMember() {
        return this.getProperty(GCM_MEMBER);
    }

    public void setRCM(String rcm) {
        this.setProperty(RCM, rcm);
    }

    public String getRCM() {
        return this.getProperty(RCM);
    }

    public void setScenario(String scenario) {
        this.setProperty(SCENARIO, scenario);
    }

    public String getScenario() {
        return this.getProperty(SCENARIO);
    }

    public void setFilePrefix(String prefix) {
        this.setProperty(FILE_PREFIX, prefix);
    }

    public String getFilePrefix() {
        return this.getProperty(FILE_PREFIX);
    }

    public void setTimePeriod(Attribute.TimeInterval t) {
        this.setProperty(TIME, t.toString());
    }

    public Attribute.TimeInterval getTimePeriod() {
        Attribute.TimeInterval ti = DefaultDataFactory.getDataFactory().createTimeInterval();
        try {
            if (this.getProperty(TIME) != null) {
                ti.setValue(this.getProperty(TIME));
            }
        }
        finally {
            return ti;
        }
    }

    public void setLocation(File f) {
        Path p_shape = f.toPath();
        Path p_base = this.basePath.toPath();
        String relativePath = p_base.relativize(p_shape).toString();
        this.setRelativeLocation(relativePath);
        this.collectOutputs();
    }

    public File getLocation() {
        if (this.basePath == null | this.getRelativeLocation() == null) {
            return null;
        }
        return new File(this.basePath, this.getRelativeLocation());
    }

    public void setRelativeLocation(String relativePath) {
        this.setProperty(LOCATION, relativePath);
        this.collectOutputs();
    }

    public String getRelativeLocation() {
        return this.getProperty(LOCATION);
    }

    public String toString() {
        String s = String.format("[%d] ", this.id) + " ";
        if (this.getRCM() != null) {
            s = s + this.getRCM() + "-";
        }
        if (this.getGCM() != null) {
            s = s + this.getGCM();
        }
        if (this.getScenario() != null) {
            s = s + " (" + this.getScenario() + ")";
        }
        if (s.isEmpty()) {
            s = "unnamed";
        }
        return s;
    }
}

