/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.ensembles.gui;

import jams.JAMS;
import jams.aggregators.Aggregator;
import jams.data.Attribute;
import jams.explorer.ensembles.gui.AbstractClimateDataTab;
import jams.explorer.ensembles.gui.ClimateDataAggregationTab;
import jams.explorer.ensembles.gui.ClimateDataOverviewTab;
import jams.explorer.ensembles.gui.EnsembleOverview;
import jams.explorer.ensembles.gui.EnsembleTable;
import jams.explorer.ensembles.implementation.ClimateEnsemble;
import jams.explorer.ensembles.implementation.ClimateModel;
import jams.explorer.gui.CancelableSwingWorker;
import jams.explorer.gui.CancelableWorkerDlg;
import jams.gui.JAMSLauncher;
import jams.gui.ObserverWorkerDlg;
import jams.gui.WorkerDlg;
import jams.gui.input.TimeintervalInput;
import jams.logging.MsgBoxLogHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;

public class EnsembleControlPanel
extends JPanel {
    static final Logger logger = Logger.getLogger(EnsembleControlPanel.class.getName());
    JPanel leftColumn;
    JPanel middleColumn;
    JPanel rightColumn;
    JLabel countLabel;
    EnsembleOverview ensembleTree;
    ClimateModel currentModel;
    JLabel ensembleMemberLabel;
    JLabel GCMLabel;
    JLabel GCMMemberLabel;
    JLabel RCMMemberLabel;
    JLabel ScenarioLabel;
    JLabel TimePeriodLabel;
    JLabel FilePr\u00e4fixLabel;
    JLabel LocationLabel;
    JLabel ShapeFileLabel;
    JTextField ensembleMemberText;
    JTextField GCMText;
    JTextField GCMMemberText;
    JTextField RCMText;
    JTextField ScenarioText;
    JTextField TimePeriodText;
    JTextField FilePr\u00e4fixText;
    JTextField LocationText;
    JTextField ShapeFileText;
    JButton selectLocation;
    JButton selectShapeFileLocation;
    JToggleButton showStatistics;
    JButton selectAllBn;
    JButton selectNoneBn;
    JButton invertSelectionBn;
    JButton exportToShape;
    TimeintervalInput refPeriodField;
    boolean calculateDiffernce;
    boolean isShowingStatistics;
    JFileChooser jfc;
    static final MsgBoxLogHandler myLogHandler = MsgBoxLogHandler.getInstance();
    HashMap<JTextField, String> textFields;
    JTabbedPane statisticsPane;
    List<AbstractClimateDataTab> tabSet;
    JAMSLauncher launcher;
    private final EnsembleTable outputTable;

    public EnsembleControlPanel() {
        this((JAMSLauncher)null);
    }

    public EnsembleControlPanel(JAMSLauncher launcher) {
        EnsembleControlPanel.registerLogHandler(logger);
        this.leftColumn = new JPanel();
        this.middleColumn = new JPanel();
        this.rightColumn = new JPanel();
        this.countLabel = new JLabel("count");
        this.ensembleTree = null;
        this.currentModel = null;
        this.ensembleMemberLabel = new JLabel("Ensemble-Member:");
        this.GCMLabel = new JLabel("GCM:");
        this.GCMMemberLabel = new JLabel("GCM Member:");
        this.RCMMemberLabel = new JLabel("RCM:");
        this.ScenarioLabel = new JLabel("Scenario:");
        this.TimePeriodLabel = new JLabel("TimePeriod:");
        this.FilePr\u00e4fixLabel = new JLabel("File-Prefix:");
        this.LocationLabel = new JLabel("Location:");
        this.ShapeFileLabel = new JLabel("Shapefile:");
        this.ensembleMemberText = new JTextField(10){
            {
                this.setEnabled(false);
            }
        };
        this.GCMText = new JTextField(10);
        this.GCMMemberText = new JTextField(10);
        this.RCMText = new JTextField(10);
        this.ScenarioText = new JTextField(10);
        this.TimePeriodText = new JTextField(10);
        this.FilePr\u00e4fixText = new JTextField(10);
        this.LocationText = new JTextField(10){
            {
                this.setEnabled(false);
            }
        };
        this.ShapeFileText = new JTextField(10){
            {
                this.setEnabled(false);
            }
        };
        this.selectLocation = new JButton(JAMS.getIcon((String)"jams/explorer/resources/images/folder.png"));
        this.selectShapeFileLocation = new JButton(JAMS.getIcon((String)"jams/explorer/resources/images/folder.png"));
        this.showStatistics = new JToggleButton("Show Statistics", false);
        this.selectAllBn = new JButton("Select All");
        this.selectNoneBn = new JButton("Select None");
        this.invertSelectionBn = new JButton("Invert Selection");
        this.exportToShape = new JButton("Export Statistics");
        this.refPeriodField = new TimeintervalInput(true);
        this.calculateDiffernce = false;
        this.isShowingStatistics = this.showStatistics.isSelected();
        this.jfc = new JFileChooser();
        this.textFields = new HashMap<JTextField, String>(){
            {
                this.put(EnsembleControlPanel.this.GCMText, "GCM");
                this.put(EnsembleControlPanel.this.GCMMemberText, "GCM Member");
                this.put(EnsembleControlPanel.this.RCMText, "RCM");
                this.put(EnsembleControlPanel.this.ScenarioText, "Scenario");
                this.put(EnsembleControlPanel.this.FilePr\u00e4fixText, "File-Prefix");
            }
        };
        this.statisticsPane = new JTabbedPane();
        this.tabSet = new ArrayList<AbstractClimateDataTab>(){
            {
                this.add(new ClimateDataOverviewTab("Overview (absolute)"));
                this.add(new ClimateDataAggregationTab("Average", Aggregator.AggregationMode.AVERAGE, null, EnsembleControlPanel.this));
                this.add(new ClimateDataAggregationTab("Median", Aggregator.AggregationMode.MEDIAN, null, EnsembleControlPanel.this));
                this.add(new ClimateDataAggregationTab("Q5", Aggregator.AggregationMode.MEDIAN, 0.05, EnsembleControlPanel.this));
                this.add(new ClimateDataAggregationTab("Q95", Aggregator.AggregationMode.MEDIAN, 0.95, EnsembleControlPanel.this));
                this.add(new ClimateDataAggregationTab("Variance", Aggregator.AggregationMode.VARIANCE, null, EnsembleControlPanel.this));
            }
        };
        this.outputTable = new EnsembleTable(null);
        this.launcher = launcher;
        this.ensembleTree = new EnsembleOverview(new ClimateEnsemble("unbenanntes Ensemble"), launcher);
        this.init();
        this.initActions();
    }

    private void init() {
        logger.entering(this.getClass().getName(), "init()");
        GroupLayout mainLayout = new GroupLayout(this);
        this.setLayout(mainLayout);
        JScrollPane tableScroller = new JScrollPane(this.outputTable);
        JPanel refPeriodPanel = new JPanel(new BorderLayout());
        refPeriodPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Reference Period"));
        this.refPeriodField.setEnabled(false);
        refPeriodPanel.add((Component)new JCheckBox(new AbstractAction("Calculate change"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                EnsembleControlPanel.this.calculateDiffernce = source.isSelected();
                EnsembleControlPanel.this.refPeriodField.setEnabled(EnsembleControlPanel.this.calculateDiffernce);
                EnsembleControlPanel.this.outputTable.fireSelectionChangeNotification();
            }
        }), "North");
        refPeriodPanel.add((Component)this.refPeriodField, "Center");
        mainLayout.setHorizontalGroup(mainLayout.createSequentialGroup().addComponent(this.leftColumn).addGroup(mainLayout.createParallelGroup().addComponent(this.middleColumn).addGroup(mainLayout.createSequentialGroup().addComponent(tableScroller).addGap(5, 10, 15).addGroup(mainLayout.createParallelGroup().addComponent(this.showStatistics, 300, 325, 350).addComponent(this.selectAllBn, 300, 325, 350).addComponent(this.selectNoneBn, 300, 325, 350).addComponent(this.invertSelectionBn, 300, 325, 350).addComponent(this.exportToShape, 300, 325, 350).addComponent(refPeriodPanel, 300, 325, 350)).addGap(5, 10, 15))));
        mainLayout.setVerticalGroup(mainLayout.createParallelGroup().addComponent(this.leftColumn).addGroup(mainLayout.createSequentialGroup().addComponent(this.middleColumn).addGroup(mainLayout.createParallelGroup().addComponent(tableScroller).addGroup(mainLayout.createSequentialGroup().addComponent(this.showStatistics).addGap(0, 5, 5).addComponent(this.selectAllBn).addGap(0, 5, 5).addComponent(this.selectNoneBn).addGap(0, 5, 5).addComponent(this.invertSelectionBn).addGap(15, 20, 25).addComponent(this.exportToShape).addGap(15, 20, 25).addComponent(refPeriodPanel)))));
        this.refPeriodField.setValue("1971-01-01 06:30 2000-12-31 06:30 6 1");
        this.leftColumn.setBorder(BorderFactory.createTitledBorder("Ensembles"));
        this.leftColumn.setMinimumSize(new Dimension(400, 400));
        this.leftColumn.setMaximumSize(new Dimension(400, 1200));
        this.leftColumn.setLayout(new BorderLayout());
        this.leftColumn.add((Component)this.ensembleTree, "Center");
        JPanel southPanel = new JPanel();
        GroupLayout leftColumnSouthLayout = new GroupLayout(southPanel);
        southPanel.setLayout(leftColumnSouthLayout);
        JSeparator sep = new JSeparator(0);
        leftColumnSouthLayout.setHorizontalGroup(leftColumnSouthLayout.createParallelGroup().addComponent(this.countLabel).addComponent(sep));
        leftColumnSouthLayout.setVerticalGroup(leftColumnSouthLayout.createSequentialGroup().addComponent(this.countLabel).addComponent(sep));
        this.leftColumn.add((Component)this.rightColumn, "South");
        this.middleColumn.setBorder(BorderFactory.createTitledBorder("Outputs"));
        this.middleColumn.setLayout(new BorderLayout());
        this.middleColumn.add((Component)this.statisticsPane, "Center");
        this.rightColumn.setBorder(BorderFactory.createTitledBorder("Information"));
        GroupLayout rightLayout = new GroupLayout(this.rightColumn);
        this.rightColumn.setLayout(rightLayout);
        this.rightColumn.setMinimumSize(new Dimension(400, 400));
        this.rightColumn.setMaximumSize(new Dimension(400, 400));
        for (JTextField f : this.textFields.keySet()) {
            f.setMaximumSize(new Dimension(350, 25));
        }
        this.LocationText.setMaximumSize(new Dimension(350, 25));
        this.ShapeFileText.setMaximumSize(new Dimension(350, 25));
        this.ensembleMemberText.setMaximumSize(new Dimension(350, 25));
        rightLayout.setHorizontalGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(rightLayout.createSequentialGroup().addComponent(this.ensembleMemberLabel).addGap(5, 10, 15).addComponent(this.ensembleMemberText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.GCMLabel).addGap(5, 10, 15).addComponent(this.GCMText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.GCMMemberLabel).addGap(5, 10, 15).addComponent(this.GCMMemberText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.RCMMemberLabel).addGap(5, 10, 15).addComponent(this.RCMText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.ScenarioLabel).addGap(5, 10, 15).addComponent(this.ScenarioText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.FilePr\u00e4fixLabel).addGap(5, 10, 15).addComponent(this.FilePr\u00e4fixText)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.LocationLabel).addGap(5, 10, 15).addComponent(this.LocationText).addComponent(this.selectLocation)).addGap(5, 10, 15).addGroup(rightLayout.createSequentialGroup().addComponent(this.ShapeFileLabel).addGap(5, 10, 15).addComponent(this.ShapeFileText).addComponent(this.selectShapeFileLocation)));
        rightLayout.setVerticalGroup(rightLayout.createSequentialGroup().addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ensembleMemberLabel).addComponent(this.ensembleMemberText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.GCMLabel).addComponent(this.GCMText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.GCMMemberLabel).addComponent(this.GCMMemberText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.RCMMemberLabel).addComponent(this.RCMText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ScenarioLabel).addComponent(this.ScenarioText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.FilePr\u00e4fixLabel).addComponent(this.FilePr\u00e4fixText)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.LocationLabel).addComponent(this.LocationText).addComponent(this.selectLocation)).addGap(5, 10, 15).addGroup(rightLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.ShapeFileLabel).addComponent(this.ShapeFileText).addComponent(this.selectShapeFileLocation)));
        this.addTabsToPane();
        this.setEnabledForTextFields(false);
        logger.exiting(this.getClass().getName(), "init()");
    }

    private void addTabsToPane() {
        this.statisticsPane.removeAll();
        for (AbstractClimateDataTab a : this.tabSet) {
            this.statisticsPane.addTab(a.getName(), a);
        }
    }

    private void initActions() {
        logger.entering(this.getClass().getName(), "initActions()");
        this.outputTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                logger.entering("outputTable->ListSelectionListener", "valueChanged");
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (EnsembleControlPanel.this.outputTable.getSelectedRow() == -1 || !EnsembleControlPanel.this.isShowingStatistics) {
                    for (AbstractClimateDataTab tab : EnsembleControlPanel.this.tabSet) {
                        tab.setOutput(null);
                    }
                    return;
                }
                for (AbstractClimateDataTab tab : EnsembleControlPanel.this.tabSet) {
                    String output = EnsembleControlPanel.this.outputTable.getOutput(EnsembleControlPanel.this.outputTable.getSelectedRow());
                    if (output == null) continue;
                    tab.setOutput(output);
                }
                logger.exiting("outputTable->ListSelectionListener", "valueChanged");
            }
        });
        this.ensembleTree.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                logger.entering("ensembleTree->TreeSelectionListener", "valueChanged");
                EnsembleControlPanel.this.setCurrentModel(null);
                TreePath p = e.getNewLeadSelectionPath();
                if (p == null) {
                    return;
                }
                Object o = p.getLastPathComponent();
                if (o instanceof ClimateEnsemble.ModelTreeNode) {
                    ClimateEnsemble.ModelTreeNode mtn = (ClimateEnsemble.ModelTreeNode)o;
                    ClimateModel climModel = mtn.getModel();
                    EnsembleControlPanel.this.setCurrentModel(climModel);
                }
                if (o instanceof ClimateEnsemble.OutputDirectoryTreeNode) {
                    ClimateEnsemble.OutputDirectoryTreeNode odtn = (ClimateEnsemble.OutputDirectoryTreeNode)o;
                    EnsembleControlPanel.this.setCurrentModel(odtn.getModel());
                }
                if (EnsembleControlPanel.this.ensembleTree != null && EnsembleControlPanel.this.ensembleTree.getClimateEnsemble() != null) {
                    if (EnsembleControlPanel.this.ensembleTree.getClimateEnsemble().getShapeFileTemplate() != null) {
                        EnsembleControlPanel.this.exportToShape.setEnabled(true);
                    } else {
                        EnsembleControlPanel.this.exportToShape.setEnabled(false);
                    }
                }
                EnsembleControlPanel.this.countLabel.setText("count: " + EnsembleControlPanel.this.ensembleTree.getClimateEnsemble().getSize());
                logger.exiting("ensembleTree->TreeSelectionListener", "valueChanged");
            }
        });
        this.ensembleTree.addEnsembleChangeListener(new EnsembleOverview.EnsembleChangeListener(){

            @Override
            public void changed(ClimateEnsemble dataset) {
                EnsembleControlPanel.this.changeEnsembleDataset(dataset);
            }
        });
        for (JTextField f : this.textFields.keySet()) {
            f.getDocument().addDocumentListener(new IdentfiableDocumentListener(this.textFields.get(f)));
        }
        this.selectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.selectLocation();
            }
        });
        this.selectShapeFileLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.selectShapeFileLocation();
            }
        });
        this.selectAllBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.outputTable.selectAll();
            }
        });
        this.selectNoneBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.outputTable.deselectAll();
            }
        });
        this.invertSelectionBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.outputTable.invertSelection();
            }
        });
        this.showStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.toggleStatisticsAction();
            }
        });
        for (ActionListener a : ((DefaultButtonModel)this.showStatistics.getModel()).getActionListeners()) {
            a.actionPerformed(new ActionEvent(this.showStatistics, 0, "init"));
        }
        this.exportToShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnsembleControlPanel.this.exportToShapeAction();
            }
        });
        logger.exiting(this.getClass().getName(), "initActions()");
    }

    public Attribute.TimeInterval getRefPeriod() {
        if (this.calculateDiffernce) {
            return this.refPeriodField.getTimeInterval();
        }
        return null;
    }

    private void changeEnsembleDataset(ClimateEnsemble dataset) {
        logger.entering(this.getClass().getName(), "changeEnsembleDataset");
        this.tabSet.clear();
        this.tabSet.add(new ClimateDataOverviewTab("Overview (absolute)"));
        this.tabSet.add(new ClimateDataAggregationTab("Average", Aggregator.AggregationMode.AVERAGE, null, this));
        this.tabSet.add(new ClimateDataAggregationTab("Median", Aggregator.AggregationMode.MEDIAN, null, this));
        this.tabSet.add(new ClimateDataAggregationTab("Q5", Aggregator.AggregationMode.MEDIAN, 0.05, this));
        this.tabSet.add(new ClimateDataAggregationTab("Q95", Aggregator.AggregationMode.MEDIAN, 0.95, this));
        this.tabSet.add(new ClimateDataAggregationTab("Variance", Aggregator.AggregationMode.VARIANCE, null, this));
        int i = 0;
        for (ClimateModel clm : dataset.getModelSet()) {
            this.tabSet.add(new ClimateDataAggregationTab(clm.toString(), Aggregator.AggregationMode.INDEX, Double.valueOf(i), this));
            ++i;
        }
        this.addTabsToPane();
        for (AbstractClimateDataTab a : this.tabSet) {
            a.setClimateEnsemble(dataset);
        }
        this.outputTable.setEnsemble(dataset);
        Enumeration<TableColumn> e = this.outputTable.getColumnModel().getColumns();
        try {
            e.nextElement().setMaxWidth(20);
            e.nextElement().setMinWidth(40);
            e.nextElement().setMinWidth(60);
            e.nextElement().setMinWidth(80);
            e.nextElement().setMinWidth(20);
        }
        catch (NoSuchElementException nsee) {
            logger.log(Level.SEVERE, "Error during layout of table", nsee);
        }
        logger.exiting(this.getClass().getName(), "changeEnsembleDataset");
    }

    private void toggleStatisticsAction() {
        logger.entering(this.getClass().getName(), "toggleStatisticsAction");
        if (this.showStatistics.isSelected()) {
            this.showStatistics.setText("Statistics are ON");
            this.showStatistics.setBackground(new Color(128, 255, 128));
        } else {
            this.showStatistics.setText("Statistics are OFF");
            this.showStatistics.setBackground(new Color(255, 128, 128));
        }
        this.isShowingStatistics = this.showStatistics.isSelected();
        this.outputTable.fireSelectionChangeNotification();
        logger.exiting(this.getClass().getName(), "toggleStatisticsAction");
    }

    private void exportToShapeAction() {
        if (this.ensembleTree.getClimateEnsemble() == null) {
            return;
        }
        logger.entering(this.getClass().getName(), "exportToShapeAction");
        this.jfc.setFileSelectionMode(1);
        int result = this.jfc.showSaveDialog(this);
        if (result == 0) {
            File targetDir = this.jfc.getSelectedFile();
            ExportWorker worker = new ExportWorker();
            worker.setTargetDir(targetDir);
            worker.getWorkerDlg().execute();
        }
        logger.exiting(this.getClass().getName(), "exportToShapeAction");
    }

    private void selectLocation() {
        logger.entering(this.getClass().getName(), "selectLocation");
        this.jfc.setFileSelectionMode(1);
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            File f = this.jfc.getSelectedFile();
            this.currentModel.setLocation(f);
        }
        logger.exiting(this.getClass().getName(), "selectLocation");
    }

    private void selectShapeFileLocation() {
        logger.entering(this.getClass().getName(), "selectShapeFileLocation");
        this.jfc.setFileSelectionMode(0);
        this.jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".shp");
            }

            @Override
            public String getDescription() {
                return "Shapefile (*.shp)";
            }
        });
        int result = this.jfc.showOpenDialog(this);
        if (result == 0) {
            File f = this.jfc.getSelectedFile();
            this.ensembleTree.getClimateEnsemble().setShapeFileTemplate(f);
        }
        logger.exiting(this.getClass().getName(), "selectShapeFileLocation");
    }

    protected void setCurrentModel(ClimateModel model) {
        logger.entering(this.getClass().getName(), "setCurrentModel");
        this.currentModel = model;
        this.setEnabledForTextFields(model != null);
        if (model == null) {
            this.FilePr\u00e4fixText.setText("");
            this.GCMMemberText.setText("");
            this.LocationText.setText("");
            this.RCMText.setText("");
            this.ScenarioText.setText("");
            this.TimePeriodText.setText("");
            this.ensembleMemberText.setText("");
            this.GCMText.setText("");
        } else {
            File f;
            this.FilePr\u00e4fixText.setText(model.getFilePrefix());
            this.GCMMemberText.setText(model.getGCMMember());
            if (model.getLocation() != null) {
                f = model.getLocation();
                this.LocationText.setText(f.getName());
            } else {
                this.LocationText.setText("");
            }
            if (this.ensembleTree.getClimateEnsemble().getShapeFileTemplate() != null) {
                f = this.ensembleTree.getClimateEnsemble().getShapeFileTemplate();
                this.ShapeFileText.setText(f.getName());
            } else {
                this.ShapeFileText.setText("");
            }
            this.RCMText.setText(model.getRCM());
            this.ScenarioText.setText(model.getScenario());
            this.TimePeriodText.setText(model.getTimePeriod().getValue());
            this.ensembleMemberText.setText("NAN");
            this.GCMText.setText(model.getGCM());
            int id = this.ensembleTree.getClimateEnsemble().getID(model);
            this.ensembleMemberText.setText(Integer.toString(id));
        }
        logger.exiting(this.getClass().getName(), "setCurrentModel");
    }

    protected void setEnabledForTextFields(boolean isEnabled) {
        for (JTextField f : this.textFields.keySet()) {
            f.setEnabled(isEnabled);
        }
    }

    public static void registerLogHandler(Logger log) {
        log.removeHandler((Handler)myLogHandler);
        log.addHandler((Handler)myLogHandler);
    }

    public static void main(String[] args) {
        EnsembleControlPanel ecp = new EnsembleControlPanel();
        JFrame frame = new JFrame("Ensemble Management");
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame.add(ecp);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class ExportWorker
    extends ObserverWorkerDlg {
        File targetDir;

        public ExportWorker() {
            super((WorkerDlg)new CancelableWorkerDlg(null, "I am busy"));
            this.targetDir = null;
            this.setTask();
            this.getWorkerDlg().setSize(600, 120);
        }

        public void setTargetDir(File dir) {
            this.targetDir = dir;
        }

        private void setTask() {
            ((CancelableWorkerDlg)this.getWorkerDlg()).setTask(new CancelableSwingWorker(){

                protected Object doInBackground() throws Exception {
                    logger.entering("EnsembleControlPanel$CancelableWorkerDlg", "doInBackground");
                    ClimateEnsemble ensemble = EnsembleControlPanel.this.ensembleTree.getClimateEnsemble();
                    for (String selectedOutput : EnsembleControlPanel.this.outputTable.getSelectedOutputs()) {
                        ExportWorker.this.update(null, "<html><div align=\"center\">Exporting</div><br><div align=\"center\">Average of " + selectedOutput + "</div></html>");
                        try {
                            ensemble.aggregateEnsembleToFile(ExportWorker.this.targetDir, selectedOutput, Aggregator.AggregationMode.AVERAGE, null, EnsembleControlPanel.this.getRefPeriod());
                        }
                        catch (Throwable ioe) {
                            if (selectedOutput == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save a dataset, since it is null", ioe);
                            }
                            if (ExportWorker.this.targetDir == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1, since the target is null".replace("%1", selectedOutput), ioe);
                                continue;
                            }
                            logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1 to the shapefile %2".replace("%1", selectedOutput).replace("%2", ExportWorker.this.targetDir.getAbsolutePath()), ioe);
                        }
                    }
                    for (String selectedOutput : EnsembleControlPanel.this.outputTable.getSelectedOutputs()) {
                        ExportWorker.this.update(null, "<html><div align=\"center\">Exporting</div><br><div align=\"center\">Median of " + selectedOutput + "</div></html>");
                        try {
                            ensemble.aggregateEnsembleToFile(ExportWorker.this.targetDir, selectedOutput, Aggregator.AggregationMode.MEDIAN, null, EnsembleControlPanel.this.getRefPeriod());
                        }
                        catch (Throwable ioe) {
                            if (selectedOutput == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save a dataset, since it is null", ioe);
                            }
                            if (ExportWorker.this.targetDir == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1, since the target is null".replace("%1", selectedOutput), ioe);
                                continue;
                            }
                            logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1 to the shapefile %2".replace("%1", selectedOutput).replace("%2", ExportWorker.this.targetDir.getAbsolutePath()), ioe);
                        }
                    }
                    for (String selectedOutput : EnsembleControlPanel.this.outputTable.getSelectedOutputs()) {
                        ExportWorker.this.update(null, "<html><div align=\"center\">Exporting</div><br><div align=\"center\">Q5 of " + selectedOutput + "</div></html>");
                        try {
                            ensemble.aggregateEnsembleToFile(ExportWorker.this.targetDir, selectedOutput, Aggregator.AggregationMode.MEDIAN, 0.05, EnsembleControlPanel.this.getRefPeriod());
                        }
                        catch (Throwable ioe) {
                            if (selectedOutput == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save a dataset, since it is null", ioe);
                            }
                            if (ExportWorker.this.targetDir == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1, since the target is null".replace("%1", selectedOutput), ioe);
                                continue;
                            }
                            logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1 to the shapefile %2".replace("%1", selectedOutput).replace("%2", ExportWorker.this.targetDir.getAbsolutePath()), ioe);
                        }
                    }
                    for (String selectedOutput : EnsembleControlPanel.this.outputTable.getSelectedOutputs()) {
                        ExportWorker.this.update(null, "<html><div align=\"center\">Exporting</div><br><div align=\"center\">Q95 of " + selectedOutput + "</div></html>");
                        try {
                            ensemble.aggregateEnsembleToFile(ExportWorker.this.targetDir, selectedOutput, Aggregator.AggregationMode.MEDIAN, 0.95, EnsembleControlPanel.this.getRefPeriod());
                        }
                        catch (Throwable ioe) {
                            if (selectedOutput == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save a dataset, since it is null", ioe);
                            }
                            if (ExportWorker.this.targetDir == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1, since the target is null".replace("%1", selectedOutput), ioe);
                                continue;
                            }
                            logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1 to the shapefile %2".replace("%1", selectedOutput).replace("%2", ExportWorker.this.targetDir.getAbsolutePath()), ioe);
                        }
                    }
                    for (String selectedOutput : EnsembleControlPanel.this.outputTable.getSelectedOutputs()) {
                        ExportWorker.this.update(null, "<html><div align=\"center\">Exporting</div><br><div align=\"center\">Variance of " + selectedOutput + "</div></html>");
                        try {
                            ensemble.aggregateEnsembleToFile(ExportWorker.this.targetDir, selectedOutput, Aggregator.AggregationMode.VARIANCE, null, EnsembleControlPanel.this.getRefPeriod());
                        }
                        catch (Throwable ioe) {
                            if (selectedOutput == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save a dataset, since it is null", ioe);
                            }
                            if (ExportWorker.this.targetDir == null) {
                                logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1, since the target is null".replace("%1", selectedOutput), ioe);
                                continue;
                            }
                            logger.log(Level.SEVERE, "Sorry, I failed to save the dataset %1 to the shapefile %2".replace("%1", selectedOutput).replace("%2", ExportWorker.this.targetDir.getAbsolutePath()), ioe);
                        }
                    }
                    logger.exiting("EnsembleControlPanel$CancelableWorkerDlg", "doInBackground");
                    return null;
                }

                @Override
                public int cancel() {
                    logger.info("EnsembleControlPanel$CancelableWorkerDlg is canceled");
                    return super.cancel(true) ? 1 : 0;
                }
            });
        }
    }

    private class IdentfiableDocumentListener
    implements DocumentListener {
        String key;

        public IdentfiableDocumentListener(String key) {
            this.key = key;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.saveChange(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.saveChange(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.saveChange(e);
        }

        public void saveChange(DocumentEvent e) {
            if (EnsembleControlPanel.this.currentModel != null) {
                try {
                    int n = e.getDocument().getLength();
                    String s = e.getDocument().getText(0, n);
                    EnsembleControlPanel.this.currentModel.setProperty(this.key, s);
                    if (EnsembleControlPanel.this.ensembleTree != null && EnsembleControlPanel.this.ensembleTree.getClimateEnsemble() != null) {
                        if (EnsembleControlPanel.this.ensembleTree.getClimateEnsemble().getShapeFileTemplate() != null) {
                            EnsembleControlPanel.this.exportToShape.setEnabled(true);
                        } else {
                            EnsembleControlPanel.this.exportToShape.setEnabled(false);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

