/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer.ensembles.gui;

import jams.explorer.ensembles.gui.AbstractDataTab;
import jams.explorer.ensembles.gui.EnsembleControlPanel;
import jams.explorer.ensembles.implementation.ClimateEnsemble;
import jams.explorer.ensembles.implementation.ClimateModel;
import jams.explorer.gui.CancelableWorkerDlg;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;

public abstract class AbstractClimateDataTab
extends AbstractDataTab {
    static final Logger logger = Logger.getLogger(AbstractClimateDataTab.class.getName());
    ClimateEnsemble ensemble;
    ClimateModel currentModel;
    String output;
    int n;
    static JFileChooser fileChooser = new JFileChooser();

    public AbstractClimateDataTab(String name) {
        super(name);
        EnsembleControlPanel.registerLogHandler(logger);
        this.n = 0;
    }

    public void setOutput(String output) {
        this.output = output;
        this.setChanged();
    }

    public void setClimateEnsemble(ClimateEnsemble ensemble) {
        this.ensemble = ensemble;
        this.n = ensemble.getSize();
        this.setChanged();
    }

    public ClimateEnsemble getClimateEnsemble() {
        return this.ensemble;
    }

    protected abstract void calculate();

    @Override
    public void refresh() {
        if (!this.isShowing() || !this.isChanged()) {
            return;
        }
        if (this.ensemble == null || this.output == null) {
            return;
        }
        CancelableWorkerDlg worker = new CancelableWorkerDlg(null, "I am busy");
        worker.setTask(new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    AbstractClimateDataTab.this.calculate();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Sorry, I am unable to refesh the climate data tab", t);
                }
                return null;
            }
        });
        worker.execute();
    }
}

