/*
 * Decompiled with CFR 0.152.
 */
package jams.explorer;

import jams.data.Attribute;
import jams.explorer.gui.DataCollectionView;
import jams.explorer.gui.DataCollectionViewDelegate;
import java.util.EnumSet;
import java.util.Set;
import optas.data.DataCollection;
import optas.data.Efficiency;
import optas.data.Measurement;
import optas.data.Parameter;
import optas.data.SimpleEnsemble;
import optas.data.StateVariable;
import optas.data.TimeSerie;

public class DataCollectionViewController
implements DataCollectionViewDelegate {
    private DataCollection collection = null;
    private DataCollectionView view = null;

    public DataCollectionViewController(DataCollection collection) {
        this.collection = collection;
        collection.addChangeListener(new DataCollection.DatasetChangeListener(){

            public void datasetChanged(DataCollection.DatasetChangeEvent dc) {
                DataCollectionViewController.this.view.refreshView();
            }
        });
        this.view = new DataCollectionView(this);
    }

    public DataCollectionView getView() {
        return this.view;
    }

    public DataCollection getDataCollection() {
        return this.collection;
    }

    @Override
    public DataCollectionView.DataType[] getAvailableDataTypes() {
        Set classes = this.collection.getDataSetTypes();
        EnumSet<DataCollectionView.DataType> types = EnumSet.noneOf(DataCollectionView.DataType.class);
        for (Class c : classes) {
            if (Measurement.class.isAssignableFrom(c)) {
                types.add(DataCollectionView.DataType.MEASUREMENT);
                continue;
            }
            if (TimeSerie.class.isAssignableFrom(c)) {
                types.add(DataCollectionView.DataType.TIME_SERIES);
                continue;
            }
            if (Efficiency.class.isAssignableFrom(c)) {
                types.add(DataCollectionView.DataType.OBJECTIVE);
                continue;
            }
            if (Parameter.class.isAssignableFrom(c)) {
                types.add(DataCollectionView.DataType.PARAMETER);
                continue;
            }
            if (!StateVariable.class.isAssignableFrom(c)) continue;
            types.add(DataCollectionView.DataType.VARIABLE);
        }
        return types.toArray(new DataCollectionView.DataType[types.size()]);
    }

    public String[] getItemIdentifiersForDataType(DataCollectionView.DataType type) {
        switch (type) {
            case TIME_SERIES: {
                return this.collection.getDatasets(TimeSerie.class).toArray(new String[0]);
            }
            case MEASUREMENT: {
                return this.collection.getDatasets(Measurement.class).toArray(new String[0]);
            }
            case OBJECTIVE: {
                return this.collection.getDatasets(Efficiency.class).toArray(new String[0]);
            }
            case PARAMETER: {
                return this.collection.getDatasets(Parameter.class).toArray(new String[0]);
            }
            case VARIABLE: {
                return this.collection.getDatasets(StateVariable.class).toArray(new String[0]);
            }
        }
        return new String[0];
    }

    @Override
    public Attribute.TimeInterval getTimeInterval(Object item) {
        return this.collection.getTimeDomain();
    }

    @Override
    public boolean hasTimeInterval(Object item) {
        return TimeSerie.class.isAssignableFrom(this.collection.getDatasetClass((String)item));
    }

    @Override
    public boolean isMultirun(Object item) {
        return !Measurement.class.isAssignableFrom(this.collection.getDatasetClass((String)item));
    }

    @Override
    public Integer[] getSimulationIDs() {
        return this.collection.getModelrunIds();
    }

    @Override
    public void itemIsBeingDisplayed(Object item) {
    }

    public void filter(Object item, double low, double high, boolean inverse) {
        Object o = this.getItemForIdentifier(item);
        if (o instanceof SimpleEnsemble) {
            this.collection.filter(item.toString(), low, high, inverse);
        }
    }

    public void filterPercentil(Object item, double low, double high, boolean inverse) {
        Object o = this.getItemForIdentifier(item);
        if (o instanceof SimpleEnsemble) {
            this.collection.filterPercentil(item.toString(), low, high, inverse);
        }
    }

    public void clearTimeFilter() {
        this.collection.clearTimeDomainFilter();
    }

    public void clearIDFilter() {
        this.collection.clearIDFilter();
    }

    public void commitFilter() {
        this.collection.commitFilter();
    }

    @Override
    public Object getItemForIdentifier(Object identifier) {
        return this.collection.getDataSet((String)identifier);
    }
}

