/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.topology;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JAMSComponentDescription(title="ReachSubbasin", author="Sven Kralisch", description="Retrieve the subbasin of a given reach", date="2020-10-25", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class ReachSubbasin
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hrus")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of reaches")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin attribute in HRUs", defaultValue="subbasin")
    public Attribute.String subbasinAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of sub-basin entity collection in reaches", defaultValue="subbasinhrus")
    public Attribute.String subbasinEntitiesAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Auto-detect subbasin ID if not existing? This is a workaround for old J2K parameter files without \"subbasin\" attribute.", defaultValue="true")
    public Attribute.Boolean autoSubbasin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to HRU relation in the input file", defaultValue="to_poly")
    public Attribute.String hru2hruAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU to reach relation in the input file", defaultValue="to_reach")
    public Attribute.String hru2reachAttributeName;
    protected Map<Attribute.Entity, List<Attribute.Entity>> reach2hruMap = new HashMap<Attribute.Entity, List<Attribute.Entity>>();

    public void init() {
        if (this.autoSubbasin.getValue() && !((Attribute.Entity)this.hrus.getEntities().get(0)).existsAttribute(this.subbasinAttributeName.getValue())) {
            List hruList = this.hrus.getEntities();
            for (int i = hruList.size() - 1; i >= 0; --i) {
                Attribute.Entity hru = (Attribute.Entity)hruList.get(i);
                Attribute.Entity toReach = (Attribute.Entity)hru.getObject(this.hru2reachAttributeName.getValue());
                Attribute.Entity toHRU = (Attribute.Entity)hru.getObject(this.hru2hruAttributeName.getValue());
                if (toReach.getId() != -1L) {
                    hru.setDouble(this.subbasinAttributeName.getValue(), (double)toReach.getId());
                    continue;
                }
                if (toHRU.getId() == -1L) continue;
                if (toHRU.existsAttribute(this.subbasinAttributeName.getValue())) {
                    hru.setDouble(this.subbasinAttributeName.getValue(), toHRU.getDouble(this.subbasinAttributeName.getValue()));
                    continue;
                }
                this.getModel().getRuntime().println("Problem: No subbbasin found for HRU " + hru.getId());
            }
        }
        HashMap<Long, Attribute.Entity> reachMap = new HashMap<Long, Attribute.Entity>();
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            reachMap.put(reach.getId(), reach);
        }
        for (Attribute.Entity hru : this.hrus.getEntities()) {
            double subbasinID = hru.getDouble(this.subbasinAttributeName.getValue());
            Attribute.Entity reach = (Attribute.Entity)reachMap.get((long)subbasinID);
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            if (hruList == null) {
                hruList = new ArrayList<Attribute.Entity>();
                this.reach2hruMap.put(reach, hruList);
            }
            hruList.add(hru);
        }
        for (Attribute.Entity reach : this.reaches.getEntities()) {
            List<Attribute.Entity> hruList = this.reach2hruMap.get(reach);
            if (hruList == null) {
                hruList = new ArrayList<Attribute.Entity>();
                this.getModel().getRuntime().println("Reach found without subbasin: " + reach.getId());
            }
            Attribute.EntityCollection hrus = this.getModel().getRuntime().getDataFactory().createEntityCollection();
            hrus.setEntities(hruList);
            reach.setObject(this.subbasinEntitiesAttributeName.getValue(), (Object)hrus);
        }
    }
}

